/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.util;

import com.tridium.sys.Nre;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComponent;
import javax.baja.util.Queue;
import javax.baja.util.Worker;
import javax.baja.workbench.component.table.BComponentTable;
import javax.baja.workbench.view.BWbComponentView;

public class WbViewEventWorker {
    private Worker worker;
    private Queue queue;
    private static final boolean processEventsAsync = System.getProperty("niagara.wbView.processEventsAsync", "true").equals("true");

    private WbViewEventWorker() {
        if (processEventsAsync) {
            this.queue = new Queue();
            this.worker = new Worker((Worker.ITodo)this.queue);
            this.worker.start("WbViewEventWorker");
            Nre.spySysManagers.add("WbViewEventWorker", (Spy)new WorkerPage());
        }
    }

    public static WbViewEventWorker getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void invokeLater(Runnable runnable) {
        if (processEventsAsync) {
            this.queue.enqueue((Object)runnable);
        } else {
            runnable.run();
        }
    }

    public final void registerForComponentEventsLater(final BWbComponentView bWbComponentView, final BComponent bComponent, final int n) {
        this.invokeLater(new Runnable(){

            public void run() {
                bWbComponentView.registerForComponentEvents(bComponent, n);
            }
        });
    }

    public final void reloadLater(final BComponentTable bComponentTable) {
        this.invokeLater(new Runnable(){

            public void run() {
                bComponentTable.reload();
            }
        });
    }

    public class WorkerPage
    extends SpyDir {
        public void write(SpyWriter spyWriter) throws Exception {
            if (WbViewEventWorker.this.worker != null) {
                WbViewEventWorker.this.worker.spy(spyWriter);
            }
        }
    }

    private static class SingletonHolder {
        public static final WbViewEventWorker INSTANCE = new WbViewEventWorker();

        private SingletonHolder() {
        }
    }
}

