/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.util;

import com.tridium.ui.BFindPane;
import com.tridium.workbench.propsheet.BPropertyEntry;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.log.Log;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.space.Mark;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIPropertyContainer;
import javax.baja.sys.BObject;
import javax.baja.sys.Slot;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.text.FindPattern;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.mgr.BMgrEditDialog;

public class WbUtil {
    private static Lexicon lex = Lexicon.make((String)"workbench");
    private static Log log = Log.getLog((String)"wb.util");

    public static void loadWithMacros(InputStream inputStream, OutputStream outputStream, Properties properties) throws IOException {
        int n;
        while ((n = inputStream.read()) >= 0) {
            if (n != 36) {
                outputStream.write(n);
                continue;
            }
            n = inputStream.read();
            if (n != 40) {
                outputStream.write(n);
                continue;
            }
            StringBuffer stringBuffer = new StringBuffer();
            while ((n = inputStream.read()) != 41) {
                stringBuffer.append((char)n);
            }
            String string = stringBuffer.toString();
            String string2 = properties.getProperty(string, string);
            for (int i = 0; i < string2.length(); ++i) {
                outputStream.write(string2.charAt(i));
            }
        }
    }

    public static BColor mixColors(BColor bColor, BColor bColor2, float f) {
        if (f <= 0.0f) {
            return bColor;
        }
        if (f >= 1.0f) {
            return bColor2;
        }
        int n = (int)((float)bColor.getRed() + (float)(bColor2.getRed() - bColor.getRed()) * f);
        int n2 = (int)((float)bColor.getGreen() + (float)(bColor2.getGreen() - bColor.getGreen()) * f);
        int n3 = (int)((float)bColor.getBlue() + (float)(bColor2.getBlue() - bColor.getBlue()) * f);
        int n4 = (int)((float)bColor.getAlpha() + (float)(bColor2.getAlpha() - bColor.getAlpha()) * f);
        return BColor.make((int)n, (int)n2, (int)n3, (int)n4);
    }

    public static BColor floatToColor(float f, BColor bColor, BColor bColor2, BColor bColor3, float f2, float f3) {
        int n;
        int n2;
        int n3;
        float f4 = Math.abs(f3 - f2) / 2.0f;
        float f5 = f2 + f4;
        if (f < f5) {
            if (f < f2) {
                return bColor;
            }
            float f6 = (float)(bColor2.getRed() - bColor.getRed()) / f4;
            float f7 = (float)bColor2.getRed() - f6 * f5;
            n3 = (int)(f6 * f + f7);
            float f8 = (float)(bColor2.getGreen() - bColor.getGreen()) / f4;
            float f9 = (float)bColor2.getGreen() - f8 * f5;
            n2 = (int)(f8 * f + f9);
            float f10 = (float)(bColor2.getBlue() - bColor.getBlue()) / f4;
            float f11 = (float)bColor2.getBlue() - f10 * f5;
            n = (int)(f10 * f + f11);
        } else {
            if (f > f3) {
                return bColor3;
            }
            float f12 = (float)(bColor3.getRed() - bColor2.getRed()) / f4;
            float f13 = (float)bColor2.getRed() - f12 * f5;
            n3 = (int)(f12 * f + f13);
            float f14 = (float)(bColor3.getGreen() - bColor2.getGreen()) / f4;
            float f15 = (float)bColor2.getGreen() - f14 * f5;
            n2 = (int)(f14 * f + f15);
            float f16 = (float)(bColor3.getBlue() - bColor2.getBlue()) / f4;
            float f17 = (float)bColor2.getBlue() - f16 * f5;
            n = (int)(f16 * f + f17);
        }
        return BColor.make((int)n3, (int)n2, (int)n);
    }

    public static int compositeDeletionWarning(BWidget bWidget, BComplex[] bComplexArray) {
        for (int i = 0; i < bComplexArray.length; ++i) {
            int n = WbUtil.compositeDeletionWarning(bWidget, (BIPropertyContainer)bComplexArray[i].getParent().asComponent(), (Slot)bComplexArray[i].getPropertyInParent());
            if (n == -1) continue;
            return n;
        }
        return -1;
    }

    public static int compositeDeletionWarning(BWidget bWidget, BIPropertyContainer bIPropertyContainer, Slot slot) {
        return WbUtil.compositeDeletionWarning(bWidget, bIPropertyContainer, new Slot[]{slot});
    }

    public static int compositeDeletionWarning(BWidget bWidget, BIPropertyContainer bIPropertyContainer, Slot[] slotArray) {
        for (int i = 0; i < slotArray.length; ++i) {
            if ((bIPropertyContainer.getFlags(slotArray[i]) & 0x1000) == 0) continue;
            return BDialog.open((BWidget)bWidget, (String)lex.getText("compositeDelete.warning.title"), (Object)lex.getText("compositeDelete.warning.message"), (int)3, (BImage)BDialog.WARNING_ICON);
        }
        return -1;
    }

    public static boolean isRemoteModuleAvailable(String string, BISession bISession) {
        BObject bObject = (BObject)bISession;
        Version version = (Version)bObject.fw(404, (Object)string, null, null, null);
        if (version == null) {
            try {
                BOrd.make((String)("file:!modules/" + string + ".jar")).resolve(bObject).get();
                return true;
            }
            catch (Exception exception) {}
        } else if (!version.isNull()) {
            return true;
        }
        return false;
    }

    public static BObject findService(BWidget bWidget, Type type, BWbShell bWbShell) {
        if (bWbShell != null) {
            try {
                BOrd bOrd = BOrd.make((BOrd)bWbShell.getActiveOrd(), (String)("service:" + type));
                return bOrd.get();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (bWidget != null) {
            BObject bObject = WbUtil.findAncenstorViaWidgetTree(bWidget, type);
            if (bObject != null) {
                return bObject;
            }
            BComponent bComponent = (BComponent)WbUtil.findAncenstorViaWidgetTree(bWidget, BComponent.TYPE);
            if (bComponent != null) {
                return WbUtil.findAncenstorViaComponentTree(bComponent, type);
            }
        }
        return null;
    }

    public static BObject findAncenstorViaComponentTree(BComponent bComponent, Type type) {
        while (bComponent != null) {
            if (bComponent.getType().is(type)) {
                return bComponent;
            }
            bComponent = (BComponent)bComponent.getParent();
        }
        return null;
    }

    public static BObject findService(BWidget bWidget, Type type) {
        if (bWidget != null) {
            return WbUtil.findService(bWidget, type, BWbShell.getWbShell(bWidget));
        }
        return null;
    }

    public static BObject findAncenstorViaWidgetTree(BWidget bWidget, Type type) {
        if (log.isTraceOn()) {
            log.trace("Looking for:" + type + " starting with " + bWidget.getType());
        }
        try {
            for (BWidget bWidget2 = bWidget; bWidget2 != null; bWidget2 = bWidget2.getParent()) {
                BObject bObject;
                Object object;
                Object object2;
                if (log.isTraceOn()) {
                    log.trace("ancestor iterator: " + bWidget2.getType());
                }
                if (bWidget2 instanceof BWbEditor) {
                    object2 = (BWbEditor)bWidget2;
                    object = object2.getCurrentValue();
                    if (object != null && object.getType().is(type)) {
                        if (log.isTraceOn()) {
                            log.trace("Found ancestor via BWbEditor widget ancestory:" + type);
                        }
                        return object;
                    }
                    bObject = object2.getBindings();
                    for (int i = 0; i < ((BObject)bObject).length; ++i) {
                        if (bObject[i].getTarget() == null || bObject[i].getTarget().getSecurityTarget() == null || !bObject[i].getTarget().getSecurityTarget().getType().is(type)) continue;
                        if (log.isTraceOn()) {
                            log.trace("Found ancestor via Binding");
                        }
                        return (BObject)bObject[i].getTarget().getSecurityTarget();
                    }
                    continue;
                }
                if (bWidget2 instanceof BPropertyEntry) {
                    object2 = ((BPropertyEntry)bWidget2).getTransferData();
                    if (object2 == null || (object = (Mark)object2.getData(TransferFormat.mark)).size() != 1 || object.getValue(0) == null || !object.getValue(0).getType().is(type)) continue;
                    if (log.isTraceOn()) {
                        log.trace("Found ancestor via PropertySheet");
                    }
                    return object.getValue(0);
                }
                if (!(bWidget2 instanceof BMgrEditDialog) || (bObject = ((BWbEditor)((Object)(object = ((BMgrEditDialog)((Object)(object2 = (BMgrEditDialog)bWidget2))).getManager()))).getCurrentValue()) == null || !bObject.getType().is(type)) continue;
                if (log.isTraceOn()) {
                    log.trace("Found ancestor via BMgrEditDialog");
                }
                return bObject;
            }
        }
        catch (Exception exception) {
            log.error("Problem searching for widget tree based ancestor", (Throwable)exception);
        }
        return null;
    }

    static class BatchReplaceRenderer
    extends TableCellRenderer {
        BatchReplaceRenderer() {
        }

        public BBrush getSelectionForeground(TableCellRenderer.Cell cell) {
            return this.getForeground(cell);
        }

        public BBrush getSelectionBackground(TableCellRenderer.Cell cell) {
            return this.getBackground(cell);
        }
    }

    static class BatchReplaceController
    extends TableController {
        BatchReplaceController() {
        }

        public boolean isFocusTraversable() {
            return false;
        }
    }

    public static class BatchReplace
    extends TableModel
    implements BFindPane.Listener {
        BWidget owner;
        BFindPane find;
        BTable table;
        String[] oldNames;
        String[] newNames;
        String lexOld = UiLexicon.bajaui().getText("old");
        String lexNew = UiLexicon.bajaui().getText("new");

        public BatchReplace(BWidget bWidget, String[] stringArray) {
            this.owner = bWidget;
            this.oldNames = stringArray;
            this.newNames = (String[])stringArray.clone();
            this.find = new BFindPane(bWidget, true, true, (BFindPane.Listener)this);
            this.table = new BTable((TableModel)this, (TableController)new BatchReplaceController());
            this.table.setCellRenderer((TableCellRenderer)new BatchReplaceRenderer());
        }

        public String[] prompt(String string) {
            BEdgePane bEdgePane = new BEdgePane();
            bEdgePane.setCenter((BWidget)new BBorderPane((BWidget)this.table, BBorder.inset, BInsets.DEFAULT));
            bEdgePane.setBottom((BWidget)new BBorderPane((BWidget)this.find, 10.0, 0.0, 0.0, 0.0));
            BConstrainedPane bConstrainedPane = new BConstrainedPane((BWidget)new BBorderPane((BWidget)bEdgePane));
            bConstrainedPane.setMinSize(400.0, 200.0);
            bConstrainedPane.setMaxSize(500.0, 600.0);
            int n = BDialog.open((BWidget)this.owner, (String)string, (Object)bConstrainedPane, (int)3);
            if (n != 1) {
                return null;
            }
            this.find.save();
            return this.newNames;
        }

        public void findPatternModified(FindPattern findPattern, String string) {
            for (int i = 0; i < this.newNames.length; ++i) {
                this.newNames[i] = findPattern.replace(this.oldNames[i], string);
            }
            this.updateTable();
        }

        public int getRowCount() {
            return this.oldNames.length;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            return n == 0 ? this.lexOld : this.lexNew;
        }

        public Object getValueAt(int n, int n2) {
            return n2 == 0 ? this.oldNames[n] : this.newNames[n];
        }
    }
}

