/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.util;

import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.sys.Slot;
import javax.baja.ui.BWidget;

public class SlotBarUtil {
    public static final int wixel = 12;
    public static final BColor propertyBg1 = BColor.make((int)167, (int)167, (int)213);
    public static final BColor propertyBg2 = BColor.make((int)210, (int)210, (int)234);
    public static final BColor actionBg1 = BColor.make((int)30, (int)211, (int)30);
    public static final BColor actionBg2 = BColor.make((int)210, (int)254, (int)210);
    public static final BColor topicBg1 = BColor.make((int)181, (int)182, (int)59);
    public static final BColor topicBg2 = BColor.make((int)227, (int)227, (int)193);
    public static final BBrush propertyGradient = SlotBarUtil.makeGradient(propertyBg2, propertyBg1);
    public static final BBrush actionGradient = SlotBarUtil.makeGradient(actionBg2, actionBg1);
    public static final BBrush topicGradient = SlotBarUtil.makeGradient(topicBg2, topicBg1);
    public static final BBrush propertyHighlightGradient = SlotBarUtil.makeGradient(BColor.white, propertyBg2);
    public static final BBrush actionHighlightGradient = SlotBarUtil.makeGradient(BColor.white, actionBg2);
    public static final BBrush topicHighlightGradient = SlotBarUtil.makeGradient(BColor.white, topicBg2);
    private static BImage[] propertyBars = new BImage[256];
    private static BImage[] actionBars = new BImage[256];
    private static BImage[] topicBars = new BImage[256];
    private static BImage[] highlightPropertyBars = new BImage[256];
    private static BImage[] highlightActionBars = new BImage[256];
    private static BImage[] highlightTopicBars = new BImage[256];

    private static BBrush makeGradient(BColor bColor, BColor bColor2) {
        BBrush.Stop[] stopArray = new BBrush.Stop[]{BBrush.stop((double)0.0, (BColor)bColor), BBrush.stop((double)100.0, (BColor)bColor2)};
        return BBrush.makeLinearGradient((BBrush.Stop[])stopArray);
    }

    public static BImage getSlotBar(BWidget bWidget, Slot slot, int n) {
        if (slot.isAction()) {
            return SlotBarUtil.getActionBar(bWidget, n);
        }
        if (slot.isTopic()) {
            return SlotBarUtil.getTopicBar(bWidget, n);
        }
        return SlotBarUtil.getPropertyBar(bWidget, n);
    }

    public static BImage getHighlightSlotBar(BWidget bWidget, Slot slot, int n) {
        if (slot.isAction()) {
            return SlotBarUtil.getHighlightActionBar(bWidget, n);
        }
        if (slot.isTopic()) {
            return SlotBarUtil.getHighlightTopicBar(bWidget, n);
        }
        return SlotBarUtil.getHighlightPropertyBar(bWidget, n);
    }

    public static BImage getPropertyBar(BWidget bWidget, int n) {
        BImage bImage = propertyBars[n];
        if (bImage == null) {
            bImage = SlotBarUtil.propertyBars[n] = SlotBarUtil.makeBar(bWidget, n, propertyGradient);
        }
        return bImage;
    }

    public static BImage getActionBar(BWidget bWidget, int n) {
        BImage bImage = actionBars[n];
        if (bImage == null) {
            bImage = SlotBarUtil.actionBars[n] = SlotBarUtil.makeBar(bWidget, n, actionGradient);
        }
        return bImage;
    }

    public static BImage getTopicBar(BWidget bWidget, int n) {
        BImage bImage = topicBars[n];
        if (bImage == null) {
            bImage = SlotBarUtil.topicBars[n] = SlotBarUtil.makeBar(bWidget, n, topicGradient);
        }
        return bImage;
    }

    public static BImage getHighlightPropertyBar(BWidget bWidget, int n) {
        BImage bImage = highlightPropertyBars[n];
        if (bImage == null) {
            bImage = SlotBarUtil.highlightPropertyBars[n] = SlotBarUtil.makeBar(bWidget, n, propertyHighlightGradient);
        }
        return bImage;
    }

    public static BImage getHighlightActionBar(BWidget bWidget, int n) {
        BImage bImage = highlightActionBars[n];
        if (bImage == null) {
            bImage = SlotBarUtil.highlightActionBars[n] = SlotBarUtil.makeBar(bWidget, n, actionHighlightGradient);
        }
        return bImage;
    }

    public static BImage getHighlightTopicBar(BWidget bWidget, int n) {
        BImage bImage = highlightTopicBars[n];
        if (bImage == null) {
            bImage = SlotBarUtil.highlightTopicBars[n] = SlotBarUtil.makeBar(bWidget, n, topicHighlightGradient);
        }
        return bImage;
    }

    private static BImage makeBar(BWidget bWidget, int n, BBrush bBrush) {
        int n2 = n * 12;
        int n3 = 24;
        BImage bImage = BImage.make((double)n2, (double)n3);
        Graphics graphics = bImage.getGraphics();
        graphics.setBrush(bBrush);
        graphics.fillRect(0.0, 0.0, (double)n2, (double)n3);
        graphics.dispose();
        return bImage;
    }
}

