/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.util;

import com.tridium.ui.UiEnv;
import com.tridium.workbench.util.BTimeoutMeter;
import java.util.HashMap;
import java.util.Iterator;
import javax.baja.gx.BColor;
import javax.baja.gx.BInsets;
import javax.baja.gx.IRectGeom;
import javax.baja.ui.BBorder;
import javax.baja.ui.BFrame;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWindow;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.workbench.util.BNotifyPane;

public class NotifyManager {
    private static NotifyManager instance;
    private static final int DEFAULT_TIMEOUT = 4000;
    private static final int rate = 50;
    private static final int delta = 5;
    private BFrame frame;
    private IRectGeom screen;
    private HashMap hash = new HashMap();

    public static NotifyManager get() {
        if (instance == null) {
            instance = new NotifyManager();
        }
        return instance;
    }

    NotifyManager() {
        this.frame = new BFrame();
        this.screen = UiEnv.get().getScreenBounds(null);
    }

    public void open(BNotifyPane bNotifyPane, int n) {
        BWindow bWindow = this.makeWindow(bNotifyPane, n);
        new Animate(bWindow, n).start();
    }

    public void close(BNotifyPane bNotifyPane) {
    }

    private BWindow makeWindow(BNotifyPane bNotifyPane, double d) {
        BTimeoutMeter bTimeoutMeter = new BTimeoutMeter(d);
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setCenter((BWidget)new BBorderPane((BWidget)bNotifyPane));
        bEdgePane.setRight((BWidget)bTimeoutMeter);
        BBorderPane bBorderPane = new BBorderPane((BWidget)bEdgePane);
        bBorderPane.setBorder(BBorder.make((String)"1px solid black"));
        bBorderPane.setFill(BColor.make((int)0xEEEEEE).toBrush());
        bBorderPane.setPadding(BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0));
        BWindow bWindow = new BWindow((BWidget)this.frame, (BWidget)bBorderPane);
        this.hash.put(bWindow, bTimeoutMeter);
        return bWindow;
    }

    class Animate
    extends Thread {
        private BWindow window;
        private int timeout;

        public Animate(BWindow bWindow, int n) {
            super("Ui:NotifyAnimation");
            this.window = bWindow;
            this.timeout = n;
        }

        public void run() {
            Object object;
            BWidget bWidget = this.window.getContent();
            bWidget.computePreferredSize();
            double d = bWidget.getPreferredWidth();
            double d2 = bWidget.getPreferredHeight();
            double d3 = NotifyManager.this.screen.width() - d;
            double d4 = NotifyManager.this.screen.height() - d2;
            double d5 = NotifyManager.this.screen.height();
            Iterator iterator = NotifyManager.this.hash.keySet().iterator();
            while (iterator.hasNext()) {
                object = (BWindow)iterator.next();
                if (object == this.window) continue;
                d4 -= object.getContent().getPreferredHeight() - 1.0;
                d5 -= object.getContent().getPreferredHeight() - 1.0;
            }
            this.window.setScreenBounds(d3, d5, d, d2);
            this.window.open();
            while (d5 > d4) {
                try {
                    Thread.sleep(50L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                d5 -= 5.0;
                if (d5 < d4) {
                    d5 = d4;
                }
                this.window.setScreenBounds(d3, d5, d, d2);
            }
            object = (BTimeoutMeter)((Object)NotifyManager.this.hash.get(this.window));
            int n = 0;
            while (n < this.timeout) {
                try {
                    Thread.sleep(100L);
                    n += 100;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ((BTimeoutMeter)((Object)object)).setCurrent(this.timeout - n);
                object.repaint();
            }
            while (d5 < NotifyManager.this.screen.height()) {
                try {
                    Thread.sleep(50L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.window.setScreenBounds(d3, d5 += 5.0, d, d2);
            }
            this.window.close();
            NotifyManager.this.hash.remove(this.window);
        }
    }
}

