/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.util;

import com.tridium.collection.BISortableTable;
import com.tridium.sys.Nre;
import javax.baja.collection.BICollection;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.naming.BOrdList;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.ui.table.TableModel;
import javax.baja.units.BUnit;
import javax.baja.units.BUnitConversion;
import javax.baja.util.IFormat;
import javax.baja.util.Lexicon;

public class CollectionTableModel
extends TableModel {
    private static IFormat defaultFormat = new DefaultFormat();
    private static Lexicon lex = Lexicon.make((String)"workbench");
    private BITable itable;
    private Context cx;
    private String[] colNames;
    private IFormat[] formats;

    public CollectionTableModel(BICollection bICollection, Context context) {
        this(bICollection.toTable(), context);
    }

    public CollectionTableModel(BITable bITable, Context context) {
        this.itable = bITable;
        this.cx = context;
        this.updateColumns();
    }

    public BITable getBITable() {
        return this.itable;
    }

    public void setCollection(BICollection bICollection) {
        this.itable = bICollection.toTable();
        this.updateColumns();
        this.updateTable();
    }

    private void updateColumns() {
        ColumnList columnList = this.itable.getColumns();
        int n = columnList.size();
        this.colNames = new String[n];
        this.formats = new IFormat[n];
        for (int i = 0; i < n; ++i) {
            BUnit bUnit;
            Column column = columnList.get(i);
            this.formats[i] = this.getFormatter(column);
            this.colNames[i] = column.getDisplayName(this.cx);
            BFacets bFacets = column.getFacets();
            if (bFacets == null || bFacets.isNull() || (bUnit = (BUnit)bFacets.get("units")) == null || bUnit.isNull()) continue;
            int n2 = Nre.unitConversion;
            if ((n2 = bFacets.geti("unitConversion", n2)) != 0) {
                bUnit = BUnitConversion.make((int)n2).getDesiredUnit(bUnit);
            }
            int n3 = i;
            this.colNames[n3] = this.colNames[n3] + " (" + bUnit.getSymbol() + ")";
        }
    }

    public int getRowCount() {
        return this.itable.size();
    }

    public int getColumnCount() {
        return this.colNames.length;
    }

    public String getColumnName(int n) {
        return this.colNames[n];
    }

    public Object getValueAt(int n, int n2) {
        Column column = this.itable.getColumns().get(n2);
        BObject bObject = this.itable.get(n, column);
        return this.formats[n2].format((Object)bObject, column.getFacets());
    }

    public Object getSubject(int n) {
        return this.itable.get(n);
    }

    private IFormat getFormatter(Column column) {
        String string = column.getName();
        if (string.equals("trendFlags") && column.getType() == BInteger.TYPE) {
            return new TrendFlagsFormat();
        }
        if (column.getType() == BOrdList.TYPE) {
            return new OrdListFormat();
        }
        return defaultFormat;
    }

    public BITable export() {
        return this.itable;
    }

    public BObject export(int n, int n2) {
        return this.itable.get(n, this.itable.getColumns().get(n2));
    }

    public boolean isColumnSortable(int n) {
        if (this.itable.size() <= 0) {
            return false;
        }
        return this.itable instanceof BISortableTable;
    }

    public void sortByColumn(int n, boolean bl) {
        if (!(this.itable instanceof BISortableTable)) {
            throw new UnsupportedOperationException();
        }
        this.itable = ((BISortableTable)this.itable).sort(this.itable.getColumns().get(n), bl);
    }

    private static class OrdListFormat
    implements IFormat {
        private OrdListFormat() {
        }

        public String format(Object object, BFacets bFacets) {
            BOrdList bOrdList = (BOrdList)object;
            try {
                return bOrdList.encodeToString().replace('\n', '|');
            }
            catch (Exception exception) {
                return bOrdList.toString();
            }
        }
    }

    private static class TrendFlagsFormat
    implements IFormat {
        private String[] tags = new String[]{"TrendFlags.start", "TrendFlags.outOfOrder", "TrendFlags.hidden", "TrendFlags.modified", "TrendFlags.interpolated", "TrendFlags.reserved1", "TrendFlags.reserved2", "TrendFlags.reserved3"};

        public TrendFlagsFormat() {
            Lexicon lexicon = Lexicon.make((String)"history");
            this.tags[0] = lexicon.getText(this.tags[0]);
            this.tags[1] = lexicon.getText(this.tags[1]);
            this.tags[2] = lexicon.getText(this.tags[2]);
            this.tags[3] = lexicon.getText(this.tags[3]);
            this.tags[4] = lexicon.getText(this.tags[4]);
            this.tags[5] = lexicon.getText(this.tags[5]);
            this.tags[6] = lexicon.getText(this.tags[6]);
            this.tags[7] = lexicon.getText(this.tags[7]);
        }

        public String format(Object object, BFacets bFacets) {
            int n = ((BInteger)object).getInt();
            if (n == 0) {
                return "{ }";
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('{');
            int n2 = 1;
            boolean bl = true;
            for (int i = 0; i < 8; ++i) {
                if ((n & n2) != 0) {
                    if (!bl) {
                        stringBuffer.append(",");
                    }
                    bl = false;
                    stringBuffer.append(this.tags[i]);
                }
                n <<= 1;
            }
            stringBuffer.append('}');
            return stringBuffer.toString();
        }
    }

    private static class DefaultFormat
    implements IFormat {
        private DefaultFormat() {
        }

        public String format(Object object, BFacets bFacets) {
            if (object instanceof BObject) {
                return ((BObject)object).toString((Context)bFacets);
            }
            return object.toString();
        }
    }
}

