/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.util;

import com.tridium.sys.registry.NModuleInfo;
import com.tridium.ui.BOptionDialog;
import com.tridium.ui.theme.Theme;
import java.util.Comparator;
import java.util.ListIterator;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.registry.ModuleInfo;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.text.Line;
import javax.baja.ui.text.Segment;
import javax.baja.ui.text.TextRenderer;
import javax.baja.util.Lexicon;
import javax.baja.util.PatternFilter;

public final class BPalettePane
extends BPane {
    public static final Property content = BPalettePane.newProperty((int)0, (BValue)new BNullWidget(), null);
    public static final Action updateTable = BPalettePane.newAction((int)0, null);
    public static final Action searchKeyEvent = BPalettePane.newAction((int)0, (BValue)new BKeyEvent(), null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$util$BPalettePane == null ? (class$com$tridium$workbench$util$BPalettePane = BPalettePane.class$("com.tridium.workbench.util.BPalettePane")) : class$com$tridium$workbench$util$BPalettePane));
    private static final Lexicon lex = Lexicon.make((Class)(class$com$tridium$workbench$util$BPalettePane == null ? (class$com$tridium$workbench$util$BPalettePane = BPalettePane.class$("com.tridium.workbench.util.BPalettePane")) : class$com$tridium$workbench$util$BPalettePane));
    private static BFileChooser chooser;
    private BTextField searchField = new BTextField("", 40);
    private Array items = new Array(class$com$tridium$workbench$util$BPalettePane$Item == null ? (class$com$tridium$workbench$util$BPalettePane$Item = BPalettePane.class$("com.tridium.workbench.util.BPalettePane$Item")) : class$com$tridium$workbench$util$BPalettePane$Item);
    private Array currentItems;
    private Model tableModel = new Model();
    private BTable table = new BTable((TableModel)this.tableModel);
    private BOrd fileOrd;
    static /* synthetic */ Class class$com$tridium$workbench$util$BPalettePane;
    static /* synthetic */ Class class$com$tridium$workbench$util$BPalettePane$Item;

    public BWidget getContent() {
        return (BWidget)this.get(content);
    }

    public void setContent(BWidget bWidget) {
        this.set(content, (BValue)bWidget, null);
    }

    public void updateTable() {
        this.invoke(updateTable, null, null);
    }

    public void searchKeyEvent(BKeyEvent bKeyEvent) {
        this.invoke(searchKeyEvent, (BValue)bKeyEvent, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BPalettePane() {
        throw new IllegalStateException();
    }

    public BPalettePane(BWidget bWidget) {
        this.table.setController((TableController)new Controller());
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setLeft((BWidget)new BLabel(lex.getText("PaletteSideBar.selectPalettes")));
        bEdgePane.setRight((BWidget)new BButton((Command)new Browse(bWidget)));
        this.searchField.setRenderer(new TextRenderer(){

            public void paintLine(Graphics graphics, TextRenderer.LineInfo lineInfo) {
                if (lineInfo.line.segments.length == 0) {
                    TextRenderer.LineInfo lineInfo2 = new TextRenderer.LineInfo();
                    lineInfo2.lineIndex = 0;
                    lineInfo2.selectionStartColumn = 0;
                    lineInfo2.selectionEndColumn = 0;
                    String string = "filter";
                    lineInfo2.line = new Line(string.toCharArray(), new Segment[]{new Segment(-1, 0, string.length())});
                    super.paintLine(graphics, lineInfo2);
                } else {
                    super.paintLine(graphics, lineInfo);
                }
            }

            public BBrush getForeground(Segment segment) {
                if (segment.type == -1) {
                    return Theme.textEditor().getDisabledTextBrush();
                }
                return super.getForeground(segment);
            }
        });
        this.linkTo((BComponent)this.searchField, (Slot)BTextField.textModified, (Slot)updateTable);
        this.linkTo((BComponent)this.searchField, (Slot)BWidget.keyEvent, (Slot)searchKeyEvent);
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.add(null, (BValue)new BLabel(BImage.make((BIcon)BIcon.std((String)"filter.png"))));
        bGridPane.add(null, (BValue)this.searchField);
        BEdgePane bEdgePane2 = new BEdgePane();
        bEdgePane2.setTop((BWidget)bEdgePane);
        bEdgePane2.setLeft((BWidget)new BBorderPane((BWidget)bGridPane, 5.0, 0.0, 0.0, 0.0));
        BConstrainedPane bConstrainedPane = new BConstrainedPane((BWidget)new BBorderPane((BWidget)this.table, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        bConstrainedPane.setMinWidth(400.0);
        bConstrainedPane.setMaxHeight(300.0);
        BEdgePane bEdgePane3 = new BEdgePane();
        bEdgePane3.setTop((BWidget)new BBorderPane((BWidget)bEdgePane2, 0.0, 0.0, 10.0, 0.0));
        bEdgePane3.setCenter((BWidget)bConstrainedPane);
        BBorderPane bBorderPane = new BBorderPane((BWidget)bEdgePane3, 10.0, 10.0, 10.0, 10.0);
        ModuleInfo[] moduleInfoArray = Sys.getRegistry().getModules();
        for (int i = 0; i < moduleInfoArray.length; ++i) {
            if (!((NModuleInfo)moduleInfoArray[i]).hasPalette()) continue;
            this.items.add((Object)new Item(moduleInfoArray[i].getModuleName(), moduleInfoArray[i].getDescription()));
        }
        this.currentItems = this.items.copy();
        this.setContent((BWidget)bBorderPane);
    }

    public void started() throws Exception {
        this.searchField.requestFocus();
    }

    public void computePreferredSize() {
        BWidget bWidget = this.getContent();
        bWidget.computePreferredSize();
        this.setPreferredSize(bWidget.getPreferredWidth(), bWidget.getPreferredHeight());
    }

    public void doLayout(BWidget[] bWidgetArray) {
        this.getContent().setBounds(0.0, 0.0, this.getWidth(), this.getHeight());
    }

    public void doUpdateTable() {
        Object object;
        TableSelection tableSelection = this.table.getSelection();
        Item[] itemArray = null;
        if (tableSelection != null) {
            object = tableSelection.getRows();
            itemArray = new Item[((int[])object).length];
            for (int i = 0; i < ((int[])object).length; ++i) {
                itemArray[i] = (Item)this.currentItems.get((int)object[i]);
            }
        }
        if (this.searchField.getText().length() > 0) {
            this.currentItems.clear();
            object = this.searchField.getText().toLowerCase();
            if (((String)object).indexOf(42) == -1 && ((String)object).indexOf(37) == -1) {
                object = (String)object + "*";
            }
            PatternFilter patternFilter = new PatternFilter((String)object);
            ListIterator listIterator = this.items.iterator();
            while (listIterator.hasNext()) {
                Item item = (Item)listIterator.next();
                if (!patternFilter.accept(item.searchTitle)) continue;
                this.currentItems.add((Object)item);
            }
        } else {
            this.currentItems = this.items.copy();
        }
        if (this.table.getSortColumn() > -1) {
            this.tableModel.sortByColumn(this.table.getSortColumn(), this.table.isSortAscending());
        }
        tableSelection.deselectAll();
        if (itemArray != null) {
            for (int i = 0; i < this.currentItems.size(); ++i) {
                for (int j = 0; j < itemArray.length; ++j) {
                    if (this.currentItems.get(i) != itemArray[j]) continue;
                    tableSelection.select(i);
                }
            }
        }
        if (tableSelection.isEmpty() && this.searchField.getText().length() > 0) {
            if (this.currentItems.size() == 1) {
                tableSelection.select(0);
            } else {
                for (int i = 0; i < this.currentItems.size(); ++i) {
                    Item item = (Item)this.currentItems.get(i);
                    if (!item.title.equalsIgnoreCase(this.searchField.getText())) continue;
                    tableSelection.select(i);
                }
            }
        }
        this.tableModel.updateTable();
    }

    public void doSearchKeyEvent(BKeyEvent bKeyEvent) {
        if (bKeyEvent.getKeyCode() == 10 || bKeyEvent.getKeyCode() == 27 || bKeyEvent.getKeyCode() == 40 || bKeyEvent.getKeyCode() == 38 || bKeyEvent.getKeyCode() == 36 || bKeyEvent.getKeyCode() == 35 || bKeyEvent.getKeyCode() == 33 || bKeyEvent.getKeyCode() == 34) {
            this.table.fireKeyEvent(bKeyEvent);
        }
    }

    public boolean isFileSelected() {
        return this.fileOrd != null;
    }

    public BOrd getFileSelection() {
        return this.fileOrd;
    }

    public String[] getTableSelection() {
        int[] nArray = this.table.getSelection().getRows();
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)this.tableModel.getValueAt(nArray[i], 0);
        }
        return stringArray;
    }

    private BOptionDialog getDialog() {
        return this.findDialog((BWidget)this);
    }

    private BOptionDialog findDialog(BWidget bWidget) {
        if (bWidget == null) {
            return null;
        }
        if (bWidget instanceof BDialog) {
            return (BOptionDialog)bWidget;
        }
        return this.findDialog((BWidget)bWidget.getParent());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Browse
    extends Command {
        public Browse(BWidget bWidget) {
            super(bWidget, lex.getText("PaletteSideBar.browse"));
        }

        public CommandArtifact doInvoke() {
            if (chooser == null) {
                chooser = BFileChooser.makeOpen((BWidget)this.getOwner());
            }
            BPalettePane.this.fileOrd = chooser.show();
            if (BPalettePane.this.fileOrd != null) {
                BPalettePane.this.getDialog().getOkButton().invokeAction();
            }
            return null;
        }
    }

    static class Item {
        String title;
        String searchTitle;
        String description;

        Item(String string, String string2) {
            this.title = string;
            this.searchTitle = string.toLowerCase();
            this.description = string2;
        }
    }

    class Model
    extends TableModel {
        Model() {
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            if (n == 0) {
                return lex.getText("PaletteSideBar.module");
            }
            return lex.getText("PaletteSideBar.description");
        }

        public int getRowCount() {
            return BPalettePane.this.currentItems.size();
        }

        public Object getValueAt(int n, int n2) {
            Item item = (Item)BPalettePane.this.currentItems.get(n);
            if (n2 == 0) {
                return item.title;
            }
            return item.description;
        }

        public boolean isColumnSortable(int n) {
            return true;
        }

        public void sortByColumn(final int n, final boolean bl) {
            Comparator comparator = new Comparator(){

                public int compare(Object object, Object object2) {
                    Item item;
                    Item item2;
                    if (!bl) {
                        item2 = (Item)object;
                        item = (Item)object2;
                    } else {
                        item = (Item)object;
                        item2 = (Item)object2;
                    }
                    if (n == 0) {
                        return item2.title.compareTo(item.title);
                    }
                    return item2.description.compareTo(item.description);
                }
            };
            Array array = BPalettePane.this.currentItems.sort(comparator);
            TableSelection tableSelection = BPalettePane.this.table.getSelection();
            TableSelection tableSelection2 = new TableSelection();
            if (tableSelection != null) {
                int[] nArray = tableSelection.getRows();
                block0: for (int i = 0; i < nArray.length; ++i) {
                    Item item = (Item)BPalettePane.this.currentItems.get(nArray[i]);
                    for (int j = 0; j < array.size(); ++j) {
                        if (array.get(j) != item) continue;
                        tableSelection2.select(j);
                        continue block0;
                    }
                }
            }
            BPalettePane.this.table.setSelection(tableSelection2);
            BPalettePane.this.currentItems = array;
        }
    }

    class Controller
    extends TableController {
        Controller() {
        }

        protected void cellDoubleClicked(BMouseEvent bMouseEvent, int n, int n2) {
            BPalettePane.this.getDialog().getOkButton().invokeAction();
        }

        public int getTextSearchColumn() {
            return 0;
        }
    }
}

