/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.util;

import com.tridium.sys.module.BModuleNavNode;
import com.tridium.sys.registry.NModuleInfo;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.nav.BINavNode;
import javax.baja.nre.util.SortUtil;
import javax.baja.registry.DependencyInfo;
import javax.baja.registry.ModuleInfo;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModuleSpace;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSubject;
import javax.baja.ui.util.BTitlePane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.view.BIExportableTableView;
import javax.baja.workbench.view.BWbView;

public class BModuleSpaceView
extends BWbView
implements BIExportableTableView {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$util$BModuleSpaceView == null ? (class$com$tridium$workbench$util$BModuleSpaceView = BModuleSpaceView.class$("com.tridium.workbench.util.BModuleSpaceView")) : class$com$tridium$workbench$util$BModuleSpaceView));
    static final int COL_NAME = 0;
    static final int COL_BAJA_VERSION = 1;
    static final int COL_VENDOR = 2;
    static final int COL_VERSION = 3;
    static final int COL_BUILD_TIME = 4;
    static final int COL_DESCRIPTION = 5;
    static final int[] DEFAULT_COLS = new int[]{0, 2, 3, 5};
    static final UiLexicon lex = UiLexicon.bajaui;
    static final String LEX_NAME = lex.getText("module.name");
    static final String LEX_BAJA_VERSION = lex.getText("module.bajaVersion");
    static final String LEX_VENDOR = lex.getText("module.vendor");
    static final String LEX_VERSION = lex.getText("module.version");
    static final String LEX_BUILD_TIME = lex.getText("module.buildTime");
    static final String LEX_DESCRIPTION = lex.getText("module.description");
    static final String LEX_NO_DEPENDS = lex.getText("module.noDepends");
    Row[] rows = new Row[0];
    BTable table;
    static /* synthetic */ Class class$com$tridium$workbench$util$BModuleSpaceView;

    public Type getType() {
        return TYPE;
    }

    public BTable getExportTable() {
        return this.table;
    }

    protected void doLoadValue(BObject bObject, Context context) throws Exception {
        BModuleSpace bModuleSpace = (BModuleSpace)bObject;
        BINavNode[] bINavNodeArray = bModuleSpace.getNavChildren();
        this.rows = new Row[bINavNodeArray.length];
        for (int i = 0; i < bINavNodeArray.length; ++i) {
            this.rows[i] = new Row((BModuleNavNode)bINavNodeArray[i]);
        }
        this.table = new BTable((TableModel)new DynamicTableModel((TableModel)new Model(), DEFAULT_COLS), (TableController)new Controller());
        this.setContent((BWidget)BTitlePane.makePane((String)lex.getText("modules"), (BTable)this.table));
    }

    protected BObject doSaveValue(BObject bObject, Context context) {
        throw new IllegalStateException();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class DependRenderer
    extends TableCellRenderer {
        DependRenderer() {
        }

        public BBrush getSelectionForeground(TableCellRenderer.Cell cell) {
            return this.getForeground(cell);
        }

        public BBrush getSelectionBackground(TableCellRenderer.Cell cell) {
            return this.getBackground(cell);
        }
    }

    static class DependModel
    extends TableModel {
        DependencyInfo[] depends;

        DependModel(ModuleInfo moduleInfo) {
            this.depends = moduleInfo.getDependencies();
        }

        public int getRowCount() {
            return Math.max(this.depends.length, 1);
        }

        public int getColumnCount() {
            return 5;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return LEX_NAME;
                }
                case 1: {
                    return LEX_BAJA_VERSION;
                }
                case 2: {
                    return LEX_VENDOR;
                }
                case 3: {
                    return LEX_VERSION;
                }
                case 4: {
                    return LEX_DESCRIPTION;
                }
            }
            return "?";
        }

        public Object getSubject(int n) {
            return this.depends[n];
        }

        public Object getValueAt(int n, int n2) {
            if (this.depends.length == 0) {
                if (n2 == 0) {
                    return LEX_NO_DEPENDS;
                }
                return "";
            }
            DependencyInfo dependencyInfo = this.depends[n];
            switch (n2) {
                case 0: {
                    return dependencyInfo.getModuleName();
                }
                case 1: {
                    return this.format(dependencyInfo.getBajaVersion());
                }
                case 2: {
                    return this.format(dependencyInfo.getVendor());
                }
                case 3: {
                    return this.format(dependencyInfo.getVendorVersion());
                }
                case 4: {
                    return dependencyInfo.getModuleInfo().getDescription();
                }
            }
            return "?";
        }

        String format(Object object) {
            if (object == null) {
                return "-";
            }
            return object.toString();
        }

        public BImage getRowIcon(int n) {
            if (this.depends.length == 0) {
                return null;
            }
            return BImage.make((BIcon)Sys.loadModule((String)this.depends[n].getModuleName()).getIcon());
        }
    }

    class ShowDepends
    extends Command {
        Row row;

        ShowDepends(BWidget bWidget, Row row) {
            super(bWidget, (Lexicon)lex, "module.depends");
            this.row = row;
        }

        public CommandArtifact doInvoke() {
            BTable bTable = new BTable((TableModel)new DependModel((ModuleInfo)this.row.info));
            bTable.setCellRenderer((TableCellRenderer)new DependRenderer());
            String string = lex.getText("module.dependsFor", new Object[]{this.row.info.getModuleName()});
            BDialog.open((BWidget)this.getOwner(), (String)string, (Object)bTable, (int)1);
            return null;
        }
    }

    static class Row {
        BModuleNavNode node;
        NModuleInfo info;
        BAbsTime buildTime;
        String fileName;

        Row(BModuleNavNode bModuleNavNode) {
            this.node = bModuleNavNode;
            this.info = bModuleNavNode.info;
            this.buildTime = BAbsTime.make((long)this.info.getBuildTime());
        }

        public Object getValueAt(int n) {
            switch (n) {
                case 0: {
                    return this.info.getModuleName();
                }
                case 1: {
                    return this.info.getBajaVersion();
                }
                case 2: {
                    return this.info.getVendor();
                }
                case 3: {
                    return this.info.getVendorVersion();
                }
                case 4: {
                    return this.buildTime;
                }
                case 5: {
                    return this.info.getDescription();
                }
            }
            return "?";
        }

        public Object getSortKey(int n) {
            return this.getValueAt(n);
        }
    }

    class Model
    extends TableModel {
        Model() {
        }

        public int getRowCount() {
            return BModuleSpaceView.this.rows.length;
        }

        public int getColumnCount() {
            return 6;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return LEX_NAME;
                }
                case 1: {
                    return LEX_BAJA_VERSION;
                }
                case 2: {
                    return LEX_VENDOR;
                }
                case 3: {
                    return LEX_VERSION;
                }
                case 4: {
                    return LEX_BUILD_TIME;
                }
                case 5: {
                    return LEX_DESCRIPTION;
                }
            }
            return "?";
        }

        public Object getSubject(int n) {
            return BModuleSpaceView.this.rows[n];
        }

        public Object getValueAt(int n, int n2) {
            return BModuleSpaceView.this.rows[n].getValueAt(n2);
        }

        public boolean isColumnSortable(int n) {
            return true;
        }

        public void sortByColumn(int n, boolean bl) {
            Object[] objectArray = new Object[BModuleSpaceView.this.rows.length];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = BModuleSpaceView.this.rows[i].getSortKey(n);
            }
            SortUtil.sort((Object[])objectArray, (Object[])BModuleSpaceView.this.rows, (boolean)bl);
        }

        public BImage getRowIcon(int n) {
            return BImage.make((BIcon)BModuleSpaceView.this.rows[n].node.getIcon());
        }
    }

    class Controller
    extends TableController {
        Controller() {
        }

        public void cellDoubleClicked(BMouseEvent bMouseEvent, int n, int n2) {
            BModuleSpaceView.this.getWbShell().hyperlink(new HyperlinkInfo(BModuleSpaceView.this.rows[n].node.getNavOrd(), (BInputEvent)bMouseEvent));
        }

        public BMenu makePopup(TableSubject tableSubject) {
            Row row = (Row)tableSubject.getActive();
            if (row == null) {
                return null;
            }
            BMenu bMenu = new BMenu();
            bMenu.add(null, (Command)new ShowDepends((BWidget)this.getTable(), row));
            return bMenu;
        }
    }
}

