/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.util;

import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.WidgetTheme;
import java.util.ArrayList;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.Graphics;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.pane.BLabelPane;
import javax.baja.ui.pane.BLabelPaneContainer;

public class BMiniTabbedPane
extends BLabelPaneContainer {
    public static final Property tabPlacement = BMiniTabbedPane.newProperty((int)0, (BValue)BValign.top, null);
    public static final Topic selectionModified = BMiniTabbedPane.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$util$BMiniTabbedPane == null ? (class$com$tridium$workbench$util$BMiniTabbedPane = BMiniTabbedPane.class$("com.tridium.workbench.util.BMiniTabbedPane")) : class$com$tridium$workbench$util$BMiniTabbedPane));
    private static WidgetTheme theme = Theme.widget();
    private static BFont textFont = theme.getTextFont();
    private static BBrush textBrush = theme.getTextBrush();
    private ArrayList mousingRectGeoms = new ArrayList();
    private int idx = 0;
    private double totalWidth = 0.0;
    private double tabListY = 0.0;
    private double xOffset = 0.0;
    private boolean tooLong = false;
    private boolean leftEnabled = false;
    private boolean rightEnabled = false;
    static /* synthetic */ Class class$com$tridium$workbench$util$BMiniTabbedPane;

    public BValign getTabPlacement() {
        return (BValign)this.get(tabPlacement);
    }

    public void setTabPlacement(BValign bValign) {
        this.set(tabPlacement, (BValue)bValign, null);
    }

    public void fireSelectionModified(BWidgetEvent bWidgetEvent) {
        this.fire(selectionModified, (BValue)bWidgetEvent, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BMiniTabbedPane() {
    }

    public BMiniTabbedPane(BValign bValign) {
        this.setTabPlacement(bValign);
    }

    public Point translateToChild(BWidget bWidget, Point point) {
        return super.translateToChild(bWidget, this.getTabPlacement().equals((Object)BValign.bottom) ? point : new Point(point.x, point.y + BMiniTabbedPane.getTabHeight()));
    }

    public void paint(Graphics graphics) {
        BWidget[] bWidgetArray = this.getChildWidgets();
        if (bWidgetArray.length == 0) {
            return;
        }
        this.paintChild(graphics, ((BLabelPane)bWidgetArray[this.idx]).getContent());
        BValign bValign = this.getTabPlacement();
        if (bValign.equals((Object)BValign.center)) {
            bValign = BValign.top;
        }
        graphics.translate(0.0, this.tabListY);
        try {
            graphics.translate(-this.xOffset, 0.0);
            try {
                this.paintLabels(graphics, bWidgetArray, bValign);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            graphics.translate(this.xOffset, 0.0);
            if (this.tooLong) {
                this.paintArrows(graphics, this.getWidth() - 18.0, bValign.equals((Object)BValign.top) ? 9.0 : 8.0);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        graphics.translate(0.0, -this.tabListY);
    }

    private void paintLabels(Graphics graphics, BWidget[] bWidgetArray, BValign bValign) {
        double d = BMiniTabbedPane.getTabHeight();
        double d2 = 3.0;
        graphics.setBrush(BColor.black);
        graphics.setFont(textFont);
        for (int i = 0; i < bWidgetArray.length; ++i) {
            String string = ((BLabelPane)bWidgetArray[i]).getLabel().getText();
            double d3 = textFont.width(string) + 12.0;
            if (bValign.equals((Object)BValign.top)) {
                if (i == this.idx) {
                    graphics.setBrush(theme.getControlHighlight());
                    graphics.fillRect(d2, 3.0, d3, d - 3.0);
                    graphics.setBrush(BColor.black);
                    graphics.strokeLine(d2, 3.0, d2, d);
                    graphics.strokeLine(d2 + d3, 3.0, d2 + d3, d);
                    graphics.strokeLine(d2, 3.0, d2 + d3, 3.0);
                } else {
                    graphics.setBrush(theme.getControlShadow());
                    graphics.strokeLine(d2 + d3, 4.0, d2 + d3, textFont.getHeight() + 2.0);
                }
                graphics.setBrush(textBrush);
                graphics.drawString(string, d2 + 6.0, textFont.getAscent() + 4.0);
            } else {
                if (i == this.idx) {
                    graphics.setBrush(theme.getControlHighlight());
                    graphics.fillRect(d2, 1.0, d3, d - 3.0);
                    graphics.setBrush(BColor.black);
                    graphics.strokeLine(d2, 1.0, d2, d - 3.0);
                    graphics.strokeLine(d2 + d3, 1.0, d2 + d3, d - 3.0);
                    graphics.strokeLine(d2, d - 3.0, d2 + d3, d - 3.0);
                } else {
                    graphics.setBrush(theme.getControlShadow());
                    graphics.strokeLine(d2 + d3, 3.0, d2 + d3, textFont.getHeight());
                }
                graphics.setBrush(textBrush);
                graphics.drawString(string, d2 + 6.0, textFont.getAscent() + 1.0);
            }
            d2 += d3;
        }
    }

    private void paintArrows(Graphics graphics, double d, double d2) {
        double d3 = BMiniTabbedPane.getTabHeight();
        graphics.setBrush(theme.getControlBackground());
        graphics.fillRect(d, 1.0, 18.0, d3 - 1.0);
        graphics.setBrush(theme.getControlShadow());
        if (this.leftEnabled) {
            graphics.strokeLine(d + 3.0, d2, d + 3.0, d2);
            graphics.strokeLine(d + 4.0, d2 - 1.0, d + 4.0, d2 + 1.0);
            graphics.strokeLine(d + 5.0, d2 - 2.0, d + 5.0, d2 + 2.0);
            graphics.strokeLine(d + 6.0, d2 - 3.0, d + 6.0, d2 + 3.0);
            graphics.strokeLine(d + 7.0, d2 - 4.0, d + 7.0, d2 + 4.0);
        } else {
            graphics.strokeLine(d + 3.0, d2, d + 3.0, d2);
            graphics.strokeLine(d + 3.0, d2, d + 3.0, d2);
            graphics.strokeLine(d + 4.0, d2 - 1.0, d + 4.0, d2 - 1.0);
            graphics.strokeLine(d + 4.0, d2 + 1.0, d + 4.0, d2 + 1.0);
            graphics.strokeLine(d + 5.0, d2 - 2.0, d + 5.0, d2 - 2.0);
            graphics.strokeLine(d + 5.0, d2 + 2.0, d + 5.0, d2 + 2.0);
            graphics.strokeLine(d + 6.0, d2 - 3.0, d + 6.0, d2 - 3.0);
            graphics.strokeLine(d + 6.0, d2 + 3.0, d + 6.0, d2 + 3.0);
            graphics.strokeLine(d + 7.0, d2 - 4.0, d + 7.0, d2 + 4.0);
        }
        if (this.rightEnabled) {
            graphics.strokeLine(d + 14.0, d2, d + 14.0, d2);
            graphics.strokeLine(d + 13.0, d2 - 1.0, d + 13.0, d2 + 1.0);
            graphics.strokeLine(d + 12.0, d2 - 2.0, d + 12.0, d2 + 2.0);
            graphics.strokeLine(d + 11.0, d2 - 3.0, d + 11.0, d2 + 3.0);
            graphics.strokeLine(d + 10.0, d2 - 4.0, d + 10.0, d2 + 4.0);
        } else {
            graphics.strokeLine(d + 14.0, d2, d + 14.0, d2);
            graphics.strokeLine(d + 14.0, d2, d + 14.0, d2);
            graphics.strokeLine(d + 13.0, d2 - 1.0, d + 13.0, d2 - 1.0);
            graphics.strokeLine(d + 13.0, d2 + 1.0, d + 13.0, d2 + 1.0);
            graphics.strokeLine(d + 12.0, d2 - 2.0, d + 12.0, d2 - 2.0);
            graphics.strokeLine(d + 12.0, d2 + 2.0, d + 12.0, d2 + 2.0);
            graphics.strokeLine(d + 11.0, d2 - 3.0, d + 11.0, d2 - 3.0);
            graphics.strokeLine(d + 11.0, d2 + 3.0, d + 11.0, d2 + 3.0);
            graphics.strokeLine(d + 10.0, d2 - 4.0, d + 10.0, d2 + 4.0);
        }
    }

    public void mousePulsed(BMouseEvent bMouseEvent) {
        double d = bMouseEvent.getX();
        double d2 = bMouseEvent.getY();
        if (this.tooLong && d >= this.getWidth() - 18.0) {
            if (d >= this.getWidth() - 9.0) {
                if (this.rightEnabled) {
                    this.xOffset += 20.0;
                    if (this.xOffset > this.getMaxOffset()) {
                        this.xOffset = this.getMaxOffset();
                    }
                    this.leftEnabled = this.xOffset > 0.0;
                    this.rightEnabled = this.xOffset < this.getMaxOffset();
                    this.repaint();
                }
            } else if (this.leftEnabled) {
                this.xOffset -= 20.0;
                if (this.xOffset < 0.0) {
                    this.xOffset = 0.0;
                }
                this.leftEnabled = this.xOffset > 0.0;
                this.rightEnabled = this.xOffset < this.getMaxOffset();
                this.repaint();
            }
        }
    }

    public void mousePressed(BMouseEvent bMouseEvent) {
        double d = bMouseEvent.getX();
        double d2 = bMouseEvent.getY();
        if (this.tooLong && d >= this.getWidth() - 18.0) {
            return;
        }
        for (int i = 0; i < this.mousingRectGeoms.size(); ++i) {
            RectGeom rectGeom = (RectGeom)this.mousingRectGeoms.get(i);
            if (!rectGeom.contains(d + this.xOffset, d2) || this.idx == i) continue;
            this.idx = i;
            this.fireSelectionModified(new BWidgetEvent(1, (BWidget)this));
            this.relayout();
            return;
        }
    }

    private double getMaxOffset() {
        return this.totalWidth - this.getWidth() + 24.0;
    }

    private void layoutRects(BWidget[] bWidgetArray, double d, BValign bValign) {
        this.totalWidth = 3.0;
        this.mousingRectGeoms.clear();
        for (int i = 0; i < bWidgetArray.length; ++i) {
            String string = ((BLabelPane)bWidgetArray[i]).getLabel().getText();
            double d2 = textFont.width(string) + 12.0;
            if (bValign.equals((Object)BValign.top)) {
                this.mousingRectGeoms.add(new RectGeom(this.totalWidth, 3.0, d2, d - 3.0));
            } else {
                this.mousingRectGeoms.add(new RectGeom(this.totalWidth, 1.0, d2, this.tabListY + d - 3.0));
            }
            this.totalWidth += d2;
        }
        if (this.totalWidth > this.getWidth()) {
            if (this.xOffset > this.getMaxOffset()) {
                this.xOffset = this.getMaxOffset();
            }
            this.tooLong = true;
            this.leftEnabled = this.xOffset > 0.0;
            this.rightEnabled = this.xOffset < this.getMaxOffset();
        } else {
            this.tooLong = false;
            this.xOffset = 0.0;
        }
    }

    public void computePreferredSize() {
        BWidget[] bWidgetArray = this.getChildWidgets();
        if (bWidgetArray.length == 0) {
            this.setPreferredSize(10.0, BMiniTabbedPane.getTabHeight());
            return;
        }
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < bWidgetArray.length; ++i) {
            BLabelPane bLabelPane = (BLabelPane)bWidgetArray[i];
            BWidget bWidget = bLabelPane.getContent();
            bWidget.computePreferredSize();
            d = Math.max(d, bWidget.getPreferredWidth());
            d2 = Math.max(d2, bWidget.getPreferredHeight());
        }
        this.setPreferredSize(d, d2 += BMiniTabbedPane.getTabHeight());
    }

    public void doLayout(BWidget[] bWidgetArray) {
        double d = BMiniTabbedPane.getTabHeight();
        BValign bValign = this.getTabPlacement();
        if (bValign.equals((Object)BValign.center)) {
            System.out.println("WARNING: BMiniTabbedPane.aligment cannot be set to 'center'");
            bValign = BValign.top;
        }
        this.tabListY = bValign.equals((Object)BValign.top) ? 0.0 : this.getHeight() - d;
        this.layoutRects(bWidgetArray, d, bValign);
        for (int i = 0; i < bWidgetArray.length; ++i) {
            BLabelPane bLabelPane = (BLabelPane)bWidgetArray[i];
            BWidget bWidget = bLabelPane.getContent();
            if (i == this.idx) {
                double d2 = 0.0;
                double d3 = bValign.equals((Object)BValign.top) ? d : 0.0;
                double d4 = this.getWidth();
                double d5 = this.getHeight() - d - 0.0;
                bLabelPane.setBounds(d2, d3, d4, d5);
                bLabelPane.setVisible(true);
                bWidget.setBounds(d2, d3, d4, d5);
                bWidget.setVisible(true);
                continue;
            }
            bLabelPane.setBounds(0.0, 0.0, 0.0, 0.0);
            bLabelPane.setVisible(false);
            bWidget.setBounds(0.0, 0.0, 0.0, 0.0);
            bWidget.setVisible(false);
        }
    }

    public BLabelPane getSelectedLabelPane() {
        BWidget[] bWidgetArray = this.getChildWidgets();
        if (bWidgetArray.length == 0) {
            return null;
        }
        return (BLabelPane)bWidgetArray[this.idx];
    }

    public void selectPane(BWidget bWidget) {
        System.out.println("BMiniTabbedPane.selectPane: aaa " + bWidget);
        BWidget[] bWidgetArray = this.getChildWidgets();
        if (bWidgetArray.length == 0) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < bWidgetArray.length; ++i) {
            System.out.println("BMiniTabbedPane.selectPane: bbb " + i + ", " + ((BLabelPane)bWidgetArray[i]).getContent());
            if (((BLabelPane)bWidgetArray[i]).getContent() != bWidget) continue;
            this.idx = i;
            return;
        }
        throw new IllegalStateException();
    }

    private static double getTabHeight() {
        return textFont.getHeight() + 4.0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

