/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.util;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.util.WbUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.sync.Transaction;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BIPropertyContainer;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Knob;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BMenu;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.table.TableSubject;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BWbComponentView;

public class BLinkSheet
extends BWbComponentView
implements BWbComponentView.Attachable {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$util$BLinkSheet == null ? (class$com$tridium$workbench$util$BLinkSheet = BLinkSheet.class$("com.tridium.workbench.util.BLinkSheet")) : class$com$tridium$workbench$util$BLinkSheet));
    private static Lexicon lex = Lexicon.make((String)"workbench");
    static final String[] cols = new String[]{lex.getText("linkSheet.mySlot"), lex.getText("linkSheet.direction"), lex.getText("linkSheet.otherPath"), lex.getText("linkSheet.otherSlot"), lex.getText("linkSheet.enabled"), lex.getText("linkSheet.type")};
    private static BImage iconIn = BImage.make((String)"module://icons/x16/arrowLeft.png");
    private static BImage iconOut = BImage.make((String)"module://icons/x16/arrowRight.png");
    private static BImage goTo = BImage.make((String)"module://icons/x16/arrowRight.png");
    private BComponent c;
    private BTable table;
    private Model model;
    private DeleteLinks deleteLinks;
    private EditLink editLink = new EditLink(this);
    private Hyperlink hyperlink;
    static /* synthetic */ Class class$com$tridium$workbench$util$BLinkSheet;
    static /* synthetic */ Class class$javax$baja$sys$BComponent;

    public Type getType() {
        return TYPE;
    }

    public BLinkSheet() {
        this.editLink.setEnabled(false);
        this.deleteLinks = new DeleteLinks(this);
        this.deleteLinks.setEnabled(false);
        this.hyperlink = new Hyperlink(this);
        this.hyperlink.setEnabled(false);
        this.model = new Model();
        this.table = new BTable();
        this.table.setModel((TableModel)new DynamicTableModel((TableModel)this.model, new int[]{0, 1, 2, 3}));
        this.table.setSelection((TableSelection)new Selection());
        this.table.setController((TableController)new Controller());
        this.table.setCellRenderer((TableCellRenderer)new Renderer());
        this.setContent((BWidget)new BBorderPane((BWidget)this.table, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
    }

    public BMenu[] getViewMenus() {
        return new BMenu[]{this.buildMenu()};
    }

    public BToolBar getViewToolBar() {
        BToolBar bToolBar = new BToolBar();
        bToolBar.add(null, (Command)this.deleteLinks);
        return bToolBar;
    }

    protected void doLoadValue(BObject bObject, Context context) throws Exception {
        this.c = (BComponent)bObject;
        this.refreshModel();
    }

    private void refreshModel() {
        int n;
        Row row;
        BLink bLink;
        this.model.rows.clear();
        BLink[] bLinkArray = this.c.getLinks();
        for (int i = 0; i < bLinkArray.length; ++i) {
            bLink = bLinkArray[i];
            BComponent bComponent = null;
            try {
                bComponent = (BComponent)bLink.getSourceOrd().resolve((BObject)this.c.getComponentSpace()).get();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            row = new Row();
            row.link = bLink;
            row.direction = 0;
            row.mySlot = bLink.getTargetSlotName();
            row.otherPath = bComponent == null ? "Unresolved: " + bLink.getSourceOrd() : "" + bComponent.getSlotPath();
            row.otherSlot = bLink.getSourceSlotName();
            row.enabled = String.valueOf(bLink.isEnabled());
            row.type = bLink.getType().toString();
            row.parent = this.c;
            row.prop = bLink.getPropertyInParent();
            this.model.rows.add(row);
        }
        Knob[] knobArray = this.c.getKnobs();
        bLink = new Array(class$javax$baja$sys$BComponent == null ? (class$javax$baja$sys$BComponent = BLinkSheet.class$("javax.baja.sys.BComponent")) : class$javax$baja$sys$BComponent);
        for (n = 0; n < knobArray.length; ++n) {
            try {
                bLink.add((Object)knobArray[n].getTargetOrd().resolve((BObject)this.c.getComponentSpace()).get());
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        if (bLink.size() > 0) {
            BComponent.lease((BComponent[])((BComponent[])bLink.trim()), (int)0);
        }
        for (n = 0; n < bLink.size(); ++n) {
            try {
                row = (BComponent)bLink.get(n);
                Row row2 = new Row();
                row2.direction = 1;
                row2.mySlot = knobArray[n].getSourceSlotName();
                row2.otherPath = row.getSlotPath().toString();
                row2.otherSlot = knobArray[n].getTargetSlotName();
                row2.parent = row;
                BLink[] bLinkArray2 = row.getLinks();
                for (int i = 0; i < bLinkArray2.length; ++i) {
                    BLink bLink2;
                    if (bLinkArray2[i].getSourceOrd().get((BObject)this.c) != this.c || !bLinkArray2[i].getSourceSlotName().equals(row2.mySlot) || !bLinkArray2[i].getTargetSlotName().equals(row2.otherSlot)) continue;
                    row2.link = bLink2 = bLinkArray2[i];
                    row2.enabled = String.valueOf(bLink2.isEnabled());
                    row2.type = bLink2.getType().toString();
                    row2.prop = bLink2.getPropertyInParent();
                    break;
                }
                this.model.rows.add(row2);
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        this.table.sizeColumnsToFit();
        this.table.relayout();
    }

    private BMenu buildMenu() {
        BMenu bMenu = new BMenu(lex.get("linkSheet"));
        bMenu.add(null, (Command)this.editLink);
        bMenu.add(null, (Command)this.deleteLinks);
        bMenu.add(null, (Command)this.hyperlink);
        return bMenu;
    }

    public void attached(BWbComponentView bWbComponentView) {
    }

    public void detached(BWbComponentView bWbComponentView) {
    }

    public void handleComponentEvent(BComponentEvent bComponentEvent) {
        switch (bComponentEvent.getId()) {
            case 1: 
            case 2: 
            case 8: 
            case 9: {
                this.refreshModel();
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Hyperlink
    extends Command {
        public Hyperlink(BWidget bWidget) {
            super(bWidget, lex.getText("linkSheet.goTo"));
        }

        public CommandArtifact doInvoke() {
            int[] nArray = BLinkSheet.this.table.getSelection().getRows();
            Row row = (Row)((BLinkSheet)BLinkSheet.this).model.rows.get(nArray[0]);
            BLinkSheet.this.getWbShell().hyperlink(BOrd.make((String)("station:|" + row.otherPath)));
            return null;
        }

        public BImage getIcon() {
            return goTo;
        }
    }

    class DeleteLinks
    extends Command {
        public DeleteLinks(BWidget bWidget) {
            super(bWidget, UiLexicon.bajaui().module, "commands.deleteLinks");
        }

        public CommandArtifact doInvoke() throws Exception {
            int n;
            Context context = Transaction.start((BComponent)BLinkSheet.this.c, null);
            int[] nArray = BLinkSheet.this.table.getSelection().getRows();
            Row[] rowArray = new Row[nArray.length];
            int n2 = -1;
            for (n = 0; n < rowArray.length; ++n) {
                rowArray[n] = (Row)((BLinkSheet)BLinkSheet.this).model.rows.get(nArray[n]);
                if (n2 == -1) {
                    n2 = WbUtil.compositeDeletionWarning((BWidget)BLinkSheet.this, (BIPropertyContainer)rowArray[n].parent, (Slot)rowArray[n].prop);
                }
                if (n2 != 2) continue;
                return null;
            }
            BLinkSheet.this.table.getSelection().deselectAll();
            for (n = 0; n < rowArray.length; ++n) {
                rowArray[n].parent.remove(rowArray[n].prop, context);
            }
            Transaction.end((BComponent)BLinkSheet.this.c, (Context)context);
            return null;
        }
    }

    class EditLink
    extends Command {
        public EditLink(BWidget bWidget) {
            super(bWidget, Lexicon.make((String)"workbench"), "edit");
        }

        public CommandArtifact doInvoke() throws Exception {
            int n = BLinkSheet.this.table.getSelection().getRow();
            Row row = (Row)((BLinkSheet)BLinkSheet.this).model.rows.get(n);
            BLink bLink = row.link;
            bLink.getParent().asComponent().lease();
            BObject bObject = BWbFieldEditor.dialog(this.getOwner(), this.getLabel(), (BObject)bLink);
            if (bObject != null) {
                BLinkSheet.this.refreshModel();
            }
            return null;
        }
    }

    class Renderer
    extends TableCellRenderer {
        Renderer() {
        }

        public void paintCell(Graphics graphics, TableCellRenderer.Cell cell) {
            String string;
            TableModel tableModel = this.getTable().getModel();
            this.paintCellBackground(graphics, cell);
            double d = 2.0;
            double d2 = (cell.height - 16.0) / 2.0;
            if (cols[1].equals(tableModel.getColumnName(cell.column)) && (string = tableModel.getRowIcon(cell.row)) != null) {
                graphics.drawImage((BImage)string, d, d2);
                d += 18.0;
            }
            string = this.getCellText(cell);
            BFont bFont = Theme.table().getCellFont();
            switch (tableModel.getColumnAlignment(cell.column).getOrdinal()) {
                case 2: {
                    d = cell.width - 2.0 - bFont.width(string);
                    break;
                }
                case 1: {
                    d = (cell.width - bFont.width(string)) / 2.0;
                }
            }
            graphics.setFont(bFont);
            graphics.drawString(string, d, bFont.getAscent() + 2.0);
        }
    }

    class Controller
    extends TableController {
        Controller() {
        }

        protected void cellDoubleClicked(BMouseEvent bMouseEvent, int n, int n2) {
            Row row = (Row)((BLinkSheet)BLinkSheet.this).model.rows.get(n);
            if (BLinkSheet.this.editLink.isEnabled()) {
                BLinkSheet.this.editLink.invoke();
            }
        }

        protected BMenu makePopup(TableSubject tableSubject) {
            return BLinkSheet.this.buildMenu();
        }

        public int getTextSearchColumn() {
            return 0;
        }
    }

    class Selection
    extends TableSelection {
        Selection() {
        }

        public void updateTable() {
            super.updateTable();
            int n = this.getRows().length;
            BLinkSheet.this.editLink.setEnabled(n == 1);
            BLinkSheet.this.deleteLinks.setEnabled(n > 0);
            BLinkSheet.this.hyperlink.setEnabled(n == 1);
        }
    }

    class RowSorter
    implements Comparator {
        private int col = 0;
        private boolean ascending = true;

        public RowSorter(int n, boolean bl) {
            this.col = n;
            this.ascending = bl;
        }

        public int compare(Object object, Object object2) {
            Row row;
            Row row2;
            if (this.ascending) {
                row2 = (Row)object;
                row = (Row)object2;
            } else {
                row2 = (Row)object2;
                row = (Row)object;
            }
            switch (this.col) {
                case 0: {
                    return row2.mySlot.compareTo(row.mySlot);
                }
                case 1: {
                    if (row2.direction < row.direction) {
                        return -1;
                    }
                    if (row2.direction == row.direction) {
                        return 0;
                    }
                    return 1;
                }
                case 2: {
                    return row2.otherPath.compareTo(row.otherPath);
                }
                case 3: {
                    return row2.otherSlot.compareTo(row.otherSlot);
                }
                case 4: {
                    return row2.enabled.compareTo(row.enabled);
                }
                case 5: {
                    return row2.type.compareTo(row.type);
                }
            }
            return 0;
        }
    }

    class Row {
        public BLink link;
        public int direction = 0;
        public String mySlot = "";
        public String otherPath = "";
        public String otherSlot = "";
        public String enabled = "";
        public String type = "";
        public Property prop = null;
        public BComponent parent = null;
        public static final int IN = 0;
        public static final int OUT = 1;

        Row() {
        }
    }

    class Model
    extends TableModel {
        ArrayList rows = new ArrayList();

        Model() {
        }

        public int getColumnCount() {
            return cols.length;
        }

        public String getColumnName(int n) {
            return cols[n];
        }

        public int getRowCount() {
            return this.rows.size();
        }

        public Object getSubject(int n) {
            return this.rows.get(n);
        }

        public Object getValueAt(int n, int n2) {
            Row row = (Row)this.rows.get(n);
            switch (n2) {
                case 0: {
                    return row.mySlot;
                }
                case 2: {
                    return row.otherPath;
                }
                case 3: {
                    return row.otherSlot;
                }
                case 4: {
                    return row.enabled;
                }
                case 5: {
                    return row.type;
                }
            }
            return "";
        }

        public BImage getRowIcon(int n) {
            Row row = (Row)this.rows.get(n);
            return row.direction == 0 ? iconIn : iconOut;
        }

        public boolean isColumnSortable(int n) {
            return true;
        }

        public void sortByColumn(int n, boolean bl) {
            Row[] rowArray = this.rows.toArray(new Row[this.rows.size()]);
            Arrays.sort(rowArray, new RowSorter(n, bl));
            this.rows.clear();
            for (int i = 0; i < rowArray.length; ++i) {
                this.rows.add(rowArray[i]);
            }
        }
    }
}

