/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.util;

import com.tridium.ui.BOptionDialog;
import com.tridium.ui.UiEnv;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.util.SlotBarUtil;
import java.util.ArrayList;
import java.util.ListIterator;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.nre.util.Array;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.LinkCheck;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BValueBinding;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BWsAnnotation;
import javax.baja.util.Lexicon;

public class BLinkPad
extends BEdgePane {
    public static final Action labelMouseEvent = BLinkPad.newAction((int)0, (BValue)new BMouseEvent(), null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$util$BLinkPad == null ? (class$com$tridium$workbench$util$BLinkPad = BLinkPad.class$("com.tridium.workbench.util.BLinkPad")) : class$com$tridium$workbench$util$BLinkPad));
    private static Context context = new BasicContext();
    private static BImage actionIcon = BImage.make((String)"module://icons/x16/action.png");
    private static BImage topicIcon = BImage.make((String)"module://icons/x16/topic.png");
    private static BImage objectIcon = BImage.make((String)"module://icons/x16/object.png");
    private static final Lexicon lex = Lexicon.make((Class)(class$com$tridium$workbench$util$BLinkPad == null ? (class$com$tridium$workbench$util$BLinkPad = BLinkPad.class$("com.tridium.workbench.util.BLinkPad")) : class$com$tridium$workbench$util$BLinkPad));
    private IComponent source;
    private IComponent target;
    private String sourceSlotName;
    private String targetSlotName;
    private SlotModel sourceModel;
    private SlotModel targetModel;
    private BTable sourceTable;
    private BTable targetTable;
    private BLabel status;
    private BLabel sourceLabel;
    private BLabel targetLabel;
    private Command reverse = new Reverse((BWidget)this);
    static /* synthetic */ Class class$com$tridium$workbench$util$BLinkPad;
    static /* synthetic */ Class class$com$tridium$workbench$util$BLinkPad$SlotInfo;

    public void labelMouseEvent(BMouseEvent bMouseEvent) {
        this.invoke(labelMouseEvent, (BValue)bMouseEvent, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean openInDialog(BWidget bWidget, String string, String string2) {
        String string3 = UiLexicon.bajaui().getText("linking.title");
        BOptionDialog bOptionDialog = new BOptionDialog(bWidget, string3, (BWidget)this, 3, null, null);
        bOptionDialog.getOkButton().setEnabled(false);
        if (string != null) {
            this.selectSourceSlot(string);
        }
        if (string2 != null) {
            this.selectTargetSlot(string2);
        }
        bOptionDialog.setBoundsCenteredOnOwner();
        bOptionDialog.open();
        if (bOptionDialog.getResult() == 1) {
            int n = this.sourceTable.getSelection().getRow();
            int n2 = this.targetTable.getSelection().getRow();
            if (n != -1 && n2 != -1) {
                this.sourceSlotName = this.sourceModel.slots[n].slotName;
                this.targetSlotName = this.targetModel.slots[n2].slotName;
                return true;
            }
        }
        return false;
    }

    private void selectSourceSlot(String string) {
        for (int i = 0; i < this.sourceModel.slots.length; ++i) {
            if (!this.sourceModel.slots[i].slotName.equals(string)) continue;
            this.sourceTable.getSelection().select(i);
            return;
        }
    }

    private void selectTargetSlot(String string) {
        for (int i = 0; i < this.targetModel.slots.length; ++i) {
            if (!this.targetModel.slots[i].slotName.equals(string)) continue;
            this.targetTable.getSelection().select(i);
            return;
        }
    }

    public BLinkPad() {
        throw new IllegalStateException();
    }

    public BLinkPad(BComponent[] bComponentArray, BComponent[] bComponentArray2) {
        this.source = bComponentArray.length == 1 ? new SingleComponent(bComponentArray[0]) : new MultiComponent(bComponentArray);
        this.target = bComponentArray2.length == 1 ? new SingleComponent(bComponentArray2[0]) : new MultiComponent(bComponentArray2);
        this.build();
    }

    public void build() {
        String string = this.source.getDisplayName() + " [" + UiLexicon.bajaui().getText("linking.source") + "]";
        String string2 = this.target.getDisplayName() + " [" + UiLexicon.bajaui().getText("linking.target") + "]";
        this.sourceLabel = new BLabel(string, Theme.widget().getBoldText(), BHalign.left);
        this.targetLabel = new BLabel(string2, Theme.widget().getBoldText(), BHalign.left);
        this.sourceLabel.add(null, (BValue)new BValueBinding());
        this.targetLabel.add(null, (BValue)new BValueBinding());
        this.linkTo((BComponent)this.sourceLabel, (Slot)BWidget.mouseEvent, (Slot)labelMouseEvent);
        this.linkTo((BComponent)this.targetLabel, (Slot)BWidget.mouseEvent, (Slot)labelMouseEvent);
        this.sourceModel = new SlotModel(this.source);
        this.targetModel = new SlotModel(this.target);
        this.sourceTable = this.newTable(this.sourceModel);
        this.targetTable = this.newTable(this.targetModel);
        String string3 = "Link \"" + string + "\" -> \"" + string2 + "\"";
        this.status = new BLabel(string3, BHalign.left);
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setTop((BWidget)new BBorderPane((BWidget)this.sourceLabel, 0.0, 0.0, 5.0, 0.0));
        bEdgePane.setCenter((BWidget)new BBorderPane((BWidget)this.sourceTable, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        BEdgePane bEdgePane2 = new BEdgePane();
        bEdgePane2.setTop((BWidget)new BBorderPane((BWidget)this.targetLabel, 0.0, 0.0, 5.0, 0.0));
        bEdgePane2.setCenter((BWidget)new BBorderPane((BWidget)this.targetTable, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        BButton bButton = new BButton(this.reverse, false, true);
        bButton.setButtonStyle(BButtonStyle.toolBar);
        BGridPane bGridPane = new BGridPane();
        bGridPane.add(null, (BValue)bButton);
        BEdgePane bEdgePane3 = new BEdgePane();
        bEdgePane3.setLeft((BWidget)bGridPane);
        bEdgePane3.setCenter((BWidget)bEdgePane2);
        BSplitPane bSplitPane = new BSplitPane();
        bSplitPane.setMoveableDivider(false);
        bSplitPane.setDividerPosition(47.0);
        bSplitPane.setDividerWidth(0.0);
        bSplitPane.setWidget1((BWidget)bEdgePane);
        bSplitPane.setWidget2((BWidget)bEdgePane3);
        this.setCenter((BWidget)bSplitPane);
        this.setBottom((BWidget)new BBorderPane((BWidget)this.status, 5.0, 0.0, 5.0, 0.0));
    }

    private BTable newTable(SlotModel slotModel) {
        BTable bTable = new BTable((TableModel)slotModel);
        bTable.setOptionsButtonVisible(false);
        bTable.setMultipleSelection(false);
        bTable.setCellRenderer((TableCellRenderer)new SlotRenderer());
        bTable.setSelection((TableSelection)new SlotSelection());
        bTable.setController((TableController)new SlotController());
        bTable.setHeaderVisible(false);
        return bTable;
    }

    private BOptionDialog getOptionDialog() {
        BWidget bWidget = this.getParentWidget();
        while (!(bWidget instanceof BDialog)) {
            bWidget = bWidget.getParentWidget();
        }
        return (BOptionDialog)bWidget;
    }

    public void computePreferredSize() {
        this.setPreferredSize(500.0, 380.0);
    }

    private SlotRow[] makeRows(IComponent iComponent, String[] stringArray) {
        ArrayList<SlotRow> arrayList = new ArrayList<SlotRow>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!iComponent.isValidSlotRow(stringArray[i])) continue;
            arrayList.add(new SlotRow(stringArray[i], iComponent));
        }
        return arrayList.toArray(new SlotRow[arrayList.size()]);
    }

    private static BImage getIcon(BComponent bComponent, String string) {
        BImage bImage;
        Slot slot = bComponent.getSlot(string);
        if (slot.isAction()) {
            bImage = actionIcon;
        }
        if (slot.isTopic()) {
            bImage = topicIcon;
        }
        try {
            BValue bValue = bComponent.get((Property)slot);
            bImage = BImage.make((BIcon)bValue.getIcon());
        }
        catch (Exception exception) {
            bImage = objectIcon;
        }
        return bImage;
    }

    private static boolean isValidSlotRow(BComponent bComponent, String string) {
        Slot slot = bComponent.getSlot(string);
        if (Flags.isHidden((BComplex)bComponent, (Slot)slot)) {
            return false;
        }
        if (slot.isProperty()) {
            BValue bValue = bComponent.get(slot.asProperty());
            if (bValue.isComponent() && !(bValue instanceof BVector)) {
                return false;
            }
            if (bValue instanceof BLink) {
                return false;
            }
            return !(bValue instanceof BWsAnnotation);
        }
        return true;
    }

    private static LinkCheck checkLink(BComponent[] bComponentArray, BComponent[] bComponentArray2, String string, String string2) {
        for (int i = 0; i < bComponentArray2.length; ++i) {
            Slot slot = bComponentArray2[i].getSlot(string2);
            for (int j = 0; j < bComponentArray.length; ++j) {
                Slot slot2 = bComponentArray[j].getSlot(string);
                LinkCheck linkCheck = bComponentArray2[i].checkLink(bComponentArray[j], slot2, slot, context);
                if (!linkCheck.isValid()) {
                    return linkCheck;
                }
                if (j <= 0 || slot.isAction() || slot.isTopic() || !slot.isProperty() || Flags.isFanIn((BComplex)bComponentArray2[i], (Slot)slot)) continue;
                return LinkCheck.makeInvalid((String)lex.getText("linkpad.propNoFanIn"));
            }
        }
        return LinkCheck.makeValid();
    }

    public void doLabelMouseEvent(BMouseEvent bMouseEvent) {
        if (bMouseEvent.getId() == 512) {
            BWidget bWidget = bMouseEvent.getWidget();
            BComponent[] bComponentArray = bWidget == this.sourceLabel ? this.source.getComponents() : this.target.getComponents();
            double d = bMouseEvent.getX();
            double d2 = bMouseEvent.getY();
            d2 = Math.max(bWidget.getHeight() + 1.0, d2 + 16.0);
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < bComponentArray.length; ++i) {
                stringBuffer.append(bComponentArray[i].toPathString());
                stringBuffer.append(" (");
                stringBuffer.append(bComponentArray[i].getType());
                stringBuffer.append(")\n");
                if (i <= 50) continue;
                stringBuffer.append("...");
                break;
            }
            UiEnv.get().openBubbleHelp(bWidget, d, d2, stringBuffer.toString());
        } else if (bMouseEvent.getId() == 505) {
            UiEnv.get().closeBubbleHelp();
            this.repaint();
        }
    }

    public BComponent[] getSourceArray() {
        return this.source.getComponents();
    }

    public BComponent[] getTargetArray() {
        return this.target.getComponents();
    }

    public String getSourceSlotName() {
        return this.sourceSlotName;
    }

    public String getTargetSlotName() {
        return this.targetSlotName;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class SlotInfo {
        String slotName;
        boolean isProperty;
        boolean isAction;

        SlotInfo(Slot slot) {
            this.slotName = slot.getName();
            this.isProperty = slot.isProperty();
            this.isAction = slot.isAction();
        }

        boolean isValidMatch(Slot slot) {
            return this.slotName.equals(slot.getName()) && this.isProperty == slot.isProperty() && this.isAction == slot.isAction();
        }
    }

    private static class MultiComponent
    implements IComponent {
        private SlotInfo[] slotInfos;
        private BComponent[] comps;

        MultiComponent(BComponent[] bComponentArray) {
            this.comps = bComponentArray;
            Array array = new Array(class$com$tridium$workbench$util$BLinkPad$SlotInfo == null ? (class$com$tridium$workbench$util$BLinkPad$SlotInfo = BLinkPad.class$("com.tridium.workbench.util.BLinkPad$SlotInfo")) : class$com$tridium$workbench$util$BLinkPad$SlotInfo);
            for (int i = 0; i < bComponentArray.length; ++i) {
                Slot[] slotArray;
                if (i == 0) {
                    slotArray = bComponentArray[i].getSlotsArray();
                    for (int j = 0; j < slotArray.length; ++j) {
                        if (Flags.isHidden((BComplex)bComponentArray[i], (Slot)slotArray[j])) continue;
                        array.add((Object)new SlotInfo(slotArray[j]));
                    }
                    continue;
                }
                slotArray = array.copy();
                ListIterator listIterator = slotArray.iterator();
                while (listIterator.hasNext()) {
                    SlotInfo slotInfo = (SlotInfo)listIterator.next();
                    boolean bl = false;
                    Slot[] slotArray2 = bComponentArray[i].getSlotsArray();
                    for (int j = 0; j < slotArray2.length; ++j) {
                        if (!slotInfo.isValidMatch(slotArray2[j])) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    array.remove((Object)slotInfo);
                }
            }
            this.slotInfos = (SlotInfo[])array.trim();
        }

        public String getName() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.comps[0].getName());
            stringBuffer.append(" (");
            stringBuffer.append(this.comps.length);
            stringBuffer.append(")");
            return stringBuffer.toString();
        }

        public String getDisplayName() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.comps[0].getDisplayName(null));
            stringBuffer.append(" (");
            stringBuffer.append(this.comps.length);
            stringBuffer.append(")...");
            return stringBuffer.toString();
        }

        public String getDisplayName(Slot slot) {
            return this.comps[0].getDisplayName(this.comps[0].getSlot(slot.getName()), null);
        }

        public LinkCheck checkLink(IComponent iComponent, String string, String string2) {
            return BLinkPad.checkLink(iComponent.getComponents(), this.comps, string, string2);
        }

        public Slot getDefaultSlot(String string) {
            return this.comps[0].getSlot(string);
        }

        public String getDisplayName(String string) {
            Slot slot = this.comps[0].getSlot(string);
            return this.comps[0].getDisplayName(slot, null);
        }

        public BImage getIcon(String string) {
            return BLinkPad.getIcon(this.comps[0], string);
        }

        public String[] getSlotNamesArray() {
            String[] stringArray = new String[this.slotInfos.length];
            for (int i = 0; i < this.slotInfos.length; ++i) {
                stringArray[i] = this.slotInfos[i].slotName;
            }
            return stringArray;
        }

        public boolean isValidSlotRow(String string) {
            for (int i = 0; i < this.comps.length; ++i) {
                if (BLinkPad.isValidSlotRow(this.comps[i], string)) continue;
                return false;
            }
            return true;
        }

        public BComponent[] getComponents() {
            return this.comps;
        }
    }

    private static class SingleComponent
    implements IComponent {
        BComponent comp;

        SingleComponent(BComponent bComponent) {
            this.comp = bComponent;
        }

        public String getName() {
            return this.comp.getName();
        }

        public String getDisplayName() {
            return this.comp.getDisplayName(null);
        }

        public String getDisplayName(String string) {
            Slot slot = this.comp.getSlot(string);
            return this.comp.getDisplayName(slot, null);
        }

        public String[] getSlotNamesArray() {
            Slot[] slotArray = this.comp.getSlotsArray();
            String[] stringArray = new String[slotArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = slotArray[i].getName();
            }
            return stringArray;
        }

        public LinkCheck checkLink(IComponent iComponent, String string, String string2) {
            return BLinkPad.checkLink(iComponent.getComponents(), this.getComponents(), string, string2);
        }

        public BComponent[] getComponents() {
            return new BComponent[]{this.comp};
        }

        public boolean isValidSlotRow(String string) {
            return BLinkPad.isValidSlotRow(this.comp, string);
        }

        public BImage getIcon(String string) {
            return BLinkPad.getIcon(this.comp, string);
        }

        public Slot getDefaultSlot(String string) {
            return this.comp.getSlot(string);
        }
    }

    private static interface IComponent {
        public String getName();

        public String getDisplayName();

        public String getDisplayName(String var1);

        public String[] getSlotNamesArray();

        public LinkCheck checkLink(IComponent var1, String var2, String var3);

        public BComponent[] getComponents();

        public boolean isValidSlotRow(String var1);

        public BImage getIcon(String var1);

        public Slot getDefaultSlot(String var1);
    }

    class Reverse
    extends Command {
        Reverse(BWidget bWidget) {
            super(bWidget, UiLexicon.bajaui().module, "linking.reverse");
        }

        public CommandArtifact doInvoke() {
            IComponent iComponent = BLinkPad.this.source;
            BLinkPad.this.source = BLinkPad.this.target;
            BLinkPad.this.target = iComponent;
            int n = BLinkPad.this.sourceTable.getSelection().getRow();
            int n2 = BLinkPad.this.targetTable.getSelection().getRow();
            BLinkPad.this.build();
            if (n != -1) {
                BLinkPad.this.targetTable.getSelection().select(n);
            }
            if (n2 != -1) {
                BLinkPad.this.sourceTable.getSelection().select(n2);
            }
            return null;
        }
    }

    class SlotController
    extends TableController {
        SlotController() {
        }

        public void focusGained(BFocusEvent bFocusEvent) {
        }

        protected void cellPressed(BMouseEvent bMouseEvent, int n, int n2) {
            if (bMouseEvent.getClickCount() == 2) {
                BButton bButton = BLinkPad.this.getOptionDialog().getOkButton();
                if (bButton.isEnabled()) {
                    bButton.invokeAction();
                }
                return;
            }
            SlotModel slotModel = (SlotModel)this.getModel();
            if (this.getSelection().isSelected(n)) {
                this.getSelection().deselect(n);
            } else if (slotModel.slots[n].link.isValid()) {
                this.getSelection().deselectAll();
                this.getSelection().select(n);
            }
            this.cellEntered(bMouseEvent, n, n2);
        }

        protected void cellEntered(BMouseEvent bMouseEvent, int n, int n2) {
            String string;
            int n3 = BLinkPad.this.sourceModel.getSelection().getRow();
            int n4 = BLinkPad.this.targetModel.getSelection().getRow();
            String string2 = BLinkPad.this.source.getName();
            String string3 = n < ((BLinkPad)BLinkPad.this).sourceModel.slots.length ? ((BLinkPad)BLinkPad.this).sourceModel.slots[n].slotName : "";
            String string4 = n3 == -1 ? "" : ((BLinkPad)BLinkPad.this).sourceModel.slots[n3].slotName;
            String string5 = BLinkPad.this.target.getName();
            String string6 = n < ((BLinkPad)BLinkPad.this).targetModel.slots.length ? ((BLinkPad)BLinkPad.this).targetModel.slots[n].slotName : "";
            String string7 = string = n4 == -1 ? "" : ((BLinkPad)BLinkPad.this).targetModel.slots[n4].slotName;
            if (n3 != -1 && n4 != -1) {
                BLinkPad.this.status.setText("Link " + string2 + "." + string4 + " -> " + string5 + "." + string);
            } else if (n3 != -1) {
                String string8 = "Link " + string2 + "." + string4 + " -> ";
                string8 = string8 + (this.getModel() == BLinkPad.this.sourceModel ? "?" : (((BLinkPad)BLinkPad.this).targetModel.slots[n].link.isValid() ? string5 + "." + string6 : "Invalid: " + ((BLinkPad)BLinkPad.this).targetModel.slots[n].link.getInvalidReason()));
                BLinkPad.this.status.setText(string8);
            } else if (n4 != -1) {
                String string9 = "Link ";
                string9 = string9 + (this.getModel() == BLinkPad.this.targetModel ? "?" : (((BLinkPad)BLinkPad.this).sourceModel.slots[n].link.isValid() ? string2 + "." + string3 : "Invalid: " + ((BLinkPad)BLinkPad.this).sourceModel.slots[n].link.getInvalidReason()));
                string9 = string9 + " -> " + string5 + "." + string;
                BLinkPad.this.status.setText(string9);
            } else {
                String string10 = this.getModel() == BLinkPad.this.sourceModel ? "Link " + string2 + "." + string3 + " -> ?" : "Link ? -> " + string5 + "." + string6;
                BLinkPad.this.status.setText(string10);
            }
        }

        protected void cellExited(BMouseEvent bMouseEvent, int n, int n2) {
            String string;
            int n3 = BLinkPad.this.sourceModel.getSelection().getRow();
            int n4 = BLinkPad.this.targetModel.getSelection().getRow();
            String string2 = BLinkPad.this.source.getName();
            String string3 = n3 == -1 ? "" : ((BLinkPad)BLinkPad.this).sourceModel.slots[n3].slotName;
            String string4 = BLinkPad.this.target.getName();
            String string5 = string = n4 == -1 ? "" : ((BLinkPad)BLinkPad.this).targetModel.slots[n4].slotName;
            if (n3 != -1 && n4 != -1) {
                BLinkPad.this.status.setText("Link " + string2 + "." + string3 + " -> " + string4 + "." + string);
            } else if (n3 != -1) {
                BLinkPad.this.status.setText("Link " + string2 + "." + string3 + " -> ?");
            } else if (n4 != -1) {
                BLinkPad.this.status.setText("Link ? -> " + string4 + "." + string);
            } else {
                BLinkPad.this.status.setText("");
            }
        }
    }

    class SlotSelection
    extends TableSelection {
        SlotSelection() {
        }

        public void updateTable() {
            IComponent iComponent;
            super.updateTable();
            int n = this.getRow();
            if (this.getModel() == BLinkPad.this.sourceModel) {
                if (n == -1) {
                    BLinkPad.this.targetModel.resetState();
                } else {
                    iComponent = ((BLinkPad)BLinkPad.this).sourceModel.component;
                    String string = ((BLinkPad)BLinkPad.this).sourceModel.slots[n].slotName;
                    BLinkPad.this.targetModel.updateStateFrom(((BLinkPad)BLinkPad.this).sourceModel.component, string);
                }
                BLinkPad.this.targetTable.repaint();
            } else {
                if (n == -1) {
                    BLinkPad.this.sourceModel.resetState();
                } else {
                    iComponent = ((BLinkPad)BLinkPad.this).targetModel.component;
                    String string = ((BLinkPad)BLinkPad.this).targetModel.slots[n].slotName;
                    BLinkPad.this.sourceModel.updateStateTo(((BLinkPad)BLinkPad.this).targetModel.component, string);
                }
                BLinkPad.this.sourceTable.repaint();
            }
            boolean bl = BLinkPad.this.sourceModel.getSelection().getRow() != -1 && BLinkPad.this.targetModel.getSelection().getRow() != -1;
            BLinkPad.this.getOptionDialog().getOkButton().setEnabled(bl);
        }
    }

    class SlotRenderer
    extends TableCellRenderer {
        SlotRenderer() {
        }

        public String getCellText(TableCellRenderer.Cell cell) {
            return ((SlotRow)cell.value).displayName;
        }

        public BBrush getForeground(TableCellRenderer.Cell cell) {
            SlotRow slotRow = (SlotRow)cell.value;
            return slotRow.enabled ? BColor.black.toBrush() : BColor.gray.toBrush();
        }

        public BBrush getSelectionForeground(TableCellRenderer.Cell cell) {
            return this.getForeground(cell);
        }

        public BBrush getSelectionBackground(TableCellRenderer.Cell cell) {
            return null;
        }

        public void paintCell(Graphics graphics, TableCellRenderer.Cell cell) {
            SlotRow slotRow = (SlotRow)cell.value;
            if (slotRow.enabled) {
                double d = cell.width / 12.0 + 1.0;
                graphics.drawImage(SlotBarUtil.getSlotBar((BWidget)this.getTable(), slotRow.defaultSlot, (int)d), 0.0, 0.0);
            }
            super.paintCell(graphics, cell);
            if (this.getSelection().isSelected(cell.row)) {
                graphics.setBrush(BColor.red);
                graphics.strokeRect(0.0, 0.0, cell.width - 3.0, cell.height - 2.0);
            }
        }
    }

    class SlotRow {
        Slot defaultSlot;
        String slotName;
        String displayName;
        BImage icon;
        boolean enabled = true;
        LinkCheck link = LinkCheck.makeValid();

        public SlotRow(String string, IComponent iComponent) {
            this.slotName = string;
            this.displayName = iComponent.getDisplayName(string);
            this.icon = iComponent.getIcon(string);
            this.defaultSlot = iComponent.getDefaultSlot(string);
        }
    }

    class SlotModel
    extends TableModel {
        IComponent component;
        SlotRow[] slots;

        public SlotModel(IComponent iComponent) {
            this.component = iComponent;
            this.slots = BLinkPad.this.makeRows(iComponent, iComponent.getSlotNamesArray());
        }

        public int getRowCount() {
            return this.slots.length;
        }

        public int getColumnCount() {
            return 1;
        }

        public String getColumnName(int n) {
            return "";
        }

        public Object getValueAt(int n, int n2) {
            return this.slots[n];
        }

        public Object getSubject(int n) {
            return this.slots[n];
        }

        public BImage getRowIcon(int n) {
            BImage bImage = this.slots[n].icon;
            return this.slots[n].enabled ? bImage : bImage.getDisabledImage();
        }

        public void updateStateFrom(IComponent iComponent, String string) {
            for (int i = 0; i < this.slots.length; ++i) {
                this.slots[i].link = this.component.checkLink(iComponent, string, this.slots[i].slotName);
                this.slots[i].enabled = this.slots[i].link.isValid();
                if (this.slots[i].link.isValid() || !this.getSelection().isSelected(i)) continue;
                this.getSelection().deselect(i);
            }
        }

        public void updateStateTo(IComponent iComponent, String string) {
            for (int i = 0; i < this.slots.length; ++i) {
                this.slots[i].link = iComponent.checkLink(this.component, this.slots[i].slotName, string);
                this.slots[i].enabled = this.slots[i].link.isValid();
                if (this.slots[i].link.isValid() || !this.getSelection().isSelected(i)) continue;
                this.getSelection().deselect(i);
            }
        }

        public void resetState() {
            for (int i = 0; i < this.slots.length; ++i) {
                this.slots[i].enabled = true;
                this.slots[i].link = LinkCheck.makeValid();
            }
        }
    }
}

