/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.util;

import com.tridium.net.BHttpObject;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.file.BExportDialog;
import com.tridium.workbench.shell.BNiagaraWbWebShell;
import java.io.File;
import javax.baja.file.BIFile;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.types.application.BApplicationFile;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.ViewQuery;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.view.BWbView;

public class BGenericAppFileView
extends BWbView {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$util$BGenericAppFileView == null ? (class$com$tridium$workbench$util$BGenericAppFileView = BGenericAppFileView.class$("com.tridium.workbench.util.BGenericAppFileView")) : class$com$tridium$workbench$util$BGenericAppFileView));
    static Lexicon lex = Lexicon.make((String)"workbench");
    static final String note1 = lex.getText("genericAppFileView.note1");
    static final String note2 = lex.getText("genericAppFileView.note2");
    static final String browserNote = lex.getText("genericAppFileView.browserNote");
    static final String launch = lex.getText("genericAppFileView.launch");
    static /* synthetic */ Class class$com$tridium$workbench$util$BGenericAppFileView;

    public Type getType() {
        return TYPE;
    }

    protected void doLoadValue(BObject bObject, Context context) throws Exception {
        if (bObject instanceof BApplicationFile) {
            this.doLoadApplicationFile((BApplicationFile)bObject);
        } else {
            this.doLoadHttpObject((BHttpObject)bObject);
        }
    }

    void doLoadApplicationFile(BApplicationFile bApplicationFile) {
        BImage bImage = BImage.make((BIcon)bApplicationFile.getIcon());
        String string = bApplicationFile.getFileName();
        boolean bl = bApplicationFile.getStore() instanceof BLocalFileStore;
        boolean bl2 = this.getShell() instanceof BNiagaraWbWebShell;
        String string2 = note1;
        if (bl) {
            string2 = string2 + " " + note2;
        } else if (bl2) {
            string2 = string2 + " " + browserNote;
        }
        BLabel bLabel = new BLabel(bImage, string);
        bLabel.setFont(Theme.widget().getBoldText());
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.add(null, (BValue)bLabel);
        bGridPane.add(null, (BValue)new BLabel(string2));
        BGridPane bGridPane2 = new BGridPane(1);
        bGridPane2.setColumnAlign(BHalign.center);
        bGridPane2.add(null, (BValue)new BBorderPane((BWidget)bGridPane, 0.0, 0.0, 10.0, 0.0));
        if (bl) {
            bGridPane2.add(null, (BValue)new BButton((Command)new LaunchFile(this, (BIFile)bApplicationFile)));
        } else if (bl2) {
            bGridPane2.add(null, (BValue)new BButton((Command)new LaunchFromBrowser(this, (BIFile)bApplicationFile)));
        }
        this.setContent((BWidget)bGridPane2);
    }

    void doLoadHttpObject(BHttpObject bHttpObject) {
        BImage bImage = BImage.make((String)"module://icons/x16/files/html.png");
        String string = bHttpObject.getUri();
        String string2 = note1 + " " + note2;
        BLabel bLabel = new BLabel(bImage, string);
        bLabel.setFont(Theme.widget().getBoldText());
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.add(null, (BValue)bLabel);
        bGridPane.add(null, (BValue)new BLabel(string2));
        BGridPane bGridPane2 = new BGridPane(1);
        bGridPane2.setColumnAlign(BHalign.center);
        bGridPane2.add(null, (BValue)new BBorderPane((BWidget)bGridPane, 0.0, 0.0, 10.0, 0.0));
        bGridPane2.add(null, (BValue)new BButton((Command)new LaunchUri(this, bHttpObject.getUri())));
        this.setContent((BWidget)bGridPane2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class LaunchFromBrowser
    extends Command {
        BIFile file;

        public LaunchFromBrowser(BWidget bWidget, BIFile bIFile) {
            super(bWidget, launch);
            this.file = bIFile;
        }

        public CommandArtifact doInvoke() throws Exception {
            BNiagaraWbWebShell bNiagaraWbWebShell = (BNiagaraWbWebShell)this.getShell();
            BOrd bOrd = this.file.getNavOrd();
            if (bNiagaraWbWebShell.isWebStart()) {
                bOrd = BOrd.make((BOrd)bOrd, (OrdQuery)new ViewQuery("?browser=true"));
            }
            bNiagaraWbWebShell.reloadHyperlink(new HyperlinkInfo(bOrd));
            return null;
        }
    }

    class LaunchUri
    extends Command {
        String uri;

        public LaunchUri(BWidget bWidget, String string) {
            super(bWidget, launch);
            this.uri = string;
        }

        public CommandArtifact doInvoke() throws Exception {
            if (System.getProperty("os.name").equalsIgnoreCase("linux")) {
                Runtime.getRuntime().exec("gnome-open " + this.uri);
            } else {
                Runtime.getRuntime().exec("cmd.exe /c start " + this.uri);
            }
            return null;
        }
    }

    class LaunchFile
    extends Command {
        BIFile file;

        public LaunchFile(BWidget bWidget, BIFile bIFile) {
            super(bWidget, launch);
            this.file = bIFile;
        }

        public CommandArtifact doInvoke() throws Exception {
            File file = ((BLocalFileStore)this.file.getStore()).getLocalFile();
            BExportDialog.launchExternal(file);
            return null;
        }
    }
}

