/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.util;

import com.tridium.ui.BFindPane;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.file.BTextFileEditor;
import com.tridium.workbench.shell.BNiagaraWbShell;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.FilePath;
import javax.baja.file.FileUtil;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BProgressDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.commands.ReflectCommand;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.file.BDirectoryChooser;
import javax.baja.ui.list.BCheckList;
import javax.baja.ui.list.BList;
import javax.baja.ui.options.BMruOptions;
import javax.baja.ui.options.BMruTextDropDown;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.text.FindPattern;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.util.PatternFilter;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbView;
import javax.baja.xml.XInputStreamReader;

public class BFileSearch
extends BDialog {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$util$BFileSearch == null ? (class$com$tridium$workbench$util$BFileSearch = BFileSearch.class$("com.tridium.workbench.util.BFileSearch")) : class$com$tridium$workbench$util$BFileSearch));
    static BImage findIcon = BImage.make((String)"module://icons/x32/magnifyingGlass.png");
    static BFont bold = Theme.widget().getBoldText();
    static boolean lastFindText = true;
    static boolean lastSubFolders = true;
    static boolean lastMakeBackup = false;
    static String FILE_PATTERN_DEFAULT = "*.java *.xml *.txt *.html *.properties *.lexicon";
    static String DIR_DEFAULT = Sys.getBajaHome().toString();
    boolean isReplace;
    BCheckBox findText;
    BFindPane findPane;
    BMruTextDropDown filePattern;
    BMruTextDropDown dir;
    BCheckBox subFolders;
    BButton ok;
    BButton cancel;
    Criteria criteria;
    static /* synthetic */ Class class$com$tridium$workbench$util$BFileSearch;

    public Type getType() {
        return TYPE;
    }

    public static void findFiles(BNiagaraWbShell bNiagaraWbShell, String string) {
        BMruOptions.make((String)"findFilesDir").save(string);
        BFileSearch.findFiles(bNiagaraWbShell);
    }

    public static void findFiles(BNiagaraWbShell bNiagaraWbShell) {
        BFileSearch.doIt(bNiagaraWbShell, false);
    }

    public static void replaceInFiles(BNiagaraWbShell bNiagaraWbShell) {
        BFileSearch.doIt(bNiagaraWbShell, true);
    }

    private static void doIt(BNiagaraWbShell bNiagaraWbShell, boolean bl) {
        String string = bl ? BFileSearch.lex().getText("fileSearch.replace.title") : BFileSearch.lex().getText("fileSearch.find.title");
        BFileSearch bFileSearch = new BFileSearch((BWidget)bNiagaraWbShell, string, bl);
        bFileSearch.setBoundsCenteredOnOwner();
        bFileSearch.open();
        if (bFileSearch.criteria == null) {
            return;
        }
        if (bNiagaraWbShell != null) {
            bNiagaraWbShell.openConsole();
        }
        Worker worker = new Worker(bNiagaraWbShell, bFileSearch.criteria);
        BProgressDialog.open((BWidget)bNiagaraWbShell, (String)string, (BProgressDialog.Worker)worker, (BImage)findIcon);
        if (bl) {
            BFileSearch.doReplace(bNiagaraWbShell, worker);
        }
    }

    public BFileSearch() {
        throw new IllegalStateException();
    }

    public BFileSearch(BWidget bWidget, String string, boolean bl) {
        super(bWidget, string, true);
        this.isReplace = bl;
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.setHalign(BHalign.left);
        BWidget bWidget2 = this.makeTextPane();
        BWidget bWidget3 = this.makeFilePane();
        BWidget bWidget4 = this.makeButtonsPane();
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setTop((BWidget)new BBorderPane(bWidget2, 8.0, 8.0, 8.0, 8.0));
        bEdgePane.setBottom((BWidget)new BBorderPane(bWidget3, 8.0, 8.0, 8.0, 8.0));
        BEdgePane bEdgePane2 = new BEdgePane();
        bEdgePane2.setTop((BWidget)new BWizardHeader(findIcon, string));
        bEdgePane2.setCenter((BWidget)new BBorderPane((BWidget)bEdgePane));
        bEdgePane2.setBottom((BWidget)new BBorderPane(bWidget4, 0.0, 10.0, 10.0, 10.0));
        this.setContent((BWidget)bEdgePane2);
        this.setDefaultButton(this.ok);
    }

    BWidget makeTextPane() {
        Object object;
        BWbView bWbView;
        BWidget bWidget;
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.setColumnAlign(BHalign.fill);
        bGridPane.setStretchColumn(0);
        boolean bl = true;
        if (!this.isReplace) {
            this.findText = new BCheckBox((ToggleCommand)new FindTextToggle((BWidget)this));
            bl = this.findText.isSelected();
            bWidget = new BEdgePane();
            bWidget.setLeft((BWidget)this.findText);
            bGridPane.add(null, (BValue)bWidget);
        }
        if ((bWidget = this.getOwner()) instanceof BWbShell && (bWbView = (object = (BWbShell)bWidget).getActiveView()) instanceof BTextFileEditor) {
            bWidget = ((BTextFileEditor)bWbView).text;
        }
        this.findPane = new BFindPane(bWidget, this.isReplace, true);
        this.findPane.setEnabled(bl);
        bGridPane.add(null, (BValue)this.findPane);
        object = BFileSearch.lex().getText("fileSearch.text." + (this.isReplace ? "replace" : "find"));
        return new BBorderPane((BWidget)bGridPane, (String)object);
    }

    BWidget makeFilePane() {
        String string = BFileSearch.lex().getText("fileSearch.file." + (this.isReplace ? "replace" : "find"));
        this.filePattern = new BMruTextDropDown("findFiles", 50);
        if (this.filePattern.getText().length() == 0) {
            this.filePattern.setText(FILE_PATTERN_DEFAULT);
        }
        this.dir = new BMruTextDropDown("findFilesDir", 50);
        if (this.dir.getText().length() == 0) {
            this.dir.setText(DIR_DEFAULT);
        }
        BButton bButton = new BButton((Command)new DirBrowse((BWidget)this), false, true);
        bButton.setButtonStyle(BButtonStyle.toolBar);
        this.subFolders = new BCheckBox(BFileSearch.lex().getText("fileSearch.subFolders"), lastSubFolders);
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.setHalign(BHalign.left);
        bGridPane.setColumnAlign(BHalign.fill);
        bGridPane.setStretchColumn(0);
        bGridPane.add(null, (BValue)new BLabel(string, BHalign.left));
        bGridPane.add(null, (BValue)new BLabel());
        bGridPane.add(null, (BValue)this.filePattern);
        bGridPane.add(null, (BValue)new BLabel());
        bGridPane.add(null, (BValue)new BLabel(BFileSearch.lex().getText("fileSearch.folder"), BHalign.left));
        bGridPane.add(null, (BValue)new BLabel());
        bGridPane.add(null, (BValue)this.dir);
        bGridPane.add(null, (BValue)bButton);
        bGridPane.add(null, (BValue)this.subFolders);
        bGridPane.add(null, (BValue)new BLabel());
        return new BBorderPane((BWidget)bGridPane, string);
    }

    BWidget makeButtonsPane() {
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.setColumnAlign(BHalign.fill);
        bGridPane.setUniformColumnWidth(true);
        this.ok = new BButton((Command)new ReflectCommand((BWidget)this, BFileSearch.lex().getText("dialog.ok"), "ok"));
        this.cancel = new BButton((Command)new ReflectCommand((BWidget)this, BFileSearch.lex().getText("dialog.cancel"), "cancel"));
        bGridPane.add(null, (BValue)this.ok);
        bGridPane.add(null, (BValue)this.cancel);
        return bGridPane;
    }

    public Criteria save() {
        Criteria criteria = new Criteria();
        criteria.isReplace = this.isReplace;
        boolean bl = criteria.isFindText = this.isReplace ? true : this.findText.isSelected();
        if (criteria.isFindText) {
            criteria.textPattern = this.findPane.save();
            FindPattern.setCurrent((FindPattern)criteria.textPattern);
            if (this.isReplace) {
                criteria.replace = this.findPane.getReplaceWith();
            }
        }
        String string = this.filePattern.getTextAndSave();
        criteria.filePatterns = PatternFilter.parseList((String)string);
        criteria.subFolders = lastSubFolders = this.subFolders.isSelected();
        criteria.root = this.saveDirectory(true);
        if (criteria.root == null) {
            BDialog.error((BWidget)this, (Object)BFileSearch.lex().getText("fileSearch.folderNotFound", new Object[]{this.dir.getText()}));
            return null;
        }
        return criteria;
    }

    public File saveDirectory(boolean bl) {
        String string;
        File file = null;
        String string2 = string = bl ? this.dir.getTextAndSave() : this.dir.getText();
        if (string.startsWith("file:")) {
            try {
                file = BFileSystem.INSTANCE.pathToLocalFile(new FilePath(string.substring("file:".length())));
            }
            catch (Exception exception) {
                return null;
            }
        } else {
            file = new File(string);
        }
        if (file != null && file.exists() && file.isDirectory()) {
            return file;
        }
        return null;
    }

    public void ok() {
        this.criteria = this.save();
        if (this.criteria != null) {
            this.close();
        }
    }

    public void cancel() {
        this.close();
    }

    public void windowClosing(BWindowEvent bWindowEvent) {
        this.cancel();
    }

    static void scan(Worker worker, File file) throws Exception {
        BFileSearch.updateScanProgress(worker);
        Criteria criteria = worker.criteria;
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            fileArray = new File[]{};
        }
        for (int i = 0; worker.isAlive && i < fileArray.length; ++i) {
            BFileSearch.updateScanProgress(worker);
            File file2 = fileArray[i];
            ++worker.totalFiles;
            if (file2.isDirectory()) {
                if (file2.getName().equals("libJar") || !criteria.subFolders) continue;
                BFileSearch.scan(worker, file2);
                continue;
            }
            if (!criteria.include(file2)) continue;
            if (!criteria.isFindText) {
                worker.found(file2, 1, 1, null);
            }
            worker.files.add(file2);
        }
    }

    static void updateScanProgress(Worker worker) {
        int n = worker.totalFiles;
        int n2 = worker.files.size();
        if (n - worker.lastScanUpdate >= 10) {
            worker.lastScanUpdate = n;
            Object[] objectArray = new Object[]{String.valueOf(n2), String.valueOf(n)};
            worker.updateProgress(0, BFileSearch.lex().getText("fileSearch.scanningFiles", objectArray));
        }
    }

    static void search(Worker worker, File file) throws Exception {
        BFileSearch.readBuffer(worker, file);
        int n = 0;
        int n2 = worker.len;
        char[] cArray = worker.buf;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            char c = cArray[i];
            boolean bl = false;
            if (c != '\r' && c != '\n') continue;
            if (c == '\r' && i + 1 < n2 && cArray[i + 1] == '\n') {
                bl = true;
            }
            n4 = ++i;
            BFileSearch.process(worker, file, ++n, n3, n4);
            n3 = n4 + 1;
        }
    }

    static void process(Worker worker, File file, int n, int n2, int n3) throws Exception {
        int n4 = 0;
        int n5 = n3 - n2;
        FindPattern findPattern = worker.criteria.textPattern;
        char[] cArray = worker.buf;
        try {
            int n6;
            while ((n6 = findPattern.findNext(cArray, n2 + n4, n5)) >= 0) {
                n4 = n6 - n2 + 1;
                worker.found(file, n, n4, new String(cArray, n2, n3 - n2).trim());
                n5 = n3 - n2 - n4;
            }
        }
        catch (Exception exception) {
            System.out.println("ERROR: " + file + ":" + n);
            exception.printStackTrace();
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void readBuffer(Worker worker, File file) throws Exception {
        BufferedReader bufferedReader = new BufferedReader((Reader)new XInputStreamReader((InputStream)new FileInputStream(file)));
        try {
            int n;
            worker.len = (int)file.length();
            if (worker.buf.length < worker.len) {
                worker.buf = new char[worker.len];
            }
            int n2 = 0;
            while ((n = bufferedReader.read()) >= 0) {
                worker.buf[n2++] = (char)n;
            }
            worker.len = n2;
        }
        catch (IOException iOException) {
            System.out.println("WARNING: Invalid file: " + file);
            System.out.println("  " + iOException);
        }
        finally {
            bufferedReader.close();
        }
    }

    static void doReplace(BNiagaraWbShell bNiagaraWbShell, Worker worker) {
        HashMap hashMap = worker.found;
        Object[] objectArray = hashMap.keySet().toArray(new String[hashMap.size()]);
        SortUtil.sort((Object[])objectArray);
        if (objectArray.length == 0) {
            BDialog.info((BWidget)bNiagaraWbShell, (Object)BFileSearch.lex().getText("fileSearch.noFilesFound"));
            return;
        }
        BCheckList bCheckList = new BCheckList();
        for (int i = 0; i < objectArray.length; ++i) {
            bCheckList.addItem((Object)((String)objectArray[i] + " (" + hashMap.get(objectArray[i]) + ")"));
        }
        BCheckBox bCheckBox = new BCheckBox(BFileSearch.lex().getText("fileSearch.makeBackup"), lastMakeBackup);
        BButton bButton = new BButton((Command)new SelectAll((BWidget)bCheckList));
        BButton bButton2 = new BButton((Command)new DeselectAll((BWidget)bCheckList));
        bButton.setButtonStyle(BButtonStyle.toolBar);
        bButton2.setButtonStyle(BButtonStyle.toolBar);
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.add(null, (BValue)bButton);
        bGridPane.add(null, (BValue)bButton2);
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setLeft((BWidget)bCheckBox);
        bEdgePane.setRight((BWidget)bGridPane);
        BEdgePane bEdgePane2 = new BEdgePane();
        bEdgePane2.setCenter((BWidget)new BBorderPane((BWidget)bCheckList, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        bEdgePane2.setBottom((BWidget)new BBorderPane((BWidget)bEdgePane, 10.0, 0.0, 0.0, 0.0));
        BConstrainedPane bConstrainedPane = new BConstrainedPane((BWidget)bEdgePane2);
        bConstrainedPane.setMinWidth(400.0);
        bConstrainedPane.setMaxHeight(400.0);
        String string = BFileSearch.lex().getText("fileSearch.file.replace");
        int n = BDialog.open((BWidget)bNiagaraWbShell, (String)string, (Object)new BBorderPane((BWidget)bConstrainedPane, 10.0, 10.0, 10.0, 10.0), (int)3);
        if (n != 1) {
            return;
        }
        boolean bl = lastMakeBackup = bCheckBox.isSelected();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!bCheckList.getSelection().isSelected(i)) continue;
            File file = new File((String)objectArray[i]);
            try {
                BFileSearch.replace(worker, file, bl);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                BDialog.error((BWidget)bNiagaraWbShell, (String)"Error", (Object)"Cannot replace", (Throwable)exception);
                break;
            }
        }
    }

    static void replace(Worker worker, File file, boolean bl) throws Exception {
        Criteria criteria = worker.criteria;
        System.out.println("Replace " + criteria.textPattern.string + " -> " + criteria.replace + " " + file + "...");
        BFileSearch.readBuffer(worker, file);
        String string = criteria.textPattern.replace(worker.buf, 0, worker.len, criteria.replace);
        if (bl) {
            FileUtil.renameToBackup((File)file);
        }
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
        printWriter.print(string);
        printWriter.close();
    }

    static UiLexicon lex() {
        return UiLexicon.bajaui();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class DeselectAll
    extends Command {
        public DeselectAll(BWidget bWidget) {
            super(bWidget, BFileSearch.lex().getText("fileSearch.deselectAll"));
        }

        public BImage getIcon() {
            return BImage.make((String)"module://icons/x16/deselectAll.png");
        }

        public CommandArtifact doInvoke() {
            BList bList = (BList)this.getOwner();
            bList.getSelection().deselectAll();
            return null;
        }
    }

    static class SelectAll
    extends Command {
        public SelectAll(BWidget bWidget) {
            super(bWidget, BFileSearch.lex().getText("fileSearch.selectAll"));
        }

        public BImage getIcon() {
            return BImage.make((String)"module://icons/x16/selectAll.png");
        }

        public CommandArtifact doInvoke() {
            BList bList = (BList)this.getOwner();
            bList.getSelection().selectAll();
            return null;
        }
    }

    static class Count {
        int count = 1;

        Count() {
        }

        public String toString() {
            return String.valueOf(this.count);
        }
    }

    static class Worker
    extends BProgressDialog.Worker {
        BNiagaraWbShell shell;
        Criteria criteria;
        int totalFiles;
        ArrayList files = new ArrayList();
        HashMap found = new HashMap();
        int lastScanUpdate = -1000;
        int count;
        char[] buf = new char[1024];
        int len;
        boolean isAlive = true;

        Worker(BNiagaraWbShell bNiagaraWbShell, Criteria criteria) {
            this.shell = bNiagaraWbShell;
            this.criteria = criteria;
        }

        public void doRun() throws Exception {
            BFileSearch.scan(this, this.criteria.root);
            if (this.criteria.isFindText) {
                this.getDialog().getProgressBar().setMax((double)this.files.size());
                for (int i = 0; this.isAlive && i < this.files.size(); ++i) {
                    File file = (File)this.files.get(i);
                    this.updateProgress(i, i + " of " + this.files.size() + ": " + file.getName());
                    BFileSearch.search(this, file);
                }
            }
            this.shell.showStatus("Found " + this.count);
        }

        public void doCancel() {
            this.isAlive = false;
        }

        public void found(File file, int n, int n2, String string) {
            ++this.count;
            String string2 = file.toString();
            Count count = (Count)this.found.get(string2);
            if (count != null) {
                ++count.count;
            } else {
                this.found.put(string2, new Count());
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string2).append(":").append(n).append(":").append(n2);
            if (this.criteria.isFindText) {
                int n3 = n2 + this.criteria.textPattern.string.length();
                stringBuffer.append(":").append(n).append(":").append(n3).append(": ").append(string);
            } else {
                stringBuffer.append(":1:1: ");
            }
            this.shell.getConsole().appendLine(stringBuffer.toString());
            this.shell.repaint();
        }
    }

    public static class Criteria {
        boolean isReplace;
        public File root;
        public boolean subFolders;
        public boolean isFindText;
        public FindPattern textPattern;
        public String replace;
        public PatternFilter[] filePatterns;

        public boolean include(File file) {
            for (int i = 0; i < this.filePatterns.length; ++i) {
                if (!this.filePatterns[i].accept(file.getName())) continue;
                return true;
            }
            return false;
        }
    }

    class FindTextToggle
    extends ToggleCommand {
        FindTextToggle(BWidget bWidget) {
            super(bWidget, BFileSearch.lex().getText("fileSearch.findText"));
            this.setSelected(lastFindText);
        }

        public void setSelected(boolean bl) {
            super.setSelected(bl);
            lastFindText = bl;
            if (BFileSearch.this.findPane != null) {
                BFileSearch.this.findPane.setEnabled(BFileSearch.this.findText.isSelected());
            }
        }
    }

    class DirBrowse
    extends Command {
        DirBrowse(BWidget bWidget) {
            super(bWidget, BFileSearch.lex().module, "fileSearch.dirBrowse");
        }

        public CommandArtifact doInvoke() {
            BOrd bOrd;
            BDirectoryChooser bDirectoryChooser = BDirectoryChooser.make((BWidget)this.getOwner());
            File file = BFileSearch.this.saveDirectory(false);
            if (file != null) {
                bOrd = (BIFile)BFileSystem.INSTANCE.localFileToOrd(file).get();
                bDirectoryChooser.setCurrentDirectory(bOrd.getNavOrd());
            }
            if ((bOrd = bDirectoryChooser.show()) == null) {
                return null;
            }
            BIFile bIFile = (BIFile)bOrd.resolve().get();
            File file2 = ((BLocalFileStore)bIFile.getStore()).getLocalFile();
            BFileSearch.this.dir.setText(file2.toString());
            return null;
        }
    }
}

