/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.util;

import com.tridium.workbench.ord.BDirectoryOrdChooser;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.util.BFileIndexerOptions;
import com.tridium.workbench.util.FileFinder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.sys.BModule;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BProgressDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.commands.ReflectCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.options.BMruTextDropDown;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.util.PatternFilter;

public class BFileIndexer
extends BDialog {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$util$BFileIndexer == null ? (class$com$tridium$workbench$util$BFileIndexer = BFileIndexer.class$("com.tridium.workbench.util.BFileIndexer")) : class$com$tridium$workbench$util$BFileIndexer));
    private static BModule module = Sys.getModuleForClass((Class)(class$com$tridium$workbench$util$BFileIndexer == null ? (class$com$tridium$workbench$util$BFileIndexer = BFileIndexer.class$("com.tridium.workbench.util.BFileIndexer")) : class$com$tridium$workbench$util$BFileIndexer));
    static BImage buildIcon = BImage.make((String)"module://icons/x32/magnifyingGlass.png");
    static UiLexicon lex = new UiLexicon(class$com$tridium$workbench$util$BFileIndexer == null ? (class$com$tridium$workbench$util$BFileIndexer = BFileIndexer.class$("com.tridium.workbench.util.BFileIndexer")) : class$com$tridium$workbench$util$BFileIndexer);
    static String FILE_PATTERN_DEFAULT = "*.java *.xml *.txt *.html *.properties *.lexicon";
    static String IGNORE_FOLDERS_DEFAULT = "libJar";
    BFileIndexerOptions options;
    BList folderList = new BList();
    BMruTextDropDown filePattern;
    BButton ok;
    BButton cancel;
    boolean cancelled = true;
    static /* synthetic */ Class class$com$tridium$workbench$util$BFileIndexer;
    static /* synthetic */ Class class$javax$baja$naming$BOrd;

    public Type getType() {
        return TYPE;
    }

    public static void index(BNiagaraWbShell bNiagaraWbShell) {
        String string = lex.getText("buildFileIndex.title");
        BFileIndexer bFileIndexer = new BFileIndexer((BWidget)bNiagaraWbShell, string);
        bFileIndexer.setBoundsCenteredOnOwner();
        bFileIndexer.open();
        if (bFileIndexer.cancelled) {
            return;
        }
        PatternFilter[] patternFilterArray = PatternFilter.parseList((String)bFileIndexer.filePattern.getTextAndSave());
        File[] fileArray = new File[bFileIndexer.folderList.getItemCount()];
        for (int i = 0; i < bFileIndexer.folderList.getItemCount(); ++i) {
            BOrd bOrd = (BOrd)bFileIndexer.folderList.getItem(i);
            BDirectory bDirectory = (BDirectory)bOrd.resolve().get();
            fileArray[i] = BFileSystem.INSTANCE.pathToLocalFile(bDirectory.getFilePath());
        }
        Worker worker = new Worker(patternFilterArray, fileArray);
        BProgressDialog.open((BWidget)bNiagaraWbShell, (String)string, (BProgressDialog.Worker)worker, (BImage)buildIcon);
    }

    public BFileIndexer() {
        throw new IllegalStateException();
    }

    public BFileIndexer(BWidget bWidget, String string) {
        super(bWidget, string, true);
        this.options = BFileIndexerOptions.make();
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setTop((BWidget)new BWizardHeader(buildIcon, string));
        bEdgePane.setCenter((BWidget)new BBorderPane(this.makePane(), 8.0, 8.0, 8.0, 8.0));
        bEdgePane.setBottom((BWidget)new BBorderPane(this.makeButtonsPane(), 0.0, 10.0, 10.0, 10.0));
        this.setContent((BWidget)bEdgePane);
        this.setDefaultButton(this.ok);
    }

    BWidget makePane() {
        this.filePattern = new BMruTextDropDown("filesToIndex", 50);
        if (this.filePattern.getText().length() == 0) {
            this.filePattern.setText(FILE_PATTERN_DEFAULT);
        }
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.setHalign(BHalign.left);
        bGridPane.setColumnAlign(BHalign.fill);
        bGridPane.setStretchColumn(0);
        bGridPane.add(null, (BValue)new BLabel(lex.getText("buildFileIndex.filesToIndex"), BHalign.left));
        bGridPane.add(null, (BValue)this.filePattern);
        bGridPane.add(null, (BValue)new BLabel(lex.getText("buildFileIndex.startingFolders"), BHalign.left));
        bGridPane.add(null, (BValue)this.makeStartingFolders());
        return bGridPane;
    }

    BWidget makeButtonsPane() {
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.setColumnAlign(BHalign.fill);
        bGridPane.setUniformColumnWidth(true);
        this.ok = new BButton((Command)new ReflectCommand((BWidget)this, UiLexicon.bajaui().getText("dialog.ok"), "ok"));
        this.cancel = new BButton((Command)new ReflectCommand((BWidget)this, UiLexicon.bajaui().getText("dialog.cancel"), "cancel"));
        bGridPane.add(null, (BValue)this.ok);
        bGridPane.add(null, (BValue)this.cancel);
        return bGridPane;
    }

    BWidget makeStartingFolders() {
        BOrd[] bOrdArray = (BOrd[])this.options.getChildren(class$javax$baja$naming$BOrd == null ? (class$javax$baja$naming$BOrd = BFileIndexer.class$("javax.baja.naming.BOrd")) : class$javax$baja$naming$BOrd);
        for (int i = 0; i < bOrdArray.length; ++i) {
            this.folderList.addItem((Object)bOrdArray[i]);
        }
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.setValign(BValign.top);
        bGridPane.setColumnAlign(BHalign.fill);
        bGridPane.add(null, (BValue)BFileIndexer.newButton(new Add((BWidget)this)));
        bGridPane.add(null, (BValue)BFileIndexer.newButton(new Remove((BWidget)this)));
        BConstrainedPane bConstrainedPane = new BConstrainedPane((BWidget)new BBorderPane((BWidget)this.folderList, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        bConstrainedPane.setMinWidth(300.0);
        bConstrainedPane.setMaxWidth(300.0);
        bConstrainedPane.setMinHeight(100.0);
        bConstrainedPane.setMaxHeight(100.0);
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setCenter((BWidget)bConstrainedPane);
        bEdgePane.setRight((BWidget)new BBorderPane((BWidget)bGridPane, 0.0, 0.0, 0.0, 10.0));
        return bEdgePane;
    }

    static BButton newButton(Command command) {
        BButton bButton = new BButton(command, true, true);
        bButton.setHalign(BHalign.left);
        return bButton;
    }

    public void ok() {
        this.cancelled = false;
        this.options.removeAll();
        for (int i = 0; i < this.folderList.getItemCount(); ++i) {
            this.options.add(null, (BValue)((BOrd)this.folderList.getItem(i)));
        }
        this.options.save();
        this.close();
    }

    public void cancel() {
        this.close();
    }

    public void windowClosing(BWindowEvent bWindowEvent) {
        this.cancel();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class Worker
    extends BProgressDialog.Worker {
        private Map tags = new TreeMap();
        private PatternFilter[] patterns;
        private File[] directories;
        private boolean isAlive;
        private int totalTasks;
        private int currentTask;

        Worker(PatternFilter[] patternFilterArray, File[] fileArray) {
            this.patterns = patternFilterArray;
            this.directories = fileArray;
        }

        public void doRun() {
            try {
                int n;
                this.isAlive = true;
                this.currentTask = 0;
                this.totalTasks = 1;
                for (n = 0; n < this.directories.length; ++n) {
                    this.countDirs(this.directories[n], 0);
                }
                if (!this.isAlive) {
                    return;
                }
                for (n = 0; n < this.directories.length; ++n) {
                    this.traverse(this.directories[n], 0);
                }
                if (!this.isAlive) {
                    return;
                }
                this.persist();
                FileFinder.reload();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void doCancel() {
            this.isAlive = false;
        }

        private void initProgress() throws Exception {
        }

        private void countDirs(File file, int n) throws Exception {
            if (!this.isAlive) {
                return;
            }
            if (n > 3) {
                return;
            }
            if (!file.isDirectory()) {
                return;
            }
            ++this.totalTasks;
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                this.countDirs(fileArray[i], n + 1);
            }
        }

        private void updateProgressBar() {
            if (this.getDialog() == null) {
                return;
            }
            ++this.currentTask;
            double d = (double)this.currentTask / (double)this.totalTasks;
            this.updateProgress((int)(d * 100.0));
        }

        private void process(File file) throws Exception {
            if (!this.include(file)) {
                return;
            }
            String string = file.getCanonicalPath();
            int n = string.lastIndexOf(File.separatorChar);
            String string2 = string.substring(n + 1);
            string = string.substring(0, n);
            ArrayList<String> arrayList = (ArrayList<String>)this.tags.get(string2);
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
                this.tags.put(string2, arrayList);
            }
            arrayList.add(string);
        }

        private boolean include(File file) {
            for (int i = 0; i < this.patterns.length; ++i) {
                if (!this.patterns[i].accept(file.getName())) continue;
                return true;
            }
            return false;
        }

        private final void traverse(File file, int n) throws Exception {
            if (!this.isAlive) {
                return;
            }
            if (file.isDirectory()) {
                if (file.getName().equals("libJar")) {
                    return;
                }
                if (n <= 3) {
                    this.updateProgressBar();
                }
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    this.traverse(fileArray[i], n + 1);
                }
            } else {
                this.process(file);
            }
        }

        private void persist() throws Exception {
            if (FileFinder.INDEX.exists()) {
                FileFinder.INDEX.delete();
            }
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(FileFinder.INDEX));
            Iterator iterator = this.tags.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                List list = (List)this.tags.get(string);
                bufferedWriter.write(string + "=");
                for (int i = 0; i < list.size(); ++i) {
                    if (i > 0) {
                        bufferedWriter.write(",");
                    }
                    bufferedWriter.write(list.get(i).toString().replace(File.separatorChar, '/'));
                }
                bufferedWriter.write("\n");
            }
            bufferedWriter.close();
        }
    }

    private class Remove
    extends Command {
        public Remove(BWidget bWidget) {
            super(bWidget, module, "buildFileIndex.remove");
        }

        public CommandArtifact doInvoke() {
            BFileIndexer.this.folderList.removeSelectedItems();
            return null;
        }
    }

    private class Add
    extends Command {
        public Add(BWidget bWidget) {
            super(bWidget, module, "buildFileIndex.add");
        }

        public CommandArtifact doInvoke() {
            BDirectoryOrdChooser bDirectoryOrdChooser = new BDirectoryOrdChooser();
            BOrd bOrd = bDirectoryOrdChooser.openChooser((BWidget)BFileIndexer.this, null, BOrd.make((String)"file:"), null);
            if (bOrd != null) {
                BFileIndexer.this.folderList.addItem((Object)bOrd);
            }
            return null;
        }
    }
}

