/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.util;

import com.tridium.ui.PaintUtil;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.fieldeditors.BDateFE;
import java.text.DateFormatSymbols;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.RectGeom;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BFrame;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BAlign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;

public class BDatePickerCalendar
extends BDialog {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$util$BDatePickerCalendar == null ? (class$com$tridium$workbench$util$BDatePickerCalendar = BDatePickerCalendar.class$("com.tridium.workbench.util.BDatePickerCalendar")) : class$com$tridium$workbench$util$BDatePickerCalendar));
    private static String[] weekdays;
    private static String[] months;
    private static BWeekday firstWeekday;
    private static final int BUTTON_SIZE = 16;
    private static BColor bg;
    private static BColor fg;
    static final BFont font;
    static final BFont bold;
    private int daysInMonth;
    private int first;
    private int startColumn;
    private int rowCount;
    private double headHeight;
    private double halfHead;
    private double rowHeight;
    private double colWidth;
    private int overDay = -1;
    private RectGeom incYear;
    private RectGeom incMonth;
    private RectGeom decYear;
    private RectGeom decMonth;
    private RectGeom overButton = null;
    private String text;
    BColor textColor = BColor.black;
    BColor overColor = BColor.green;
    public BMonth month;
    public int year;
    public int day;
    boolean selectionMade;
    static /* synthetic */ Class class$com$tridium$workbench$util$BDatePickerCalendar;

    public Type getType() {
        return TYPE;
    }

    public BDatePickerCalendar() {
        throw new IllegalStateException();
    }

    public static BDatePickerCalendar dialog(BWidget bWidget, int n, BMonth bMonth) {
        BDatePickerCalendar bDatePickerCalendar = new BDatePickerCalendar(bWidget, n, bMonth);
        bDatePickerCalendar.setBoundsCenteredOnOwner();
        bDatePickerCalendar.open();
        if (!bDatePickerCalendar.selectionMade) {
            return null;
        }
        return bDatePickerCalendar;
    }

    public BDatePickerCalendar(BWidget bWidget) {
        this(bWidget, Clock.time().getYear(), Clock.time().getMonth());
    }

    public BDatePickerCalendar(BWidget bWidget, int n, BMonth bMonth) {
        super(bWidget, "", true);
        this.year = n;
        this.month = bMonth;
    }

    public void computePreferredSize() {
        double d = 7.0 * font.width("000") + 7.0;
        double d2 = 6.0 * (font.getAscent() + 4.0) + 6.0 + 2.0 * bold.getHeight();
        this.setPreferredSize(d, d2);
    }

    public void doLayout(BWidget[] bWidgetArray) {
        double d = this.getWidth();
        double d2 = this.getHeight();
        this.daysInMonth = BAbsTime.getDaysInMonth((int)this.year, (BMonth)this.month);
        this.first = BAbsTime.getWeekday((int)this.year, (BMonth)this.month, (int)1).getOrdinal();
        this.rowCount = BDatePickerCalendar.rows(this.daysInMonth, this.first);
        this.startColumn = 0;
        BWeekday bWeekday = firstWeekday;
        while (bWeekday.getOrdinal() != this.first) {
            bWeekday = bWeekday.next();
            ++this.startColumn;
        }
        this.headHeight = bold.getHeight() * 2.0;
        this.halfHead = this.headHeight / 2.0;
        this.rowHeight = (d2 - this.headHeight) / (double)this.rowCount;
        this.colWidth = d / 7.0;
        this.text = months[this.month.getOrdinal()] + " " + this.year;
        if (this.incYear == null) {
            this.incYear = new RectGeom();
            this.decYear = new RectGeom();
            this.incMonth = new RectGeom();
            this.decMonth = new RectGeom();
        }
        this.decYear.set(0.0, 0.0, 16.0, this.halfHead);
        this.decMonth.set(16.0, 0.0, 16.0, this.halfHead);
        this.incYear.set(d - 16.0, 0.0, 16.0, this.halfHead);
        this.incMonth.set(this.incYear.x - 16.0, 0.0, 16.0, this.halfHead);
    }

    private static int rows(int n, int n2) {
        BWeekday bWeekday = BWeekday.make((int)n2);
        BWeekday bWeekday2 = firstWeekday.previous();
        int n3 = 1;
        while (bWeekday.getOrdinal() != bWeekday2.getOrdinal()) {
            ++n3;
            bWeekday = bWeekday.next();
        }
        int n4 = (n - n3) / 7;
        if ((n - n3) % 7 != 0) {
            ++n4;
        }
        return n4 + 1;
    }

    public void paint(Graphics graphics) {
        int n;
        double d = this.getWidth();
        double d2 = this.getHeight();
        graphics.setBrush(bg);
        graphics.fillRect(0.0, 0.0, d, this.halfHead);
        graphics.setBrush(fg);
        if (this.overButton == this.decMonth) {
            graphics.fill((IGeom)this.decMonth);
            graphics.setBrush(bg);
        }
        PaintUtil.drawArrow((Graphics)graphics, (double)this.decMonth.x, (double)(this.decMonth.y + 1.0), (double)this.decMonth.width, (double)this.decMonth.height, (BAlign)BAlign.left);
        graphics.setBrush(fg);
        if (this.overButton == this.decYear) {
            graphics.fill((IGeom)this.decYear);
            graphics.setBrush(bg);
        }
        PaintUtil.drawArrow((Graphics)graphics, (double)(this.decYear.x + 2.0), (double)(this.decYear.y + 1.0), (double)this.decYear.width, (double)this.decYear.height, (BAlign)BAlign.left);
        PaintUtil.drawArrow((Graphics)graphics, (double)(this.decYear.x - 3.0), (double)(this.decYear.y + 1.0), (double)this.decYear.width, (double)this.decYear.height, (BAlign)BAlign.left);
        graphics.setBrush(fg);
        if (this.overButton == this.incMonth) {
            graphics.fill((IGeom)this.incMonth);
            graphics.setBrush(bg);
        }
        PaintUtil.drawArrow((Graphics)graphics, (double)this.incMonth.x, (double)(this.incMonth.y + 1.0), (double)this.incMonth.width, (double)this.incMonth.height, (BAlign)BAlign.right);
        graphics.setBrush(fg);
        if (this.overButton == this.incYear) {
            graphics.fill((IGeom)this.incYear);
            graphics.setBrush(bg);
        }
        PaintUtil.drawArrow((Graphics)graphics, (double)(this.incYear.x + 2.0), (double)(this.incYear.y + 1.0), (double)this.incYear.width, (double)this.incYear.height, (BAlign)BAlign.right);
        PaintUtil.drawArrow((Graphics)graphics, (double)(this.incYear.x - 3.0), (double)(this.incYear.y + 1.0), (double)this.incYear.width, (double)this.incYear.height, (BAlign)BAlign.right);
        graphics.setBrush(BColor.white);
        graphics.fillRect(0.0, this.headHeight, d, d2 - this.headHeight);
        graphics.setBrush(BColor.black);
        graphics.strokeLine(0.0, this.headHeight, d, this.headHeight);
        graphics.strokeLine(0.0, this.headHeight - 1.0, d, this.headHeight - 1.0);
        graphics.strokeLine(0.0, this.halfHead, d, this.halfHead);
        double d3 = this.colWidth;
        for (int i = 0; i < 6; ++i) {
            graphics.strokeLine(d3, this.halfHead, d3, d2);
            d3 += this.colWidth;
        }
        double d4 = this.headHeight + this.rowHeight;
        for (int i = 0; i < this.rowCount - 1; ++i) {
            graphics.strokeLine(0.0, d4, d, d4);
            d4 += this.rowHeight;
        }
        graphics.strokeRect(0.0, 0.0, d - 1.0, d2 - 1.0);
        double d5 = this.halfHead - 3.0;
        graphics.setFont(bold);
        graphics.drawString(this.text, (d - bold.width(this.text)) / 2.0, d5);
        d5 = this.headHeight - 3.0;
        double d6 = 0.0;
        for (n = 0; n < 7; ++n) {
            double d7 = font.width(weekdays[n]);
            graphics.drawString(weekdays[n], d6 + (this.colWidth - d7) / 2.0, d5);
            d6 += this.colWidth;
        }
        n = this.startColumn;
        graphics.setFont(font);
        d5 = this.headHeight + (this.rowHeight - font.getAscent()) / 2.0 + font.getAscent() - 1.0;
        int n2 = 0;
        for (int i = 1; i <= this.daysInMonth; ++i) {
            String string = Integer.toString(i);
            double d8 = (double)n * this.colWidth + (this.colWidth - font.width(string)) / 2.0 + 1.0;
            graphics.setBrush(fg);
            if (i == this.overDay) {
                graphics.fillRect((double)n * this.colWidth, this.headHeight + (double)n2 * this.rowHeight, this.colWidth, this.rowHeight);
                graphics.setBrush(bg);
            }
            graphics.drawString(string, d8, d5);
            n = (n + 1) % 7;
            if (n != 0) continue;
            d5 += this.rowHeight;
            ++n2;
        }
    }

    public void mousePressed(BMouseEvent bMouseEvent) {
        double d = bMouseEvent.getX();
        double d2 = bMouseEvent.getY();
        if (d2 < this.halfHead) {
            if (this.decYear.contains(d, d2)) {
                this.year = --this.year == 1969 ? 9999 : this.year;
            } else if (this.decMonth.contains(d, d2)) {
                this.month = this.month.previous();
            } else if (this.incMonth.contains(d, d2)) {
                this.month = this.month.next();
            } else if (this.incYear.contains(d, d2)) {
                this.year = ++this.year > 9999 ? 1970 : this.year;
            }
            this.relayout();
        } else if (d2 > this.headHeight) {
            this.day = this.overDay;
            this.selectionMade = true;
            this.close();
        }
    }

    public void mouseMoved(BMouseEvent bMouseEvent) {
        double d = bMouseEvent.getX();
        double d2 = bMouseEvent.getY();
        if (this.rowHeight < 0.0 || this.colWidth < 0.0) {
            return;
        }
        if (d2 < this.headHeight) {
            RectGeom rectGeom = null;
            if (this.decYear.contains(d, d2)) {
                rectGeom = this.decYear;
            } else if (this.decMonth.contains(d, d2)) {
                rectGeom = this.decMonth;
            } else if (this.incMonth.contains(d, d2)) {
                rectGeom = this.incMonth;
            } else if (this.incYear.contains(d, d2)) {
                rectGeom = this.incYear;
            }
            if (rectGeom == this.overButton && this.overDay == -1) {
                return;
            }
            this.overButton = rectGeom;
            this.overDay = -1;
            this.repaint();
            return;
        }
        int n = (int)((d2 - this.headHeight) / this.rowHeight) * 7 + (int)(d / this.colWidth) + 1 - this.startColumn;
        if (this.overDay == n && this.overButton == null) {
            return;
        }
        this.overDay = n;
        if (this.overDay > this.daysInMonth || this.overDay < 1) {
            this.overDay = -1;
        }
        this.overButton = null;
        this.repaint();
    }

    public void mouseExited(BMouseEvent bMouseEvent) {
        this.overButton = null;
        this.overDay = -1;
        this.repaint();
    }

    public void windowClosing(BWindowEvent bWindowEvent) {
        this.close();
    }

    public static void main(String[] stringArray) throws Exception {
        BFrame bFrame = new BFrame();
        BDateFE bDateFE = new BDateFE();
        BGridPane bGridPane = new BGridPane();
        bGridPane.add(null, (BValue)new BBorderPane((BWidget)bDateFE));
        bDateFE.loadValue((BObject)BAbsTime.make());
        bFrame.setContent((BWidget)bGridPane);
        bFrame.setScreenBounds(100.0, 10.0, 200.0, 200.0);
        bFrame.open();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols();
        months = dateFormatSymbols.getShortMonths();
        weekdays = new String[7];
        BWeekday bWeekday = firstWeekday = BWeekday.getFirstDayOfWeek(null);
        for (int i = 0; i < 7; ++i) {
            BDatePickerCalendar.weekdays[i] = bWeekday.getShortDisplayTag(null).substring(0, 1);
            bWeekday = bWeekday.next();
        }
        bg = BColor.white;
        fg = BColor.black;
        font = Theme.widget().getTextFont();
        bold = Theme.widget().getBoldText();
    }
}

