/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.util;

import com.tridium.workbench.ord.RefFilter;
import com.tridium.workbench.ord.RefNode;
import java.util.ArrayList;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.sync.Transaction;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Knob;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.pane.BTreePane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNode;
import javax.baja.ui.tree.TreeSelection;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.util.BCompositeAction;
import javax.baja.util.BCompositeTopic;
import javax.baja.util.Lexicon;

public class BCompositeEditor
extends BEdgePane {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$util$BCompositeEditor == null ? (class$com$tridium$workbench$util$BCompositeEditor = BCompositeEditor.class$("com.tridium.workbench.util.BCompositeEditor")) : class$com$tridium$workbench$util$BCompositeEditor));
    private static Lexicon lex = Lexicon.make((String)"workbench");
    private static BModule module = Sys.getModuleForClass((Class)(class$com$tridium$workbench$util$BCompositeEditor == null ? (class$com$tridium$workbench$util$BCompositeEditor = BCompositeEditor.class$("com.tridium.workbench.util.BCompositeEditor")) : class$com$tridium$workbench$util$BCompositeEditor));
    private static BImage inIcon = BImage.make((String)"module://icons/x16/arrowLeft.png");
    private static BImage outIcon = BImage.make((String)"module://icons/x16/arrowRight.png");
    private static BBrush colorProperty = BColor.make((int)13816554).toBrush();
    private static BBrush colorAction = BColor.make((int)0xB8F8B8).toBrush();
    private static BBrush colorTopic = BColor.make((int)14934976).toBrush();
    private BComponent composite;
    private BTree tree;
    private BTable table;
    private ArrayList removed = new ArrayList();
    private BWidget owner;
    private Add add;
    private Reverse reverse;
    private Rename rename;
    private Remove remove;
    private MoveUp moveUp;
    private MoveDown moveDown;
    static /* synthetic */ Class class$com$tridium$workbench$util$BCompositeEditor;

    public Type getType() {
        return TYPE;
    }

    public static void openInDialog(BWidget bWidget, BComponent bComponent) {
        BCompositeEditor bCompositeEditor = new BCompositeEditor(bWidget, bComponent);
        if (1 == BDialog.open((BWidget)bWidget, (String)lex.getText("compositeEditor.title"), (Object)((Object)bCompositeEditor), (int)3)) {
            bComponent = bCompositeEditor.createComposite();
            bComponent.lease(Integer.MAX_VALUE);
        }
    }

    public BCompositeEditor() {
        throw new IllegalStateException();
    }

    public BCompositeEditor(BWidget bWidget, BComponent bComponent) {
        Object object;
        String string;
        String string2;
        String string3;
        String string4;
        this.owner = bWidget;
        this.composite = bComponent;
        bComponent.lease();
        this.tree = new BTree((TreeModel)new Model(bComponent));
        this.tree.setMultipleSelection(true);
        this.tree.setController((TreeController)new Controller());
        this.tree.setSelection((TreeSelection)new Selection());
        CompositeModel compositeModel = new CompositeModel();
        this.table = new BTable((TableModel)compositeModel);
        this.table.setController((TableController)new CompositeController());
        this.table.setSelection((TableSelection)new CompositeSelection());
        this.table.setCellRenderer((TableCellRenderer)new CompositeRenderer());
        BLink[] bLinkArray = bComponent.getLinks();
        BOrd bOrd = bComponent.getHandleOrd();
        for (int i = 0; i < bLinkArray.length; ++i) {
            boolean bl;
            BComponent bComponent2 = (BComponent)bLinkArray[i].getSourceOrd().resolve((BObject)bComponent).get();
            string4 = bComponent2.getSlotPath().toString();
            if (!string4.startsWith(string3 = bComponent.getSlotPath().toString()) || string4.equals(string3)) continue;
            string2 = bLinkArray[i].getTargetSlotName();
            string = bLinkArray[i].getSourceSlotName();
            bComponent2.lease();
            object = bComponent2.getSlot(string);
            boolean bl2 = bl = object.isTopic() || Flags.isReadonly((BComplex)bComponent2, (Slot)object);
            if (bComponent.getProperty(string2) == null) {
                bComponent.remove(bLinkArray[i].getName());
                continue;
            }
            Property property = bComponent.getProperty(string2);
            compositeModel.add(1, string2, string4, string, property.getType(), bl, true, bComponent.getFlags((Slot)property));
        }
        Knob[] knobArray = bComponent.getKnobs();
        for (int i = 0; i < knobArray.length; ++i) {
            string4 = (BComponent)knobArray[i].getTargetOrd().resolve((BObject)bComponent).get();
            string4.lease();
            string3 = string4.getSlotPath().toString();
            string2 = bComponent.getSlotPath().toString();
            if (!string3.startsWith(string2) || string3.equals(string2)) continue;
            string = knobArray[i].getSourceSlotName();
            object = knobArray[i].getTargetSlotName();
            if (bComponent.getProperty(string) == null) {
                string4.remove(knobArray[i].getLink().getName());
                continue;
            }
            Property property = bComponent.getProperty(string);
            compositeModel.add(0, string, string3, (String)object, property.getType(), false, true, bComponent.getFlags((Slot)property));
        }
        Property[] propertyArray = bComponent.getPropertiesArray();
        int n = 0;
        for (int i = 0; i < propertyArray.length; ++i) {
            for (int j = 0; j < compositeModel.getRowCount(); ++j) {
                if (!propertyArray[i].getName().equals(compositeModel.get((int)j).name)) continue;
                compositeModel.move(j, n++);
            }
        }
        BSplitPane bSplitPane = new BSplitPane();
        bSplitPane.setDividerPosition(25.0);
        bSplitPane.setWidget1(this.buildLeftPane());
        bSplitPane.setWidget2(this.buildRightPane());
        String string5 = lex.getText("compositeEditor.title");
        string = lex.getText("compositeEditor.subtitle");
        object = BImage.make((String)"module://icons/x32/composite.png");
        BWizardHeader bWizardHeader = new BWizardHeader((BImage)object, string5, string);
        this.setTop((BWidget)bWizardHeader);
        this.setCenter((BWidget)bSplitPane);
    }

    private BWidget buildLeftPane() {
        this.add = new Add((BWidget)this);
        this.add.setEnabled(false);
        BButton bButton = new BButton((Command)this.add);
        bButton.setButtonStyle(BButtonStyle.toolBar);
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.setHalign(BHalign.left);
        bGridPane.add(null, (BValue)bButton);
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setTop((BWidget)new BBorderPane((BWidget)bGridPane, 5.0, 0.0, 5.0, 0.0));
        bEdgePane.setCenter((BWidget)new BBorderPane((BWidget)new BTreePane(this.tree), BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        return bEdgePane;
    }

    private BWidget buildRightPane() {
        this.reverse = new Reverse((BWidget)this);
        this.rename = new Rename((BWidget)this);
        this.remove = new Remove((BWidget)this);
        this.moveUp = new MoveUp((BWidget)this);
        this.moveDown = new MoveDown((BWidget)this);
        this.reverse.setEnabled(false);
        this.rename.setEnabled(false);
        this.remove.setEnabled(false);
        this.moveUp.setEnabled(false);
        this.moveDown.setEnabled(false);
        BButton bButton = new BButton((Command)this.reverse);
        BButton bButton2 = new BButton((Command)this.rename);
        BButton bButton3 = new BButton((Command)this.remove);
        BButton bButton4 = new BButton((Command)this.moveUp);
        BButton bButton5 = new BButton((Command)this.moveDown);
        bButton.setButtonStyle(BButtonStyle.toolBar);
        bButton2.setButtonStyle(BButtonStyle.toolBar);
        bButton3.setButtonStyle(BButtonStyle.toolBar);
        bButton4.setButtonStyle(BButtonStyle.toolBar);
        bButton5.setButtonStyle(BButtonStyle.toolBar);
        BGridPane bGridPane = new BGridPane(3);
        bGridPane.add(null, (BValue)bButton);
        bGridPane.add(null, (BValue)bButton2);
        bGridPane.add(null, (BValue)bButton3);
        BGridPane bGridPane2 = new BGridPane(2);
        bGridPane2.add(null, (BValue)bButton4);
        bGridPane2.add(null, (BValue)bButton5);
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setLeft((BWidget)bGridPane);
        bEdgePane.setRight((BWidget)bGridPane2);
        BEdgePane bEdgePane2 = new BEdgePane();
        bEdgePane2.setTop((BWidget)new BBorderPane((BWidget)bEdgePane, 5.0, 0.0, 5.0, 0.0));
        bEdgePane2.setCenter((BWidget)new BBorderPane((BWidget)this.table, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        return bEdgePane2;
    }

    public BComponent createComposite() {
        CompositeSlot compositeSlot;
        int n;
        Context context = Transaction.start((BComponent)this.composite, null);
        CompositeModel compositeModel = (CompositeModel)this.table.getModel();
        for (n = 0; n < compositeModel.getRowCount(); ++n) {
            compositeSlot = compositeModel.get(n);
            compositeSlot.name = SlotPath.escape((String)compositeSlot.name);
            if (compositeSlot.backup == null) {
                this.addCompositeSlot(context, compositeSlot);
                continue;
            }
            if (compositeSlot.dir == compositeSlot.backup.dir) {
                this.renameCompositeSlot(context, compositeSlot);
                continue;
            }
            compositeSlot.backup.backup = compositeSlot.backup;
            this.removeCompositeSlot(context, compositeSlot.backup);
            this.addCompositeSlot(context, compositeSlot);
        }
        for (n = 0; n < this.removed.size(); ++n) {
            compositeSlot = (CompositeSlot)this.removed.get(n);
            this.removeCompositeSlot(context, compositeSlot);
        }
        try {
            Transaction.end((BComponent)this.composite, (Context)context);
        }
        catch (Exception exception) {
            BDialog.error((BWidget)this.getShell(), (String)"Error", (Object)"createComposite failed.", (Throwable)exception);
        }
        this.reorderCompositeSlots();
        return this.composite;
    }

    private void addCompositeSlot(Context context, CompositeSlot compositeSlot) {
        Slot slot;
        BComponent bComponent = (BComponent)BOrd.make((String)compositeSlot.ord).resolve((BObject)this.composite).get();
        BFacets bFacets = bComponent.getSlotFacets(slot = bComponent.getSlot(compositeSlot.slot));
        if (bFacets == null) {
            bFacets = BFacets.NULL;
        }
        Object object = slot.isAction() || slot.isTopic() ? (compositeSlot.dir == 0 ? new BCompositeAction() : new BCompositeTopic()) : (BValue)compositeSlot.type.getInstance();
        int n = compositeSlot.dir == 1 ? 1 : 0;
        this.composite.add(compositeSlot.name, (BValue)object, n |= compositeSlot.flags, bFacets, context);
        if (compositeSlot.dir == 1) {
            BLink bLink = new BLink(bComponent.getHandleOrd(), compositeSlot.slot, compositeSlot.name, true);
            this.composite.add(null, (BValue)bLink, 4096, BFacets.NULL, context);
        } else {
            BLink bLink = new BLink(this.composite.getHandleOrd(), compositeSlot.name, compositeSlot.slot, true);
            bComponent.add(null, (BValue)bLink, 4096, BFacets.NULL, context);
        }
    }

    private void renameCompositeSlot(Context context, CompositeSlot compositeSlot) {
        if (compositeSlot.backup.name.equals(compositeSlot.name)) {
            return;
        }
        BComponent bComponent = this.composite;
        Property property = bComponent.getProperty(compositeSlot.backup.name);
        BString bString = BString.make((String)compositeSlot.name);
        bComponent.rename(property, compositeSlot.name, context);
        BLink[] bLinkArray = bComponent.getLinks((Slot)property);
        for (int i = 0; i < bLinkArray.length; ++i) {
            BLink bLink = bLinkArray[i];
            bLink.set(BLink.targetSlotName, (BValue)bString, context);
        }
        Knob[] knobArray = bComponent.getKnobs((Slot)property);
        block1: for (int i = 0; i < knobArray.length; ++i) {
            Knob knob = knobArray[i];
            BComponent bComponent2 = (BComponent)knob.getTargetOrd().get((BObject)bComponent);
            bComponent2.lease();
            Property property2 = bComponent2.getProperty(knob.getTargetSlotName());
            BLink[] bLinkArray2 = bComponent2.getLinks((Slot)property2);
            for (int j = 0; j < bLinkArray2.length; ++j) {
                BLink bLink = bLinkArray2[j];
                if (!this.isMatch(knob, bLink)) continue;
                bLink.set(BLink.sourceSlotName, (BValue)bString, context);
                continue block1;
            }
        }
    }

    private boolean isMatch(Knob knob, BLink bLink) {
        return bLink.getSourceOrd().equals((Object)knob.getSourceOrd()) && bLink.getSourceSlotName().equals(knob.getSourceSlotName());
    }

    private void removeCompositeSlot(Context context, CompositeSlot compositeSlot) {
        if (compositeSlot.dir == 1) {
            BLink[] bLinkArray = this.composite.getLinks();
            for (int i = 0; i < bLinkArray.length; ++i) {
                if (!bLinkArray[i].getTargetSlotName().equals(compositeSlot.backup.name)) continue;
                this.composite.remove(bLinkArray[i].getPropertyInParent(), context);
                this.composite.remove(this.composite.getProperty(compositeSlot.backup.name), context);
                return;
            }
        } else {
            BComponent bComponent = (BComponent)BOrd.make((String)compositeSlot.ord).resolve((BObject)this.composite).get();
            bComponent.lease();
            BLink[] bLinkArray = bComponent.getLinks();
            for (int i = 0; i < bLinkArray.length; ++i) {
                if (!bLinkArray[i].getSourceSlotName().equals(compositeSlot.backup.name)) continue;
                bComponent.remove(bLinkArray[i].getPropertyInParent(), null);
                this.composite.remove(this.composite.getProperty(compositeSlot.backup.name), null);
                return;
            }
        }
        throw new RuntimeException("Could not find link for " + compositeSlot.backup.name);
    }

    public void reorderCompositeSlots() {
        Property[] propertyArray;
        this.composite.lease();
        CompositeModel compositeModel = (CompositeModel)this.table.getModel();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < compositeModel.getRowCount(); ++i) {
            arrayList.add(compositeModel.get((int)i).name);
        }
        this.composite.loadSlots();
        SlotCursor slotCursor = this.composite.getProperties();
        while (slotCursor.next()) {
            propertyArray = slotCursor.property();
            if (propertyArray.isFrozen() || arrayList.contains(propertyArray.getName())) continue;
            arrayList.add(propertyArray.getName());
        }
        propertyArray = new Property[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            propertyArray[i] = this.composite.getProperty((String)arrayList.get(i));
        }
        this.composite.reorder(propertyArray);
    }

    public void computePreferredSize() {
        this.setPreferredSize(650.0, 450.0);
    }

    private String getUniqueName(String string) {
        CompositeModel compositeModel = (CompositeModel)this.table.getModel();
        this.composite.loadSlots();
        Slot[] slotArray = this.composite.getSlotsArray();
        int n = 1;
        String string2 = string;
        for (int i = 0; i < slotArray.length; ++i) {
            if (slotArray[i].getName().equals(string2)) {
                string2 = string + n;
                ++n;
                i = -1;
                continue;
            }
            for (int j = 0; j < compositeModel.getRowCount(); ++j) {
                CompositeSlot compositeSlot = compositeModel.get(j);
                if (!compositeSlot.name.equals(string2)) continue;
                string2 = string + n;
                ++n;
                j = compositeModel.getRowCount();
                i = -1;
            }
        }
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Selection
    extends TreeSelection {
        Selection() {
        }

        public void updateTree() {
            super.updateTree();
            TreeNode[] treeNodeArray = this.getNodes();
            boolean bl = false;
            if (treeNodeArray != null) {
                for (int i = 0; i < treeNodeArray.length; ++i) {
                    bl = !(((Node)treeNodeArray[i]).ref.object instanceof BComponent);
                }
            }
            BCompositeEditor.this.add.setEnabled(bl);
        }
    }

    class Controller
    extends TreeController {
        Controller() {
        }

        protected void doSelectAction(TreeNode treeNode, double d, double d2) {
            if (BCompositeEditor.this.add.isEnabled()) {
                BCompositeEditor.this.add.invoke();
            }
        }
    }

    class Node
    extends TreeNode {
        RefNode ref;
        Node[] kids;

        public Node(TreeModel treeModel, RefNode refNode) {
            super(treeModel);
            this.ref = refNode;
        }

        public Node(TreeNode treeNode, RefNode refNode) {
            super(treeNode);
            this.ref = refNode;
        }

        public Object getSubject() {
            return this.ref;
        }

        public String getText() {
            return this.ref.text;
        }

        public BImage getIcon() {
            return this.ref.icon;
        }

        public boolean hasChildren() {
            if (!(this.ref.object instanceof BComponent)) {
                return false;
            }
            if (this.kids == null) {
                return true;
            }
            return this.kids.length > 0;
        }

        public int getChildCount() {
            if (this.kids == null) {
                this.getChild(-1);
            }
            return this.kids.length;
        }

        public TreeNode getChild(int n) {
            if (this.kids == null) {
                this.load();
            }
            return n == -1 ? null : this.kids[n];
        }

        public TreeNode getChild(String string) {
            if (this.kids == null) {
                this.load();
            }
            for (int i = 0; i < this.kids.length; ++i) {
                if (!this.kids[i].ref.name.equals(string)) continue;
                return this.kids[i];
            }
            return null;
        }

        private void load() {
            if (this.kids == null) {
                RefNode[] refNodeArray = this.ref.getChildren(this.ref.object == BCompositeEditor.this.composite ? RefFilter.components : RefFilter.all);
                ArrayList<Node> arrayList = new ArrayList<Node>();
                for (int i = 0; i < refNodeArray.length; ++i) {
                    if (refNodeArray[i].object instanceof BLink) continue;
                    arrayList.add(new Node(this, refNodeArray[i]));
                }
                this.kids = new Node[arrayList.size()];
                arrayList.toArray(this.kids);
            }
        }
    }

    class Model
    extends TreeModel {
        Node root;

        public Model(BComponent bComponent) {
            this.root = new Node(this, new RefNode((BComplex)bComponent));
        }

        public int getRootCount() {
            return 1;
        }

        public TreeNode getRoot(int n) {
            return this.root;
        }
    }

    class CompositeRenderer
    extends TableCellRenderer {
        CompositeRenderer() {
        }

        public BBrush getBackground(TableCellRenderer.Cell cell) {
            CompositeModel compositeModel = (CompositeModel)this.getTable().getModel();
            CompositeSlot compositeSlot = compositeModel.get(cell.row);
            if (compositeSlot.type.is(BCompositeAction.TYPE)) {
                return colorAction;
            }
            if (compositeSlot.type.is(BCompositeTopic.TYPE)) {
                return colorTopic;
            }
            return colorProperty;
        }

        public BBrush getSelectionForeground(TableCellRenderer.Cell cell) {
            if (cell.column == 0) {
                return this.getForeground(cell);
            }
            return super.getSelectionForeground(cell);
        }

        public BBrush getSelectionBackground(TableCellRenderer.Cell cell) {
            if (cell.column == 0) {
                return this.getBackground(cell);
            }
            return super.getSelectionBackground(cell);
        }
    }

    class CompositeSelection
    extends TableSelection {
        CompositeSelection() {
        }

        public void updateTable() {
            super.updateTable();
            CompositeModel compositeModel = (CompositeModel)this.getTable().getModel();
            int[] nArray = this.getRows();
            BCompositeEditor.this.rename.setEnabled(nArray.length > 0);
            BCompositeEditor.this.remove.setEnabled(nArray.length > 0);
            BCompositeEditor.this.moveUp.setEnabled(nArray.length > 0);
            BCompositeEditor.this.moveDown.setEnabled(nArray.length > 0);
            for (int i = 0; i < nArray.length; ++i) {
                CompositeSlot compositeSlot = ((CompositeModel)BCompositeEditor.this.table.getModel()).get(nArray[i]);
                if (compositeSlot.readonly) {
                    BCompositeEditor.this.reverse.setEnabled(false);
                    return;
                }
                for (int j = 0; j < compositeModel.getRowCount(); ++j) {
                    CompositeSlot compositeSlot2 = compositeModel.get(j);
                    if (!(compositeSlot2.ord + compositeSlot2.slot).equals(compositeSlot.ord + compositeSlot.slot) || compositeSlot2.name.equals(compositeSlot.name)) continue;
                    BCompositeEditor.this.reverse.setEnabled(false);
                    return;
                }
            }
            BCompositeEditor.this.reverse.setEnabled(nArray.length > 0);
        }
    }

    class CompositeController
    extends TableController {
        CompositeController() {
        }

        public void keyPressed(BKeyEvent bKeyEvent) {
            super.keyPressed(bKeyEvent);
            if (bKeyEvent.getKeyCode() == 127 && BCompositeEditor.this.remove.isEnabled()) {
                BCompositeEditor.this.remove.invoke();
            }
        }

        protected void handleEnter(BKeyEvent bKeyEvent) {
            bKeyEvent.consume();
            if (BCompositeEditor.this.rename.isEnabled()) {
                BCompositeEditor.this.rename.invoke();
            }
            BCompositeEditor.this.table.repaint();
        }

        protected void cellDoubleClicked(BMouseEvent bMouseEvent, int n, int n2) {
            if (n2 == 0) {
                if (BCompositeEditor.this.reverse.isEnabled()) {
                    BCompositeEditor.this.reverse.invoke();
                }
            } else if (BCompositeEditor.this.rename.isEnabled()) {
                BCompositeEditor.this.rename.invoke();
            }
            BCompositeEditor.this.table.repaint();
        }
    }

    class CompositeSlot {
        public String name;
        public String ord;
        public String slot;
        public Object handle;
        public Type type;
        public int dir;
        public boolean readonly = false;
        public static final int IN = 0;
        public static final int OUT = 1;
        public CompositeSlot backup = null;
        public int flags = 0;

        CompositeSlot() {
        }
    }

    class CompositeModel
    extends TableModel {
        ArrayList kids = new ArrayList();

        CompositeModel() {
        }

        public int getRowCount() {
            return this.kids.size();
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return lex.getText("compositeEditor.dir");
                }
                case 1: {
                    return lex.getText("compositeEditor.slot");
                }
                case 2: {
                    return lex.getText("compositeEditor.ord");
                }
            }
            return "";
        }

        public Object getValueAt(int n, int n2) {
            CompositeSlot compositeSlot = (CompositeSlot)this.kids.get(n);
            switch (n2) {
                case 0: {
                    return compositeSlot.dir == 0 ? lex.getText("compositeEditor.in") : lex.getText("compositeEditor.out");
                }
                case 1: {
                    return compositeSlot.name;
                }
                case 2: {
                    String string = BCompositeEditor.this.composite.getSlotPath().toString();
                    String string2 = compositeSlot.ord + "/" + compositeSlot.slot;
                    return string2.substring(string.length() + 1);
                }
            }
            return "";
        }

        public Object getSubject(int n) {
            return this.kids.get(n);
        }

        public BImage getRowIcon(int n) {
            CompositeSlot compositeSlot = (CompositeSlot)this.kids.get(n);
            return compositeSlot.dir == 0 ? inIcon : outIcon;
        }

        public void add(int n, String string, String string2, String string3, Type type, boolean bl, boolean bl2, int n2) {
            CompositeSlot compositeSlot = new CompositeSlot();
            compositeSlot.name = SlotPath.unescape((String)string);
            compositeSlot.ord = string2;
            compositeSlot.slot = string3;
            compositeSlot.dir = n;
            compositeSlot.type = type;
            compositeSlot.readonly = bl;
            compositeSlot.flags = n2;
            if (bl2) {
                compositeSlot.backup = new CompositeSlot();
                compositeSlot.backup.name = string;
                compositeSlot.backup.ord = string2;
                compositeSlot.backup.slot = string3;
                compositeSlot.backup.dir = n;
                compositeSlot.backup.type = type;
                compositeSlot.backup.readonly = bl;
                compositeSlot.backup.flags = n2;
            }
            this.kids.add(compositeSlot);
        }

        public void remove(int n) {
            this.kids.remove(n);
        }

        public CompositeSlot get(int n) {
            if (n > this.kids.size()) {
                return null;
            }
            return (CompositeSlot)this.kids.get(n);
        }

        public void move(int n, int n2) {
            Object e = this.kids.remove(n);
            this.kids.add(n2, e);
        }
    }

    public class MoveDown
    extends Command {
        public MoveDown(BWidget bWidget) {
            super(bWidget, module, "compositeEditor.moveDown");
        }

        public CommandArtifact doInvoke() {
            CompositeModel compositeModel = (CompositeModel)BCompositeEditor.this.table.getModel();
            int[] nArray = compositeModel.getSelection().getRows();
            if (nArray.length == 0 || nArray[nArray.length - 1] == compositeModel.getRowCount() - 1) {
                return null;
            }
            for (int i = nArray.length - 1; i >= 0; --i) {
                compositeModel.getSelection().deselect(nArray[i]);
                compositeModel.move(nArray[i], nArray[i] + 1);
                compositeModel.getSelection().select(nArray[i] + 1);
            }
            BCompositeEditor.this.table.relayout();
            return null;
        }
    }

    public class MoveUp
    extends Command {
        public MoveUp(BWidget bWidget) {
            super(bWidget, module, "compositeEditor.moveUp");
        }

        public CommandArtifact doInvoke() {
            CompositeModel compositeModel = (CompositeModel)BCompositeEditor.this.table.getModel();
            int[] nArray = compositeModel.getSelection().getRows();
            if (nArray.length == 0 || nArray[0] == 0) {
                return null;
            }
            for (int i = 0; i < nArray.length; ++i) {
                compositeModel.getSelection().deselect(nArray[i]);
                compositeModel.move(nArray[i], nArray[i] - 1);
                compositeModel.getSelection().select(nArray[i] - 1);
            }
            BCompositeEditor.this.table.relayout();
            return null;
        }
    }

    public class Remove
    extends Command {
        public Remove(BWidget bWidget) {
            super(bWidget, module, "compositeEditor.remove");
        }

        public CommandArtifact doInvoke() {
            CompositeModel compositeModel = (CompositeModel)BCompositeEditor.this.table.getModel();
            int[] nArray = compositeModel.getSelection().getRows();
            for (int i = 0; i < nArray.length; ++i) {
                CompositeSlot compositeSlot = compositeModel.get(nArray[i] - i);
                if (compositeSlot.backup != null) {
                    BCompositeEditor.this.removed.add(compositeSlot);
                }
                compositeModel.remove(nArray[i] - i);
            }
            BCompositeEditor.this.table.getSelection().deselectAll();
            BCompositeEditor.this.table.relayout();
            return null;
        }
    }

    public class Rename
    extends Command {
        public Rename(BWidget bWidget) {
            super(bWidget, module, "compositeEditor.rename");
        }

        public CommandArtifact doInvoke() {
            int[] nArray = BCompositeEditor.this.table.getSelection().getRows();
            for (int i = 0; i < nArray.length; ++i) {
                int n;
                CompositeSlot compositeSlot = ((CompositeModel)BCompositeEditor.this.table.getModel()).get(nArray[i]);
                BTextField bTextField = new BTextField(compositeSlot.name, 25);
                BGridPane bGridPane = new BGridPane(1);
                bGridPane.add(null, (BValue)bTextField);
                BBorderPane bBorderPane = new BBorderPane((BWidget)bGridPane, 10.0, 10.0, 10.0, 10.0);
                if (1 != BDialog.open((BWidget)this.getOwner(), (String)lex.getText("compositeEditor.rename.label"), (Object)bBorderPane, (int)3)) break;
                if (compositeSlot.name.equals(bTextField.getText())) continue;
                BCompositeEditor.this.composite.loadSlots();
                Slot[] slotArray = BCompositeEditor.this.composite.getSlotsArray();
                for (n = 0; n < slotArray.length; ++n) {
                    if (!slotArray[n].getName().equals(bTextField.getText())) continue;
                    BDialog.error((BWidget)this.getOwner(), (String)lex.getText("compositeEditor.rename.label"), (Object)lex.getText("compositeEditor.rename.exists"));
                    return null;
                }
                for (n = 0; n < BCompositeEditor.this.table.getModel().getRowCount(); ++n) {
                    CompositeSlot compositeSlot2 = ((CompositeModel)BCompositeEditor.this.table.getModel()).get(n);
                    if (!compositeSlot2.name.equals(bTextField.getText())) continue;
                    BDialog.error((BWidget)this.getOwner(), (String)lex.getText("compositeEditor.rename.label"), (Object)lex.getText("compositeEditor.rename.exists"));
                    return null;
                }
                compositeSlot.name = bTextField.getText();
                BCompositeEditor.this.table.repaint();
            }
            return null;
        }
    }

    public class Reverse
    extends Command {
        public Reverse(BWidget bWidget) {
            super(bWidget, module, "compositeEditor.reverse");
        }

        public CommandArtifact doInvoke() {
            CompositeModel compositeModel = (CompositeModel)BCompositeEditor.this.table.getModel();
            int[] nArray = BCompositeEditor.this.table.getSelection().getRows();
            for (int i = 0; i < nArray.length; ++i) {
                CompositeSlot compositeSlot = compositeModel.get(nArray[i]);
                if (compositeSlot.readonly) continue;
                int n = compositeSlot.dir = compositeSlot.dir == 0 ? 1 : 0;
                if (compositeSlot.type.is(BCompositeAction.TYPE)) {
                    compositeSlot.type = BCompositeTopic.TYPE;
                    continue;
                }
                if (compositeSlot.readonly || !compositeSlot.type.is(BCompositeTopic.TYPE)) continue;
                compositeSlot.type = BCompositeAction.TYPE;
            }
            BCompositeEditor.this.table.repaint();
            return null;
        }
    }

    public class Add
    extends Command {
        public Add(BWidget bWidget) {
            super(bWidget, module, "compositeEditor.add");
        }

        public CommandArtifact doInvoke() {
            int n;
            CompositeModel compositeModel = (CompositeModel)BCompositeEditor.this.table.getModel();
            TreeNode[] treeNodeArray = BCompositeEditor.this.tree.getSelection().getNodes();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (n = 0; n < treeNodeArray.length; ++n) {
                int n2;
                int n3;
                Node node = (Node)treeNodeArray[n];
                if (node.ref.object instanceof BComponent) continue;
                BComponent bComponent = (BComponent)((Node)node.getParent()).ref.object;
                String string = node.ref.name;
                String string2 = bComponent.getSlotPath().toString();
                Slot slot = bComponent.getSlot(node.ref.name);
                boolean bl = false;
                boolean bl2 = false;
                for (n3 = 0; n3 < compositeModel.getRowCount(); n3 += 1) {
                    CompositeSlot compositeSlot = compositeModel.get(n3);
                    if (!(compositeSlot.ord + compositeSlot.slot).equals(string2 + slot.getName())) continue;
                    if (compositeSlot.dir == 1) {
                        bl2 = true;
                    }
                    if (compositeSlot.dir != 0) continue;
                    bl = true;
                }
                if (bl && bl2) continue;
                int n4 = n3 = slot.isTopic() || Flags.isReadonly((BComplex)bComponent, (Slot)slot) ? 1 : 0;
                if (bl2 && n3) continue;
                int n5 = n2 = n3 != 0 ? 1 : 0;
                if (bl2) {
                    n2 = 0;
                } else if (bl) {
                    n2 = 1;
                }
                Type type = slot.isTopic() ? BCompositeTopic.TYPE : (slot.isAction() ? (n2 == 0 ? BCompositeAction.TYPE : BCompositeTopic.TYPE) : node.ref.object.getType());
                compositeModel.add(n2, BCompositeEditor.this.getUniqueName(string), string2, node.ref.name, type, n3 != 0, false, 4096);
                arrayList.add(new Integer(compositeModel.getRowCount() - 1));
            }
            BCompositeEditor.this.table.relayout();
            if (arrayList.size() > 0) {
                BCompositeEditor.this.table.requestFocus();
                BCompositeEditor.this.table.getSelection().deselectAll();
                for (n = 0; n < arrayList.size(); ++n) {
                    BCompositeEditor.this.table.getSelection().select(((Integer)arrayList.get(n)).intValue());
                }
            }
            return null;
        }
    }
}

