/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.transfer;

import com.tridium.file.types.bog.BBogFile;
import com.tridium.sys.transfer.CompToComp;
import com.tridium.sys.transfer.DeleteOp;
import com.tridium.sys.transfer.FileToFile;
import com.tridium.sys.transfer.TransferStrategy;
import com.tridium.ui.BOptionDialog;
import com.tridium.workbench.shell.BGeneralOptions;
import com.tridium.workbench.transfer.TransferArtifact;
import java.util.HashMap;
import java.util.HashSet;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.space.BComponentSpace;
import javax.baja.space.Mark;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListRenderer;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.transfer.TransferConst;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Version;
import javax.baja.workbench.commands.ComponentRenameCommand;
import javax.baja.workbench.commands.FileRenameCommand;

public class TransferUtil
implements TransferConst {
    public static final String PARAM_PROMPT_FOR_NAME = "promptForName";
    static final String TRASH_FILE_PATH = "!trash";
    static /* synthetic */ Class class$javax$baja$file$BIFile;
    static /* synthetic */ Class class$javax$baja$sys$BObject;

    public static TransferEnvelope getTransferData(BObject bObject) {
        if (bObject == null) {
            return null;
        }
        return TransferEnvelope.make((Mark)new Mark(bObject));
    }

    public static boolean isComplex(Mark mark) {
        BObject[] bObjectArray = mark.getValues();
        for (int i = 0; i < bObjectArray.length; ++i) {
            if (bObjectArray[i] instanceof BComplex) continue;
            return false;
        }
        return true;
    }

    public static boolean isComponent(Mark mark) {
        BObject[] bObjectArray = mark.getValues();
        for (int i = 0; i < bObjectArray.length; ++i) {
            if (bObjectArray[i] instanceof BComponent) continue;
            return false;
        }
        return true;
    }

    public static boolean isFile(Mark mark) {
        BObject[] bObjectArray = mark.getValues();
        for (int i = 0; i < bObjectArray.length; ++i) {
            if (bObjectArray[i] instanceof BIFile) continue;
            return false;
        }
        return true;
    }

    public static CommandArtifact insert(BWidget bWidget, TransferContext transferContext, BObject bObject, BComponent bComponent) throws Exception {
        Mark mark = (Mark)transferContext.getEnvelope().getData(TransferFormat.mark);
        return TransferUtil.insert(bWidget, transferContext.getAction(), mark, bObject, bComponent, (Context)transferContext);
    }

    public static CommandArtifact insert(BWidget bWidget, int n, Mark mark, BObject bObject, BComponent bComponent, Context context) throws Exception {
        if (!TransferUtil.checkForMissingModules(bWidget, mark, bObject)) {
            return null;
        }
        if ((mark = TransferUtil.promptForName(bWidget, n, mark, bObject, bComponent)) == null) {
            return null;
        }
        if (!TransferUtil.checkFileReplace(bWidget, mark, bObject)) {
            return null;
        }
        TransferArtifact transferArtifact = new TransferArtifact(bWidget, n, mark, bObject, bComponent, context);
        transferArtifact.redo();
        if (transferArtifact.getResult() == null) {
            return null;
        }
        return transferArtifact;
    }

    static Mark promptForName(BWidget bWidget, int n, Mark mark, BObject bObject, BComponent bComponent) {
        if (n != 16) {
            return mark;
        }
        if (mark.size() != 1) {
            return mark;
        }
        if (!BGeneralOptions.make().getPromptForNameOnInsert() && !TransferUtil.isFile(mark)) {
            return mark;
        }
        if (bComponent != null && bComponent.get(PARAM_PROMPT_FOR_NAME) == BBoolean.FALSE) {
            return mark;
        }
        String string = mark.getNames()[0];
        BObject bObject2 = mark.getValues()[0];
        if ((bObject = TransferStrategy.toActualTarget((BObject)bObject)) instanceof BComponent) {
            BComponent bComponent2 = (BComponent)bObject;
            BComponentSpace bComponentSpace = bComponent2.getComponentSpace();
            string = bComponentSpace != null ? (String)bComponentSpace.fw(111, (Object)string, (Object)new CompToComp.TargetNameContainer(bComponent2, new HashMap()), null, null) : CompToComp.getUniqueName((BComponent)bComponent2, (String)string);
        } else if (bObject instanceof BDirectory) {
            if (!(bObject2 instanceof BIFile)) {
                return mark;
            }
            if (!TransferUtil.isChild((BIFile)((BDirectory)bObject), (BIFile)bObject2)) {
                return mark;
            }
            string = FileToFile.getUniqueFilename((BDirectory)((BDirectory)bObject), (String)string);
        }
        if (bObject instanceof BDirectory) {
            string = BOptionDialog.promptFileName((BWidget)bWidget, (String)TransferUtil.lex().getText("name"), (String)string);
        } else {
            string = BDialog.prompt((BWidget)bWidget, (String)TransferUtil.lex().getText("name"), (String)SlotPath.unescape((String)string), (int)30);
            if (string == null) {
                return null;
            }
            string = SlotPath.escape((String)string);
        }
        if (string == null) {
            return null;
        }
        return new Mark(bObject2, string);
    }

    static boolean checkForMissingModules(BWidget bWidget, Mark mark, BObject bObject) throws Exception {
        try {
            BLabel bLabel;
            String string;
            int n;
            BComponent bComponent;
            bObject = TransferStrategy.toActualTarget((BObject)bObject);
            if (!(bObject instanceof BComponent)) {
                return true;
            }
            BComponent bComponent2 = bObject.asComponent();
            BComponentSpace bComponentSpace = bComponent2.getComponentSpace();
            if (bComponentSpace == null) {
                return true;
            }
            BObject[] bObjectArray = mark.getValues();
            if (bObjectArray.length > 0 && bObjectArray[0] instanceof BComponent && bComponentSpace == (bComponent = (BComponent)bObjectArray[0]).getComponentSpace()) {
                return true;
            }
            bComponent = new HashSet();
            HashSet hashSet = new HashSet();
            for (int i = 0; i < bObjectArray.length; ++i) {
                TransferUtil.accumulateDependencies(bObjectArray[i], hashSet, (HashSet)bComponent, true);
            }
            String string2 = "";
            string2 = TransferUtil.getMissingRemoteModules(bComponent.toArray(), bObject);
            if (string2.length() > 0) {
                BDialog.error((BWidget)bWidget, (Object)TransferUtil.lex().getText("missingModules.error.prompt", new Object[]{string2}));
                return false;
            }
            string2 = TransferUtil.getMissingRemoteModules(hashSet.toArray(), bObject);
            if (string2.length() > 0 && (n = BDialog.open((BWidget)bWidget, (String)(string = UiLexicon.bajaui().getText("missingModules.warning.title")), (Object)(bLabel = new BLabel(UiLexicon.bajaui().getText("missingModules.warning.prompt", new Object[]{string2}), BHalign.left)), (int)3, (BImage)BDialog.QUESTION_ICON)) == 2) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    static String getMissingRemoteModules(Object[] objectArray, BObject bObject) {
        String string = "";
        for (int i = 0; i < objectArray.length; ++i) {
            Version version = (Version)bObject.fw(404, (Object)objectArray[i].toString(), null, null, null);
            if (version == null || !version.equals((Object)Version.NULL)) continue;
            if (string.length() > 0) {
                string = string + ", ";
            }
            string = string + objectArray[i];
        }
        return string;
    }

    static void accumulateDependencies(BObject bObject, HashSet hashSet, HashSet hashSet2, boolean bl) throws Exception {
        BObject[] bObjectArray;
        BComplex bComplex;
        String string = bObject.getType().getTypeInfo().getModuleName();
        if (bl) {
            hashSet2.add(string);
        } else if (!hashSet2.contains(string)) {
            hashSet.add(string);
        }
        if (bObject instanceof BComplex) {
            bComplex = bObject.asComplex();
            bObjectArray = bComplex.getProperties();
            while (bObjectArray.next()) {
                TransferUtil.accumulateDependencies((BObject)bComplex.get(bObjectArray.property()), hashSet, hashSet2, false);
            }
        }
        if (bObject instanceof BBogFile) {
            bComplex = null;
            try {
                bComplex = ((BBogFile)bObject).readComponents();
            }
            catch (Exception exception) {
                return;
            }
            bObjectArray = bComplex.getValues();
            for (int i = 0; i < bObjectArray.length; ++i) {
                TransferUtil.accumulateDependencies(bObjectArray[i], hashSet, hashSet2, bl);
            }
        }
    }

    static boolean checkFileReplace(BWidget bWidget, Mark mark, BObject bObject) throws Exception {
        BLabel bLabel;
        Object object;
        BIFile bIFile;
        Object object2;
        if (!TransferUtil.isFile(mark)) {
            return true;
        }
        if (!(bObject instanceof BIFile)) {
            return true;
        }
        if (!(bObject instanceof BDirectory)) {
            return true;
        }
        if (((BIFile)bObject).getFilePath().getBody().equals(TRASH_FILE_PATH)) {
            return true;
        }
        BDirectory bDirectory = (BDirectory)bObject;
        String[] stringArray = mark.getNames();
        BIFile[] bIFileArray = (BIFile[])mark.getValues((Object[])new BIFile[mark.size()]);
        HashMap<String, BIFile> hashMap = new HashMap<String, BIFile>();
        BIFile[] bIFileArray2 = bDirectory.listFiles();
        for (int i = 0; i < bIFileArray2.length; ++i) {
            hashMap.put(bIFileArray2[i].getFileName(), bIFileArray2[i]);
        }
        Array array = new Array(class$javax$baja$file$BIFile == null ? (class$javax$baja$file$BIFile = TransferUtil.class$("javax.baja.file.BIFile")) : class$javax$baja$file$BIFile);
        for (int i = 0; i < stringArray.length; ++i) {
            BIFile bIFile2 = (BIFile)hashMap.get(stringArray[i]);
            if (bIFile2 == null) continue;
            array.add((Object)bIFile2);
        }
        Object[] objectArray = (BIFile[])array.trim();
        if (objectArray.length == 0) {
            return true;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            for (int j = 0; j < bIFileArray.length; ++j) {
                object2 = objectArray[i];
                bIFile = bIFileArray[j];
                if (!object2.equals((Object)bIFile) && !TransferUtil.isDescendent(object2, bIFile)) continue;
                BDialog.error((BWidget)bWidget, (Object)TransferUtil.lex().getText("file.replace.same", new Object[]{objectArray[i].getFileName()}));
                return false;
            }
        }
        if (objectArray.length == 1) {
            object = TransferUtil.lex().getText("file.replace.one", new Object[]{objectArray[0].getFileName()});
            bLabel = new BLabel((String)object, BHalign.left);
        } else {
            object = new BList();
            object.setRenderer(new ListRenderer(){

                public BBrush getSelectionForeground(ListRenderer.Item item) {
                    return this.getForeground(item);
                }

                public BBrush getSelectionBackground(ListRenderer.Item item) {
                    return this.getBackground(item);
                }
            });
            for (int i = 0; i < objectArray.length; ++i) {
                object.addItem((Object)objectArray[i].getFileName());
            }
            object2 = TransferUtil.lex().getText("file.replace.multiple");
            bIFile = new BEdgePane();
            bIFile.setTop((BWidget)new BLabel((String)object2, BHalign.left));
            bIFile.setCenter((BWidget)object);
            bLabel = bIFile;
        }
        object = TransferUtil.lex().getText("file.replace.title");
        int n = BDialog.open((BWidget)bWidget, (String)object, (Object)bLabel, (int)3, (BImage)BDialog.QUESTION_ICON);
        if (n == 2) {
            return false;
        }
        bIFile = new Array(class$javax$baja$sys$BObject == null ? (class$javax$baja$sys$BObject = TransferUtil.class$("javax.baja.sys.BObject")) : class$javax$baja$sys$BObject);
        bIFile.addAll(objectArray);
        mark = new Mark((BObject[])bIFile.trim());
        TransferUtil.delete(bWidget, mark);
        return true;
    }

    static boolean isDescendent(BIFile bIFile, BIFile bIFile2) {
        String string = bIFile.getFilePath().getBody();
        return bIFile2.getFilePath().getParent().getBody().startsWith(string);
    }

    static boolean isChild(BIFile bIFile, BIFile bIFile2) {
        String string = bIFile.getFilePath().getBody();
        return bIFile2.getFilePath().getParent().getBody().equals(string);
    }

    public static CommandArtifact duplicate(BWidget bWidget, BObject bObject) throws Exception {
        if (bObject instanceof BComponent) {
            BComponent bComponent = (BComponent)bObject.asComponent().getParent();
            return TransferUtil.insert(bWidget, 16, new Mark(bObject), (BObject)bComponent, null, null);
        }
        if (bObject instanceof BIFile) {
            BIFile bIFile = (BIFile)bObject;
            Mark mark = new Mark((BObject)bIFile, bIFile.getFileName());
            BDirectory bDirectory = (BDirectory)bIFile.getNavParent();
            return TransferUtil.insert(bWidget, 16, mark, (BObject)bDirectory, null, null);
        }
        throw new UnsupportedOperationException("Don't know how to duplicate: " + bObject.getType());
    }

    public static CommandArtifact delete(BWidget bWidget, Mark mark) throws Exception {
        if (TransferUtil.isComplex(mark)) {
            return TransferUtil.deleteComponent(bWidget, mark);
        }
        if (TransferUtil.isFile(mark)) {
            return TransferUtil.deleteFile(bWidget, mark);
        }
        throw new UnsupportedOperationException("Don't know how to delete");
    }

    static CommandArtifact deleteComponent(BWidget bWidget, Mark mark) throws Exception {
        DeleteOp deleteOp = null;
        for (int i = 0; i < mark.size(); ++i) {
            if (!mark.getValue(i).isComponent()) continue;
            BComponent bComponent = mark.getValue(i).asComponent();
            BComponentSpace bComponentSpace = (BComponentSpace)bComponent.getSpace();
            deleteOp = (DeleteOp)bComponentSpace.fw(112, (Object)mark, null, null, null);
            break;
        }
        if (deleteOp == null) {
            deleteOp = DeleteOp.make((Mark)mark, null);
        }
        DeleteOpArtifact deleteOpArtifact = new DeleteOpArtifact(deleteOp);
        deleteOpArtifact.redo();
        return deleteOpArtifact;
    }

    static CommandArtifact deleteFile(BWidget bWidget, Mark mark) throws Exception {
        int n;
        boolean bl = true;
        BIFile[] bIFileArray = (BIFile[])mark.getValues((Object[])new BIFile[mark.size()]);
        for (n = 0; n < bIFileArray.length; ++n) {
            if (bIFileArray[n].getFilePath().getBody().indexOf("trash/") >= 0) continue;
            bl = false;
            break;
        }
        if (bl) {
            n = BDialog.confirm((BWidget)bWidget, (Object)TransferUtil.lex().getText("deleteTrash.confirm"));
            if (n == 8) {
                return null;
            }
            for (int i = 0; i < bIFileArray.length; ++i) {
                bIFileArray[i].delete();
            }
            return null;
        }
        return TransferUtil.insert(bWidget, 32, mark, (BObject)TransferUtil.getTrash(), null, null);
    }

    public static BDirectory getTrash() throws Exception {
        BFileSystem bFileSystem = BFileSystem.INSTANCE;
        return bFileSystem.makeDir(new FilePath(TRASH_FILE_PATH));
    }

    public static CommandArtifact rename(BWidget bWidget, Mark mark) throws Exception {
        if (TransferUtil.isComponent(mark)) {
            return TransferUtil.renameComponent(bWidget, mark);
        }
        if (TransferUtil.isFile(mark)) {
            return TransferUtil.renameFile(bWidget, mark);
        }
        throw new UnsupportedOperationException("Don't know how to rename");
    }

    static CommandArtifact renameComponent(BWidget bWidget, Mark mark) throws Exception {
        int n = mark.size();
        BComponent[] bComponentArray = (BComponent[])mark.getValues((Object[])new BComponent[n]);
        BComponent[] bComponentArray2 = new BComponent[n];
        Property[] propertyArray = new Property[n];
        for (int i = 0; i < n; ++i) {
            bComponentArray2[i] = (BComponent)bComponentArray[i].getParent();
            propertyArray[i] = bComponentArray[i].getPropertyInParent();
        }
        ComponentRenameCommand componentRenameCommand = new ComponentRenameCommand(bWidget, bComponentArray2, propertyArray, null);
        return componentRenameCommand.doInvoke();
    }

    static CommandArtifact renameFile(BWidget bWidget, Mark mark) throws Exception {
        BIFile[] bIFileArray = (BIFile[])mark.getValues((Object[])new BIFile[mark.size()]);
        FileRenameCommand fileRenameCommand = new FileRenameCommand(bWidget, bIFileArray);
        return fileRenameCommand.doInvoke();
    }

    static UiLexicon lex() {
        return UiLexicon.bajaui();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class DeleteOpArtifact
    implements CommandArtifact {
        DeleteOp op;

        DeleteOpArtifact(DeleteOp deleteOp) {
            this.op = deleteOp;
        }

        public void redo() {
            this.op = this.op.delete();
        }

        public void undo() {
            this.op = this.op.undelete();
        }
    }
}

