/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.synthetic;

import java.io.IOException;
import java.util.ArrayList;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.registry.ModuleInfo;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.table.TableSubject;
import javax.baja.util.BTypeSpec;
import javax.baja.workbench.BWbPlugin;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;

public class SyntheticModuleDependenciesTab {
    private BAbstractButton editButton;
    private BTable table;
    private BWidget content;
    private XElem root;
    private BWbPlugin parent;

    public SyntheticModuleDependenciesTab(BWbPlugin bWbPlugin) {
        this.parent = bWbPlugin;
        BBorderPane bBorderPane = new BBorderPane();
        bBorderPane.setPadding(BInsets.make((double)10.0, (double)10.0, (double)10.0, (double)10.0));
        BEdgePane bEdgePane = new BEdgePane();
        this.table = new BTable((TableModel)new Model());
        this.table.setController((TableController)new Controller());
        this.table.setSelection((TableSelection)new Selection());
        bEdgePane.setCenter((BWidget)this.table);
        BBorderPane bBorderPane2 = new BBorderPane();
        bBorderPane2.setPadding(BInsets.make((double)10.0, (double)0.0, (double)0.0, (double)0.0));
        bEdgePane.setBottom((BWidget)bBorderPane2);
        BGridPane bGridPane = new BGridPane(4);
        bGridPane.setColumnGap(20.0);
        this.editButton = BButton.make((Command)new EditCommand(bWbPlugin));
        bGridPane.add(null, (BValue)this.editButton);
        bBorderPane2.setContent((BWidget)bGridPane);
        bBorderPane.setContent((BWidget)bEdgePane);
        this.content = bBorderPane;
    }

    public void loadValue(XElem xElem, Context context) {
        this.root = xElem;
        this.table.sizeColumnsToFit();
    }

    public void saveValue(Context context) {
    }

    public BWidget getContent() {
        return this.content;
    }

    public void updateDependencies() {
        int n;
        int n2;
        if (this.root.elem("types") == null) {
            return;
        }
        XElem[] xElemArray = this.root.elem("types").elems("type");
        ArrayList<ModuleInfo> arrayList = new ArrayList<ModuleInfo>();
        TypeInfo[] typeInfoArray = Sys.getRegistry().getTypes();
        arrayList.add(Sys.getBajaModule().getModuleInfo());
        for (n2 = 0; n2 < xElemArray.length; ++n2) {
            String string = xElemArray[n2].get("extends");
            for (n = 0; n < typeInfoArray.length; ++n) {
                if (!typeInfoArray[n].getTypeClassName().equals(string)) continue;
                arrayList.add(Sys.getRegistry().getModule(typeInfoArray[n].getModuleName()));
                break;
            }
            if (xElemArray[n2].elem("slots") == null) continue;
            XElem[] xElemArray2 = xElemArray[n2].elem("slots").elems("property");
            for (int i = 0; i < xElemArray2.length; ++i) {
                try {
                    BTypeSpec bTypeSpec = BTypeSpec.make((String)xElemArray2[i].get("type", BTypeSpec.NULL.encodeToString()));
                    arrayList.add(Sys.getRegistry().getModule(bTypeSpec.getModuleName()));
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        for (n2 = 0; n2 < this.root.elem("dependencies").elems("dependency").length; ++n2) {
            boolean bl = true;
            for (n = 0; n < arrayList.size(); ++n) {
                if (!((ModuleInfo)arrayList.get(n)).getModuleName().equals(this.root.elem("dependencies").elems("dependency")[n2].get("name"))) continue;
                bl = false;
            }
            if (!bl) continue;
            this.root.elem("dependencies").removeContent(n2--);
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            ModuleInfo moduleInfo = (ModuleInfo)arrayList.get(n2);
            if (moduleInfo.getModuleName().equals(this.root.get("name"))) continue;
            this.addDependency(moduleInfo);
        }
        this.table.getModel().updateTable(true);
        this.table.repaint();
    }

    private void addDependency(ModuleInfo moduleInfo) {
        XElem[] xElemArray = this.root.elem("dependencies").elems("dependency");
        for (int i = 0; i < xElemArray.length; ++i) {
            if (!xElemArray[i].get("name", "").equals(moduleInfo.getModuleName())) continue;
            return;
        }
        XElem xElem = new XElem("dependency");
        xElem.addAttr("name", moduleInfo.getModuleName());
        xElem.addAttr("vendor", moduleInfo.getVendor());
        xElem.addAttr("vendorVersion", moduleInfo.getVendorVersion().toString());
        this.root.elem("dependencies").addContent((XContent)xElem);
    }

    private class Model
    extends TableModel {
        private Model() {
        }

        public int getRowCount() {
            try {
                return SyntheticModuleDependenciesTab.this.root.elem("dependencies").elems("dependency").length;
            }
            catch (Exception exception) {
                return 0;
            }
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int n) {
            if (n == 0) {
                return "Module";
            }
            if (n == 1) {
                return "Vendor";
            }
            if (n == 2) {
                return "Version";
            }
            return "???";
        }

        public Object getSubject(int n) {
            return SyntheticModuleDependenciesTab.this.root.elem("dependencies").elems("dependency")[n];
        }

        public Object getValueAt(int n, int n2) {
            XElem xElem = SyntheticModuleDependenciesTab.this.root.elem("dependencies").elems("dependency")[n];
            switch (n2) {
                case 0: {
                    return xElem.get("name");
                }
                case 1: {
                    return xElem.get("vendor");
                }
                case 2: {
                    return xElem.get("vendorVersion");
                }
            }
            return "???";
        }

        public BImage getRowIcon(int n) {
            return BImage.make((BIcon)BIcon.std((String)"module.png"));
        }

        public boolean isColumnSortable(int n) {
            return false;
        }
    }

    private class Selection
    extends TableSelection {
        private Selection() {
        }

        private void updateButtons() {
            boolean bl = this.isEmpty();
            SyntheticModuleDependenciesTab.this.editButton.setEnabled(!bl);
        }

        public void deselect(int n) {
            super.deselect(n);
            this.updateButtons();
        }

        public void deselectAll() {
            super.deselectAll();
            this.updateButtons();
        }

        public void select(int n, boolean bl) {
            super.select(n, bl);
            this.updateButtons();
        }

        public void select(int n, int n2, boolean bl) {
            super.select(n, n2, bl);
            this.updateButtons();
        }

        public void select(int n, int n2) {
            super.select(n, n2);
            this.updateButtons();
        }

        public void select(int n) {
            super.select(n);
            this.updateButtons();
        }

        public void select(int[] nArray) {
            super.select(nArray);
            this.updateButtons();
        }

        public void selectAll() {
            super.selectAll();
            this.updateButtons();
        }
    }

    private class Controller
    extends TableController {
        private Controller() {
        }

        public int getTextSearchColumn() {
            return 0;
        }

        protected void cellDoubleClicked(BMouseEvent bMouseEvent, int n, int n2) {
            this.getTable().getSelection().select(n, true);
            try {
                SyntheticModuleDependenciesTab.this.editButton.getCommand().doInvoke();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        protected BMenu makePopup(TableSubject tableSubject) {
            BMenu bMenu = new BMenu();
            if (tableSubject.getRows().length > 0) {
                bMenu.add("edit", SyntheticModuleDependenciesTab.this.editButton.getCommand());
            }
            return bMenu;
        }
    }

    private class EditCommand
    extends Command {
        public EditCommand(BWidget bWidget) {
            super(bWidget, "Edit Version");
        }

        public BImage getIcon() {
            return BImage.make((BIcon)BIcon.std((String)"edit.png"));
        }

        public CommandArtifact doInvoke() throws Exception {
            XElem xElem = SyntheticModuleDependenciesTab.this.root.elem("dependencies").elem(SyntheticModuleDependenciesTab.this.table.getSelection().getRow());
            BGridPane bGridPane = new BGridPane(2);
            bGridPane.setHalign(BHalign.left);
            BTextField bTextField = new BTextField("", 25);
            bTextField.setText(xElem.get("vendorVersion"));
            bGridPane.add(null, (BValue)new BLabel("Version"));
            bGridPane.add(null, (BValue)bTextField);
            String string = "Edit Dependency";
            int n = 3;
            if (BDialog.open((BWidget)this.getOwner(), (String)string, (Object)bGridPane, (int)n, null) == 2) {
                return null;
            }
            xElem.setAttr("vendor", Sys.getRegistry().getModule(xElem.get("name")).getVendor());
            xElem.setAttr("vendorVersion", bTextField.getText());
            SyntheticModuleDependenciesTab.this.table.getModel().updateTable();
            SyntheticModuleDependenciesTab.this.parent.setModified();
            return null;
        }
    }
}

