/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.slotsheet;

import com.tridium.util.ObjectUtil;
import com.tridium.workbench.fieldeditors.BTypeSpecFE;
import com.tridium.workbench.slotsheet.BSlotSheet;
import com.tridium.workbench.slotsheet.ConfigFacetsCommand;
import com.tridium.workbench.util.BFlagConfig;
import com.tridium.workbench.util.ConfigFlagsCommand;
import com.tridium.workbench.util.WbUtil;
import java.util.HashMap;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.space.Mark;
import javax.baja.sync.Transaction;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIPropertyContainer;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BTextField;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.commands.SetDisplayNameCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.transfer.Clipboard;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BFormat;
import javax.baja.util.BNameMap;
import javax.baja.util.BTypeSpec;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.commands.ComponentRenameCommand;
import javax.baja.workbench.commands.ComponentReorderCommand;

public class SlotSheetCommands {
    static BTypeSpec lastType = BTypeSpec.make((String)"baja", (String)"String");
    final UiLexicon lex = UiLexicon.bajaui();
    static String lastName = "newSlot";
    public final BSlotSheet sheet;
    public AddCommand add;
    public CopyCommand copy;
    public DeleteCommand delete;
    public RenameCommand rename;
    public FlagsCommand flags;
    public FacetsCommand facets;
    public ReorderCommand reorder;
    public DisplayNameCommand displayName;
    public BajadocForTypeCommand bajadocForType;

    public SlotSheetCommands(BSlotSheet bSlotSheet) {
        this.sheet = bSlotSheet;
        this.add = new AddCommand();
        this.copy = new CopyCommand();
        this.delete = new DeleteCommand();
        this.rename = new RenameCommand();
        this.flags = new FlagsCommand();
        this.facets = new FacetsCommand();
        this.reorder = new ReorderCommand();
        this.displayName = new DisplayNameCommand();
        this.bajadocForType = new BajadocForTypeCommand();
        this.rename.setEnabled(false);
        this.flags.setEnabled(false);
    }

    public BMenu[] getViewMenus() {
        BMenu bMenu = UiLexicon.bajaui().buildMenu("slotsheet.menu.label");
        bMenu.add("add", (Command)this.add);
        bMenu.add("rename", (Command)this.rename);
        bMenu.add("flags", (Command)this.flags);
        bMenu.add("facets", (Command)this.facets);
        bMenu.add("reorder", (Command)this.reorder);
        bMenu.add("displayName", (Command)this.displayName);
        bMenu.add("sep0", (BValue)new BSeparator());
        bMenu.add("bajadocForType", (Command)this.bajadocForType);
        return new BMenu[]{bMenu};
    }

    public BToolBar getViewToolBar() {
        BToolBar bToolBar = new BToolBar();
        bToolBar.add("add", (Command)this.add);
        bToolBar.add("rename", (Command)this.rename);
        bToolBar.add("flags", (Command)this.flags);
        bToolBar.add("reorder", (Command)this.reorder);
        return bToolBar;
    }

    public void updateCommands() {
        BIPropertyContainer bIPropertyContainer = this.sheet.component;
        Slot[] slotArray = this.sheet.getSelectedSlots();
        int n = slotArray.length;
        boolean bl = n > 0;
        boolean bl2 = n > 0;
        for (int i = 0; i < slotArray.length; ++i) {
            Slot slot = slotArray[i];
            BValue bValue = null;
            if (slot.isProperty()) {
                bValue = bIPropertyContainer.get(slot.asProperty());
            }
            bl &= slotArray[i].isDynamic();
            bl2 = bl2 && bValue instanceof BComponent;
        }
        this.delete.setEnabled(bl);
        this.copy.setEnabled(bl2);
        this.rename.setEnabled(bl);
        this.facets.setEnabled(bl);
        this.flags.setEnabled(n > 0);
        this.displayName.setEnabled(n == 1);
        this.bajadocForType.setEnabled(n == 1 && slotArray[0].isProperty());
        this.sheet.setCommandEnabled(1, this.copy.isEnabled());
        this.sheet.setCommandEnabled(4, this.delete.isEnabled());
        this.sheet.setCommandEnabled(5, this.rename.isEnabled());
    }

    private boolean forceUpdate() {
        if (this.sheet.component instanceof BComponent) {
            return !((BComponent)this.sheet.component).isMounted();
        }
        return true;
    }

    void delete(BIPropertyContainer bIPropertyContainer, Slot slot, Context context) {
        if (slot.isFrozen()) {
            return;
        }
        bIPropertyContainer.remove(slot.asProperty(), context);
    }

    static BNameMap buildNewNameMap(BIPropertyContainer bIPropertyContainer, String string, String string2) {
        BNameMap bNameMap = null;
        BValue bValue = bIPropertyContainer.get("displayNames");
        if (bValue instanceof BNameMap) {
            bNameMap = (BNameMap)bValue;
        }
        HashMap<String, BFormat> hashMap = new HashMap<String, BFormat>();
        Slot[] slotArray = bIPropertyContainer.getSlotsArray();
        for (int i = 0; i < slotArray.length; ++i) {
            BFormat bFormat;
            Slot slot = slotArray[i];
            String string3 = slot.getName();
            if (string3.equals(string)) {
                if (string2.length() <= 0) continue;
                hashMap.put(string3, BFormat.make((String)string2));
                continue;
            }
            if (bNameMap == null || (bFormat = bNameMap.get(string3)) == null) continue;
            hashMap.put(string3, bFormat);
        }
        return BNameMap.make(hashMap);
    }

    class BajadocForTypeCommand
    extends SlotSheetCommand {
        public BajadocForTypeCommand() {
            super("slotsheet.commands.bajadocForType");
        }

        public CommandArtifact doInvoke() throws Exception {
            Property property = (Property)SlotSheetCommands.this.sheet.getSelectedSlots()[0];
            BValue bValue = SlotSheetCommands.this.sheet.component.get(property);
            BOrd bOrd = ObjectUtil.getReferenceHelpOrd((BObject)bValue);
            BWidgetShell bWidgetShell = this.getShell();
            if (bWidgetShell instanceof BWbShell) {
                ((BWbShell)bWidgetShell).hyperlink(bOrd);
            }
            return null;
        }
    }

    class DisplayNameCommand
    extends SlotSheetCommand {
        int row;

        public DisplayNameCommand() {
            super("slotsheet.commands.displayName");
        }

        public CommandArtifact doInvoke() throws Exception {
            BSlotSheet.SlotEntry slotEntry = SlotSheetCommands.this.sheet.getSelectedEntries()[0];
            Slot slot = slotEntry.slot;
            BIPropertyContainer bIPropertyContainer = SlotSheetCommands.this.sheet.component;
            String string = SetDisplayNameCommand.promptForNewDisplayName((BWidget)this.getOwner(), (BIPropertyContainer)bIPropertyContainer, (String)slotEntry.toDisplayName());
            if (string == null) {
                return null;
            }
            BNameMap bNameMap = SlotSheetCommands.buildNewNameMap(bIPropertyContainer, slot.getName(), string);
            Property property = bIPropertyContainer.getProperty("displayNames");
            if (bNameMap.isNull()) {
                if (property != null) {
                    bIPropertyContainer.remove(property, null);
                }
            } else if (property == null) {
                bIPropertyContainer.add("displayNames", (BValue)bNameMap, 261, null, null);
            } else {
                bIPropertyContainer.set(property, (BValue)bNameMap, null);
            }
            if (SlotSheetCommands.this.forceUpdate()) {
                SlotSheetCommands.this.sheet.updateModels();
            }
            return null;
        }
    }

    public class ReorderCommand
    extends SlotSheetCommand {
        public ReorderCommand() {
            super("commands.reorder");
        }

        public CommandArtifact doInvoke() throws Exception {
            BIPropertyContainer bIPropertyContainer = SlotSheetCommands.this.sheet.component;
            CommandArtifact commandArtifact = new ComponentReorderCommand((BWidget)SlotSheetCommands.this.sheet, bIPropertyContainer).doInvoke();
            if (SlotSheetCommands.this.forceUpdate()) {
                SlotSheetCommands.this.sheet.updateModels();
            }
            return commandArtifact;
        }
    }

    public class FacetsCommand
    extends SlotSheetCommand {
        public FacetsCommand() {
            super("commands.configFacets");
        }

        public CommandArtifact doInvoke() throws Exception {
            Slot[] slotArray = SlotSheetCommands.this.sheet.getSelectedSlots();
            Property[] propertyArray = new Property[slotArray.length];
            System.arraycopy(slotArray, 0, propertyArray, 0, propertyArray.length);
            BIPropertyContainer bIPropertyContainer = SlotSheetCommands.this.sheet.component;
            CommandArtifact commandArtifact = new ConfigFacetsCommand((BWidget)SlotSheetCommands.this.sheet, bIPropertyContainer, propertyArray).doInvoke();
            if (SlotSheetCommands.this.forceUpdate()) {
                SlotSheetCommands.this.sheet.updateModels();
            }
            return commandArtifact;
        }
    }

    public class FlagsCommand
    extends SlotSheetCommand {
        public FlagsCommand() {
            super("commands.configFlags");
        }

        public CommandArtifact doInvoke() throws Exception {
            Slot[] slotArray = SlotSheetCommands.this.sheet.getSelectedSlots();
            BIPropertyContainer bIPropertyContainer = SlotSheetCommands.this.sheet.component;
            CommandArtifact commandArtifact = new ConfigFlagsCommand((BWidget)SlotSheetCommands.this.sheet, bIPropertyContainer, slotArray).doInvoke();
            if (SlotSheetCommands.this.forceUpdate()) {
                SlotSheetCommands.this.sheet.updateModels();
            }
            return commandArtifact;
        }
    }

    public class RenameCommand
    extends SlotSheetCommand {
        public RenameCommand() {
            super("slotsheet.commands.rename");
        }

        public CommandArtifact doInvoke() throws Exception {
            BIPropertyContainer bIPropertyContainer = SlotSheetCommands.this.sheet.component;
            Slot[] slotArray = SlotSheetCommands.this.sheet.getSelectedSlots();
            BIPropertyContainer[] bIPropertyContainerArray = new BIPropertyContainer[slotArray.length];
            Property[] propertyArray = new Property[slotArray.length];
            for (int i = 0; i < slotArray.length; ++i) {
                bIPropertyContainerArray[i] = bIPropertyContainer;
                propertyArray[i] = (Property)slotArray[i];
            }
            CommandArtifact commandArtifact = new ComponentRenameCommand((BWidget)SlotSheetCommands.this.sheet, bIPropertyContainerArray, propertyArray, null).doInvoke();
            if (SlotSheetCommands.this.forceUpdate()) {
                SlotSheetCommands.this.sheet.updateModels();
            }
            return commandArtifact;
        }
    }

    public class DeleteCommand
    extends SlotSheetCommand {
        public DeleteCommand() {
            super("commands.delete");
        }

        public CommandArtifact doInvoke() throws Exception {
            BIPropertyContainer bIPropertyContainer = SlotSheetCommands.this.sheet.component;
            boolean bl = bIPropertyContainer instanceof BComponent;
            Context context = bl ? Transaction.start((BComponent)((BComponent)bIPropertyContainer), null) : null;
            Slot[] slotArray = SlotSheetCommands.this.sheet.getSelectedSlots();
            if (WbUtil.compositeDeletionWarning((BWidget)SlotSheetCommands.this.sheet, bIPropertyContainer, slotArray) == 2) {
                return null;
            }
            for (int i = 0; i < slotArray.length; ++i) {
                SlotSheetCommands.this.delete(bIPropertyContainer, slotArray[i], context);
            }
            if (bl) {
                Transaction.end((BComponent)((BComponent)bIPropertyContainer), (Context)context);
            }
            if (SlotSheetCommands.this.forceUpdate()) {
                SlotSheetCommands.this.sheet.updateModels();
            }
            return null;
        }
    }

    public class CopyCommand
    extends SlotSheetCommand {
        public CopyCommand() {
            super("commands.copy");
        }

        public CommandArtifact doInvoke() throws Exception {
            BIPropertyContainer bIPropertyContainer = SlotSheetCommands.this.sheet.component;
            Slot[] slotArray = SlotSheetCommands.this.sheet.getSelectedSlots();
            BComponent[] bComponentArray = new BComponent[slotArray.length];
            for (int i = 0; i < bComponentArray.length; ++i) {
                bComponentArray[i] = (BComponent)bIPropertyContainer.get(slotArray[i].asProperty());
            }
            Mark mark = new Mark((BObject[])bComponentArray);
            TransferEnvelope transferEnvelope = TransferEnvelope.make((Mark)mark);
            Clipboard.getDefault().setContents(transferEnvelope);
            Mark.setCurrent((Mark)mark);
            return null;
        }
    }

    public class AddCommand
    extends SlotSheetCommand
    implements ObjectUtil.NameContainer {
        public AddCommand() {
            super("slotsheet.commands.add");
        }

        public boolean contains(String string) {
            return SlotSheetCommands.this.sheet.component.getSlot(SlotPath.escape((String)string)) != null;
        }

        public CommandArtifact doInvoke() throws Exception {
            String string = ObjectUtil.generateUniqueSlotName((String)lastName, (ObjectUtil.NameContainer)this);
            BTextField bTextField = new BTextField(string, 25);
            BGridPane bGridPane = new BGridPane();
            bGridPane.setHalign(BHalign.left);
            bGridPane.add(null, (BValue)bTextField);
            BBorderPane bBorderPane = new BBorderPane((BWidget)bGridPane, "Name");
            BTypeSpecFE bTypeSpecFE = new BTypeSpecFE();
            BFacets bFacets = BFacets.make((String)"allowNull", (BIDataValue)BBoolean.FALSE, (String)"targetType", (BIDataValue)BString.make((String)"baja:Value"), (String)"showAbstract", (BIDataValue)BBoolean.FALSE);
            bTypeSpecFE.loadValue((BObject)lastType, (Context)bFacets);
            BGridPane bGridPane2 = new BGridPane();
            bGridPane2.setHalign(BHalign.left);
            bGridPane2.add(null, (BValue)bTypeSpecFE);
            BBorderPane bBorderPane2 = new BBorderPane((BWidget)bGridPane2, "Type");
            BFlagConfig bFlagConfig = new BFlagConfig(SlotSheetCommands.this.sheet.component, null);
            BGridPane bGridPane3 = new BGridPane();
            bGridPane3.setHalign(BHalign.left);
            bGridPane3.add(null, (BValue)bFlagConfig);
            BBorderPane bBorderPane3 = new BBorderPane((BWidget)bGridPane3, "Flags");
            BGridPane bGridPane4 = new BGridPane(1);
            bGridPane4.setColumnAlign(BHalign.fill);
            bGridPane4.add(null, (BValue)bBorderPane);
            bGridPane4.add(null, (BValue)bBorderPane2);
            bGridPane4.add(null, (BValue)bBorderPane3);
            String string2 = this.getLabel();
            int n = 3;
            if (BDialog.open((BWidget)SlotSheetCommands.this.sheet, (String)string2, (Object)bGridPane4, (int)n, null) == 2) {
                return null;
            }
            lastName = bTextField.getText();
            string = SlotPath.escape((String)bTextField.getText());
            BTypeSpec bTypeSpec = lastType = (BTypeSpec)bTypeSpecFE.saveValue();
            int n2 = bFlagConfig.save();
            BValue bValue = (BValue)bTypeSpec.getInstance();
            SlotSheetCommands.this.sheet.component.add(string, bValue, n2, null, null);
            if (SlotSheetCommands.this.forceUpdate()) {
                SlotSheetCommands.this.sheet.updateModels();
            }
            return null;
        }
    }

    public class SlotSheetCommand
    extends Command {
        public SlotSheetCommand(String string) {
            super((BWidget)SlotSheetCommands.this.sheet, UiLexicon.bajaui().module, string);
        }

        public CommandArtifact doInvoke() throws Exception {
            BDialog.message((BWidget)SlotSheetCommands.this.sheet, (Object)("Incomplete: " + this.getLabel()));
            return null;
        }
    }
}

