/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.slotsheet;

import com.tridium.sys.module.BTypeNavNode;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.slotsheet.BSlotSheet;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BFormat;
import javax.baja.util.BNameMap;
import javax.baja.workbench.view.BWbView;

public class BTypeSlotSheet
extends BWbView {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$slotsheet$BTypeSlotSheet == null ? (class$com$tridium$workbench$slotsheet$BTypeSlotSheet = BTypeSlotSheet.class$("com.tridium.workbench.slotsheet.BTypeSlotSheet")) : class$com$tridium$workbench$slotsheet$BTypeSlotSheet));
    static BFont overrideFont = BFont.make((String)Theme.table().getCellFont().getName(), (double)Theme.table().getCellFont().getSize(), (int)1);
    final UiLexicon lex = UiLexicon.bajaui();
    final String lexProperty = this.lex.getText("slotsheet.property");
    final String lexAction = this.lex.getText("slotsheet.action");
    final String lexTopic = this.lex.getText("slotsheet.topic");
    final String lexFrozen = this.lex.getText("slotsheet.frozen");
    final String lexDynamic = this.lex.getText("slotsheet.dynamic");
    final String lexSlot = this.lex.getText("slotsheet.slot");
    final String lexIndex = this.lex.getText("slotsheet.index");
    final String lexName = this.lex.getText("slotsheet.name");
    final String lexDisplayName = this.lex.getText("slotsheet.displayName");
    final String lexDefinition = this.lex.getText("slotsheet.definition");
    final String lexFlags = this.lex.getText("slotsheet.flags");
    final String lexType = this.lex.getText("slotsheet.type");
    final String lexFacets = this.lex.getText("slotsheet.facets");
    final String lexNameMap = this.lex.getText("slotsheet.nameMap");
    Model model = new Model();
    BTable table;
    SlotEntry[] slots = new SlotEntry[0];
    BNameMap displayNames = null;
    String name;
    static /* synthetic */ Class class$com$tridium$workbench$slotsheet$BTypeSlotSheet;

    public Type getType() {
        return TYPE;
    }

    public BTypeSlotSheet() {
        this.table = new BTable((TableModel)this.model);
        this.table.setCellRenderer((TableCellRenderer)new Renderer());
        this.table.setSelection((TableSelection)new Selection());
        this.setContent((BWidget)new BBorderPane((BWidget)this.table, BBorder.inset, BInsets.DEFAULT));
    }

    public void doLoadValue(BObject bObject, Context context) {
        BTypeNavNode bTypeNavNode = (BTypeNavNode)bObject;
        this.name = bTypeNavNode.getNavName();
        this.updateModels(bTypeNavNode.getSlots());
    }

    public BObject doSaveValue(BObject bObject, Context context) throws Exception {
        return bObject;
    }

    public Slot[] getSelectedSlots() {
        int[] nArray = this.table.getSelection().getRows();
        Slot[] slotArray = new Slot[nArray.length];
        for (int i = 0; i < slotArray.length; ++i) {
            slotArray[i] = this.slots[nArray[i]].slot;
        }
        return slotArray;
    }

    public SlotEntry[] getSelectedEntries() {
        int[] nArray = this.table.getSelection().getRows();
        SlotEntry[] slotEntryArray = new SlotEntry[nArray.length];
        for (int i = 0; i < slotEntryArray.length; ++i) {
            slotEntryArray[i] = this.slots[nArray[i]];
        }
        return slotEntryArray;
    }

    void updateModels(Slot[] slotArray) {
        SlotEntry[] slotEntryArray = new SlotEntry[slotArray.length];
        BNameMap bNameMap = null;
        for (int i = 0; i < slotArray.length; ++i) {
            Property property;
            BValue bValue;
            Slot slot = slotArray[i];
            String string = slot.getName();
            slotEntryArray[i] = new SlotEntry(i, slot);
            if (!slot.isProperty() || !string.equals("displayNames") || !((bValue = (property = slot.asProperty()).getDefaultValue()) instanceof BNameMap)) continue;
            bNameMap = (BNameMap)bValue;
        }
        this.table.relayout();
        this.slots = slotEntryArray;
        this.displayNames = bNameMap;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class SlotEntry {
        String summary;
        int index;
        BImage icon;
        Slot slot;
        String definition;
        int flags;
        String type;
        String facetsString;

        SlotEntry(int n, Slot slot) {
            this.slot = slot;
            this.index = n;
            this.flags = slot.getDefaultFlags();
            this.facetsString = slot.getFacets().toString();
            String string = this.definition = slot.isFrozen() ? BTypeSlotSheet.this.lexFrozen : BTypeSlotSheet.this.lexDynamic;
            if (slot.isAction()) {
                this.summary = BTypeSlotSheet.this.lexAction;
                this.icon = BSlotSheet.actionIcon;
                this.type = this.typestr(slot.asAction().getReturnType()) + " (" + this.typestr(slot.asAction().getParameterType()) + ")";
            } else if (slot.isTopic()) {
                this.summary = BTypeSlotSheet.this.lexTopic;
                this.icon = BSlotSheet.topicIcon;
                this.type = this.typestr(slot.asTopic().getEventType());
            } else {
                this.summary = BTypeSlotSheet.this.lexProperty;
                this.icon = BSlotSheet.propertyIcon;
                this.type = slot.isFrozen() ? this.typestr(slot.asProperty().getType()) : slot.getDeclaringType().toString();
            }
        }

        boolean isDisplayNameOverridden() {
            return BTypeSlotSheet.this.displayNames != null && BTypeSlotSheet.this.displayNames.get(this.slot.getName()) != null;
        }

        String toDisplayName() {
            BFormat bFormat;
            if (BTypeSlotSheet.this.displayNames != null && (bFormat = BTypeSlotSheet.this.displayNames.get(this.slot.getName())) != null) {
                return bFormat.getFormat();
            }
            return this.slot.getDefaultDisplayName(null);
        }

        String typestr(Type type) {
            if (type == null) {
                return "void";
            }
            return type.toString();
        }
    }

    class Model
    extends TableModel {
        Model() {
        }

        public int getRowCount() {
            return BTypeSlotSheet.this.slots.length;
        }

        public int getColumnCount() {
            return 8;
        }

        public String getColumnName(int n) {
            if (n == 0) {
                return BTypeSlotSheet.this.lexSlot;
            }
            if (n == 1) {
                return BTypeSlotSheet.this.lexIndex;
            }
            if (n == 2) {
                return BTypeSlotSheet.this.lexName;
            }
            if (n == 3) {
                return BTypeSlotSheet.this.lexDisplayName;
            }
            if (n == 4) {
                return BTypeSlotSheet.this.lexDefinition;
            }
            if (n == 5) {
                return BTypeSlotSheet.this.lexFlags;
            }
            if (n == 6) {
                return BTypeSlotSheet.this.lexType;
            }
            if (n == 7) {
                return BTypeSlotSheet.this.lexFacets;
            }
            return "???";
        }

        public Object getSubject(int n) {
            return BTypeSlotSheet.this.slots[n];
        }

        public Object getValueAt(int n, int n2) {
            SlotEntry slotEntry = BTypeSlotSheet.this.slots[n];
            if (n2 == 0) {
                return slotEntry.summary;
            }
            if (n2 == 1) {
                return String.valueOf(slotEntry.index);
            }
            if (n2 == 2) {
                return slotEntry.slot.getName();
            }
            if (n2 == 3) {
                return slotEntry.toDisplayName();
            }
            if (n2 == 4) {
                return slotEntry.definition;
            }
            if (n2 == 5) {
                return Flags.encodeToString((int)slotEntry.flags);
            }
            if (n2 == 6) {
                return slotEntry.type;
            }
            if (n2 == 7) {
                return slotEntry.facetsString;
            }
            return "???";
        }

        public BImage getRowIcon(int n) {
            return BTypeSlotSheet.this.slots[n].icon;
        }

        public boolean isColumnSortable(int n) {
            return true;
        }

        public void sortByColumn(int n, boolean bl) {
            Object[] objectArray = new Object[BTypeSlotSheet.this.slots.length];
            block3: for (int i = 0; i < objectArray.length; ++i) {
                switch (n) {
                    case 1: {
                        objectArray[i] = new Integer(BTypeSlotSheet.this.slots[i].index);
                        continue block3;
                    }
                    default: {
                        objectArray[i] = this.getValueAt(i, n).toString();
                    }
                }
            }
            SortUtil.sort((Object[])objectArray, (Object[])BTypeSlotSheet.this.slots, (boolean)bl);
        }
    }

    class Renderer
    extends TableCellRenderer {
        Renderer() {
        }

        public BFont getFont(TableCellRenderer.Cell cell) {
            SlotEntry slotEntry;
            if (cell.column == 3 && (slotEntry = BTypeSlotSheet.this.slots[cell.row]).isDisplayNameOverridden()) {
                return overrideFont;
            }
            return super.getFont(cell);
        }
    }

    class Selection
    extends TableSelection {
        Selection() {
        }

        public void updateTable() {
            super.updateTable();
        }
    }
}

