/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.slotsheet;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.slotsheet.SlotSheetCommands;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BIPropertyContainer;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BFormat;
import javax.baja.util.BNameMap;
import javax.baja.workbench.view.BWbComponentView;

public class BSlotSheet
extends BWbComponentView {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$slotsheet$BSlotSheet == null ? (class$com$tridium$workbench$slotsheet$BSlotSheet = BSlotSheet.class$("com.tridium.workbench.slotsheet.BSlotSheet")) : class$com$tridium$workbench$slotsheet$BSlotSheet));
    static BFont overrideFont = BFont.make((String)Theme.table().getCellFont().getName(), (double)Theme.table().getCellFont().getSize(), (int)1);
    final UiLexicon lex = UiLexicon.bajaui();
    final String lexProperty = this.lex.getText("slotsheet.property");
    final String lexAction = this.lex.getText("slotsheet.action");
    final String lexTopic = this.lex.getText("slotsheet.topic");
    final String lexFrozen = this.lex.getText("slotsheet.frozen");
    final String lexDynamic = this.lex.getText("slotsheet.dynamic");
    final String lexSlot = this.lex.getText("slotsheet.slot");
    final String lexIndex = this.lex.getText("slotsheet.index");
    final String lexName = this.lex.getText("slotsheet.name");
    final String lexDisplayName = this.lex.getText("slotsheet.displayName");
    final String lexDefinition = this.lex.getText("slotsheet.definition");
    final String lexFlags = this.lex.getText("slotsheet.flags");
    final String lexType = this.lex.getText("slotsheet.type");
    final String lexFacets = this.lex.getText("slotsheet.facets");
    final String lexNameMap = this.lex.getText("slotsheet.nameMap");
    public static final BImage propertyIcon = BImage.make((String)"module://icons/x16/object.png");
    public static final BImage actionIcon = BImage.make((String)"module://icons/x16/shapes/circleGreen.png");
    public static final BImage topicIcon = BImage.make((String)"module://icons/x16/shapes/circleGold.png");
    public final SlotSheetCommands commands = new SlotSheetCommands(this);
    Model model = new Model();
    BTable table;
    BIPropertyContainer component;
    SlotEntry[] slots = new SlotEntry[0];
    BNameMap displayNames = null;
    static /* synthetic */ Class class$com$tridium$workbench$slotsheet$BSlotSheet;

    public Type getType() {
        return TYPE;
    }

    public BSlotSheet() {
        this.autoRegisterForComponentEvents = false;
        UiLexicon uiLexicon = UiLexicon.bajaui();
        this.table = new BTable((TableModel)this.model);
        this.table.setController((TableController)new Controller());
        this.table.setCellRenderer((TableCellRenderer)new Renderer());
        this.table.setSelection((TableSelection)new Selection());
        this.setContent((BWidget)new BBorderPane((BWidget)this.table, BBorder.inset, BInsets.DEFAULT));
    }

    public BMenu[] getViewMenus() {
        return this.commands.getViewMenus();
    }

    public BToolBar getViewToolBar() {
        return this.commands.getViewToolBar();
    }

    public void doLoadValue(BObject bObject, Context context) {
        this.component = (BIPropertyContainer)bObject;
        if (this.component instanceof BComponent) {
            this.registerForComponentEvents((BComponent)this.component);
        }
        this.updateModels();
    }

    public BObject doSaveValue(BObject bObject, Context context) throws Exception {
        return bObject;
    }

    public CommandArtifact invokeCommand(int n) throws Exception {
        switch (n) {
            case 1: {
                return this.commands.copy.doInvoke();
            }
            case 4: {
                return this.commands.delete.doInvoke();
            }
            case 5: {
                return this.commands.rename.doInvoke();
            }
        }
        return super.invokeCommand(n);
    }

    public void handleComponentEvent(BComponentEvent bComponentEvent) {
        this.updateModels();
    }

    public Slot[] getSelectedSlots() {
        int[] nArray = this.table.getSelection().getRows();
        Slot[] slotArray = new Slot[nArray.length];
        for (int i = 0; i < slotArray.length; ++i) {
            slotArray[i] = this.slots[nArray[i]].slot;
        }
        return slotArray;
    }

    public SlotEntry[] getSelectedEntries() {
        int[] nArray = this.table.getSelection().getRows();
        SlotEntry[] slotEntryArray = new SlotEntry[nArray.length];
        for (int i = 0; i < slotEntryArray.length; ++i) {
            slotEntryArray[i] = this.slots[nArray[i]];
        }
        return slotEntryArray;
    }

    void updateModels() {
        if (this.component == null) {
            return;
        }
        Slot[] slotArray = this.component.getSlotsArray();
        SlotEntry[] slotEntryArray = new SlotEntry[slotArray.length];
        BNameMap bNameMap = null;
        for (int i = 0; i < slotArray.length; ++i) {
            Property property;
            BValue bValue;
            Slot slot = slotArray[i];
            String string = slot.getName();
            slotEntryArray[i] = new SlotEntry(this.component, i, slot);
            if (!slot.isProperty() || !string.equals("displayNames") || !((bValue = this.component.get(property = slot.asProperty())) instanceof BNameMap)) continue;
            bNameMap = (BNameMap)bValue;
        }
        this.table.relayout();
        this.slots = slotEntryArray;
        this.displayNames = bNameMap;
        this.commands.updateCommands();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class SlotEntry {
        String summary;
        int index;
        BImage icon;
        Slot slot;
        String definition;
        int flags;
        String type;
        String facetsString;

        SlotEntry(BIPropertyContainer bIPropertyContainer, int n, Slot slot) {
            this.slot = slot;
            this.index = n;
            this.flags = bIPropertyContainer.getFlags(slot);
            this.facetsString = bIPropertyContainer.getSlotFacets(slot).toString();
            String string = this.definition = slot.isFrozen() ? BSlotSheet.this.lexFrozen : BSlotSheet.this.lexDynamic;
            if (slot.isAction()) {
                this.summary = BSlotSheet.this.lexAction;
                this.icon = actionIcon;
                this.type = this.typestr(slot.asAction().getReturnType()) + " (" + this.typestr(slot.asAction().getParameterType()) + ")";
            } else if (slot.isTopic()) {
                this.summary = BSlotSheet.this.lexTopic;
                this.icon = topicIcon;
                this.type = this.typestr(slot.asTopic().getEventType());
            } else {
                this.summary = BSlotSheet.this.lexProperty;
                this.icon = propertyIcon;
                this.type = slot.isFrozen() ? this.typestr(slot.asProperty().getType()) : bIPropertyContainer.get(slot.asProperty()).getType().toString();
            }
        }

        boolean isDisplayNameOverridden() {
            return BSlotSheet.this.displayNames != null && BSlotSheet.this.displayNames.get(this.slot.getName()) != null;
        }

        String toDisplayName() {
            BFormat bFormat;
            if (BSlotSheet.this.displayNames != null && (bFormat = BSlotSheet.this.displayNames.get(this.slot.getName())) != null) {
                return bFormat.getFormat();
            }
            return BSlotSheet.this.component.getDisplayName(this.slot, null);
        }

        String typestr(Type type) {
            if (type == null) {
                return "void";
            }
            return type.toString();
        }
    }

    class Model
    extends TableModel {
        Model() {
        }

        public int getRowCount() {
            return BSlotSheet.this.slots.length;
        }

        public int getColumnCount() {
            return 8;
        }

        public String getColumnName(int n) {
            if (n == 0) {
                return BSlotSheet.this.lexSlot;
            }
            if (n == 1) {
                return BSlotSheet.this.lexIndex;
            }
            if (n == 2) {
                return BSlotSheet.this.lexName;
            }
            if (n == 3) {
                return BSlotSheet.this.lexDisplayName;
            }
            if (n == 4) {
                return BSlotSheet.this.lexDefinition;
            }
            if (n == 5) {
                return BSlotSheet.this.lexFlags;
            }
            if (n == 6) {
                return BSlotSheet.this.lexType;
            }
            if (n == 7) {
                return BSlotSheet.this.lexFacets;
            }
            return "???";
        }

        public Object getSubject(int n) {
            return BSlotSheet.this.slots[n];
        }

        public Object getValueAt(int n, int n2) {
            SlotEntry slotEntry = BSlotSheet.this.slots[n];
            if (n2 == 0) {
                return slotEntry.summary;
            }
            if (n2 == 1) {
                return String.valueOf(slotEntry.index);
            }
            if (n2 == 2) {
                return slotEntry.slot.getName();
            }
            if (n2 == 3) {
                return slotEntry.toDisplayName();
            }
            if (n2 == 4) {
                return slotEntry.definition;
            }
            if (n2 == 5) {
                return Flags.encodeToString((int)slotEntry.flags);
            }
            if (n2 == 6) {
                return slotEntry.type;
            }
            if (n2 == 7) {
                return slotEntry.facetsString;
            }
            return "???";
        }

        public BImage getRowIcon(int n) {
            return BSlotSheet.this.slots[n].icon;
        }

        public boolean isColumnSortable(int n) {
            return true;
        }

        public void sortByColumn(int n, boolean bl) {
            Object[] objectArray = new Object[BSlotSheet.this.slots.length];
            block3: for (int i = 0; i < objectArray.length; ++i) {
                switch (n) {
                    case 1: {
                        objectArray[i] = new Integer(BSlotSheet.this.slots[i].index);
                        continue block3;
                    }
                    default: {
                        objectArray[i] = this.getValueAt(i, n).toString();
                    }
                }
            }
            SortUtil.sort((Object[])objectArray, (Object[])BSlotSheet.this.slots, (boolean)bl);
        }
    }

    class Renderer
    extends TableCellRenderer {
        Renderer() {
        }

        public BFont getFont(TableCellRenderer.Cell cell) {
            SlotEntry slotEntry;
            if (cell.column == 3 && (slotEntry = BSlotSheet.this.slots[cell.row]).isDisplayNameOverridden()) {
                return overrideFont;
            }
            return super.getFont(cell);
        }
    }

    class Selection
    extends TableSelection {
        Selection() {
        }

        public void updateTable() {
            super.updateTable();
            BSlotSheet.this.commands.updateCommands();
        }
    }

    class Controller
    extends TableController {
        Controller() {
        }

        protected void handleEnter(BKeyEvent bKeyEvent) {
            int n = this.getSelection().getRow();
            BSlotSheet.this.commands.displayName.invoke();
        }

        public void cellDoubleClicked(BMouseEvent bMouseEvent, int n, int n2) {
            BSlotSheet.this.commands.displayName.invoke();
        }

        public void popup(BMouseEvent bMouseEvent, int n, int n2) {
            BMenu bMenu = new BMenu();
            bMenu.add(null, (Command)BSlotSheet.this.commands.add);
            bMenu.add(null, (Command)BSlotSheet.this.commands.copy);
            bMenu.add(null, (Command)BSlotSheet.this.commands.delete);
            bMenu.add(null, (Command)BSlotSheet.this.commands.rename);
            bMenu.add(null, (Command)BSlotSheet.this.commands.flags);
            bMenu.add(null, (Command)BSlotSheet.this.commands.facets);
            bMenu.add(null, (Command)BSlotSheet.this.commands.reorder);
            bMenu.add(null, (Command)BSlotSheet.this.commands.displayName);
            bMenu.add(null, (BValue)new BSeparator());
            bMenu.add(null, (Command)BSlotSheet.this.commands.bajadocForType);
            bMenu.open(bMouseEvent);
        }

        public int getTextSearchColumn() {
            return 3;
        }
    }
}

