/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.sidebars;

import com.tridium.ui.theme.custom.nss.StyleUtils;
import com.tridium.workbench.preview.BComponentPreviewWidget;
import com.tridium.workbench.util.BPalettePane;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BToggleButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.options.BOptions;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.pane.BTreePane;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeNode;
import javax.baja.util.Lexicon;
import javax.baja.workbench.nav.tree.BNavTree;
import javax.baja.workbench.nav.tree.DefaultNavTreeModel;
import javax.baja.workbench.nav.tree.NavTreeModel;
import javax.baja.workbench.nav.tree.NavTreeNode;
import javax.baja.workbench.sidebar.BWbSideBar;

public class BPaletteSideBar
extends BWbSideBar {
    public static final Action updateTree = BPaletteSideBar.newAction((int)0, null);
    public static final Action treeSelectionModified = BPaletteSideBar.newAction((int)0, null);
    public static final Topic previewToggled = BPaletteSideBar.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$sidebars$BPaletteSideBar == null ? (class$com$tridium$workbench$sidebars$BPaletteSideBar = BPaletteSideBar.class$("com.tridium.workbench.sidebars.BPaletteSideBar")) : class$com$tridium$workbench$sidebars$BPaletteSideBar));
    private static BImage openIcon = BImage.make((String)"module://icons/x16/openPalette.png");
    private static BImage closeIcon = BImage.make((String)"module://icons/x16/close.png");
    private static BImage moduleIcon = BImage.make((String)"module://icons/x16/module.png");
    private static BImage bogIcon = BImage.make((String)"module://icons/x16/objectFile.png");
    private static BImage prvIcon = BImage.make((String)"module://icons/x16/printPreview.png");
    private static Lexicon lex = Lexicon.make((String)"workbench");
    private BListDropDown openPals;
    private Close close;
    private ComponentPreview compPrev;
    private BNavTree tree;
    private BTreePane treePane;
    private BSplitPane splitPane;
    private BEdgePane content;
    private BComponentPreviewWidget prevWid;
    private HashMap hash = new HashMap();
    static /* synthetic */ Class class$com$tridium$workbench$sidebars$BPaletteSideBar;
    static /* synthetic */ Class class$javax$baja$sys$BInteger;
    static /* synthetic */ Class class$javax$baja$sys$BString;

    public void updateTree() {
        this.invoke(updateTree, null, null);
    }

    public void treeSelectionModified() {
        this.invoke(treeSelectionModified, null, null);
    }

    public void firePreviewToggled(BBoolean bBoolean) {
        this.fire(previewToggled, (BValue)bBoolean, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BPaletteSideBar() {
        this(false);
    }

    public BPaletteSideBar(boolean bl) {
        this.openPals = new BListDropDown();
        this.linkTo(null, (BComponent)this.openPals, (Slot)BListDropDown.listActionPerformed, (Slot)updateTree);
        this.tree = new BNavTree(new EmptyModel());
        this.tree.setMultipleSelection(true);
        BButton bButton = new BButton((Command)new Open(this), false, true);
        this.close = new Close(this);
        BButton bButton2 = new BButton((Command)this.close, false, true);
        this.compPrev = new ComponentPreview(this);
        BToggleButton bToggleButton = new BToggleButton((ToggleCommand)this.compPrev, false, true);
        bButton.setButtonStyle(BButtonStyle.toolBar);
        bButton.setFocusTraversable(false);
        bButton2.setButtonStyle(BButtonStyle.toolBar);
        bButton2.setFocusTraversable(false);
        bToggleButton.setButtonStyle(BButtonStyle.toolBar);
        bToggleButton.setFocusTraversable(false);
        BGridPane bGridPane = new BGridPane(3);
        bGridPane.setColumnAlign(BHalign.fill);
        bGridPane.setRowAlign(BValign.fill);
        bGridPane.add(null, (BValue)bButton);
        bGridPane.add(null, (BValue)bButton2);
        bGridPane.add(null, (BValue)bToggleButton);
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setLeft((BWidget)bGridPane);
        bEdgePane.setCenter((BWidget)new BBorderPane((BWidget)this.openPals, 0.0, 0.0, 0.0, 5.0));
        BBorderPane bBorderPane = new BBorderPane((BWidget)bEdgePane, 5.0, 5.0, 5.0, 5.0);
        StyleUtils.addStyleClass((IStylable)bBorderPane, (String)"sidebar-header");
        this.content = new BEdgePane();
        this.content.setTop((BWidget)bBorderPane);
        this.treePane = new BTreePane((BTree)this.tree);
        this.treePane.setStyleId("palette-sidebar");
        StyleUtils.addStyleClass((IStylable)this.treePane, (String)"sidebar-body");
        this.content.setCenter((BWidget)this.treePane);
        this.splitPane = new BSplitPane(BOrientation.vertical, 65.0);
        this.prevWid = new BComponentPreviewWidget();
        this.splitPane.setWidget2((BWidget)new BBorderPane((BWidget)this.prevWid, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        this.close.setEnabled(false);
        this.openPals.setEnabled(false);
        this.setContent((BWidget)this.content);
        this.linkTo((BComponent)this.tree, (Slot)BTree.selectionModified, (Slot)treeSelectionModified);
        this.loadPalettes();
        if (this.openPals.getList().getItemCount() > 0) {
            int n;
            BInteger[] bIntegerArray = (BInteger[])this.getOptions().getChildren(class$javax$baja$sys$BInteger == null ? (class$javax$baja$sys$BInteger = BPaletteSideBar.class$("javax.baja.sys.BInteger")) : class$javax$baja$sys$BInteger);
            int n2 = n = bIntegerArray.length > 0 ? bIntegerArray[0].getInt() : 0;
            if (n >= this.openPals.getList().getItemCount()) {
                n = 0;
            }
            this.openPals.getList().setSelectedIndex(n);
            this.doUpdateTree();
        }
        this.compPrev.setSelected(bl);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        graphics.setBrush(BColor.black);
        graphics.strokeRect(0.0, 0.0, this.getWidth() - 1.0, this.getHeight() - 1.0);
    }

    public void doUpdateTree() {
        NavTreeModel navTreeModel;
        int n = this.openPals.getList().getSelectedIndex();
        this.close.setEnabled(n != -1);
        this.openPals.setEnabled(n != -1);
        if (n == -1) {
            this.tree.setModel(new EmptyModel());
            return;
        }
        String string = ((Item)this.openPals.getList().getSelectedItem()).name;
        if (string == null) {
            this.tree.setModel(new EmptyModel());
        } else {
            Property property;
            BOptions bOptions;
            navTreeModel = (NavTreeModel)((Object)this.hash.get(string));
            if (navTreeModel == null) {
                try {
                    if (string.startsWith("file:")) {
                        bOptions = (BINavNode)BOrd.make((String)string).resolve().get();
                        navTreeModel = new DefaultNavTreeModel((BINavNode)bOptions);
                        this.hash.put(string, navTreeModel);
                    } else {
                        bOptions = Sys.loadModule((String)string);
                        property = bOptions.getNavChild("module.palette");
                        navTreeModel = new DefaultNavTreeModel((BINavNode)property);
                        this.hash.put(string, navTreeModel);
                    }
                }
                catch (Exception exception) {
                    System.out.println("[" + string + "]  Module or Palette does not exist! Do something!");
                    return;
                }
            }
            this.tree.setModel(navTreeModel);
            bOptions = this.getOptions();
            property = bOptions.getProperty("currentPalette");
            if (property == null) {
                bOptions.add("currentPalette", (BValue)BInteger.make((int)n));
            } else {
                bOptions.set(property, (BValue)BInteger.make((int)n));
            }
        }
        navTreeModel = this.tree.getSelection();
        if (navTreeModel != null) {
            navTreeModel.deselectAll();
        }
        this.tree.relayout();
        this.doTreeSelectionModified();
    }

    public void doTreeSelectionModified() {
        if (!this.compPrev.isSelected()) {
            return;
        }
        NavTreeNode navTreeNode = (NavTreeNode)this.tree.getSelection().getNode();
        if (navTreeNode != null && navTreeNode.getNavNode() instanceof BComponent) {
            this.prevWid.setCurrentComponent((BComponent)navTreeNode.getNavNode());
        } else {
            this.prevWid.setCurrentComponent(null);
        }
        this.repaint();
    }

    public BOptions getOptions() {
        return BOptions.load((String)"paletteSideBar", (Type)BOptions.TYPE);
    }

    private void loadPalettes() {
        this.openPals.getList().removeAllItems();
        this.sort();
        BOptions bOptions = this.getOptions();
        BString[] bStringArray = (BString[])bOptions.getChildren(class$javax$baja$sys$BString == null ? (class$javax$baja$sys$BString = BPaletteSideBar.class$("javax.baja.sys.BString")) : class$javax$baja$sys$BString);
        for (int i = 0; i < bStringArray.length; ++i) {
            String string = bStringArray[i].toString();
            if (string.startsWith("file:")) {
                this.openPals.getList().addItem(bogIcon, (Object)new Item(this.toDisplay(string), string));
                continue;
            }
            this.openPals.getList().addItem(moduleIcon, (Object)new Item(string, string));
        }
    }

    private String toDisplay(String string) {
        int n;
        String string2 = ".bog";
        int n2 = string.indexOf(string2);
        if (n2 == -1) {
            string2 = ".palette";
            n2 = string.indexOf(".palette");
        }
        if (n2 == -1) {
            return string;
        }
        for (n = n2 - 1; n > 0 && string.charAt(n) != '/' && string.charAt(n) != '^' && string.charAt(n) != '!'; --n) {
        }
        return string.substring(n + 1, n2 + string2.length());
    }

    private void sort() {
        BOptions bOptions = this.getOptions();
        Property[] propertyArray = bOptions.getPropertiesArray();
        if (propertyArray.length == 0) {
            return;
        }
        Arrays.sort(propertyArray, new Sorter());
        bOptions.reorder(propertyArray, null);
    }

    public BNavTree getNavTree() {
        return this.tree;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Item {
        public String displayName;
        public String name;

        public Item(String string, String string2) {
            this.displayName = string;
            this.name = string2;
        }

        public String toString() {
            return this.displayName;
        }

        public boolean equals(Object object) {
            return this.name.equals(((Item)object).name);
        }
    }

    private class Sorter
    implements Comparator {
        private Sorter() {
        }

        public int compare(Object object, Object object2) {
            BValue bValue = BPaletteSideBar.this.getOptions().get((Property)object);
            BValue bValue2 = BPaletteSideBar.this.getOptions().get((Property)object2);
            if (bValue instanceof BString && bValue2 instanceof BString) {
                BString bString = (BString)bValue;
                BString bString2 = (BString)bValue2;
                return bString.getString().compareTo(bString2.getString());
            }
            return 1;
        }
    }

    class EmptyModel
    extends NavTreeModel {
        EmptyModel() {
        }

        public int getRootCount() {
            return 0;
        }

        public TreeNode getRoot(int n) {
            return null;
        }
    }

    class ComponentPreview
    extends ToggleCommand {
        public ComponentPreview(BWidget bWidget) {
            super(bWidget, lex.getText("PaletteSideBar.preview"));
        }

        public BImage getIcon() {
            return prvIcon;
        }

        public CommandArtifact doInvoke() {
            if (this.isSelected()) {
                BPaletteSideBar.this.content.setCenter((BWidget)new BNullWidget());
                BPaletteSideBar.this.splitPane.setWidget1((BWidget)BPaletteSideBar.this.treePane);
                BPaletteSideBar.this.content.setCenter((BWidget)BPaletteSideBar.this.splitPane);
                BPaletteSideBar.this.doTreeSelectionModified();
            } else {
                BPaletteSideBar.this.splitPane.setWidget1((BWidget)new BNullWidget());
                BPaletteSideBar.this.content.setCenter((BWidget)BPaletteSideBar.this.treePane);
            }
            BPaletteSideBar.this.relayout();
            BPaletteSideBar.this.firePreviewToggled(this.isSelected() ? BBoolean.TRUE : BBoolean.FALSE);
            return null;
        }
    }

    class Close
    extends Command {
        public Close(BWidget bWidget) {
            super(bWidget, lex.getText("PaletteSideBar.closePalette"));
        }

        public BImage getIcon() {
            return closeIcon;
        }

        public CommandArtifact doInvoke() {
            Item item = (Item)BPaletteSideBar.this.openPals.getList().getSelectedItem();
            if (item != null) {
                int n;
                BOptions bOptions = BPaletteSideBar.this.getOptions();
                Property[] propertyArray = bOptions.loadSlots().getPropertiesArray();
                for (n = 0; n < propertyArray.length; ++n) {
                    BValue bValue = bOptions.get(propertyArray[n]);
                    if (!(bValue instanceof BString) || !((BString)bValue).getString().equals(item.name)) continue;
                    bOptions.remove(propertyArray[n]);
                    break;
                }
                BPaletteSideBar.this.openPals.getList().removeItem((Object)item);
                BPaletteSideBar.this.hash.remove(item.name);
                n = BPaletteSideBar.this.openPals.getList().getItemCount();
                int n2 = BPaletteSideBar.this.openPals.getList().getSelectedIndex();
                if (n == 0) {
                    BPaletteSideBar.this.openPals.getList().getSelection().deselectAll();
                } else if (n2 >= n) {
                    BPaletteSideBar.this.openPals.getList().setSelectedIndex(n - 1);
                }
                BPaletteSideBar.this.doUpdateTree();
            }
            return null;
        }
    }

    class Open
    extends Command {
        public Open(BWidget bWidget) {
            super(bWidget, lex.getText("PaletteSideBar.openPalette"));
        }

        public BImage getIcon() {
            return openIcon;
        }

        public CommandArtifact doInvoke() {
            BPalettePane bPalettePane = new BPalettePane(this.getOwner());
            if (1 == BDialog.open((BWidget)this.getOwner(), (String)lex.getText("PaletteSideBar.openPalette"), (Object)((Object)bPalettePane), (int)3)) {
                if (bPalettePane.isFileSelected()) {
                    String string = bPalettePane.getFileSelection().relativizeToSession().toString();
                    ListModel listModel = BPaletteSideBar.this.openPals.getList().getModel();
                    Item item = new Item(BPaletteSideBar.this.toDisplay(string), string);
                    listModel.addItem(bogIcon, (Object)item);
                    BPaletteSideBar.this.getOptions().add(null, (BValue)BString.make((String)string));
                    BPaletteSideBar.this.openPals.getList().setSelectedIndex(listModel.indexOfItem((Object)item));
                } else {
                    String[] stringArray = bPalettePane.getTableSelection();
                    if (stringArray.length == 0) {
                        return null;
                    }
                    BOptions bOptions = BPaletteSideBar.this.getOptions();
                    ListModel listModel = BPaletteSideBar.this.openPals.getList().getModel();
                    for (int i = 0; i < stringArray.length; ++i) {
                        Item item = new Item(stringArray[i], stringArray[i]);
                        if (listModel.indexOfItem((Object)item) == -1) {
                            bOptions.add(null, (BValue)BString.make((String)item.name));
                            BPaletteSideBar.this.loadPalettes();
                        }
                        if (i != 0) continue;
                        BPaletteSideBar.this.openPals.getList().setSelectedIndex(listModel.indexOfItem((Object)item));
                    }
                }
                BPaletteSideBar.this.doUpdateTree();
            }
            return null;
        }
    }
}

