/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.sidebars;

import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.custom.nss.StyleUtils;
import com.tridium.util.ThrowableUtil;
import com.tridium.workbench.bookmark.BookmarkEvents;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.shell.WbMain;
import java.util.HashMap;
import java.util.Set;
import javax.baja.file.BIFile;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavEvent;
import javax.baja.spy.BSpySpace;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.bookmark.BBookmark;
import javax.baja.ui.bookmark.BBookmarkFolder;
import javax.baja.ui.bookmark.BBookmarkOptions;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.DefaultListModel;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.pane.BTreePane;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.nav.tree.BNavTree;
import javax.baja.workbench.nav.tree.DefaultNavTreeModel;
import javax.baja.workbench.nav.tree.NavTreeController;
import javax.baja.workbench.nav.tree.NavTreeModel;
import javax.baja.workbench.nav.tree.NavTreeNode;
import javax.baja.workbench.nav.tree.NavTreeSubject;
import javax.baja.workbench.sidebar.BWbSideBar;

public class BNavSideBar
extends BWbSideBar
implements BookmarkEvents.Listener {
    public static final Action updateTree = BNavSideBar.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$sidebars$BNavSideBar == null ? (class$com$tridium$workbench$sidebars$BNavSideBar = BNavSideBar.class$("com.tridium.workbench.sidebars.BNavSideBar")) : class$com$tridium$workbench$sidebars$BNavSideBar));
    private boolean init = false;
    private static BImage errorIcon = BImage.make((String)"module://icons/x32/error.png");
    private static BImage newTreeIcon = BImage.make((String)"module://icons/x16/newTree.png");
    private static BImage syncIcon = BImage.make((String)"module://icons/x16/sync.png");
    private static BImage closeIcon = BImage.make((String)"module://icons/x16/close.png");
    private static Lexicon lex = Lexicon.make((String)"workbench");
    private BEdgePane content;
    private BTreePane treePane;
    private BListDropDown openTrees;
    private Close close;
    private BNavTree tree;
    private BINavNode root;
    private boolean inError = false;
    private HashMap hash = new HashMap();
    static /* synthetic */ Class class$com$tridium$workbench$sidebars$BNavSideBar;
    static /* synthetic */ Class class$javax$baja$ui$bookmark$BBookmark;

    public void updateTree() {
        this.invoke(updateTree, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BNavSideBar() {
        this.tree = new BNavTree();
        this.tree.setMultipleSelection(true);
        this.tree.setController(new Controller());
        this.openTrees = new BListDropDown();
        this.openTrees.getList().setModel((ListModel)new NavListModel());
        this.linkTo(null, (BComponent)this.openTrees, (Slot)BListDropDown.listActionPerformed, (Slot)updateTree);
        BButton bButton = new BButton((Command)new NewTree(this), false, true);
        BButton bButton2 = new BButton((Command)new SyncTree(this), false, true);
        this.close = new Close(this);
        BButton bButton3 = new BButton((Command)this.close, false, true);
        bButton.setButtonStyle(BButtonStyle.toolBar);
        bButton.setFocusTraversable(false);
        bButton2.setButtonStyle(BButtonStyle.toolBar);
        bButton2.setFocusTraversable(false);
        bButton3.setButtonStyle(BButtonStyle.toolBar);
        bButton3.setFocusTraversable(false);
        BGridPane bGridPane = new BGridPane(3);
        bGridPane.setColumnAlign(BHalign.fill);
        bGridPane.setRowAlign(BValign.fill);
        bGridPane.add(null, (BValue)bButton);
        bGridPane.add(null, (BValue)bButton2);
        bGridPane.add(null, (BValue)bButton3);
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setLeft((BWidget)bGridPane);
        bEdgePane.setCenter((BWidget)new BBorderPane((BWidget)this.openTrees, 0.0, 0.0, 0.0, 5.0));
        BBorderPane bBorderPane = new BBorderPane((BWidget)bEdgePane, 5.0, 5.0, 5.0, 5.0);
        StyleUtils.addStyleClass((IStylable)bBorderPane, (String)"sidebar-header");
        this.treePane = new BTreePane((BTree)this.tree);
        this.tree.setStyleId("nav-sidebar");
        StyleUtils.addStyleClass((IStylable)this.tree, (String)"sidebar-body");
        this.content = new BEdgePane();
        this.content.setTop((BWidget)bBorderPane);
        this.content.setCenter((BWidget)this.treePane);
        this.setContent((BWidget)this.content);
    }

    public void started() throws Exception {
        super.started();
        if (!this.init) {
            BOrd bOrd = this.getWbShell().getProfile().getNavRootOrd();
            this.root = (BINavNode)bOrd.resolve().get();
            this.loadNavTrees();
            this.openTrees.getList().setSelectedIndex(0);
            this.doUpdateTree();
            this.init = true;
        }
        BookmarkEvents.add(this);
    }

    public void stopped() throws Exception {
        super.stopped();
        BookmarkEvents.remove(this);
    }

    public void activeViewChanged() {
        if (!this.inError) {
            return;
        }
        this.doUpdateTree();
    }

    public void goInto(BINavNode bINavNode) {
        BBookmarkOptions bBookmarkOptions = this.getOptions();
        BBookmark bBookmark = new BBookmark(bINavNode.getNavDisplayName(null), bINavNode.getNavOrd(), bINavNode.getNavIcon());
        this.getGoInto().add(null, (BValue)bBookmark);
        bBookmarkOptions.save();
        this.addTreeToList(bBookmark);
        this.openTrees.getList().setSelectedIndex(this.openTrees.getList().getItemCount() - 1);
        this.doUpdateTree();
        BookmarkEvents.fireBookmarkChanged();
    }

    public void syncTree() {
        this.syncTree(false);
    }

    public void syncTree(boolean bl) {
        new SyncCommand((BWidget)this.tree, bl).invoke();
        new RefreshCommand((BWidget)this.tree).invoke();
    }

    public void bookmarkChanged() {
        int n = this.openTrees.getList().getSelectedIndex();
        this.loadNavTrees();
        BList bList = this.openTrees.getList();
        Set set = this.hash.keySet();
        NavWrapper[] navWrapperArray = set.toArray(new NavWrapper[set.size()]);
        block0: for (int i = 0; i < navWrapperArray.length; ++i) {
            for (int j = 0; j < bList.getItemCount(); ++j) {
                NavWrapper navWrapper = (NavWrapper)bList.getItem(j);
                if ((navWrapperArray[i].bookmark.getName() != null || navWrapper.bookmark.getName() != null) && !navWrapperArray[i].bookmark.getName().equals(navWrapper.bookmark.getName()) || !navWrapperArray[i].bookmark.getBookmarkOrd().equals((Object)navWrapper.bookmark.getBookmarkOrd())) continue;
                this.hash.put(navWrapper, this.hash.remove(navWrapperArray[i]));
                continue block0;
            }
        }
        if (n >= this.openTrees.getList().getItemCount()) {
            n = 0;
        }
        this.openTrees.getList().setSelectedIndex(n);
        this.doUpdateTree();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        graphics.setBrush(BColor.black);
        graphics.strokeRect(0.0, 0.0, this.getWidth() - 1.0, this.getHeight() - 1.0);
    }

    public void doUpdateTree() {
        this.inError = false;
        NavWrapper navWrapper = (NavWrapper)this.openTrees.getSelectedItem();
        this.close.setEnabled(!navWrapper.isRoot);
        try {
            NavTreeModel navTreeModel = (NavTreeModel)((Object)this.hash.get(navWrapper));
            if (navTreeModel == null) {
                BNiagaraWbShell bNiagaraWbShell = (BNiagaraWbShell)this.getWbShell();
                BOrd bOrd = navWrapper.bookmark.getBookmarkOrd();
                BObject bObject = this.openTrees.getSelectedIndex() == 0 ? bOrd.resolve().get() : bNiagaraWbShell.resolve(bOrd, null).get();
                navWrapper.bookmark.setIcon(bObject.getIcon());
                navTreeModel = new Model((BINavNode)bObject);
                this.hash.put(navWrapper, navTreeModel);
            } else {
                BOrd bOrd = navWrapper.bookmark.getBookmarkOrd();
                try {
                    bOrd.resolve(null);
                }
                catch (Exception exception) {
                    this.hash.remove(navWrapper);
                    BNiagaraWbShell bNiagaraWbShell = (BNiagaraWbShell)this.getWbShell();
                    BObject bObject = bNiagaraWbShell.resolve(bOrd, null).get();
                    navTreeModel = new Model((BINavNode)bObject);
                    this.hash.put(navWrapper, navTreeModel);
                }
            }
            this.tree.setModel(navTreeModel);
            this.tree.relayout();
            if (!(this.content.getCenter() instanceof BTreePane)) {
                this.content.setCenter((BWidget)this.treePane);
            }
        }
        catch (Exception exception) {
            this.hash.remove(navWrapper);
            this.displayError(navWrapper.bookmark.getText(), exception);
        }
    }

    public BNavTree getTree() {
        return this.tree;
    }

    private void displayError(String string, Exception exception) {
        this.inError = true;
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.setRowGap(1.0);
        bGridPane.add(null, (BValue)new BLabel(lex.getText("NavSideBar.couldNotFind"), Theme.widget().getBoldText()));
        bGridPane.add(null, (BValue)new BLabel(string));
        BGridPane bGridPane2 = new BGridPane(2);
        bGridPane2.add(null, (BValue)new BLabel(errorIcon, ""));
        bGridPane2.add(null, (BValue)bGridPane);
        BGridPane bGridPane3 = new BGridPane(1);
        bGridPane3.setRowGap(5.0);
        bGridPane3.setColumnAlign(BHalign.center);
        bGridPane3.add(null, (BValue)bGridPane2);
        bGridPane3.add(null, (BValue)new BButton((Command)new Details(this, string, exception)));
        this.content.setCenter((BWidget)bGridPane3);
    }

    public BBookmarkOptions getOptions() {
        return BBookmarkOptions.make();
    }

    public BBookmarkFolder getGoInto() {
        BBookmarkFolder bBookmarkFolder = (BBookmarkFolder)this.getOptions().getRootFolder().get("goInto");
        if (bBookmarkFolder == null) {
            bBookmarkFolder = new BBookmarkFolder("Go Into");
            this.getOptions().getRootFolder().add("goInto", (BValue)bBookmarkFolder);
        }
        return bBookmarkFolder;
    }

    private void loadNavTrees() {
        this.openTrees.getList().removeAllItems();
        this.openTrees.getList().addItem((Object)new NavWrapper(this.makeRoot(), true));
        BBookmarkFolder bBookmarkFolder = this.getGoInto();
        BBookmark[] bBookmarkArray = (BBookmark[])bBookmarkFolder.getChildren(class$javax$baja$ui$bookmark$BBookmark == null ? (class$javax$baja$ui$bookmark$BBookmark = BNavSideBar.class$("javax.baja.ui.bookmark.BBookmark")) : class$javax$baja$ui$bookmark$BBookmark);
        for (int i = 0; i < bBookmarkArray.length; ++i) {
            this.addTreeToList(bBookmarkArray[i]);
        }
    }

    private BBookmark makeRoot() {
        BNavRoot bNavRoot = this.root == null ? BNavRoot.INSTANCE : this.root;
        return new BBookmark(bNavRoot.getNavDisplayName(null), bNavRoot.getNavOrd(), bNavRoot.getNavIcon());
    }

    private void addTreeToList(BBookmark bBookmark) {
        NavWrapper navWrapper = new NavWrapper(bBookmark);
        this.openTrees.getList().addItem(BImage.make((BIcon)bBookmark.getIcon()), (Object)navWrapper);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Model
    extends DefaultNavTreeModel {
        public Model(BINavNode bINavNode) {
            super(bINavNode);
        }

        protected void added(NavEvent navEvent) {
            super.added(navEvent);
            this.updateAll(navEvent);
        }

        protected void removed(NavEvent navEvent) {
            NavWrapper navWrapper = (NavWrapper)BNavSideBar.this.openTrees.getSelectedItem();
            BOrd bOrd = navWrapper.bookmark.getBookmarkOrd();
            if (WbMain.isRemoved(navEvent, bOrd)) {
                BNavSideBar.this.displayError(navWrapper.bookmark.getText(), new Exception("Parent node removed"));
                BNavSideBar.this.hash.remove(navWrapper);
            } else {
                super.removed(navEvent);
                this.updateAll(navEvent);
            }
        }

        protected void reordered(NavEvent navEvent) {
            super.reordered(navEvent);
            this.updateAll(navEvent);
        }

        private void updateAll(NavEvent navEvent) {
            if (this != BNavSideBar.this.hash.get(BNavSideBar.this.openTrees.getSelectedItem())) {
                return;
            }
            for (int i = 0; i < BNavSideBar.this.openTrees.getList().getItemCount(); ++i) {
                NavWrapper navWrapper = (NavWrapper)BNavSideBar.this.openTrees.getList().getItem(i);
                NavTreeModel navTreeModel = (NavTreeModel)((Object)BNavSideBar.this.hash.get(navWrapper));
                if (navTreeModel == null || this == navTreeModel) continue;
                navTreeModel.navEvent(navEvent);
            }
        }

        public NavTreeNode makeNavTreeNode(NavTreeNode navTreeNode, BINavNode bINavNode) {
            if (bINavNode instanceof BSpySpace) {
                return null;
            }
            if (bINavNode instanceof BIFile && bINavNode.getNavName().endsWith(".lock")) {
                return null;
            }
            return super.makeNavTreeNode(navTreeNode, bINavNode);
        }
    }

    class GoIntoCommand
    extends Command {
        BNavSideBar owner;
        NavTreeNode node;

        GoIntoCommand(BNavSideBar bNavSideBar2, NavTreeNode navTreeNode) {
            super((BWidget)bNavSideBar2, UiLexicon.bajaui().module, "tree.goInto");
            this.owner = bNavSideBar2;
            this.node = navTreeNode;
        }

        public CommandArtifact doInvoke() throws Exception {
            this.owner.goInto(this.node.getNavNode());
            return null;
        }
    }

    class SyncCommand
    extends Command {
        boolean silence = false;

        SyncCommand(BWidget bWidget, boolean bl) {
            super(bWidget, UiLexicon.bajaui().module, "tree.sync");
            this.silence = bl;
        }

        public CommandArtifact doInvoke() {
            block2: {
                try {
                    BObject bObject = BNavSideBar.this.getWbShell().getActiveOrdTarget().get();
                    BNavSideBar.this.tree.expandToNavNode((BINavNode)bObject);
                }
                catch (Exception exception) {
                    if (this.silence) break block2;
                    BGridPane bGridPane = new BGridPane(1);
                    bGridPane.setHalign(BHalign.left);
                    bGridPane.add(null, (BValue)new BLabel(lex.getText("NavSideBar.nodeNotFound")));
                    bGridPane.add(null, (BValue)new BLabel(BNavSideBar.this.getWbShell().getActiveOrd().toString()));
                    BDialog.open((BWidget)this.getOwner(), (String)BDialog.TITLE_ERROR, (Object)bGridPane, (int)1, (BImage)BDialog.ERROR_ICON, (Throwable)exception);
                }
            }
            return null;
        }
    }

    class RefreshCommand
    extends Command {
        RefreshCommand(BWidget bWidget) {
            super(bWidget, UiLexicon.bajaui().module, "tree.refresh");
        }

        public CommandArtifact doInvoke() throws Exception {
            if (BNavSideBar.this.tree.getModel() instanceof Model) {
                Model model = (Model)BNavSideBar.this.tree.getModel();
                model.setRootVisible(true);
                NavTreeNode navTreeNode = (NavTreeNode)model.getRoot(0);
                model.setRootVisible(false);
                navTreeNode.refresh();
            }
            return null;
        }
    }

    class Controller
    extends NavTreeController {
        Controller() {
        }

        protected BMenu makePopup(NavTreeSubject navTreeSubject) {
            BMenu bMenu = super.makePopup(navTreeSubject);
            BNavTree bNavTree = (BNavTree)this.getTree();
            if (bNavTree.getReadonly()) {
                return null;
            }
            if (navTreeSubject.size() == 0) {
                if (bMenu == null) {
                    bMenu = new BMenu();
                }
                bMenu.add(null, (Command)new RefreshCommand((BWidget)bNavTree));
                bMenu.add(null, (Command)new SyncCommand((BWidget)bNavTree, false));
                return bMenu;
            }
            NavTreeNode navTreeNode = (NavTreeNode)navTreeSubject.getActiveNode();
            if (navTreeSubject.size() == 1 && navTreeNode != null && !(navTreeNode.getNavNode() instanceof BSpySpace)) {
                if (bMenu == null) {
                    bMenu = new BMenu();
                }
                bMenu.add(null, (Command)new GoIntoCommand(BNavSideBar.this, navTreeNode));
            }
            return bMenu;
        }
    }

    class NavWrapper {
        public BBookmark bookmark;
        public boolean isRoot = false;

        public NavWrapper(BBookmark bBookmark) {
            this(bBookmark, false);
        }

        public NavWrapper(BBookmark bBookmark, boolean bl) {
            this.bookmark = bBookmark;
            this.isRoot = bl;
        }

        public String toString() {
            return this.bookmark.getText();
        }
    }

    class NavListModel
    extends DefaultListModel {
        NavListModel() {
        }

        public BImage getItemIcon(int n) {
            NavWrapper navWrapper = (NavWrapper)this.getItem(n);
            return BImage.make((BIcon)navWrapper.bookmark.getIcon());
        }
    }

    class Details
    extends Command {
        private String name;
        private Exception e;

        public Details(BWidget bWidget, String string, Exception exception) {
            super(bWidget, lex.getText("NavSideBar.details"));
            this.name = string;
            this.e = exception;
        }

        public CommandArtifact doInvoke() {
            BTextEditor bTextEditor = new BTextEditor(ThrowableUtil.dumpToString((Throwable)this.e), false);
            BTextEditorPane bTextEditorPane = new BTextEditorPane(bTextEditor, 25, 80);
            BDialog.open((BWidget)this.getOwner(), (String)lex.getText("NavSideBar.details"), (Object)bTextEditorPane, (int)1);
            return null;
        }
    }

    class Close
    extends Command {
        public Close(BWidget bWidget) {
            super(bWidget, lex.getText("NavSideBar.closeTree"));
        }

        public BImage getIcon() {
            return closeIcon;
        }

        public CommandArtifact doInvoke() {
            NavWrapper navWrapper = (NavWrapper)BNavSideBar.this.openTrees.getList().getSelectedItem();
            navWrapper.bookmark.getParent().asComponent().remove((BComplex)navWrapper.bookmark);
            BNavSideBar.this.getOptions().save();
            BNavSideBar.this.openTrees.getList().removeItem((Object)navWrapper);
            BNavSideBar.this.hash.remove(navWrapper);
            BNavSideBar.this.openTrees.getList().setSelectedIndex(0);
            BNavSideBar.this.doUpdateTree();
            BookmarkEvents.fireBookmarkChanged();
            return null;
        }
    }

    class SyncTree
    extends Command {
        SyncTree(BWidget bWidget) {
            super(bWidget, UiLexicon.bajaui().module, "tree.sync");
        }

        public BImage getIcon() {
            return syncIcon;
        }

        public CommandArtifact doInvoke() {
            BNavSideBar.this.syncTree(true);
            return null;
        }
    }

    class NewTree
    extends Command {
        private int count = 1;

        public NewTree(BWidget bWidget) {
            super(bWidget, lex.getText("NavSideBar.newTree"));
        }

        public BImage getIcon() {
            return newTreeIcon;
        }

        public CommandArtifact doInvoke() {
            BBookmarkOptions bBookmarkOptions = BNavSideBar.this.getOptions();
            BBookmark bBookmark = BNavSideBar.this.makeRoot();
            bBookmark.setText(bBookmark.getText() + " (" + this.count++ + ")");
            BNavSideBar.this.getGoInto().add(null, (BValue)bBookmark);
            bBookmarkOptions.save();
            BNavSideBar.this.addTreeToList(bBookmark);
            BNavSideBar.this.openTrees.getList().setSelectedIndex(BNavSideBar.this.openTrees.getList().getItemCount() - 1);
            BNavSideBar.this.doUpdateTree();
            BookmarkEvents.fireBookmarkChanged();
            return null;
        }
    }
}

