/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.shell;

import com.tridium.ui.awt.AwtUiEnv;
import com.tridium.workbench.shell.BNiagaraWbFrame;
import com.tridium.workbench.shell.BSideBarPane;
import com.tridium.workbench.shell.BWbPane;
import com.tridium.workbench.shell.WbCommands;
import java.awt.Frame;
import java.awt.Rectangle;
import java.io.File;
import java.util.HashMap;
import javax.baja.gx.BRectGeom;
import javax.baja.gx.IRectGeom;
import javax.baja.sys.BDouble;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.workbench.BWbProfile;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XWriter;

public class WbState {
    static HashMap byProfile = new HashMap();
    static BRectGeom defBounds = BRectGeom.make((double)50.0, (double)50.0, (double)800.0, (double)600.0);
    final Type profile;
    final File file;
    BRectGeom bounds = defBounds;
    boolean maximized = false;
    double hsplitPos = 25.0;
    String sideBarPickle = "";
    boolean showSideBar = true;
    boolean showConsole = false;
    boolean pathBarUsesNavFile = true;

    public static WbState get(BWbProfile bWbProfile) {
        Type type = bWbProfile.getType();
        WbState wbState = (WbState)byProfile.get(type);
        if (wbState == null) {
            wbState = new WbState(type);
            if (wbState.file.exists()) {
                wbState.loadFromFile();
            } else {
                wbState.loadFromProfile(bWbProfile);
            }
            byProfile.put(type, wbState);
        }
        return wbState;
    }

    public static void load(BNiagaraWbFrame bNiagaraWbFrame) {
        WbState wbState = WbState.get(bNiagaraWbFrame.getProfile());
        wbState.loadToShell(bNiagaraWbFrame);
    }

    public static void save(BNiagaraWbFrame bNiagaraWbFrame) {
        WbState wbState = WbState.get(bNiagaraWbFrame.getProfile());
        wbState.saveFromShell(bNiagaraWbFrame);
        wbState.saveToFile();
    }

    public WbState(Type type) {
        this.profile = type;
        this.file = new File(Sys.getUserHome(), "wb-" + type.getTypeName() + ".xml");
    }

    public void loadFromProfile(BWbProfile bWbProfile) {
        if (bWbProfile.hasSideBar()) {
            BSideBarPane bSideBarPane = new BSideBarPane();
            bSideBarPane.initFromProfile(bWbProfile);
            this.sideBarPickle = bSideBarPane.pickle();
        }
    }

    public void loadToShell(BNiagaraWbFrame bNiagaraWbFrame) {
        BWbPane bWbPane = bNiagaraWbFrame.pane;
        WbCommands wbCommands = bNiagaraWbFrame.commands;
        if (!this.maximized) {
            bNiagaraWbFrame.frame.setBounds((int)this.bounds.x, (int)this.bounds.y, (int)this.bounds.width, (int)this.bounds.height);
        } else {
            ((AwtUiEnv)AwtUiEnv.get()).setMaximized((Frame)((Object)bNiagaraWbFrame.frame), true);
            IRectGeom iRectGeom = ((AwtUiEnv)AwtUiEnv.get()).getDefaultScreenBounds();
            bNiagaraWbFrame.frame.setBounds((int)(iRectGeom.width() * 0.125), (int)(iRectGeom.height() * 0.125), (int)(iRectGeom.width() * 0.75), (int)(iRectGeom.height() * 0.75));
        }
        bWbPane.setSplitPosition(this.hsplitPos);
        if (bWbPane.sideBar != null) {
            bWbPane.sideBar.unpickle(this.sideBarPickle);
        }
        wbCommands.showSideBar.setSelected(this.showSideBar);
        wbCommands.console.setSelected(this.showConsole);
        wbCommands.pathBarUsesNavFile.setSelected(this.pathBarUsesNavFile);
    }

    public void saveFromShell(BNiagaraWbFrame bNiagaraWbFrame) {
        Rectangle rectangle = bNiagaraWbFrame.getFrameBounds();
        BWbPane bWbPane = bNiagaraWbFrame.pane;
        WbCommands wbCommands = bNiagaraWbFrame.commands;
        this.maximized = ((AwtUiEnv)AwtUiEnv.get()).isMaximized((Frame)((Object)bNiagaraWbFrame.frame));
        this.bounds = BRectGeom.make((double)rectangle.x, (double)rectangle.y, (double)rectangle.width, (double)rectangle.height);
        this.hsplitPos = bWbPane.getSplitPosition();
        this.sideBarPickle = bWbPane.sideBar == null ? "" : bWbPane.sideBar.pickle();
        this.showSideBar = wbCommands.showSideBar.isSelected();
        this.showConsole = wbCommands.console.isSelected();
        this.pathBarUsesNavFile = wbCommands.pathBarUsesNavFile.isSelected();
    }

    public void loadFromFile() {
        try {
            XElem xElem = XParser.make((File)this.file).parse();
            this.bounds = this.load(xElem, "bounds", this.bounds);
            this.maximized = this.load(xElem, "maximized", "false").equals("true");
            this.hsplitPos = this.load(xElem, "hsplitPos", this.hsplitPos);
            this.sideBarPickle = this.load(xElem, "sideBarPickle", this.sideBarPickle);
            this.showSideBar = this.load(xElem, "showSideBar", this.showSideBar);
            this.showConsole = this.load(xElem, "showConsole", this.showConsole);
            this.pathBarUsesNavFile = this.load(xElem, "pathBarUsesNavFile", this.pathBarUsesNavFile);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void saveToFile() {
        try {
            XWriter xWriter = new XWriter(this.file);
            xWriter.w((Object)"<WbState version='1.0' timestamp='").safe("" + Clock.time()).w((Object)"'>\n");
            this.save(xWriter, "profile", this.profile);
            this.save(xWriter, "bounds", this.bounds.encodeToString());
            this.save(xWriter, "maximized", this.maximized ? "true" : "false");
            this.save(xWriter, "hsplitPos", BDouble.encode((double)this.hsplitPos));
            this.save(xWriter, "sideBarPickle", this.sideBarPickle);
            this.save(xWriter, "showSideBar", "" + this.showSideBar);
            this.save(xWriter, "showConsole", "" + this.showConsole);
            this.save(xWriter, "pathBarUsesNavFile", "" + this.pathBarUsesNavFile);
            xWriter.w((Object)"</WbState>\n");
            xWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    String load(XElem xElem, String string, String string2) {
        XElem xElem2 = xElem.elem(string);
        if (xElem2 == null) {
            return string2;
        }
        return xElem2.get("value", string2);
    }

    boolean load(XElem xElem, String string, boolean bl) {
        return this.load(xElem, string, "" + bl).equals("true");
    }

    double load(XElem xElem, String string, double d) {
        return BDouble.decode((String)this.load(xElem, string, BDouble.encode((double)d)));
    }

    BRectGeom load(XElem xElem, String string, BRectGeom bRectGeom) {
        return BRectGeom.make((String)this.load(xElem, string, bRectGeom.encodeToString()));
    }

    void save(XWriter xWriter, String string, Object object) {
        xWriter.w((Object)"  <").w((Object)string).w((Object)" value='").safe(object.toString()).w((Object)"'/>\n");
    }
}

