/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.shell;

import com.tridium.sys.Nre;
import com.tridium.workbench.shell.BWbApplication;
import java.io.File;
import java.util.Comparator;
import java.util.HashMap;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.log.Log;
import javax.baja.nre.util.Array;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.options.BOptions;
import javax.baja.ui.options.BUserOptions;
import javax.baja.ui.options.OptionsManager;
import javax.baja.workbench.BWbProfile;
import javax.baja.workbench.BWbShell;

public class WbOptionsManager
extends Thread
implements OptionsManager {
    static final Log log = Log.getLog((String)"sys.options");
    private BWbApplication app;
    private HashMap keyToOptions = new HashMap();
    private HashMap optionsToKey = new HashMap();
    private HashMap toSave = new HashMap();

    WbOptionsManager(BWbApplication bWbApplication) {
        super(Nre.mainThreadGroup, "Ui:OptionsManager");
        this.setDaemon(true);
        this.app = bWbApplication;
        this.start();
    }

    public BOptions[] getLoaded() {
        return this.keyToOptions.values().toArray(new BOptions[this.keyToOptions.size()]);
    }

    public String toKey(BOptions bOptions) {
        String string = (String)this.optionsToKey.get(bOptions);
        if (string == null) {
            throw new IllegalStateException("Options not loaded " + bOptions.getType());
        }
        return string;
    }

    public BOptions load(TypeInfo typeInfo) {
        return this.load(typeInfo.getTypeSpec().getResolvedType());
    }

    public BOptions load(Type type) {
        return this.load(type.toString(), type);
    }

    public synchronized BOptions load(String string, Type type) {
        if (type.is(BUserOptions.TYPE) && !string.equals(type.toString())) {
            throw new IllegalArgumentException("Key must be type.toString() for UserOptions: " + type);
        }
        BOptions bOptions = (BOptions)this.keyToOptions.get(string);
        if (bOptions == null) {
            try {
                File file = WbOptionsManager.keyToFile(string);
                if (file.exists()) {
                    if (log.isTraceOn()) {
                        log.trace("Load \"" + string + "\" from " + file.getName());
                    }
                    ValueDocDecoder valueDocDecoder = new ValueDocDecoder(file);
                    bOptions = (BOptions)valueDocDecoder.decodeDocument();
                }
            }
            catch (Exception exception) {
                log.error("Cannot load options \"" + string + "\": " + exception);
            }
            if (bOptions == null) {
                if (log.isTraceOn()) {
                    log.trace("Load \"" + string + "\" new");
                }
                bOptions = (BOptions)type.getInstance();
            }
            this.keyToOptions.put(string, bOptions);
            this.optionsToKey.put(bOptions, string);
        }
        return bOptions;
    }

    public void save(BOptions bOptions) {
        this.saveAsync(bOptions);
    }

    public void saveAll() {
        BOptions[] bOptionsArray = this.getLoaded();
        for (int i = 0; i < bOptionsArray.length; ++i) {
            this.saveSync(bOptionsArray[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAsync(BOptions bOptions) {
        HashMap hashMap = this.toSave;
        synchronized (hashMap) {
            this.toSave.put(bOptions.getName(), bOptions);
        }
    }

    public void saveSync(BOptions bOptions) {
        try {
            String string = this.toKey(bOptions);
            File file = WbOptionsManager.keyToFile(string);
            if (log.isTraceOn()) {
                log.trace("Save \"" + string + "\" to " + file.getName());
            }
            ValueDocEncoder valueDocEncoder = new ValueDocEncoder(file);
            valueDocEncoder.encodeDocument((BValue)bOptions);
            valueDocEncoder.close();
        }
        catch (Exception exception) {
            log.error("Cannot save options", (Throwable)exception);
        }
    }

    public static File keyToFile(String string) {
        File file = new File(Sys.getUserHome(), "options");
        if (!file.exists()) {
            file.mkdirs();
        }
        string = string.replace(':', '-');
        return new File(file, string + ".options");
    }

    public static TypeInfo[] getAllUserOptions(BWbShell bWbShell) {
        int n;
        Array array = new Array((Object[])Sys.getRegistry().getConcreteTypes(BUserOptions.TYPE.getTypeInfo()));
        BWbProfile bWbProfile = bWbShell.getProfile();
        for (n = array.size() - 1; n >= 0; --n) {
            if (bWbProfile.hasUserOptions((TypeInfo)array.get(n))) continue;
            array.remove(n);
        }
        array.sort(new Comparator(){

            public int compare(Object object, Object object2) {
                TypeInfo typeInfo = (TypeInfo)object;
                TypeInfo typeInfo2 = (TypeInfo)object2;
                return typeInfo.getDisplayName(null).compareTo(typeInfo2.getDisplayName(null));
            }
        });
        n = -1;
        for (int i = 0; i < array.size(); ++i) {
            if (!array.get(i).toString().equals("workbench:GeneralOptions")) continue;
            n = i;
            break;
        }
        if (n != -1) {
            Object object = array.remove(n);
            array.add(0, object);
        }
        return (TypeInfo[])array.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        while (true) {
            try {
                block6: while (true) {
                    Thread.sleep(5000L);
                    var2_3 = this.toSave;
                    synchronized (var2_3) {
                        if (this.toSave.size() == 0) {
                            continue;
                        }
                        var1_1 = this.toSave.values().toArray(new BOptions[this.toSave.size()]);
                        this.toSave.clear();
                    }
                    var2_4 = 0;
                    while (true) {
                        if (var2_4 < var1_1.length) ** break;
                        continue block6;
                        this.saveSync(var1_1[var2_4]);
                        ++var2_4;
                    }
                    break;
                }
            }
            catch (Throwable var1_2) {
                var1_2.printStackTrace();
                continue;
            }
            break;
        }
    }
}

