/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.shell;

import com.tridium.fox.session.Fox;
import com.tridium.sys.Nre;
import com.tridium.sys.NreLib;
import com.tridium.sys.registry.NAgentInfo;
import com.tridium.ui.UiEnv;
import com.tridium.ui.awt.AwtShellManager;
import com.tridium.ui.awt.AwtUiEnv;
import com.tridium.ui.theme.custom.CustomThemeModuleManager;
import com.tridium.util.CommandLineArguments;
import com.tridium.workbench.job.JobMonitor;
import com.tridium.workbench.nav.BSessionAgent;
import com.tridium.workbench.nav.NavMonitor;
import com.tridium.workbench.service.BWbServiceManager;
import com.tridium.workbench.shell.BGeneralOptions;
import com.tridium.workbench.shell.BNiagaraWbFrame;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.shell.BSaveAllDialog;
import com.tridium.workbench.shell.BViewTab;
import com.tridium.workbench.shell.BWbApplication;
import com.tridium.workbench.shell.WbState;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.file.BFileSystem;
import javax.baja.gx.BImage;
import javax.baja.gx.BPoint;
import javax.baja.gx.BSize;
import javax.baja.gx.IRectGeom;
import javax.baja.license.Feature;
import javax.baja.license.LicenseDatabaseException;
import javax.baja.license.LicenseException;
import javax.baja.log.Log;
import javax.baja.naming.BHost;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nav.NavEvent;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.BICredentials;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BModule;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeNotFoundException;
import javax.baja.ui.BDialog;
import javax.baja.ui.BFrame;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.options.BOptions;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.PatternFilter;
import javax.baja.workbench.BWbProfile;
import javax.baja.workbench.BWbShell;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class WbMain {
    public static BICredentials kioskCredentials;
    public static final AgentFilter licenseFilter;
    private static String defaultBrandTitle;
    private static String defaultBrandSplash;
    private static String defaultBrandIcon;
    public static String brandTitle;
    public static String brandSplash;
    public static String brandIcon;
    public static Type defaultProfileType;
    static boolean licenseAdmin;
    static String licenseName;
    static String licenseCompany;
    static String licenseEmail;
    static String licenseInfo;
    private static int frameCount;
    private static Log logger;

    public static boolean isKiosk() {
        return Sys.getStation() != null;
    }

    public static boolean isKioskAccessible(BOrd bOrd) {
        if (!WbMain.isKiosk()) {
            return true;
        }
        String string = bOrd.toString();
        return !string.startsWith("local:") || string.startsWith("local:|fox:") || string.startsWith("local:|foxs:") || string.startsWith("local:|platform:") || string.startsWith("local:|platformssl:") || string.startsWith("local:|sox:");
    }

    public static void open(BWbShell bWbShell, BOrd bOrd, String string) {
        if (string.equals("_help")) {
            WbMain.openHelp(bWbShell, bOrd);
        } else if (string.equals("_main")) {
            WbMain.openReuse(bWbShell, bOrd, defaultProfileType);
        } else {
            bWbShell.hyperlink(bOrd);
        }
    }

    public static void openHelp(BWbShell bWbShell, BOrd bOrd) {
        if (WbMain.isKiosk()) {
            bWbShell.hyperlink(bOrd);
            return;
        }
        Type type = bWbShell.getProfile().getType();
        try {
            type = Sys.getType((String)"help:HelpProfile");
        }
        catch (Exception exception) {
            System.out.println("WARNING:  Missing help:HelpProfile");
        }
        WbMain.openReuse(bWbShell, bOrd, type);
    }

    public static void openReuse(BWbShell bWbShell, BOrd bOrd, Type type) {
        AwtShellManager awtShellManager = (AwtShellManager)bWbShell.widgetSupport(null);
        awtShellManager.clearTempFocus();
        BWidgetShell[] bWidgetShellArray = BWidget.getApplication().getShells();
        for (int i = 0; i < bWidgetShellArray.length; ++i) {
            BWbShell bWbShell2;
            if (!(bWidgetShellArray[i] instanceof BWbShell) || !(bWbShell2 = (BWbShell)bWidgetShellArray[i]).getProfile().getType().is(type)) continue;
            bWbShell2.hyperlink(bOrd);
            awtShellManager = (AwtShellManager)bWbShell2.widgetSupport(null);
            Frame frame = (Frame)awtShellManager.getWindow();
            ((AwtUiEnv)AwtUiEnv.get()).setIconified(frame, false);
            frame.toFront();
            return;
        }
        BNiagaraWbFrame bNiagaraWbFrame = null;
        if (bWbShell instanceof BNiagaraWbFrame) {
            bNiagaraWbFrame = (BNiagaraWbFrame)bWbShell;
        }
        WbMain.openFrame(bNiagaraWbFrame, bOrd, type);
    }

    public static BNiagaraWbFrame openFrame(BNiagaraWbFrame bNiagaraWbFrame, BOrd bOrd, Type type) {
        return WbMain.openFrame(bNiagaraWbFrame, BOrdList.make((BOrd)bOrd), type, null, null);
    }

    public static BNiagaraWbFrame openFrame(BNiagaraWbFrame bNiagaraWbFrame, BOrdList bOrdList, Type type) {
        return WbMain.openFrame(bNiagaraWbFrame, bOrdList, type, null, null);
    }

    public static BNiagaraWbFrame openFrame(BNiagaraWbFrame bNiagaraWbFrame, BOrd bOrd, Type type, BPoint bPoint, BSize bSize) {
        return WbMain.openFrame(bNiagaraWbFrame, BOrdList.make((BOrd)bOrd), type, bPoint, bSize);
    }

    public static BNiagaraWbFrame openFrame(BNiagaraWbFrame bNiagaraWbFrame, BOrdList bOrdList, Type type, BPoint bPoint, BSize bSize) {
        Object object;
        BNiagaraWbFrame bNiagaraWbFrame2 = new BNiagaraWbFrame(type);
        if (bNiagaraWbFrame != null) {
            object = (AwtShellManager)bNiagaraWbFrame.widgetSupport(null);
            object.clearTempFocus();
        }
        if (bNiagaraWbFrame != null) {
            WbState.save(bNiagaraWbFrame);
        }
        WbState.load(bNiagaraWbFrame2);
        if (bPoint != null && bSize != null) {
            bNiagaraWbFrame2.frame.setBounds((int)bPoint.x(), (int)bPoint.y(), (int)bSize.width(), (int)bSize.height());
        } else if (bNiagaraWbFrame != null) {
            object = bNiagaraWbFrame.frame.getBounds();
            Rectangle rectangle = bNiagaraWbFrame2.frame.getBounds();
            if (object.x == rectangle.x && object.y == rectangle.y) {
                bNiagaraWbFrame2.frame.setBounds(rectangle.x + 15, rectangle.y + 15, rectangle.width, rectangle.height);
            }
        }
        if (WbMain.isKiosk()) {
            UiEnv.get().setKiosk((BWidgetShell)bNiagaraWbFrame2);
        }
        WbMain.validateBounds(bNiagaraWbFrame2);
        ++frameCount;
        if (bOrdList == null) {
            bOrdList = BOrdList.make((BOrd)bNiagaraWbFrame2.profile.getStartOrd());
        }
        bNiagaraWbFrame2.hyperlink(bOrdList.get(0));
        int n = 0;
        for (int i = 1; i < bOrdList.size(); ++i) {
            if (bOrdList.get(i).toString().startsWith("tab:")) {
                n = Integer.parseInt(bOrdList.get(i).toString().substring(4));
                continue;
            }
            bNiagaraWbFrame2.pane.views.addTab();
            bNiagaraWbFrame2.hyperlink(bOrdList.get(i));
        }
        BViewTab[] bViewTabArray = bNiagaraWbFrame2.pane.views.getTabs();
        if (n < bViewTabArray.length && n > 0) {
            bNiagaraWbFrame2.pane.views.selectLabelPane(bViewTabArray[n]);
        }
        bNiagaraWbFrame2.open();
        bNiagaraWbFrame2.frame.toFront();
        return bNiagaraWbFrame2;
    }

    private static void validateBounds(BNiagaraWbFrame bNiagaraWbFrame) {
        Rectangle rectangle = bNiagaraWbFrame.frame.getBounds();
        IRectGeom iRectGeom = UiEnv.get().getScreenBounds((BWidget)bNiagaraWbFrame);
        if ((double)rectangle.x - iRectGeom.x() > iRectGeom.width() || (double)rectangle.x - iRectGeom.x() + (double)rectangle.width > iRectGeom.width()) {
            rectangle.x = (int)iRectGeom.x() + (int)iRectGeom.width() - rectangle.width - 10;
        }
        if (rectangle.x < 0) {
            rectangle.x = 10;
            rectangle.width = Math.min(rectangle.width, (int)iRectGeom.width() - 20);
        }
        if ((double)rectangle.y - iRectGeom.y() > iRectGeom.height() || (double)rectangle.y - iRectGeom.y() + (double)rectangle.height > iRectGeom.height()) {
            rectangle.y = (int)iRectGeom.y() + (int)iRectGeom.height() - rectangle.height - 10;
        }
        if ((double)rectangle.y < iRectGeom.y()) {
            rectangle.y = 10;
            rectangle.height = Math.min(rectangle.height, (int)iRectGeom.height() - 20);
        }
        bNiagaraWbFrame.frame.setBounds(rectangle);
    }

    public static void closeFrame(BNiagaraWbFrame bNiagaraWbFrame) {
        if (frameCount == 1 && Sys.getStation() != null) {
            if (bNiagaraWbFrame.getProfile().getType() == defaultProfileType) {
                return;
            }
            if (!bNiagaraWbFrame.confirmClose()) {
                return;
            }
            bNiagaraWbFrame.close();
            --frameCount;
            WbMain.openFrame(null, (BOrdList)null, defaultProfileType);
            return;
        }
        WbState.save(bNiagaraWbFrame);
        if (frameCount <= 1) {
            WbMain.exit(bNiagaraWbFrame);
            --frameCount;
        } else {
            if (!bNiagaraWbFrame.confirmClose()) {
                return;
            }
            bNiagaraWbFrame.close();
            --frameCount;
        }
    }

    public static void exit(BNiagaraWbFrame bNiagaraWbFrame) {
        BWbApplication bWbApplication = (BWbApplication)BWidget.getApplication();
        try {
            String string = UiLexicon.bajaui().getText("saveBeforeExit");
            int n = BSaveAllDialog.saveAll((BWidget)bNiagaraWbFrame, string);
            if (n == 2) {
                return;
            }
            BWidgetShell[] bWidgetShellArray = bWbApplication.getShells();
            for (int i = 0; i < bWidgetShellArray.length; ++i) {
                if (!(bWidgetShellArray[i] instanceof BNiagaraWbFrame)) continue;
                BNiagaraWbFrame bNiagaraWbFrame2 = (BNiagaraWbFrame)bWidgetShellArray[i];
                bNiagaraWbFrame2.shutdownShell();
            }
            BWbServiceManager.make().shutdown();
            if (bNiagaraWbFrame != null) {
                WbState.save(bNiagaraWbFrame);
            }
            BNiagaraWbShell.history.save();
            WbMain.saveNavTree();
            WbMain.saveOptions();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (!bWbApplication.isApplet()) {
            System.exit(0);
        }
    }

    public static void initApplet() {
        if (frameCount <= 0) {
            frameCount = 1;
        }
    }

    public static void loadOptions() {
        BGeneralOptions bGeneralOptions = BGeneralOptions.make();
        bGeneralOptions.apply();
        CustomThemeModuleManager.installFromEnum((BDynamicEnum)bGeneralOptions.getActiveTheme());
    }

    public static void saveOptions() {
        BOptions.getOptionsManager().saveAll();
    }

    public static void loadBrand() {
        File file = new File(Sys.getBajaHome(), "lib" + File.separator + "brand.properties");
        try {
            Properties properties = new Properties();
            FileInputStream fileInputStream = new FileInputStream(file);
            properties.load(fileInputStream);
            fileInputStream.close();
            brandTitle = properties.getProperty("workbench.title");
            brandSplash = properties.getProperty("workbench.splash");
            brandIcon = properties.getProperty("workbench.icon");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (brandTitle == null) {
            brandTitle = defaultBrandTitle;
        }
        if (brandSplash == null) {
            brandSplash = defaultBrandSplash;
        }
        if (brandIcon == null) {
            brandIcon = defaultBrandIcon;
        }
    }

    public static void loadNavTree() {
        try {
            File file = new File(Sys.getUserHome(), "navTree.xml");
            if (!file.exists()) {
                return;
            }
            XElem xElem = XParser.make((File)file).parse();
            XElem[] xElemArray = xElem.elems("host");
            for (int i = 0; i < xElemArray.length; ++i) {
                XElem xElem2 = xElemArray[i];
                BOrd bOrd = BOrd.make((String)xElem2.get("ord"));
                BHost bHost = (BHost)bOrd.get();
                XElem[] xElemArray2 = xElem2.elems("session");
                for (int j = 0; j < xElemArray2.length; ++j) {
                    XElem xElem3 = xElemArray2[j];
                    String string = xElem3.get("agent");
                    try {
                        Type type = Sys.getType((String)string);
                        if (type == null) continue;
                        BSessionAgent bSessionAgent = (BSessionAgent)type.getInstance();
                        bSessionAgent.unpickle(bHost, xElem3);
                        continue;
                    }
                    catch (ModuleNotFoundException moduleNotFoundException) {
                        logger.warning("Missing Module for session agent: " + string);
                        continue;
                    }
                    catch (TypeNotFoundException typeNotFoundException) {
                        logger.warning("Missing Type for session agent: " + string);
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void saveNavTree() {
        try {
            XElem xElem = new XElem("navTree");
            BHost[] bHostArray = BHost.getAllHosts();
            for (int i = 0; i < bHostArray.length; ++i) {
                BHost bHost = bHostArray[i];
                XElem xElem2 = new XElem("host");
                xElem.addContent((XContent)xElem2);
                xElem2.addAttr("ord", "" + bHost.getAbsoluteOrd());
                BISession[] bISessionArray = bHost.getChildSessions();
                for (int j = 0; j < bISessionArray.length; ++j) {
                    BISession bISession = bISessionArray[j];
                    XElem xElem3 = new XElem("session");
                    xElem2.addContent((XContent)xElem3);
                    BSessionAgent bSessionAgent = BSessionAgent.makeFor(bISession);
                    if (bSessionAgent == null) continue;
                    xElem3.addAttr("agent", bSessionAgent.getType().toString());
                    bSessionAgent.pickle(bISession, xElem3);
                }
            }
            File file = new File(Sys.getUserHome(), "navTree.xml");
            xElem.write(file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static boolean isRemoved(NavEvent navEvent, BOrd bOrd) {
        if (navEvent.getId() != 2 && navEvent.getId() != 5) {
            return false;
        }
        if (bOrd == null) {
            return false;
        }
        String string = bOrd.toString();
        String string2 = navEvent.getOldChildOrd().toString();
        return (string = TextUtil.toLowerCase((String)string)).equals(string2 = TextUtil.toLowerCase((String)string2)) || string.startsWith(string2 + "/") || string.startsWith(string2 + "|");
    }

    public static boolean getLicenseAdmin() {
        return licenseAdmin;
    }

    public static String getLicenseName() {
        return licenseName;
    }

    public static String getLicenseCompany() {
        return licenseCompany;
    }

    public static String getLicenseEmail() {
        return licenseEmail;
    }

    public static String getLicenseInfo() {
        return licenseInfo;
    }

    public static void checkWorkbenchLicense() {
        WbMain.checkLicense(true);
    }

    public static void checkLicense() {
        WbMain.checkLicense(false);
    }

    private static void checkLicense(boolean bl) {
        Throwable throwable = null;
        try {
            if (bl) {
                Sys.getLicenseManager().checkFeature("Tridium", "workbench");
                Sys.getLicenseManager().checkFeature("Tridium", "nre");
            } else {
                WbMain.doCheckLicense();
            }
            return;
        }
        catch (LicenseDatabaseException licenseDatabaseException) {
            licenseDatabaseException.printStackTrace();
            Nre.licenseManager.dump();
            throwable = licenseDatabaseException;
        }
        catch (LicenseException licenseException) {
            licenseException.printStackTrace();
            Nre.licenseManager.dump();
        }
        catch (Throwable throwable2) {
            throwable2.printStackTrace();
            throwable = throwable2;
        }
        if (throwable == null) {
            try {
                WbMain.getLicenseFromPortal();
                if (bl) {
                    Sys.getLicenseManager().checkFeature("Tridium", "workbench");
                    Sys.getLicenseManager().checkFeature("Tridium", "nre");
                } else {
                    WbMain.doCheckLicense();
                }
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throwable = exception;
            }
        }
        String string = NreLib.getHostId();
        String string2 = UiLexicon.bajaui().getText("dialog.error");
        String string3 = UiLexicon.bajaui().getText("license.error", new Object[]{string});
        BFrame bFrame = WbMain.makeLicenseFrame();
        bFrame.setContent((BWidget)new BLabel(defaultBrandTitle));
        bFrame.open();
        BDialog.error((BWidget)bFrame, (String)string2, (Object)string3, (Throwable)throwable);
        System.exit(0);
    }

    private static void getLicenseFromPortal() {
        try {
            BModule bModule = Sys.loadModule((String)"portalApi");
            Class clazz = bModule.loadClass("com.tridium.portal.wb.LicenseProcedure");
            Method method = clazz.getMethod("licenseMe", new Class[0]);
            method.invoke(null, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.getTargetException().printStackTrace();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static BFrame makeLicenseFrame() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = dimension.width;
        int n2 = dimension.height;
        int n3 = 10;
        int n4 = 10;
        BFrame bFrame = new BFrame(defaultBrandTitle);
        bFrame.setIconImage(BImage.make((String)defaultBrandIcon));
        bFrame.setScreenBounds(0.0, 0.0, (double)n3, (double)n4);
        bFrame.setBoundsCenteredOnScreen();
        return bFrame;
    }

    public static void doCheckLicense() throws Exception {
        Sys.getLicenseManager().checkFeature("Tridium", "nre");
        Feature feature = Sys.getLicenseManager().checkFeature("Tridium", "workbench");
        boolean bl = false;
        PatternFilter[] patternFilterArray = PatternFilter.parseList((String)feature.get("profiles", "*"), (String)";");
        for (int i = 0; i < patternFilterArray.length; ++i) {
            if (!patternFilterArray[i].accept(defaultProfileType.toString())) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw new LocalizableException("workbench", "profileNotLicensed", new Object[]{defaultProfileType});
        }
        licenseAdmin = feature.getb("admin", false);
        Feature feature2 = Sys.getLicenseManager().getFeature("Tridium", "about");
        licenseName = feature2.get("project");
        licenseCompany = feature2.get("owner");
        licenseInfo = licenseName != null && licenseCompany != null ? licenseName + ", " + licenseCompany : (licenseName != null ? licenseName : (licenseCompany != null ? licenseCompany : null));
    }

    public static PatternFilter[] getLicensedProfiles() {
        Feature feature = Sys.getLicenseManager().checkFeature("Tridium", "workbench");
        return PatternFilter.parseList((String)feature.get("profiles", "*"), (String)";");
    }

    public static void usage() {
        System.out.println("usage:");
        System.out.println("  wb [options] <ord>");
        System.out.println("parameters:");
        System.out.println("  ord              ; delimited list of initial ords to display");
        System.out.println("options:");
        System.out.println("  -profile:<type>  workbench:WbProfile to use");
        System.out.println("  -file:ord        initial file to display");
        System.out.println("  -locale:<x>      set the default locale (en_US)");
        System.out.println("  -@<option>       pass option to Java VM");
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        PatternFilter[] patternFilterArray;
        CommandLineArguments commandLineArguments = new CommandLineArguments(stringArray);
        if (commandLineArguments.hasHelpOption()) {
            WbMain.usage();
            return;
        }
        WbMain.checkWorkbenchLicense();
        String string = commandLineArguments.getOption("profile");
        if (string == null && (patternFilterArray = WbMain.getLicensedProfiles()).length == 1 && !patternFilterArray[0].hasWildChars()) {
            string = patternFilterArray[0].getPattern();
        }
        if (string != null) {
            try {
                defaultProfileType = Sys.getType((String)string);
                System.out.println("-- Default profile: " + string);
            }
            catch (Exception exception) {
                System.out.println("ERROR: Invalid profile: " + string);
                exception.printStackTrace();
            }
        }
        WbMain.checkLicense();
        patternFilterArray = new BOrdList[commandLineArguments.parameters.length];
        if (commandLineArguments.parameters.length > 0) {
            for (n = 0; n < commandLineArguments.parameters.length; ++n) {
                patternFilterArray[n] = BOrdList.make((String)commandLineArguments.parameters[n].replace(';', '\n'));
            }
        } else if (commandLineArguments.hasOption("file")) {
            patternFilterArray = new BOrdList[]{BOrdList.make((BOrd)BFileSystem.INSTANCE.localFileToOrd(new File(commandLineArguments.getOption("file"))))};
        }
        WbMain.boot();
        if (patternFilterArray.length > 0) {
            for (n = 0; n < patternFilterArray.length; ++n) {
                WbMain.openFrame(null, (BOrdList)patternFilterArray[n], defaultProfileType);
            }
        } else {
            WbMain.openFrame(null, (BOrdList)null, defaultProfileType);
        }
    }

    public static void boot() {
        if (!WbMain.isKiosk()) {
            WbMain.loadOptions();
            BNiagaraWbShell.history.load();
            WbMain.loadNavTree();
        }
        WbMain.loadBrand();
        Fox.hostName = Sys.getLocalHost().getHostName();
        Fox.hostAddress = Sys.getLocalHost().getHostAddress();
        Fox.appName = "Workbench";
        Fox.appVersion = "" + Sys.getBajaModule().getVendorVersion();
        JobMonitor.init();
        NavMonitor.init();
        BWbServiceManager.make().boot();
    }

    static {
        licenseFilter = new AgentFilter(){

            public boolean include(AgentInfo agentInfo) {
                if (licenseAdmin) {
                    return true;
                }
                return !NAgentInfo.isAdmin((AgentInfo)agentInfo);
            }
        };
        Spy.ROOT.add("workbench", (Spy)new Page());
        defaultBrandTitle = "Niagara Workbench";
        defaultBrandSplash = "module://workbench/com/tridium/workbench/media/splash_generic.png";
        defaultBrandIcon = "module://icons/x16/workbench.png";
        defaultProfileType = BWbProfile.TYPE;
        frameCount = 0;
        logger = Log.getLog((String)"com.tridium.workbench.shell");
    }

    static class Page
    extends Spy {
        Page() {
        }

        public void write(SpyWriter spyWriter) throws Exception {
            spyWriter.startProps("Workbench");
            spyWriter.prop((Object)"brandTitle", (Object)brandTitle);
            spyWriter.prop((Object)"brandSplash", (Object)brandSplash);
            spyWriter.prop((Object)"brandIcon", (Object)brandIcon);
            spyWriter.prop((Object)"defaultProfileType", (Object)defaultProfileType);
            spyWriter.prop((Object)"licenseAdmin", licenseAdmin);
            spyWriter.prop((Object)"licenseName", (Object)licenseName);
            spyWriter.prop((Object)"licenseCompany", (Object)licenseCompany);
            spyWriter.prop((Object)"licenseEmail", (Object)licenseEmail);
            spyWriter.prop((Object)"licenseInfo", (Object)licenseInfo);
            spyWriter.prop((Object)"frameCount", frameCount);
            spyWriter.endProps();
        }
    }
}

