/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.shell;

import com.tridium.workbench.shell.BNiagaraWbApplet;
import com.tridium.workbench.shell.BNiagaraWbShell;
import java.io.File;
import java.util.ArrayList;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.Path;
import javax.baja.naming.ViewQuery;
import javax.baja.sys.Sys;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XWriter;

public class WbHistory {
    public static final int MAX_HISTORY = 50;
    private Entry[] list = new Entry[50];
    private int count;
    private int current = -1;
    private ArrayList recent = new ArrayList();
    private BNiagaraWbShell shell;

    public WbHistory() {
    }

    public WbHistory(BNiagaraWbShell bNiagaraWbShell) {
        this.shell = bNiagaraWbShell;
    }

    public Entry append(BOrd bOrd) {
        Entry entry = new Entry(bOrd);
        for (int i = this.current + 1; i < this.count; ++i) {
            this.list[i] = null;
        }
        this.count = this.current + 1;
        if (this.count >= this.list.length) {
            this.count = this.list.length;
            System.arraycopy(this.list, 1, this.list, 0, this.count - 1);
            this.list[this.count - 1] = entry;
        } else {
            this.list[this.count++] = entry;
        }
        this.current = this.count - 1;
        this.recentAdd(entry);
        return entry;
    }

    public BOrd back() {
        if (this.current < 1) {
            return null;
        }
        return this.list[--this.current].ord;
    }

    public BOrd forward() {
        if (this.current >= this.count - 1) {
            return null;
        }
        return this.list[++this.current].ord;
    }

    public boolean isBackEnabled() {
        BNiagaraWbApplet bNiagaraWbApplet;
        if (this.shell != null && this.shell.isApplet() && (bNiagaraWbApplet = (BNiagaraWbApplet)this.shell).isAppletReloadOnHyperlink()) {
            return true;
        }
        return this.current >= 1;
    }

    public boolean isForwardEnabled() {
        BNiagaraWbApplet bNiagaraWbApplet;
        if (this.shell != null && this.shell.isApplet() && (bNiagaraWbApplet = (BNiagaraWbApplet)this.shell).isAppletReloadOnHyperlink()) {
            return true;
        }
        return this.current < this.count - 1;
    }

    private void dump(String string) {
        System.out.println("WbHistory " + string);
        for (int i = 0; i < this.count; ++i) {
            String string2 = this.current == i ? "->" : "  ";
            System.out.println(string2 + i + ": " + this.list[i]);
        }
    }

    Entry[] getBackHistory() {
        Entry[] entryArray = new Entry[this.current];
        for (int i = 0; i < this.current; ++i) {
            entryArray[this.current - i - 1] = this.list[i];
        }
        return entryArray;
    }

    Entry[] getForwardHistory() {
        Entry[] entryArray = new Entry[this.count - this.current - 1];
        for (int i = 0; i < this.count - this.current - 1; ++i) {
            entryArray[i] = this.list[this.current + i + 1];
        }
        return entryArray;
    }

    Entry getCurrent() {
        return this.list[this.current];
    }

    public int recentIndexOf(BOrd bOrd) {
        for (int i = 0; i < this.recent.size(); ++i) {
            if (!bOrd.equals((Object)((Entry)this.recent.get((int)i)).ord)) continue;
            return i;
        }
        return -1;
    }

    public void recentAdd(Entry entry) {
        int n = this.recentIndexOf(entry.ord);
        if (n < 0) {
            if (this.recent.size() >= 50) {
                this.recent.remove(this.recent.size() - 1);
            }
        } else {
            this.recent.remove(n);
        }
        this.recent.add(0, entry);
    }

    public void recentTouch(BOrd bOrd) {
        int n = this.recentIndexOf(bOrd);
        if (n >= 0) {
            Entry entry = (Entry)this.recent.get(n);
            this.recent.remove(n);
            this.recent.add(0, entry);
        }
    }

    Entry[] recentList() {
        return this.recent.toArray(new Entry[this.recent.size()]);
    }

    public void load() {
        try {
            File file = new File(Sys.getUserHome(), "recentOrds.xml");
            if (!file.exists()) {
                return;
            }
            XElem xElem = XParser.make((File)file).parse();
            XElem[] xElemArray = xElem.elems("entry");
            for (int i = 0; i < xElemArray.length; ++i) {
                XElem xElem2 = xElemArray[i];
                String string = xElem2.get("name");
                BOrd bOrd = BOrd.make((String)xElem2.get("ord"));
                BImage bImage = null;
                String string2 = xElem2.get("icon", null);
                if (string2 != null) {
                    bImage = BImage.make((String)string2);
                }
                this.recent.add(new Entry(string, bOrd, bImage));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void save() {
        try {
            File file = new File(Sys.getUserHome(), "recentOrds.xml");
            XWriter xWriter = new XWriter(file);
            xWriter.prolog();
            xWriter.w((Object)"<recentOrds>\n");
            for (int i = 0; i < this.recent.size(); ++i) {
                Entry entry = (Entry)this.recent.get(i);
                xWriter.w((Object)"  <entry").attr(" name", entry.name).attr(" ord", "" + entry.ord);
                if (entry.icon != null) {
                    xWriter.attr(" icon", entry.icon.encodeToString());
                }
                xWriter.w((Object)"/>\n");
            }
            xWriter.w((Object)"</recentOrds>\n");
            xWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static String toName(BOrd bOrd) {
        if (bOrd == null) {
            return "null";
        }
        try {
            String string;
            OrdQuery[] ordQueryArray = bOrd.parse();
            int n = ordQueryArray.length;
            int n2 = n - 1;
            OrdQuery ordQuery = ordQueryArray[n2];
            String string2 = null;
            if (ordQuery instanceof ViewQuery && n >= 2) {
                string = ((ViewQuery)ordQuery).getViewId();
                if (string != null) {
                    int n3 = string.indexOf(58);
                    string2 = n3 > 0 ? string.substring(n3 + 1) : string;
                }
                ordQuery = ordQueryArray[--n2];
            }
            string = null;
            if (ordQuery.isSession()) {
                string = BOrd.make((OrdQuery[])ordQueryArray, (int)0, (int)(n2 + 1)).toString();
            } else if (ordQuery instanceof Path) {
                Path path = (Path)ordQuery;
                string = path.depth() == 0 ? BOrd.make((OrdQuery[])ordQueryArray, (int)Math.max(0, n2 - 2), (int)(n2 + 1)).toString() : path.nameAt(path.depth() - 1);
            }
            if (string == null) {
                string = ordQuery.toString();
            }
            if (string2 != null) {
                string = string + " [" + string2 + "]";
            }
            return string;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return bOrd.toString();
        }
    }

    static class Entry {
        public String name;
        public BOrd ord;
        public BImage icon;
        public BOrd ordNoView;
        public String viewId;

        public Entry(String string, BOrd bOrd, BImage bImage) {
            this.name = string;
            this.ord = bOrd;
            this.icon = bImage;
        }

        public Entry(BOrd bOrd) {
            this.name = WbHistory.toName(bOrd);
            this.ord = bOrd;
        }
    }
}

