/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.shell;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.user.BUserChannel;
import com.tridium.gx.awt.ImageManager;
import com.tridium.util.BSessionInfo;
import com.tridium.util.ObjectUtil;
import com.tridium.workbench.auth.BCnxHandler;
import com.tridium.workbench.bookmark.BBookmarkMenu;
import com.tridium.workbench.file.BExportDialog;
import com.tridium.workbench.shell.BNiagaraWbApplet;
import com.tridium.workbench.shell.BNiagaraWbFrame;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.shell.BOptionsEditor;
import com.tridium.workbench.shell.BRecentList;
import com.tridium.workbench.shell.BRightClickButton;
import com.tridium.workbench.shell.BSaveAllDialog;
import com.tridium.workbench.shell.BStationFinder;
import com.tridium.workbench.shell.BViewTab;
import com.tridium.workbench.shell.BWbApplication;
import com.tridium.workbench.shell.NHyperlinkInfo;
import com.tridium.workbench.shell.OpenUtil;
import com.tridium.workbench.shell.WbHistory;
import com.tridium.workbench.shell.WbMain;
import com.tridium.workbench.util.BFileSearch;
import com.tridium.workbench.util.BGotoFile;
import com.tridium.workbench.util.BSessionInfoDialog;
import com.tridium.workbench.util.TypeInfoSpec;
import java.lang.reflect.Method;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.file.BSubSpaceFile;
import javax.baja.gx.BImage;
import javax.baja.naming.BISession;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.BSession;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BActionMenuItem;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BHyperlinkMode;
import javax.baja.ui.BMenu;
import javax.baja.ui.BMenuBar;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BSubMenuItem;
import javax.baja.ui.BToggleButton;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.CommandEvent;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.options.BMruTextDropDown;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.sidebar.BWbSideBar;
import javax.baja.workbench.tool.BWbNavNodeTool;
import javax.baja.workbench.tool.BWbTool;
import javax.baja.workbench.view.BWbView;

public class WbCommands
extends BNiagaraWbShell.Support {
    public final boolean isKiosk;
    public final BToggleButton rightClickButton;
    public final Command newWindow = new NewWindowCommand();
    public final Command newTab = new NewTabCommand();
    public final Command closeTab = new CloseTabCommand(null);
    public final Command closeOtherTabs = new CloseOtherTabsCommand(null);
    public final Command nextTab = new NextTabCommand();
    public final Command prevTab = new PrevTabCommand();
    public final Command save = new SaveCommand();
    public final Command saveAll = new SaveAllCommand();
    public final Command saveBog = new SaveBogCommand();
    public final Command open = new OpenMenuCommand();
    public final Command openOrd = new OpenOrdCommand();
    public final Command openFile = new OpenFileCommand();
    public final Command openDir = new OpenDirCommand();
    public final Command openQuery = new OpenQueryCommand();
    public final Command findStations = new FindStationsCommand();
    public final Command print = new PrintCommand();
    public final ExportCommand export = new ExportCommand();
    public final Command back = new BackCommand(null);
    public final Command forward = new ForwardCommand(null);
    public final Command upLevel = new UpLevelCommand(null);
    public final Command recentOrds = new RecentOrdsCommand();
    public final Command refresh = new RefreshCommand();
    public final Command refreshTabs = new RefreshTabsCommand();
    public final Command sessionInfo = new SessionInfoCommand();
    public final Command home = new HomeCommand();
    public final Command logoff = new LogoffCommand();
    public final Command close = new CloseCommand();
    public final Command exit = new ExitCommand();
    public final Command cut = new PluginCommand(0);
    public final Command copy = new PluginCommand(1);
    public final Command paste = new PluginCommand(2);
    public final Command pasteSpecial = new PluginCommand(11);
    public final Command duplicate = new PluginCommand(3);
    public final Command delete = new PluginCommand(4);
    public final Command rename = new PluginCommand(5);
    public BActionMenuItem undoMenu;
    public BActionMenuItem redoMenu;
    public BButton undoButton;
    public BButton redoButton;
    public final Command find = new PluginCommand(6);
    public final Command findNext = new PluginCommand(8);
    public final Command findPrev = new PluginCommand(7);
    public final Command replace = new PluginCommand(9);
    public final Command goTo = new PluginCommand(10);
    public final Command gotoFile = new GotoFileCommand();
    public final Command findFiles = new FindFilesCommand();
    public final Command replaceInFiles = new ReplaceInFilesCommand();
    public final Command consolePrev = new ConsolePrevCommand();
    public final Command consoleNext = new ConsoleNextCommand();
    public final Command consoleKill = new ConsoleKillCommand();
    public final Command options = new OptionsCommand();
    public final Command[] tools = this.buildToolCommands();
    public final Command sideBarMenu = new SideBarMenuCommand();
    public final ToggleCommand showSideBar = new ShowSideBarCommand();
    public final Command[] sideBars = this.buildSideBarCommands();
    public final Command activePlugin = new ActivePlugin();
    public final ConsoleGroup consoleGroup;
    public final ConsoleToggle hideConsole;
    public final ConsoleToggle console;
    public final ToggleCommand pathBarUsesNavFile = new PathBarUsesNavFileCommand();
    public final Command helpContents = new HelpContentsCommand();
    public final Command helpOnView = new HelpOnViewCommand();
    public final Command helpGuideOnTarget = new HelpGuideOnTargetCommand();
    public final Command helpBajadocOnTarget = new HelpBajadocOnTargetCommand();
    public final Command helpFindBajadoc = new HelpFindBajadocCommand();
    public final Command about = new AboutCommand();
    static /* synthetic */ Class class$javax$baja$ui$Command;
    static /* synthetic */ Class class$javax$baja$ui$BWidget;
    static /* synthetic */ Class class$java$lang$String;

    public WbCommands(BNiagaraWbShell bNiagaraWbShell) {
        super(bNiagaraWbShell);
        this.isKiosk = WbMain.isKiosk();
        this.rightClickButton = new BRightClickButton(bNiagaraWbShell);
        this.consoleGroup = new ConsoleGroup();
        this.hideConsole = new ConsoleToggle("commands.hideConsole");
        this.consoleGroup.add(this.hideConsole);
        this.console = new ConsoleToggle("commands.console");
        this.consoleGroup.add(this.console);
    }

    public BMenuBar makeMenuBar() {
        BBookmarkMenu bBookmarkMenu = new BBookmarkMenu();
        BMenuBar bMenuBar = new BMenuBar();
        bMenuBar.add("file", (BValue)this.buildFileMenu());
        bMenuBar.add("edit", (BValue)this.buildEditMenu());
        bMenuBar.add("search", (BValue)this.buildSearchMenu());
        bMenuBar.add("bookmarks", (BValue)bBookmarkMenu);
        bMenuBar.add("tools", (BValue)this.buildToolsMenu());
        bMenuBar.add("window", (BValue)this.buildWindowMenu());
        bMenuBar.add("help", (BValue)this.buildHelpMenu());
        return bMenuBar;
    }

    public BMenu makeOpenMenu() {
        BOrd bOrd = BOrd.make((String)"local:|fox:");
        BOrd bOrd2 = BOrd.make((String)"local:|foxs:");
        boolean bl = this.shell.profile.canHyperlink(bOrd) || this.shell.profile.canHyperlink(bOrd2);
        BMenu bMenu = UiLexicon.bajaui().buildMenu("menu.open.label");
        bMenu.add("openOrd", this.openOrd);
        bMenu.add("openFile", this.openFile);
        bMenu.add("openDir", this.openDir);
        if (bl) {
            bMenu.add("openQuery", this.openQuery);
        }
        bMenu.add("sep0", (BValue)new BSeparator());
        Command[] commandArray = BCnxHandler.getCnxCommands((BWidget)this.shell, null);
        for (int i = 0; i < commandArray.length; ++i) {
            bMenu.add(this.toSlotName(commandArray[i]), commandArray[i]);
        }
        if (bl) {
            bMenu.add("sep1", (BValue)new BSeparator());
            bMenu.add("findStations", this.findStations);
        }
        return bMenu;
    }

    private BMenu buildFileMenu() {
        BSubMenuItem bSubMenuItem = new BSubMenuItem(this.makeOpenMenu());
        bSubMenuItem.setText(UiLexicon.bajaui().getText("commands.open.label"));
        bSubMenuItem.setImage(BImage.make((String)"module://icons/x16/open.png"));
        BMenu bMenu = UiLexicon.bajaui().buildMenu("menu.file.label");
        bMenu.add("open", (BValue)bSubMenuItem);
        bMenu.add("sep0", (BValue)new BSeparator());
        if (!this.isKiosk) {
            bMenu.add("newWindow", this.newWindow);
        }
        bMenu.add("newTab", this.newTab);
        bMenu.add("closeTab", this.closeTab);
        bMenu.add("closeOtherTabs", this.closeOtherTabs);
        bMenu.add("nextTab", this.nextTab);
        bMenu.add("prevTab", this.prevTab);
        bMenu.add("sep1", (BValue)new BSeparator());
        bMenu.add("save", this.save);
        bMenu.add("saveAll", this.saveAll);
        bMenu.add("saveBog", this.saveBog);
        bMenu.add("sep2", (BValue)new BSeparator());
        bMenu.add("export", (Command)this.export);
        bMenu.add("sep3", (BValue)new BSeparator());
        bMenu.add("back", this.back);
        bMenu.add("forward", this.forward);
        bMenu.add("upLevel", this.upLevel);
        bMenu.add("sep4", (BValue)new BSeparator());
        bMenu.add("recentOrds", this.recentOrds);
        bMenu.add("home", this.home);
        bMenu.add("refresh", this.refresh);
        bMenu.add("refreshtabs", this.refreshTabs);
        bMenu.add("sessionInfo", this.sessionInfo);
        bMenu.add("sep6", (BValue)new BSeparator());
        bMenu.add("logoff", this.logoff);
        if (!this.isKiosk) {
            bMenu.add("close", this.close);
            bMenu.add("exit", this.exit);
        }
        return bMenu;
    }

    private BMenu buildEditMenu() {
        BMenu bMenu = UiLexicon.bajaui().buildMenu("menu.edit.label");
        bMenu.add("cut", this.cut);
        bMenu.add("copy", this.copy);
        bMenu.add("paste", this.paste);
        bMenu.add("pasteSpecial", this.pasteSpecial);
        bMenu.add("duplicate", this.duplicate);
        bMenu.add("delete", this.delete);
        bMenu.add("rename", this.rename);
        bMenu.add("sep2", (BValue)new BSeparator());
        bMenu.add("undo", this.shell.getUndoManager().getUndoCommand());
        bMenu.add("redo", this.shell.getUndoManager().getRedoCommand());
        this.undoMenu = (BActionMenuItem)bMenu.get("undo");
        this.redoMenu = (BActionMenuItem)bMenu.get("redo");
        return bMenu;
    }

    private BMenu buildSearchMenu() {
        BMenu bMenu = UiLexicon.bajaui().buildMenu("menu.search.label");
        bMenu.add("find", this.find);
        bMenu.add("findPrev", this.findNext);
        bMenu.add("findNext", this.findPrev);
        bMenu.add("replace", this.replace);
        bMenu.add("goto", this.goTo);
        bMenu.add("sep0", (BValue)new BSeparator());
        bMenu.add("gotoFile", this.gotoFile);
        bMenu.add("findFiles", this.findFiles);
        bMenu.add("replaceInFiles", this.replaceInFiles);
        bMenu.add("sep1", (BValue)new BSeparator());
        bMenu.add("consolePrev", this.consolePrev);
        bMenu.add("consoleNext", this.consoleNext);
        return bMenu;
    }

    private Command[] buildToolCommands() {
        Array array = new Array(class$javax$baja$ui$Command == null ? (class$javax$baja$ui$Command = WbCommands.class$("javax.baja.ui.Command")) : class$javax$baja$ui$Command);
        if (this.profile.hasTools()) {
            TypeInfo[] typeInfoArray = BWbTool.getInstalled();
            for (int i = 0; i < typeInfoArray.length; ++i) {
                if (!this.profile.hasTool(typeInfoArray[i])) continue;
                array.add((Object)new ToolCommand(typeInfoArray[i]));
            }
        }
        return (Command[])array.trim();
    }

    private BMenu buildToolsMenu() {
        BMenu bMenu = UiLexicon.bajaui().buildMenu("menu.tools.label");
        bMenu.add("options", this.options);
        if (this.tools.length > 0) {
            bMenu.add("sep", (BValue)new BSeparator());
            for (int i = 0; i < this.tools.length; ++i) {
                bMenu.add("t" + i, this.tools[i]);
            }
        }
        return bMenu;
    }

    private Command[] buildSideBarCommands() {
        Array array = new Array(class$javax$baja$ui$Command == null ? (class$javax$baja$ui$Command = WbCommands.class$("javax.baja.ui.Command")) : class$javax$baja$ui$Command);
        if (this.profile.hasSideBar()) {
            TypeInfo[] typeInfoArray = BWbSideBar.getInstalled();
            for (int i = 0; i < typeInfoArray.length; ++i) {
                if (!this.profile.hasSideBar(typeInfoArray[i])) continue;
                array.add((Object)new SideBarCommand(typeInfoArray[i]));
            }
        }
        return (Command[])array.trim();
    }

    public BMenu buildSideBarMenu() {
        BMenu bMenu = UiLexicon.bajaui().buildMenu("menu.sidebar.label");
        bMenu.add("show", (Command)this.showSideBar);
        if (this.sideBars.length > 0) {
            bMenu.add("sep0", (BValue)new BSeparator());
            for (int i = 0; i < this.sideBars.length; ++i) {
                bMenu.add("m" + i, this.sideBars[i]);
            }
        }
        return bMenu;
    }

    private BMenu buildWindowMenu() {
        BMenu bMenu = UiLexicon.bajaui().buildMenu("menu.window.label");
        if (this.profile.hasSideBar()) {
            bMenu.add("sidebars", (BValue)new BSubMenuItem(this.buildSideBarMenu()));
            bMenu.add("sep0", (BValue)new BSeparator());
        }
        bMenu.add("pathBarUsesNavFile", (Command)this.pathBarUsesNavFile);
        bMenu.add("activePlugin", this.activePlugin);
        bMenu.add("sep1", (BValue)new BSeparator());
        bMenu.add("hideConsole", (Command)this.hideConsole);
        bMenu.add("console", (Command)this.console);
        bMenu.add("consoleKill", this.consoleKill);
        return bMenu;
    }

    private BMenu buildHelpMenu() {
        BMenu bMenu = UiLexicon.bajaui().buildMenu("menu.help.label");
        bMenu.add("contents", this.helpContents);
        bMenu.add("sep0", (BValue)new BSeparator());
        bMenu.add("onView", this.helpOnView);
        bMenu.add("guideOnTarget", this.helpGuideOnTarget);
        bMenu.add("bajadocOnTarget", this.helpBajadocOnTarget);
        bMenu.add("sep1", (BValue)new BSeparator());
        bMenu.add("findBajadoc", this.helpFindBajadoc);
        bMenu.add("sep2", (BValue)new BSeparator());
        bMenu.add("about", this.about);
        return bMenu;
    }

    private String toSlotName(Command command) {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = TextUtil.split((String)command.getKeyBase(), (char)'.');
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (i == 0) {
                stringBuffer.append(string);
                continue;
            }
            stringBuffer.append(TextUtil.capitalize((String)string));
        }
        return stringBuffer.toString();
    }

    public BToolBar makeToolBar() {
        BToolBar bToolBar = new BToolBar();
        bToolBar.add("back", this.back).setMenuController((BAbstractButton.MenuController)new BackMenuController());
        bToolBar.add("forward", this.forward).setMenuController((BAbstractButton.MenuController)new ForwardMenuController());
        bToolBar.add("upLevel", this.upLevel).setMenuController((BAbstractButton.MenuController)new UpLevelMenuController());
        bToolBar.add("sep0", (BValue)new BSeparator(), null);
        if (this.profile.hasSideBar()) {
            bToolBar.add("sideBar", this.sideBarMenu).setMenuController((BAbstractButton.MenuController)new SideBarMenuController());
        }
        bToolBar.add("recentOrds", this.recentOrds);
        bToolBar.add("home", this.home);
        bToolBar.add("refresh", this.refresh);
        bToolBar.add("refreshTabs", this.refreshTabs);
        bToolBar.add("sessionInfo", this.sessionInfo);
        bToolBar.add("sep2", (BValue)new BSeparator(), null);
        bToolBar.add("open", this.open).setMenuController((BAbstractButton.MenuController)new OpenMenuController());
        bToolBar.add("save", this.save);
        bToolBar.add("saveBog", this.saveBog);
        bToolBar.add("export", (Command)this.export);
        bToolBar.add("sep3", (BValue)new BSeparator(), null);
        bToolBar.add("cut", this.cut);
        bToolBar.add("copy", this.copy);
        bToolBar.add("paste", this.paste);
        bToolBar.add("duplicate", this.duplicate);
        bToolBar.add("delete", this.delete);
        bToolBar.add("sep4", (BValue)new BSeparator(), null);
        bToolBar.add("undo", this.shell.getUndoManager().getUndoCommand());
        bToolBar.add("redo", this.shell.getUndoManager().getRedoCommand());
        this.undoButton = (BButton)bToolBar.get("undo");
        this.redoButton = (BButton)bToolBar.get("redo");
        return bToolBar;
    }

    void updateTab(BViewTab bViewTab) {
        this.back.setEnabled(bViewTab.history.isBackEnabled());
        this.forward.setEnabled(bViewTab.history.isForwardEnabled());
        this.upLevel.setEnabled(bViewTab.hasParent);
        this.updateView(bViewTab.view);
    }

    void updateView(BWbView bWbView) {
        boolean bl = bWbView != null;
        this.cut.setEnabled(bl && bWbView.isCommandEnabled(0));
        this.copy.setEnabled(bl && bWbView.isCommandEnabled(1));
        this.paste.setEnabled(bl && bWbView.isCommandEnabled(2));
        this.pasteSpecial.setEnabled(bl && bWbView.isCommandEnabled(11));
        this.duplicate.setEnabled(bl && bWbView.isCommandEnabled(3));
        this.delete.setEnabled(bl && bWbView.isCommandEnabled(4));
        this.rename.setEnabled(bl && bWbView.isCommandEnabled(5));
        this.find.setEnabled(bl && bWbView.isCommandEnabled(6));
        this.findNext.setEnabled(bl && bWbView.isCommandEnabled(8));
        this.findPrev.setEnabled(bl && bWbView.isCommandEnabled(7));
        this.replace.setEnabled(bl && bWbView.isCommandEnabled(9));
        this.goTo.setEnabled(bl && bWbView.isCommandEnabled(10));
        this.consoleKill.setEnabled(bl && this.shell.pane.console.inExec());
        this.helpOnView.setEnabled(bl);
        this.helpGuideOnTarget.setEnabled(bl);
        this.helpBajadocOnTarget.setEnabled(bl);
        boolean bl2 = false;
        try {
            BISession bISession = this.shell.getActiveView().getCurrentValueSession();
            if (bISession != null && !(bISession instanceof BLocalHost) && bISession.isConnected()) {
                bl2 = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sessionInfo.setEnabled(bl && bl2);
        this.save.setEnabled(bl && bWbView.isModified());
        this.updateSaveBog();
    }

    public void updateSaveBog() {
        BComponent bComponent;
        BComponentSpace bComponentSpace;
        BObject bObject;
        this.saveBog.setEnabled(false);
        if (this.shell.tab().view != null && (bObject = this.shell.tab().view.getCurrentValue()) instanceof BComponent && (bComponentSpace = (bComponent = (BComponent)bObject).getComponentSpace()) != null && bComponentSpace.getNavParent() instanceof BSubSpaceFile) {
            BSubSpaceFile bSubSpaceFile = (BSubSpaceFile)bComponentSpace.getNavParent();
            this.saveBog.setEnabled(bSubSpaceFile.isModified());
        }
    }

    CloseTabCommand makeCloseTab(BViewTab bViewTab) {
        return new CloseTabCommand(bViewTab);
    }

    CloseOtherTabsCommand makeCloseOtherTabs(BViewTab bViewTab) {
        return new CloseOtherTabsCommand(bViewTab);
    }

    public BackMenuController makeBackMenuController() {
        return new BackMenuController();
    }

    public ForwardMenuController makeForwardMenuController() {
        return new ForwardMenuController();
    }

    public static BOrd getAboutOrd() {
        return BOrd.make((String)"workbench:/help/about.html");
    }

    public BOrd getHomeOrd() {
        BOrd bOrd = WbCommands.getAboutOrd();
        try {
            BWbView bWbView = this.shell.getActiveView();
            BObject bObject = bWbView.getCurrentValue();
            BISession bISession = BOrd.toSession((BObject)bObject);
            if (bISession instanceof BFoxSession) {
                BFoxSession bFoxSession = (BFoxSession)bISession;
                BFoxClientConnection bFoxClientConnection = bFoxSession.getConnection();
                BUserChannel bUserChannel = bFoxClientConnection.getChannels().getUserChannel();
                bOrd = bUserChannel.getHomePage();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bOrd;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class AboutCommand
    extends WbCommand {
        AboutCommand() {
            super("commands.help.about");
        }

        public CommandArtifact doInvoke() {
            WbCommands.this.shell.hyperlink(BOrd.make((String)"workbench:/help/about.html"));
            return null;
        }
    }

    public class GotoFileCommand
    extends WbCommand {
        GotoFileCommand() {
            super("commands.gotoFile");
        }

        public CommandArtifact doInvoke() {
            BGotoFile.go(WbCommands.this.shell);
            return null;
        }
    }

    public class HelpFindBajadocCommand
    extends WbCommand {
        private Method helpSystemExists;
        private Method loadHelp;
        private Method findBajadocOrd;

        HelpFindBajadocCommand() {
            super("commands.help.findBajadoc");
        }

        public CommandArtifact doInvoke() {
            try {
                Class clazz = Sys.loadClass((String)"help", (String)"com.tridium.help.BajadocFinder");
                Class clazz2 = Sys.loadClass((String)"help", (String)"com.tridium.help.HelpSystem");
                Class clazz3 = Sys.loadClass((String)"help", (String)"com.tridium.help.ui.BHelpSideBar");
                this.helpSystemExists = clazz2.getMethod("exists", null);
                this.loadHelp = clazz3.getMethod("loadHelp", class$javax$baja$ui$BWidget == null ? (class$javax$baja$ui$BWidget = WbCommands.class$("javax.baja.ui.BWidget")) : class$javax$baja$ui$BWidget);
                this.findBajadocOrd = clazz.getMethod("findBajadocOrd", class$javax$baja$ui$BWidget == null ? (class$javax$baja$ui$BWidget = WbCommands.class$("javax.baja.ui.BWidget")) : class$javax$baja$ui$BWidget, class$java$lang$String == null ? (class$java$lang$String = WbCommands.class$("java.lang.String")) : class$java$lang$String);
                if (this.helpSystemExists()) {
                    this.find();
                } else {
                    this.loadHelp();
                    if (this.helpSystemExists()) {
                        this.find();
                    }
                }
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
            return null;
        }

        private void find() throws Exception {
            BMruTextDropDown bMruTextDropDown = new BMruTextDropDown("findBajadoc", 30);
            String string = WbCommands.this.shell.getSelectedText();
            if (string != null) {
                bMruTextDropDown.setText(string);
            }
            BEdgePane bEdgePane = new BEdgePane();
            bEdgePane.setTop((BWidget)bMruTextDropDown);
            int n = BDialog.open((BWidget)WbCommands.this.shell, (String)this.getLabel(), (Object)bEdgePane, (int)3, (BImage)BDialog.QUESTION_ICON);
            if (n != 1) {
                return;
            }
            String string2 = bMruTextDropDown.getTextAndSave();
            BOrd bOrd = this.findBajadocOrd(string2);
            if (bOrd != null) {
                WbMain.openHelp(WbCommands.this.shell, bOrd);
            } else {
                WbCommands.this.shell.showStatus("Not found: " + string2);
            }
        }

        private void loadHelp() throws Exception {
            this.loadHelp.invoke(null, new Object[]{WbCommands.this.shell});
        }

        private boolean helpSystemExists() throws Exception {
            return (Boolean)this.helpSystemExists.invoke(null, null);
        }

        private BOrd findBajadocOrd(String string) throws Exception {
            return (BOrd)this.findBajadocOrd.invoke(null, new Object[]{WbCommands.this.shell, string});
        }
    }

    public static class HelpCommand
    extends Command {
        BOrd ord;

        public HelpCommand(BWidget bWidget, Lexicon lexicon, String string, BOrd bOrd) {
            super(bWidget, lexicon, string);
            this.ord = bOrd;
        }

        public HelpCommand(BWidget bWidget, String string, BOrd bOrd) {
            this(bWidget, (Lexicon)UiLexicon.bajaui(), string, bOrd);
        }

        public CommandArtifact doInvoke() {
            BWidgetShell bWidgetShell = this.getShell();
            if (bWidgetShell instanceof BWbShell) {
                WbMain.openHelp((BWbShell)bWidgetShell, this.ord);
            }
            return null;
        }
    }

    public class HelpBajadocOnTargetCommand
    extends WbCommand {
        HelpBajadocOnTargetCommand() {
            super("commands.help.bajadocOnTarget");
        }

        public CommandArtifact doInvoke() {
            BWbView bWbView = WbCommands.this.shell.getActiveView();
            BObject bObject = bWbView.getCurrentValue();
            if (bObject != null) {
                BOrd bOrd = ObjectUtil.getReferenceHelpOrd((BObject)bObject);
                WbMain.openHelp(WbCommands.this.shell, bOrd);
            }
            return null;
        }
    }

    public class HelpGuideOnTargetCommand
    extends WbCommand {
        HelpGuideOnTargetCommand() {
            super("commands.help.guideOnTarget");
        }

        public CommandArtifact doInvoke() {
            BWbView bWbView = WbCommands.this.shell.getActiveView();
            BObject bObject = bWbView.getCurrentValue();
            if (bObject != null) {
                BOrd bOrd = ObjectUtil.getGuideHelpOrd((BObject)bObject);
                WbMain.openHelp(WbCommands.this.shell, bOrd);
            }
            return null;
        }
    }

    public class HelpOnViewCommand
    extends WbCommand {
        HelpOnViewCommand() {
            super("commands.help.onView");
        }

        public CommandArtifact doInvoke() {
            BWbView bWbView = WbCommands.this.shell.getActiveView();
            BOrd bOrd = ObjectUtil.getGuideHelpOrd((BObject)bWbView);
            WbMain.openHelp(WbCommands.this.shell, bOrd);
            return null;
        }
    }

    public class HelpContentsCommand
    extends WbCommand {
        HelpContentsCommand() {
            super("commands.help.contents");
        }

        public CommandArtifact doInvoke() {
            WbMain.openHelp(WbCommands.this.shell, BOrd.make((String)"workbench:/help/contents.html"));
            return null;
        }
    }

    public class PathBarUsesNavFileCommand
    extends WbToggleCommand {
        public PathBarUsesNavFileCommand() {
            super("commands.pathBarUsesNavFile");
            this.setSelected(true);
        }
    }

    public class ConsoleToggle
    extends WbToggleCommand {
        ConsoleToggle(String string) {
            super(string);
        }

        public CommandArtifact doInvoke() {
            if (this == WbCommands.this.console) {
                WbCommands.this.shell.pane.console.prime();
            }
            return null;
        }
    }

    public class ActivePlugin
    extends WbCommand {
        ActivePlugin() {
            super("commands.activePlugin");
        }

        public CommandArtifact doInvoke() {
            BWbView bWbView = WbCommands.this.shell.getActiveView();
            if (bWbView != null) {
                bWbView.prime();
            }
            return null;
        }
    }

    public class ConsoleKillCommand
    extends WbCommand {
        public ConsoleKillCommand() {
            super("commands.consoleKill");
        }

        public CommandArtifact doInvoke() {
            if (WbCommands.this.shell.pane != null) {
                WbCommands.this.shell.pane.console.kill();
            }
            return null;
        }
    }

    public class ConsoleGroup
    extends ToggleCommandGroup {
        protected void selected(ToggleCommand toggleCommand) {
            if (WbCommands.this.shell.pane != null) {
                WbCommands.this.shell.pane.setConsoleVisible(toggleCommand == WbCommands.this.console);
                if (toggleCommand == WbCommands.this.console) {
                    WbCommands.this.shell.pane.console.prime();
                } else {
                    WbCommands.this.activePlugin.invoke();
                }
            }
        }
    }

    public class SideBarCommand
    extends Command {
        TypeInfoSpec spec;

        SideBarCommand(TypeInfo typeInfo) {
            super((BWidget)WbCommands.this.shell, "SideBar");
            this.spec = new TypeInfoSpec(typeInfo);
            this.label = this.spec.label;
            this.icon = this.spec.icon;
        }

        public CommandArtifact doInvoke() {
            WbCommands.this.shell.pane.sideBar.open(this.spec);
            return null;
        }
    }

    public class ShowSideBarCommand
    extends WbToggleCommand {
        public ShowSideBarCommand() {
            super("commands.showSideBar");
        }

        public void setSelected(boolean bl) {
            super.setSelected(bl);
            WbCommands.this.shell.pane.setSideBarVisible(bl);
        }
    }

    public class SideBarMenuCommand
    extends WbToggleCommand {
        public SideBarMenuCommand() {
            super("commands.sideBarMenu");
        }

        public CommandArtifact doInvoke() {
            return null;
        }
    }

    public class SideBarMenuController
    implements BAbstractButton.MenuController {
        public boolean isMenuDistinct() {
            return false;
        }

        public BMenu getMenu(BAbstractButton bAbstractButton) {
            return WbCommands.this.buildSideBarMenu();
        }
    }

    public class ConsolePrevCommand
    extends WbCommand {
        public ConsolePrevCommand() {
            super("commands.consolePrev");
        }

        public CommandArtifact doInvoke() {
            WbCommands.this.shell.pane.console.prev();
            return null;
        }
    }

    public class ConsoleNextCommand
    extends WbCommand {
        public ConsoleNextCommand() {
            super("commands.consoleNext");
        }

        public CommandArtifact doInvoke() {
            WbCommands.this.shell.pane.console.next();
            return null;
        }
    }

    public class ReplaceInFilesCommand
    extends WbCommand {
        public ReplaceInFilesCommand() {
            super("commands.replaceInFiles");
        }

        public CommandArtifact doInvoke() {
            BFileSearch.replaceInFiles(WbCommands.this.shell);
            return null;
        }
    }

    public class FindFilesCommand
    extends WbCommand {
        public FindFilesCommand() {
            super("commands.findFiles");
        }

        public CommandArtifact doInvoke() {
            BFileSearch.findFiles(WbCommands.this.shell);
            return null;
        }
    }

    public class SaveBogCommand
    extends WbCommand {
        SaveBogCommand() {
            super("commands.saveBog");
        }

        public CommandArtifact doInvoke() throws Exception {
            if (WbCommands.this.shell.tab().view == null) {
                return null;
            }
            BComponent bComponent = (BComponent)WbCommands.this.shell.tab().view.getCurrentValue();
            if (bComponent == null) {
                return null;
            }
            BComponentSpace bComponentSpace = bComponent.getComponentSpace();
            if (bComponentSpace.getNavParent() instanceof BSubSpaceFile) {
                BSubSpaceFile bSubSpaceFile = (BSubSpaceFile)bComponentSpace.getNavParent();
                bSubSpaceFile.save();
                WbCommands.this.updateSaveBog();
            }
            return null;
        }
    }

    public class SaveCommand
    extends WbCommand {
        SaveCommand() {
            super("commands.save");
        }

        public CommandArtifact doInvoke() {
            WbCommands.this.shell.save(WbCommands.this.shell.tab().view);
            return null;
        }
    }

    public class ToolCommand
    extends Command {
        TypeInfoSpec spec;

        ToolCommand(TypeInfo typeInfo) {
            super((BWidget)WbCommands.this.shell, "Tool");
            this.spec = new TypeInfoSpec(typeInfo);
            this.label = this.spec.label;
            this.icon = this.spec.icon;
        }

        public CommandArtifact doInvoke() throws Exception {
            BWbTool bWbTool = this.spec.info.is(BWbNavNodeTool.TYPE) ? BWbNavNodeTool.make(this.spec.info.toString()) : (BWbTool)this.spec.info.getInstance();
            return bWbTool.invoke(WbCommands.this.shell);
        }
    }

    public class OptionsCommand
    extends WbCommand {
        OptionsCommand() {
            super("commands.options");
        }

        public CommandArtifact doInvoke() {
            BOptionsEditor.openInDialog(WbCommands.this.shell);
            return null;
        }
    }

    public class ExitCommand
    extends WbCommand {
        ExitCommand() {
            super("commands.exit");
        }

        public CommandArtifact doInvoke() {
            WbMain.exit((BNiagaraWbFrame)WbCommands.this.shell);
            return null;
        }
    }

    public class CloseCommand
    extends WbCommand {
        CloseCommand() {
            super("commands.close");
        }

        public CommandArtifact doInvoke() {
            WbMain.closeFrame((BNiagaraWbFrame)WbCommands.this.shell);
            return null;
        }
    }

    public class LogoffCommand
    extends WbCommand {
        LogoffCommand() {
            super("commands.logoff");
        }

        public CommandArtifact doInvoke() {
            BWbApplication.autoLogoff();
            return null;
        }
    }

    public class HomeCommand
    extends WbCommand {
        HomeCommand() {
            super("commands.home");
        }

        public CommandArtifact doInvoke() {
            WbCommands.this.shell.hyperlink(WbCommands.this.profile.getHomeOrd());
            return null;
        }
    }

    public class RefreshTabsCommand
    extends WbCommand {
        public RefreshTabsCommand() {
            super("commands.refreshtabs");
        }

        public CommandArtifact doInvoke(CommandEvent commandEvent) throws Exception {
            if (commandEvent.isControlDown()) {
                ImageManager.trimAll();
            }
            BViewTab[] bViewTabArray = WbCommands.this.shell.pane.views.getTabs();
            BViewTab bViewTab = WbCommands.this.shell.tab();
            int n = -1;
            for (int i = 0; i < bViewTabArray.length; ++i) {
                if (bViewTab == bViewTabArray[i]) {
                    n = i;
                }
                BOrd bOrd = bViewTabArray[i].getOrd();
                bViewTabArray[i].closeTab();
                WbCommands.this.shell.hyperlink(new HyperlinkInfo(bOrd, BHyperlinkMode.newTab));
            }
            bViewTabArray = WbCommands.this.shell.pane.views.getTabs();
            if (n > -1) {
                WbCommands.this.shell.pane.views.selectLabelPane(bViewTabArray[n]);
            }
            return null;
        }
    }

    public class SessionInfoCommand
    extends WbCommand {
        SessionInfoCommand() {
            super("commands.sessionInfo");
        }

        public CommandArtifact doInvoke(CommandEvent commandEvent) throws Exception {
            try {
                BSessionInfoDialog bSessionInfoDialog;
                BSession bSession;
                BSessionInfo bSessionInfo;
                BISession bISession = WbCommands.this.shell.getActiveView().getCurrentValueSession();
                if (bISession instanceof BSession && (bSessionInfo = (bSession = (BSession)bISession).getSessionInfo()) != null && (bSessionInfoDialog = this.getDialog(bSessionInfo)) != null) {
                    bSessionInfoDialog.show(bSessionInfo);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        private final BSessionInfoDialog getDialog(BSessionInfo bSessionInfo) {
            BSessionInfoDialog bSessionInfoDialog = null;
            AgentList agentList = Sys.getRegistry().getSpecificAgents(bSessionInfo.getType().getTypeInfo());
            if (agentList == null || agentList.size() == 0) {
                return null;
            }
            AgentInfo agentInfo = agentList.get(0);
            bSessionInfoDialog = (BSessionInfoDialog)agentInfo.getInstance();
            return bSessionInfoDialog;
        }
    }

    public class RefreshCommand
    extends WbCommand {
        RefreshCommand() {
            super("commands.refresh");
        }

        public CommandArtifact doInvoke(CommandEvent commandEvent) throws Exception {
            if (commandEvent.isControlDown()) {
                ImageManager.trimAll();
            }
            WbCommands.this.shell.hyperlink(new NHyperlinkInfo(WbCommands.this.shell.getActiveOrd(), BHyperlinkMode.replace, false));
            return null;
        }
    }

    public class RecentOrdsCommand
    extends WbCommand {
        RecentOrdsCommand() {
            super("commands.recentOrds");
        }

        public CommandArtifact doInvoke() throws Exception {
            WbHistory.Entry[] entryArray = BNiagaraWbShell.history.recentList();
            BRecentList bRecentList = new BRecentList();
            bRecentList.load(entryArray);
            int n = BDialog.open((BWidget)WbCommands.this.shell, (String)this.getLabel(), (Object)((Object)bRecentList), (int)3);
            if (n == 2) {
                return null;
            }
            HyperlinkInfo hyperlinkInfo = bRecentList.result();
            if (hyperlinkInfo == null) {
                return null;
            }
            WbCommands.this.shell.hyperlink(hyperlinkInfo);
            return null;
        }
    }

    public class UpLevelCommand
    extends WbCommand {
        BOrd ord;

        UpLevelCommand(BOrd bOrd) {
            super("commands.upLevel");
            this.ord = bOrd;
            if (bOrd != null) {
                this.label = WbHistory.toName(bOrd);
                this.icon = null;
                this.accelerator = null;
            }
        }

        public CommandArtifact doInvoke() throws Exception {
            BOrd bOrd = this.ord;
            if (bOrd == null) {
                bOrd = WbCommands.this.shell.tab().ord.getParent();
            }
            if (bOrd != null) {
                WbCommands.this.shell.hyperlink(bOrd);
            }
            return null;
        }
    }

    class UpLevelMenuController
    implements BAbstractButton.MenuController {
        UpLevelMenuController() {
        }

        public boolean isMenuDistinct() {
            return true;
        }

        public BMenu getMenu(BAbstractButton bAbstractButton) {
            BMenu bMenu = new BMenu();
            for (BOrd bOrd = WbCommands.this.shell.tab().ord.getParent(); bOrd != null; bOrd = bOrd.getParent()) {
                bMenu.add(null, (Command)new UpLevelCommand(bOrd));
            }
            return bMenu;
        }
    }

    public class ForwardCommand
    extends WbCommand {
        BOrd ord;

        ForwardCommand(WbHistory.Entry entry) {
            super("commands.forward");
            if (entry != null) {
                this.ord = entry.ord;
                this.label = entry.name;
                this.icon = entry.icon;
                this.accelerator = null;
            }
        }

        public CommandArtifact doInvoke() throws Exception {
            Object object;
            if (WbCommands.this.shell.isApplet() && ((BNiagaraWbApplet)((Object)(object = (BNiagaraWbApplet)WbCommands.this.shell))).isAppletReloadOnHyperlink()) {
                ((BNiagaraWbApplet)((Object)object)).browserForward();
                return null;
            }
            object = this.ord;
            if (object == null) {
                object = WbCommands.this.shell.tab().history.forward();
            } else {
                BOrd bOrd = WbCommands.this.shell.tab().history.forward();
                while (bOrd != null && bOrd != object) {
                    bOrd = WbCommands.this.shell.tab().history.forward();
                }
            }
            if (object != null) {
                WbCommands.this.shell.hyperlink(new NHyperlinkInfo((BOrd)object, BHyperlinkMode.replace, false));
            }
            return null;
        }
    }

    class ForwardMenuController
    implements BAbstractButton.MenuController {
        ForwardMenuController() {
        }

        public boolean isMenuDistinct() {
            return true;
        }

        public BMenu getMenu(BAbstractButton bAbstractButton) {
            BMenu bMenu = new BMenu();
            WbHistory.Entry[] entryArray = WbCommands.this.shell.tab().history.getForwardHistory();
            for (int i = 0; i < entryArray.length && i < 10; ++i) {
                bMenu.add("forward" + i, (Command)new ForwardCommand(entryArray[i]));
            }
            return bMenu;
        }
    }

    public class BackCommand
    extends WbCommand {
        BOrd ord;

        BackCommand(WbHistory.Entry entry) {
            super("commands.back");
            if (entry != null) {
                this.ord = entry.ord;
                this.label = entry.name;
                this.icon = entry.icon;
                this.accelerator = null;
            }
        }

        public CommandArtifact doInvoke() throws Exception {
            Object object;
            if (WbCommands.this.shell.isApplet() && ((BNiagaraWbApplet)((Object)(object = (BNiagaraWbApplet)WbCommands.this.shell))).isAppletReloadOnHyperlink()) {
                ((BNiagaraWbApplet)((Object)object)).browserBack();
                return null;
            }
            object = this.ord;
            if (object == null) {
                object = WbCommands.this.shell.tab().history.back();
            } else {
                BOrd bOrd = WbCommands.this.shell.tab().history.back();
                while (bOrd != null && bOrd != object) {
                    bOrd = WbCommands.this.shell.tab().history.back();
                }
            }
            if (object != null) {
                WbCommands.this.shell.hyperlink(new NHyperlinkInfo((BOrd)object, BHyperlinkMode.replace, false));
            }
            return null;
        }
    }

    class BackMenuController
    implements BAbstractButton.MenuController {
        BackMenuController() {
        }

        public boolean isMenuDistinct() {
            return true;
        }

        public BMenu getMenu(BAbstractButton bAbstractButton) {
            BMenu bMenu = new BMenu();
            WbHistory.Entry[] entryArray = WbCommands.this.shell.tab().history.getBackHistory();
            for (int i = 0; i < entryArray.length && i < 10; ++i) {
                bMenu.add("back" + i, (Command)new BackCommand(entryArray[i]));
            }
            return bMenu;
        }
    }

    class ExportCommand
    extends WbCommand {
        ExportCommand() {
            super("commands.export");
        }

        public CommandArtifact doInvoke() throws Exception {
            return BExportDialog.invoke(WbCommands.this.shell, false);
        }

        public void updateEnabled() {
            try {
                this.setEnabled(BExportDialog.hasExporters(WbCommands.this.shell, false));
            }
            catch (Exception exception) {
                this.setEnabled(false);
            }
        }
    }

    class PrintCommand
    extends WbCommand {
        PrintCommand() {
            super("commands.print");
        }

        public CommandArtifact doInvoke() throws Exception {
            return BExportDialog.invoke(WbCommands.this.shell, true);
        }
    }

    class SaveAllCommand
    extends WbCommand {
        SaveAllCommand() {
            super("commands.saveAll");
        }

        public CommandArtifact doInvoke() {
            BSaveAllDialog.saveAll((BWidget)WbCommands.this.shell, this.getLabel());
            return null;
        }
    }

    class PrevTabCommand
    extends WbCommand {
        PrevTabCommand() {
            super("commands.prevTab");
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            WbCommands.this.shell.pane.views.selectPrevTab();
            return null;
        }
    }

    class NextTabCommand
    extends WbCommand {
        NextTabCommand() {
            super("commands.nextTab");
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            WbCommands.this.shell.pane.views.selectNextTab();
            return null;
        }
    }

    class CloseOtherTabsCommand
    extends WbCommand {
        BViewTab tabToKeep;

        CloseOtherTabsCommand(BViewTab bViewTab) {
            super("commands.closeOtherTabs");
            this.tabToKeep = bViewTab;
            if (bViewTab != null) {
                this.accelerator = null;
            }
        }

        public CommandArtifact doInvoke() {
            BViewTab bViewTab = this.tabToKeep;
            if (bViewTab == null) {
                bViewTab = WbCommands.this.shell.tab();
            }
            BViewTab[] bViewTabArray = WbCommands.this.shell.pane.views.getTabs();
            for (int i = 0; i < bViewTabArray.length; ++i) {
                if (bViewTabArray[i] == bViewTab) continue;
                bViewTabArray[i].closeTab();
            }
            return null;
        }
    }

    class CloseTabCommand
    extends WbCommand {
        BViewTab tab;

        CloseTabCommand(BViewTab bViewTab) {
            super("commands.closeTab");
            this.tab = bViewTab;
            this.setEnabled(bViewTab != null);
            if (bViewTab != null) {
                this.accelerator = null;
            }
        }

        public CommandArtifact doInvoke() {
            BViewTab bViewTab = this.tab;
            if (bViewTab == null) {
                bViewTab = WbCommands.this.shell.tab();
            }
            bViewTab.closeTab();
            return null;
        }
    }

    class NewTabCommand
    extends WbCommand {
        NewTabCommand() {
            super("commands.newTab");
        }

        public CommandArtifact doInvoke() {
            WbCommands.this.shell.hyperlink(new HyperlinkInfo(WbCommands.this.shell.getActiveOrd(), BHyperlinkMode.newTab));
            return null;
        }
    }

    class NewWindowCommand
    extends WbCommand {
        NewWindowCommand() {
            super("commands.newWindow");
        }

        public CommandArtifact doInvoke() {
            WbCommands.this.shell.hyperlink(new HyperlinkInfo(WbCommands.this.shell.getActiveOrd(), BHyperlinkMode.newShell));
            return null;
        }
    }

    public class FindStationsCommand
    extends WbCommand {
        FindStationsCommand() {
            super("commands.findStations");
        }

        public CommandArtifact doInvoke() throws Exception {
            BStationFinder bStationFinder = new BStationFinder();
            int n = BDialog.open((BWidget)WbCommands.this.shell, (String)this.getLabel(), (Object)bStationFinder, (int)3);
            if (n == 2) {
                return null;
            }
            BOrd bOrd = bStationFinder.result();
            if (bOrd == null) {
                return null;
            }
            WbCommands.this.shell.hyperlink(bOrd);
            return null;
        }
    }

    public class OpenQueryCommand
    extends WbCommand {
        OpenQueryCommand() {
            super("commands.open.query");
        }

        public CommandArtifact doInvoke() throws Exception {
            OpenUtil.openQuery(WbCommands.this.shell);
            return null;
        }
    }

    public class OpenDirCommand
    extends WbCommand {
        OpenDirCommand() {
            super("commands.open.dir");
        }

        public CommandArtifact doInvoke() throws Exception {
            OpenUtil.openDir(WbCommands.this.shell);
            return null;
        }
    }

    public class OpenFileCommand
    extends WbCommand {
        OpenFileCommand() {
            super("commands.open.file");
        }

        public CommandArtifact doInvoke() throws Exception {
            OpenUtil.openFile(WbCommands.this.shell);
            return null;
        }
    }

    public class OpenOrdCommand
    extends WbCommand {
        OpenOrdCommand() {
            super("commands.open.ord");
        }

        public CommandArtifact doInvoke() throws Exception {
            OpenUtil.openOrd(WbCommands.this.shell);
            return null;
        }
    }

    public class OpenMenuCommand
    extends WbToggleCommand {
        public OpenMenuCommand() {
            super("commands.open");
        }

        public CommandArtifact doInvoke() {
            return null;
        }
    }

    public class OpenMenuController
    implements BAbstractButton.MenuController {
        public boolean isMenuDistinct() {
            return false;
        }

        public BMenu getMenu(BAbstractButton bAbstractButton) {
            return WbCommands.this.makeOpenMenu();
        }
    }

    public class PluginCommand
    extends WbCommand {
        private int id;

        public PluginCommand(int n) {
            super("commands." + BWbView.commandIdToString(n));
            this.id = n;
        }

        public CommandArtifact doInvoke() throws Exception {
            BWbView bWbView = WbCommands.this.shell.getActiveView();
            if (bWbView != null) {
                return bWbView.invokeCommand(this.id);
            }
            return null;
        }
    }

    public class WbToggleCommand
    extends ToggleCommand {
        public WbToggleCommand(String string) {
            super((BWidget)WbCommands.this.shell, UiLexicon.bajaui().module, string);
        }
    }

    public class WbCommand
    extends Command {
        public WbCommand(String string) {
            super((BWidget)WbCommands.this.shell, UiLexicon.bajaui().module, string);
        }
    }
}

