/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.shell;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.bql.builder.BBqlQueryBuilder;
import com.tridium.workbench.shell.BNiagaraWbShell;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.InvalidOrdBaseException;
import javax.baja.naming.OrdTarget;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.file.BDirectoryChooser;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;

public class OpenUtil {
    static Lexicon lex = Lexicon.make((String)"workbench");

    public static void openOrd(BNiagaraWbShell bNiagaraWbShell) throws Exception {
        String string = bNiagaraWbShell.getActiveOrd().toString();
        string = BDialog.prompt((BWidget)bNiagaraWbShell, (String)UiLexicon.bajaui().getText("commands.open.ord.label"), (String)string, (int)70);
        if (string != null) {
            bNiagaraWbShell.hyperlink(BOrd.make((String)string));
        }
    }

    public static void openFile(BNiagaraWbShell bNiagaraWbShell) throws Exception {
        BOrd bOrd;
        if (bNiagaraWbShell.fileChooser == null) {
            bNiagaraWbShell.fileChooser = BFileChooser.makeOpen((BWidget)bNiagaraWbShell);
        }
        if ((bOrd = bNiagaraWbShell.fileChooser.show()) == null) {
            return;
        }
        bNiagaraWbShell.hyperlink(bOrd);
    }

    public static void openDir(BNiagaraWbShell bNiagaraWbShell) throws Exception {
        BOrd bOrd;
        if (bNiagaraWbShell.dirChooser == null) {
            bNiagaraWbShell.dirChooser = BDirectoryChooser.make((BWidget)bNiagaraWbShell);
        }
        if ((bOrd = bNiagaraWbShell.dirChooser.show()) == null) {
            return;
        }
        bNiagaraWbShell.hyperlink(bOrd);
    }

    public static void openQuery(BNiagaraWbShell bNiagaraWbShell) throws Exception {
        OrdTarget ordTarget;
        BObject bObject = null;
        try {
            ordTarget = bNiagaraWbShell.getActiveOrdTarget();
            if (ordTarget == null) {
                OpenUtil.makeErrorDisplay(bNiagaraWbShell);
                return;
            }
            bObject = ordTarget.get();
            bObject = BOrd.make((BOrd)bNiagaraWbShell.getActiveOrd(), (String)"station:|slot:/").resolve().get();
        }
        catch (Exception exception) {
            if (!(exception instanceof InvalidOrdBaseException)) {
                exception.printStackTrace();
            }
            OpenUtil.makeErrorDisplay(bNiagaraWbShell);
            return;
        }
        if (bNiagaraWbShell.bqlBuilder == null) {
            bNiagaraWbShell.bqlBuilder = new BBqlQueryBuilder(bObject, BOrd.NULL);
        }
        if ((ordTarget = bNiagaraWbShell.bqlBuilder.open((BWidget)bNiagaraWbShell)) == null) {
            return;
        }
        bNiagaraWbShell.hyperlink((BOrd)ordTarget);
    }

    public static void makeErrorDisplay(BNiagaraWbShell bNiagaraWbShell) {
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.setRowGap(2.0);
        bGridPane.add(null, (BValue)new BLabel(lex.getText("open.query.line1"), Theme.widget().getBoldText()));
        bGridPane.add(null, (BValue)new BLabel(lex.getText("open.query.line2")));
        BGridPane bGridPane2 = new BGridPane(2);
        bGridPane2.setColumnGap(5.0);
        bGridPane2.add(null, (BValue)new BLabel(BImage.make((String)"module://icons/x32/error.png")));
        bGridPane2.add(null, (BValue)bGridPane);
        BDialog.open((BWidget)bNiagaraWbShell, (String)"Error", (Object)new BBorderPane((BWidget)bGridPane2), (int)1);
        bNiagaraWbShell.bqlBuilder = null;
    }
}

