/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.shell;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.sys.BFoxConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.user.BUserChannel;
import com.tridium.ui.Binder;
import com.tridium.workbench.nav.BFileMenuAgent;
import com.tridium.workbench.pathbar.BNavFilePA;
import com.tridium.workbench.pathbar.BPathBarAgent;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.shell.BPasswordResetDialog;
import com.tridium.workbench.shell.BViewTab;
import com.tridium.workbench.shell.BViewTabbedPane;
import com.tridium.workbench.shell.NoViewRegisteredException;
import com.tridium.workbench.shell.ViewRestrictedException;
import com.tridium.workbench.shell.WbHistory;
import com.tridium.workbench.shell.WbMain;
import java.io.IOException;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.agent.BAbstractPxView;
import javax.baja.gx.BImage;
import javax.baja.log.Log;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdScheme;
import javax.baja.naming.BViewScheme;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.naming.ViewQuery;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavFileSpace;
import javax.baja.nre.util.Array;
import javax.baja.security.AuthenticationException;
import javax.baja.security.BICredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BPermissions;
import javax.baja.security.PermissionException;
import javax.baja.space.BSpace;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BHyperlinkMode;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.workbench.BWbProfile;
import javax.baja.workbench.WbSys;
import javax.baja.workbench.px.BWbPxView;
import javax.baja.workbench.view.BWbView;

public class NHyperlinkInfo
extends HyperlinkInfo {
    static final AgentFilter pathBarAgentFilter = AgentFilter.is((Type)BPathBarAgent.TYPE);
    static Log log = Log.getLog((String)"wb.hyperlink");
    static BPathBarAgent[] noPathBarAgents = new BPathBarAgent[0];
    BWbProfile profile;
    BOrd currentOrd;
    boolean appendToHistory;
    BICredentials credentials;
    BNiagaraWbShell shell;
    BViewTab tab;
    WbHistory.Entry historyEntry;
    BImage icon;
    OrdQuery[] queries;
    boolean hasParent;
    OrdTarget target;
    BPermissions permissions;
    AgentList viewAgents;
    AgentInfo agent;
    BWbView view;
    Context context;
    BPathBarAgent[] pathBarAgents;
    String fault;
    static /* synthetic */ Class class$com$tridium$workbench$pathbar$BPathBarAgent;

    public static NHyperlinkInfo make(HyperlinkInfo hyperlinkInfo) {
        if (hyperlinkInfo instanceof NHyperlinkInfo) {
            return (NHyperlinkInfo)hyperlinkInfo;
        }
        return new NHyperlinkInfo(hyperlinkInfo.getOrd(), hyperlinkInfo.getMode(), true, null);
    }

    public NHyperlinkInfo(BOrd bOrd, BHyperlinkMode bHyperlinkMode, boolean bl) {
        this(bOrd, bHyperlinkMode, bl, null);
    }

    public NHyperlinkInfo(BOrd bOrd, BHyperlinkMode bHyperlinkMode, boolean bl, BICredentials bICredentials) {
        super(bOrd, bHyperlinkMode);
        this.appendToHistory = bl;
        this.credentials = bICredentials;
        if (log.isTraceOn()) {
            log.trace("--- NHyperlinkInfo(" + bOrd + ", " + bHyperlinkMode + ", " + bl + ", " + bICredentials + ") ---");
        }
    }

    public void hyperlink(BViewTab bViewTab) throws Throwable {
        this.tab = bViewTab;
        this.shell = bViewTab.shell;
        this.profile = this.shell.profile;
        try {
            this.currentOrd = bViewTab.ord;
            this.resetTab();
            this.ord = this.normalizeOrd();
            this.hasParent = this.hasParent();
            this.historyEntry = this.appendToHistory();
            this.queries = this.parseOrd();
            this.target = this.resolve();
            this.icon = this.getIcon();
            this.permissions = this.getPermissions();
            this.viewAgents = this.getViewAgentsList();
            this.agent = this.getAgent();
            this.view = this.getView();
            this.context = this.getContext();
            this.pathBarAgents = this.makePathBarAgents();
            this.fault = this.getFault();
            this.updateTab();
            this.installView();
            this.activateView();
            this.loadView();
            this.view = this.profile.customizeView(this.view);
            this.startBinder();
        }
        finally {
            try {
                if (bViewTab != null) {
                    bViewTab.ord = this.ord;
                    bViewTab.updateShell();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void resetTab() {
        if (log.isTraceOn()) {
            log.trace("resetTab: " + (Object)((Object)this.tab));
        }
        this.tab.stopView(true);
    }

    private BOrd normalizeOrd() {
        BOrd bOrd = this.ord;
        BOrd bOrd2 = this.ord;
        try {
            BOrd bOrd3 = this.ord;
            if (this.currentOrd != null) {
                bOrd3 = BOrd.make((BOrd)this.currentOrd, (BOrd)bOrd3);
            }
            bOrd2 = bOrd3.normalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (log.isTraceOn()) {
            log.trace("normalizeOrd: " + bOrd + " -> " + bOrd2);
        }
        return bOrd2;
    }

    private boolean hasParent() {
        boolean bl = false;
        try {
            bl = this.ord.getParent() != null && !this.ord.toString().startsWith("workbench:/");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (log.isTraceOn()) {
            log.trace("hasParent: " + bl);
        }
        return bl;
    }

    private WbHistory.Entry appendToHistory() throws Exception {
        if (log.isTraceOn()) {
            log.trace("appendToHistory");
        }
        WbHistory.Entry entry = null;
        if (this.appendToHistory) {
            entry = this.tab.history.append(this.ord);
            BNiagaraWbShell.history.recentAdd(entry);
        } else {
            this.tab.history.recentTouch(this.ord);
            BNiagaraWbShell.history.recentTouch(this.ord);
        }
        return entry;
    }

    private OrdQuery[] parseOrd() throws Exception {
        if (log.isTraceOn()) {
            log.trace("parseOrd");
        }
        try {
            return this.ord.parse();
        }
        catch (Exception exception) {
            throw new LocalizableException("bajaui", "errorPanel.invalidOrd", (Throwable)exception);
        }
    }

    private OrdTarget resolve() throws Exception {
        BISession bISession;
        BSpace bSpace;
        BComponent bComponent;
        if (!WbMain.isKioskAccessible(this.ord)) {
            throw new UnresolvedException("Local access denied in kiosk mode");
        }
        OrdTarget ordTarget = this.shell.resolve(this.ord, this.credentials);
        if (log.isTraceOn()) {
            log.trace("resolved: " + ordTarget.get().toDebugString());
        }
        if (ordTarget.get() instanceof BComponent) {
            bComponent = (BComponent)ordTarget.get();
            bComponent.lease();
        }
        bComponent = null;
        if (ordTarget.get() instanceof BComponent && ((BComponent)ordTarget.get()).getSession() instanceof BFoxSession) {
            bComponent = (BFoxSession)((BComponent)ordTarget.get()).getSession();
        } else if (ordTarget.get() instanceof BFoxSession) {
            bComponent = (BFoxSession)ordTarget.get();
        } else {
            try {
                bSpace = ordTarget.getSpace();
                if (bSpace != null && (bISession = bSpace.getSession()) instanceof BFoxSession) {
                    bComponent = (BFoxSession)bISession;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (bComponent != null) {
            bSpace = bComponent.getConnection();
            bISession = bSpace.session();
            FoxMessage foxMessage = bISession.getRemoteWelcome();
            BAbsTime bAbsTime = BAbsTime.make((long)foxMessage.getTime("passwordExpires", BAbsTime.NULL.getMillis()));
            boolean bl = foxMessage.getBoolean("forceReset", false);
            if (!bl && !bAbsTime.isNull() && bISession.promptForPasswordReset) {
                if (BDialog.open((BWidget)this.shell, (String)"Password Expiration", (Object)("Your password expires " + bAbsTime + ".  Would you like to reset it now?"), (int)12, (BImage)BImage.make((String)"module://icons/x32/keys.png")) == 4) {
                    bl = true;
                } else {
                    bISession.promptForPasswordReset = false;
                }
            }
            if (bl && bISession.promptForPasswordReset) {
                boolean bl2 = false;
                String string = null;
                int n = 0;
                while (!bl2) {
                    try {
                        ++n;
                        BUserChannel bUserChannel = ((BFoxConnection)bISession.conn()).getChannels().getUserChannel();
                        bUserChannel.fetchPrefs();
                        BPassword bPassword = BPasswordResetDialog.open((BWidget)this.shell, bUserChannel.getPasswordStrength(), string);
                        if (bPassword != null) {
                            bUserChannel.setPassword(bPassword, true);
                            bISession.promptForPasswordReset = false;
                            bl2 = true;
                            continue;
                        }
                        bl2 = true;
                        throw new AuthenticationException("password not changed as required");
                    }
                    catch (AuthenticationException authenticationException) {
                        this.ensureDisconnect((BFoxSession)bComponent);
                        throw authenticationException;
                    }
                    catch (IOException iOException) {
                        this.ensureDisconnect((BFoxSession)bComponent);
                        throw iOException;
                    }
                    catch (Exception exception) {
                        string = exception.getLocalizedMessage();
                        if (n <= 100) continue;
                        this.ensureDisconnect((BFoxSession)bComponent);
                        throw exception;
                    }
                }
            }
        }
        return ordTarget;
    }

    private void ensureDisconnect(BFoxSession bFoxSession) {
        block3: {
            try {
                if (bFoxSession != null) {
                    bFoxSession.disconnect();
                }
            }
            catch (Exception exception) {
                if (!log.isTraceOn()) break block3;
                log.trace("Cannot disconnect", (Throwable)exception);
            }
        }
    }

    private BImage getIcon() {
        try {
            BImage bImage = BImage.make((BIcon)this.target.get().getIcon());
            if (this.historyEntry != null) {
                this.historyEntry.icon = bImage;
            }
            return bImage;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private BPermissions getPermissions() throws Exception {
        BPermissions bPermissions = this.target.getPermissionsForTarget();
        if (log.isTraceOn()) {
            log.trace("getPermissions: " + bPermissions);
        }
        return bPermissions;
    }

    private AgentList getViewAgentsList() throws Exception {
        BObject bObject = this.target.get();
        AgentFilter agentFilter = WbSys.getViewsFilter((BWidget)this.shell, bObject);
        if (BFileMenuAgent.disable) {
            agentFilter = AgentFilter.and((AgentFilter)agentFilter, (BPermissions)this.permissions);
        }
        AgentList agentList = this.profile.getAgents(bObject).filter(agentFilter);
        if (log.isTraceOn()) {
            log.trace("getAgents: " + agentList);
        }
        if (agentList.size() == 0) {
            AgentList agentList2 = this.target.get().getAgents().filter(WbSys.getBaseViewsFilter());
            if (agentList2.size() > 0) {
                throw new ViewRestrictedException(bObject.getType());
            }
            throw new NoViewRegisteredException(bObject.getType());
        }
        return agentList;
    }

    private AgentInfo getAgent() throws Exception {
        OrdQuery ordQuery;
        String string = null;
        if (this.queries.length > 0 && (ordQuery = this.queries[this.queries.length - 1]) instanceof ViewQuery) {
            string = ((ViewQuery)ordQuery).getViewId();
        }
        ordQuery = null;
        ordQuery = string == null && this.viewAgents.size() > 0 ? this.viewAgents.getDefault() : this.viewAgents.get(string);
        if (this.historyEntry != null && string != null) {
            this.historyEntry.ordNoView = BOrd.make((OrdQuery[])this.queries, (int)0, (int)(this.queries.length - 1));
            this.historyEntry.viewId = string;
        }
        if (ordQuery == null) {
            System.out.println("No views accessible:");
            System.out.println("  ord:         " + this.ord);
            System.out.println("  target.type: " + this.target.get().getType());
            System.out.println("  target:      " + this.target.get());
            if (string != null) {
                throw new LocalizableRuntimeException("bajaui", "errorPanel.invalidView", new Object[]{string});
            }
            throw new LocalizableRuntimeException("bajaui", "errorPanel.noViews");
        }
        if (!this.permissions.has(ordQuery.getRequiredPermissions())) {
            throw new PermissionException(this.permissions + " < " + ordQuery.getRequiredPermissions());
        }
        if (log.isTraceOn()) {
            log.trace("getAgent: " + ordQuery);
        }
        return ordQuery;
    }

    private BWbView getView() throws Exception {
        BObject bObject = this.agent.getInstance();
        if (log.isTraceOn()) {
            log.trace("getView: " + bObject.toDebugString());
        }
        if (bObject instanceof BWbView) {
            return (BWbView)bObject;
        }
        if (bObject instanceof BAbstractPxView) {
            BWbPxView bWbPxView = new BWbPxView((BAbstractPxView)bObject);
            return bWbPxView;
        }
        throw new LocalizableRuntimeException("bajaui", "errorPanel.notWbView");
    }

    private Context getContext() throws Exception {
        try {
            BISession bISession = BOrd.toSession((BObject)this.target.get());
            if (bISession != null) {
                return bISession.getSessionContext();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    private BPathBarAgent[] makePathBarAgents() throws Exception {
        if (this.shell.getProfile().makeLocatorBar() == null) {
            return noPathBarAgents;
        }
        try {
            Object object;
            BINavNode bINavNode;
            BObject bObject;
            BISession bISession;
            if (this.shell.commands.pathBarUsesNavFile.isSelected() && (bISession = BOrd.toSession((BObject)(bObject = this.target.get()))) != null) {
                bINavNode = bISession.getNavChild("navfile");
                object = null;
                if (bINavNode != null && (object = BNavFilePA.make((BNavFileSpace)bINavNode, this.target)) != null) {
                    return object;
                }
            }
            bObject = new Array(class$com$tridium$workbench$pathbar$BPathBarAgent == null ? (class$com$tridium$workbench$pathbar$BPathBarAgent = NHyperlinkInfo.class$("com.tridium.workbench.pathbar.BPathBarAgent")) : class$com$tridium$workbench$pathbar$BPathBarAgent);
            for (int i = 0; i < this.queries.length; ++i) {
                bINavNode = i == 0 ? BOrd.NULL : this.ord.getSubOrd(0, i);
                object = this.makePathBarAgent(this.queries[i]);
                if (object == null) continue;
                if (i == this.queries.length - 1) {
                    object.setAgentOrd((BOrd)bINavNode, this.queries[i], this.target.get());
                } else {
                    object.setAgentOrd((BOrd)bINavNode, this.queries[i]);
                }
                BPathBarAgent[] bPathBarAgentArray = object.explode();
                for (int j = 0; j < bPathBarAgentArray.length; ++j) {
                    bObject.add((Object)bPathBarAgentArray[j]);
                }
            }
            return (BPathBarAgent[])bObject.trim();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private BPathBarAgent makePathBarAgent(OrdQuery ordQuery) {
        BOrdScheme bOrdScheme = BOrdScheme.lookup((String)ordQuery.getScheme());
        if (bOrdScheme.getType().is(BViewScheme.TYPE)) {
            return null;
        }
        AgentList agentList = bOrdScheme.getAgents().filter(pathBarAgentFilter);
        if (agentList.size() == 0) {
            return null;
        }
        return (BPathBarAgent)agentList.getDefault().getInstance();
    }

    private String getFault() throws Exception {
        BISession bISession;
        if (log.isTraceOn()) {
            log.trace("getFault");
        }
        if ((bISession = BOrd.toSession((BObject)this.target.get())) instanceof BFoxSession) {
            return ((BFoxSession)bISession).getStationFault();
        }
        return null;
    }

    private void updateTab() throws Exception {
        if (log.isTraceOn()) {
            log.trace("updateTab");
        }
        this.tab.ord = this.ord;
        this.tab.hasParent = this.hasParent;
        this.tab.target = this.target;
        this.tab.agents = this.viewAgents;
        this.tab.agent = this.agent;
        this.tab.view = this.view;
        this.tab.pathBarAgents = this.pathBarAgents;
        this.tab.fault = this.fault;
    }

    private void installView() {
        String string = BViewTabbedPane.toTabName(this.ord, this.target);
        if (log.isTraceOn()) {
            log.trace("installView: " + string);
        }
        BImage bImage = this.icon;
        BLabel bLabel = this.tab.getLabel();
        if (bImage != null) {
            bLabel.setImage(bImage);
        }
        bLabel.setText(string);
        this.tab.setContent(this.view);
    }

    private void activateView() {
        if (log.isTraceOn()) {
            log.trace("activateView");
        }
        this.tab.fireActivated();
    }

    private void loadView() throws Throwable {
        if (log.isTraceOn()) {
            log.trace("loadView");
        }
        this.view.fw(403);
        this.view.loadValue(this.target.get(), this.context);
        if (this.view.getLoadError() != null) {
            throw this.view.getLoadError();
        }
        this.view.prime();
        this.shell.relayout();
        this.view.relayout();
    }

    private void startBinder() throws Throwable {
        Binder binder = (Binder)this.view.fw(302);
        binder.start(this.target, this.context);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

