/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.shell;

import com.tridium.sys.license.Brand;
import com.tridium.workbench.shell.WbMain;
import com.tridium.workbench.util.WbUtil;
import java.util.Properties;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.BMemoryFileStore;
import javax.baja.file.FilePath;
import javax.baja.file.types.text.BHtmlFile;
import javax.baja.naming.BOrd;
import javax.baja.sys.BObject;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.util.TextUtil;
import javax.baja.xml.XWriter;

public class HelpGenerator {
    public static BObject makeAbout() throws Exception {
        Properties properties = new Properties();
        properties.put("title", XWriter.safeToString((String)WbMain.brandTitle, (boolean)false));
        properties.put("splash", WbMain.brandSplash);
        properties.put("license", WbMain.getLicenseInfo() == null ? "" : "Licensed to " + WbMain.getLicenseInfo());
        properties.put("version", "Version " + Sys.loadModule((String)"workbench").getVendorVersion());
        properties.put("copyright", "Copyright Tridium, Inc 1996-" + Clock.time().getYear());
        try {
            BOrd.make((String)("file:!lib/" + Brand.getBrandId() + "LicenseAgreement.txt")).get();
            properties.put("brandEulaText", TextUtil.toFriendly((String)Brand.getBrandId()) + " End User License Agreement");
            properties.put("brandEulaFile", "file:!lib/" + Brand.getBrandId() + "LicenseAgreement.txt|view:workbench:TextFileViewer?wordWrap=true");
        }
        catch (Exception exception) {
            properties.put("brandEulaText", "");
            properties.put("brandEulaFile", "");
        }
        try {
            BOrd.make((String)("file:!lib/" + Brand.getBrandId() + "ReadMeLicenses.txt")).get();
            properties.put("brandThirdPartyLicensesText", TextUtil.toFriendly((String)Brand.getBrandId()) + " Third Party Licenses");
            properties.put("brandThirdPartyLicensesFile", "file:!lib/" + Brand.getBrandId() + "ReadMeLicenses.txt|view:workbench:TextFileViewer?wordWrap=true");
        }
        catch (Exception exception) {
            properties.put("brandThirdPartyLicensesText", "");
            properties.put("brandThirdPartyLicensesFile", "");
        }
        BIFile bIFile = (BIFile)BOrd.make((String)"module://workbench/com/tridium/workbench/media/about.html").resolve().get();
        BMemoryFileStore bMemoryFileStore = new BMemoryFileStore(null, new FilePath("/help/about.html"));
        WbUtil.loadWithMacros(bIFile.getInputStream(), bMemoryFileStore.getOutputStream(), properties);
        return new BHtmlFile((BIFileStore)bMemoryFileStore);
    }

    public static BObject makeContents() throws Exception {
        Properties properties = new Properties();
        BIFile bIFile = (BIFile)BOrd.make((String)"module://workbench/com/tridium/workbench/media/contents.html").resolve().get();
        BMemoryFileStore bMemoryFileStore = new BMemoryFileStore(null, new FilePath("/help/contents.html"));
        WbUtil.loadWithMacros(bIFile.getInputStream(), bMemoryFileStore.getOutputStream(), properties);
        return new BHtmlFile((BIFileStore)bMemoryFileStore);
    }
}

