/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.shell;

import com.tridium.ui.theme.custom.nss.StyleUtils;
import com.tridium.workbench.console.BConsole;
import com.tridium.workbench.shell.BNiagaraWbLocatorBar;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.shell.BScrollingToolbarPane;
import com.tridium.workbench.shell.BSideBarPane;
import com.tridium.workbench.shell.BViewTab;
import com.tridium.workbench.shell.BViewTabbedPane;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BButton;
import javax.baja.ui.BMenu;
import javax.baja.ui.BMenuBar;
import javax.baja.ui.BMenuItem;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BSubMenuItem;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.BWbLocatorBar;
import javax.baja.workbench.BWbProfile;
import javax.baja.workbench.BWbStatusBar;
import javax.baja.workbench.sidebar.BWbSideBar;

public class BWbPane
extends BEdgePane {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$shell$BWbPane == null ? (class$com$tridium$workbench$shell$BWbPane = BWbPane.class$("com.tridium.workbench.shell.BWbPane")) : class$com$tridium$workbench$shell$BWbPane));
    private static final Property[] noMenus = new Property[0];
    final BNiagaraWbShell shell;
    final BWbProfile profile;
    private BWidget menuBar;
    private Property[] mergedMenus = noMenus;
    private BScrollingToolbarPane toolBarPane;
    private Property mergedToolBar;
    private BWbLocatorBar locatorBar;
    BViewTabbedPane views;
    BSideBarPane sideBar;
    BConsole console;
    private BSplitPane hSplitPane;
    private BSplitPane vSplitPane;
    private BWbStatusBar statusBar;
    private BWidget statusBarSupplement;
    static /* synthetic */ Class class$com$tridium$workbench$shell$BWbPane;

    public Type getType() {
        return TYPE;
    }

    public BWbPane() {
        throw new IllegalStateException();
    }

    public BWbPane(BNiagaraWbShell bNiagaraWbShell) {
        this.shell = bNiagaraWbShell;
        this.profile = bNiagaraWbShell.profile;
        this.setTop((BWidget)new BEdgePane());
        this.buildMenuBar();
        this.buildToolBar();
        this.buildLocatorBar();
        this.buildContent();
        this.buildStatusBar();
    }

    public void update(BViewTab bViewTab) {
        try {
            this.updateMenuBar(bViewTab);
            this.updateToolBar(bViewTab);
            this.updateLocatorBar(bViewTab);
            this.updateSideBars(bViewTab);
            this.updateStatusBar(bViewTab);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean hasMenu(String string) {
        if (this.menuBar == null) {
            return false;
        }
        String[] stringArray = TextUtil.split((String)string, (char)'|');
        BWidget bWidget = this.menuBar;
        for (int i = 0; i < stringArray.length; ++i) {
            BComponent bComponent = (BComponent)bWidget.get(stringArray[i]);
            if (bComponent instanceof BSubMenuItem) {
                bComponent = ((BSubMenuItem)bComponent).getMenu();
            }
            if (bComponent == null) {
                return false;
            }
            bWidget = bComponent;
        }
        return true;
    }

    BWidget getMenuBar() {
        return this.menuBar;
    }

    private void buildMenuBar() {
        this.menuBar = this.profile.makeMenuBar();
        if (this.menuBar == null) {
            return;
        }
        BMenu[] bMenuArray = ((BMenuBar)this.menuBar).getMenus();
        for (int i = 0; i < bMenuArray.length; ++i) {
            bMenuArray[i].removeConsecutiveSeparators();
        }
        BEdgePane bEdgePane = (BEdgePane)this.getTop();
        if (this.shell.isApplet() || this.shell.isWebStart()) {
            this.menuBar = this.menuBarToDropDown(this.menuBar);
            BButton bButton = new BButton(UiLexicon.bajaui().getText("menu"));
            bButton.setMenuController((BAbstractButton.MenuController)new AppletMenuController());
            bButton.setButtonStyle(BButtonStyle.toolBar);
            bEdgePane.setLeft((BWidget)bButton);
        } else {
            bEdgePane.setTop(this.menuBar);
        }
    }

    private BMenu menuBarToDropDown(BWidget bWidget) {
        BMenu bMenu = new BMenu();
        BMenu[] bMenuArray = ((BMenuBar)bWidget).getMenus();
        for (int i = 0; i < bMenuArray.length; ++i) {
            BMenu bMenu2 = bMenuArray[i];
            String string = bMenu2.getName();
            bWidget.remove((BComplex)bMenu2);
            bMenu.add(string, (BValue)new BSubMenuItem(bMenu2));
        }
        return bMenu;
    }

    private void updateMenuBar(BViewTab bViewTab) {
        if (this.menuBar == null) {
            return;
        }
        for (int i = 0; i < this.mergedMenus.length; ++i) {
            BWbPane.unregisterFromCommands((BWidget)this.menuBar.get(this.mergedMenus[i]));
            this.menuBar.remove(this.mergedMenus[i]);
        }
        this.mergedMenus = noMenus;
        BMenu[] bMenuArray = null;
        try {
            if (bViewTab.view != null) {
                bMenuArray = bViewTab.view.getViewMenus();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (bMenuArray == null) {
            this.mergedMenus = noMenus;
        } else {
            BValue bValue = this.menuBar.get("help");
            if (bValue != null) {
                this.menuBar.remove("help");
            }
            this.mergedMenus = new Property[bMenuArray.length];
            for (int i = 0; i < bMenuArray.length; ++i) {
                this.mergedMenus[i] = this.addMenu("merge" + i, bMenuArray[i]);
            }
            if (bValue != null) {
                this.menuBar.add("help", bValue);
            }
        }
    }

    private Property addMenu(String string, BMenu bMenu) {
        if (this.menuBar instanceof BMenuBar) {
            return this.menuBar.add(string, (BValue)bMenu);
        }
        return this.menuBar.add(string, (BValue)new BSubMenuItem(bMenu));
    }

    private void buildToolBar() {
        BSeparator bSeparator;
        BToolBar bToolBar = this.profile.makeToolBar();
        if (bToolBar == null) {
            return;
        }
        bToolBar.removeConsecutiveSeparators();
        this.toolBarPane = new BScrollingToolbarPane(10, bToolBar);
        BEdgePane bEdgePane = new BEdgePane();
        StyleUtils.addStyleClass((IStylable)bEdgePane, (String)"toolbar-container");
        if (this.menuBar instanceof BMenuBar) {
            bSeparator = new BSeparator(BOrientation.horizontal);
            bSeparator.setStyleClasses("below-menu-bar");
            bEdgePane.setTop((BWidget)bSeparator);
        }
        bEdgePane.setCenter((BWidget)this.toolBarPane);
        bSeparator = (BEdgePane)this.getTop();
        bSeparator.setCenter((BWidget)bEdgePane);
    }

    private void updateToolBar(BViewTab bViewTab) {
        if (this.toolBarPane == null) {
            return;
        }
        if (this.mergedToolBar != null) {
            BWbPane.unregisterFromCommands((BWidget)this.toolBarPane.get(this.mergedToolBar));
            this.toolBarPane.removeMergedToolbar(this.mergedToolBar);
            this.mergedToolBar = null;
        }
        BToolBar bToolBar = null;
        try {
            if (bViewTab.view != null) {
                bToolBar = bViewTab.view.getViewToolBar();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (bToolBar != null) {
            this.mergedToolBar = this.toolBarPane.addMergedToolbar(bToolBar);
        }
        this.shell.commands.export.updateEnabled();
        this.toolBarPane.relayout();
    }

    private void buildLocatorBar() {
        this.locatorBar = this.profile.makeLocatorBar();
        if (this.locatorBar == null) {
            return;
        }
        BBorderPane bBorderPane = new BBorderPane((BWidget)this.locatorBar, 3.0, 0.0, 3.0, 0.0);
        BEdgePane bEdgePane = (BEdgePane)this.getTop();
        bEdgePane.setBottom((BWidget)bBorderPane);
    }

    private void updateLocatorBar(BViewTab bViewTab) {
        try {
            if (this.locatorBar == null) {
                return;
            }
            if (this.locatorBar instanceof BNiagaraWbLocatorBar) {
                ((BNiagaraWbLocatorBar)this.locatorBar).update(bViewTab);
            } else {
                this.locatorBar.activeViewChanged();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public double getSplitPosition() {
        return this.hSplitPane.getDividerPosition();
    }

    public void setSplitPosition(double d) {
        if (this.sideBar != null) {
            this.hSplitPane.setDividerPosition(d);
        }
    }

    void setSideBarVisible(boolean bl) {
        if (this.sideBar != null) {
            this.sideBar.setVisible(bl);
            this.hSplitPane.relayout();
        }
    }

    void setConsoleVisible(boolean bl) {
        if (this.console != null) {
            this.console.setVisible(bl);
            this.vSplitPane.relayout();
        }
    }

    private void updateSideBars(BViewTab bViewTab) {
        if (this.sideBar != null) {
            BWbSideBar[] bWbSideBarArray = this.sideBar.list();
            for (int i = 0; i < bWbSideBarArray.length; ++i) {
                try {
                    bWbSideBarArray[i].activeViewChanged();
                    continue;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }

    private void buildContent() {
        this.views = new BViewTabbedPane(this.shell, this);
        this.hSplitPane = new BSplitPane(BOrientation.horizontal, 30.0);
        if (this.profile.hasSideBar()) {
            this.sideBar = this.shell.makeSideBar();
            this.sideBar.shell = this.shell;
            this.sideBar.setVisible(false);
            this.hSplitPane.setWidget1((BWidget)this.sideBar);
        } else {
            this.hSplitPane.getWidget1().setVisible(false);
        }
        this.hSplitPane.setWidget2((BWidget)this.views);
        this.console = new BConsole(this.shell);
        this.console.setVisible(false);
        this.vSplitPane = new BSplitPane(BOrientation.vertical, 85.0);
        this.vSplitPane.setWidget1((BWidget)this.hSplitPane);
        this.vSplitPane.setWidget2((BWidget)this.console);
        StyleUtils.addStyleClass((IStylable)this.vSplitPane, (String)"lower-split");
        this.setCenter((BWidget)this.vSplitPane);
    }

    public void showStatus(String string) {
        if (this.statusBar == null) {
            return;
        }
        this.statusBar.showStatus(string);
        this.statusBar.repaint();
    }

    private void buildStatusBar() {
        this.statusBar = this.profile.makeStatusBar();
        if (this.statusBar == null) {
            return;
        }
        this.setBottom((BWidget)this.statusBar);
    }

    private void updateStatusBar(BViewTab bViewTab) {
        if (this.statusBar == null) {
            return;
        }
        BWidget bWidget = null;
        if (bViewTab.view != null) {
            bWidget = bViewTab.view.getViewStatusBarSupplement();
        }
        if (bWidget == null) {
            bWidget = new BNullWidget();
        }
        this.statusBar.setSupplement(bWidget);
    }

    static void unregisterFromCommands(BWidget bWidget) {
        if (bWidget instanceof BAbstractButton) {
            ((BAbstractButton)bWidget).setCommand(null, false, false);
        } else if (bWidget instanceof BMenuItem) {
            ((BMenuItem)bWidget).setCommand(null);
        }
        BWidget[] bWidgetArray = bWidget.getChildWidgets();
        for (int i = 0; i < bWidgetArray.length; ++i) {
            BWbPane.unregisterFromCommands(bWidgetArray[i]);
        }
    }

    public BSideBarPane getSideBar() {
        return this.sideBar;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class AppletMenuController
    implements BAbstractButton.MenuController {
        AppletMenuController() {
        }

        public boolean isMenuDistinct() {
            return false;
        }

        public BMenu getMenu(BAbstractButton bAbstractButton) {
            return (BMenu)BWbPane.this.menuBar;
        }
    }
}

