/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.shell;

import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.shell.BViewTab;
import com.tridium.workbench.shell.BWbPane;
import java.util.ArrayList;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.ViewQuery;
import javax.baja.nav.BINavNode;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BLabelPane;
import javax.baja.ui.pane.BTabbedPane;

public class BViewTabbedPane
extends BTabbedPane {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$shell$BViewTabbedPane == null ? (class$com$tridium$workbench$shell$BViewTabbedPane = BViewTabbedPane.class$("com.tridium.workbench.shell.BViewTabbedPane")) : class$com$tridium$workbench$shell$BViewTabbedPane));
    BViewTab dragged = null;
    long lastSwapTimestamp = -1L;
    BViewTab lastSwap = null;
    private static final int MAX_NAME = 25;
    static final BImage faultIcon = BImage.make((String)"module://icons/x32/warning.png");
    private BNiagaraWbShell shell;
    private BWbPane pane;
    static /* synthetic */ Class class$com$tridium$workbench$shell$BViewTabbedPane;

    public Type getType() {
        return TYPE;
    }

    public BViewTabbedPane() {
        throw new IllegalStateException();
    }

    public BViewTabbedPane(BNiagaraWbShell bNiagaraWbShell, BWbPane bWbPane) {
        this.shell = bNiagaraWbShell;
        this.pane = bWbPane;
        this.setShowSingleTab(false);
        this.setPaintFullBorder(false);
        this.setTabSupport(new Support());
        this.addTab();
        BButton bButton = new BButton(bNiagaraWbShell.commands.closeTab, false, true);
        bButton.setButtonStyle(BButtonStyle.toolBar);
        this.setTabControl((BWidget)bButton);
    }

    public BViewTab tab() {
        return (BViewTab)this.getSelectedLabelPane();
    }

    public BViewTab[] getTabs() {
        ArrayList<BObject> arrayList = new ArrayList<BObject>();
        SlotCursor slotCursor = this.getProperties();
        while (slotCursor.nextComponent()) {
            if (!(slotCursor.get() instanceof BViewTab)) continue;
            BViewTab bViewTab = (BViewTab)slotCursor.get();
            arrayList.add(slotCursor.get());
        }
        return arrayList.toArray(new BViewTab[arrayList.size()]);
    }

    public BViewTab[] getModifiedTabs() {
        ArrayList<BObject> arrayList = new ArrayList<BObject>();
        SlotCursor slotCursor = this.getProperties();
        while (slotCursor.nextComponent()) {
            if (!(slotCursor.get() instanceof BViewTab)) continue;
            BViewTab bViewTab = (BViewTab)slotCursor.get();
            if (bViewTab.view == null || !bViewTab.view.isModified()) continue;
            arrayList.add(slotCursor.get());
        }
        return arrayList.toArray(new BViewTab[arrayList.size()]);
    }

    public static int indexOf(BViewTab[] bViewTabArray, BViewTab bViewTab) {
        for (int i = 0; i < bViewTabArray.length; ++i) {
            if (bViewTabArray[i] != bViewTab) continue;
            return i;
        }
        return -1;
    }

    public void selectionModified(BLabelPane bLabelPane) {
        super.selectionModified(bLabelPane);
        this.tab().updateShell();
        if (this.tab().view != null) {
            this.tab().view.prime();
        }
    }

    public void added(Property property, Context context) {
        super.added(property, context);
        this.numberOfTabsUpdated();
    }

    public void removed(Property property, BValue bValue, Context context) {
        super.removed(property, bValue, context);
        this.numberOfTabsUpdated();
    }

    void numberOfTabsUpdated() {
        boolean bl = this.getTabs().length > 1;
        this.shell.commands.closeTab.setEnabled(bl);
        this.shell.commands.closeOtherTabs.setEnabled(bl);
        this.shell.commands.nextTab.setEnabled(bl);
        this.shell.commands.prevTab.setEnabled(bl);
        this.shell.commands.refreshTabs.setEnabled(bl);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        BViewTab bViewTab = this.tab();
        if (bViewTab == null || bViewTab.fault == null) {
            return;
        }
        String string = bViewTab.fault;
        double d = this.getWidth();
        double d2 = this.getHeight();
        BLabel bLabel = new BLabel(string, BHalign.left);
        bLabel.setImage(faultIcon);
        bLabel.computePreferredSize();
        double d3 = bLabel.getPreferredWidth();
        double d4 = bLabel.getPreferredHeight();
        double d5 = Math.max(10.0, d - d3 - 20.0);
        double d6 = Math.max(10.0, d2 - d4 - 20.0);
        bLabel.setBounds(0.0, 0.0, d3, d4);
        bLabel.doLayout(null);
        graphics.setBrush(BColor.make((int)255, (int)255, (int)0, (int)180));
        graphics.fillRect(d5 - 10.0, d6 - 10.0, d3 + 20.0, d4 + 20.0);
        graphics.setBrush(BColor.black);
        graphics.strokeRect(d5 - 10.0, d6 - 10.0, d3 + 20.0, d4 + 20.0);
        graphics.translate(d5, d6);
        bLabel.paint(graphics);
    }

    public void mouseDragged(BMouseEvent bMouseEvent) {
        BViewTab bViewTab;
        if (this.dragged != null && (bViewTab = (BViewTab)this.tabAt(bMouseEvent.getX(), bMouseEvent.getY())) instanceof BViewTab && (bViewTab != this.lastSwap || Clock.millis() - this.lastSwapTimestamp > 1000L)) {
            this.lastSwap = null;
            Property[] propertyArray = this.getDynamicPropertiesArray();
            int n = -1;
            int n2 = -1;
            for (int i = 0; i < propertyArray.length; ++i) {
                if (propertyArray[i] == bViewTab.getPropertyInParent()) {
                    n = i;
                    continue;
                }
                if (propertyArray[i] != this.dragged.getPropertyInParent()) continue;
                n2 = i;
            }
            if (n != -1 && n2 != -1) {
                Property property = propertyArray[n];
                propertyArray[n] = propertyArray[n2];
                propertyArray[n2] = property;
                this.lastSwap = bViewTab;
                this.lastSwapTimestamp = Clock.millis();
            }
            this.reorder(propertyArray);
        }
        super.mouseDragged(bMouseEvent);
    }

    public void mouseDragStarted(BMouseEvent bMouseEvent) {
        BLabelPane bLabelPane = this.tabAt(bMouseEvent.getX(), bMouseEvent.getY());
        if (bLabelPane instanceof BViewTab) {
            this.dragged = (BViewTab)bLabelPane;
            this.lastSwap = null;
        }
        super.mouseDragStarted(bMouseEvent);
    }

    public void mouseReleased(BMouseEvent bMouseEvent) {
        this.dragged = null;
        super.mouseReleased(bMouseEvent);
    }

    public void mousePressed(BMouseEvent bMouseEvent) {
        if (bMouseEvent.isButton2Down()) {
            BLabelPane bLabelPane = this.tabAt(bMouseEvent.getX(), bMouseEvent.getY());
            if (bLabelPane != null) {
                ((BViewTab)bLabelPane).closeTab();
            }
        } else {
            super.mousePressed(bMouseEvent);
        }
    }

    public void selectNextTab() {
        BViewTab[] bViewTabArray = this.getTabs();
        int n = BViewTabbedPane.indexOf(bViewTabArray, this.tab());
        int n2 = (n + 1) % bViewTabArray.length;
        this.selectLabelPane(bViewTabArray[n2]);
    }

    public void selectPrevTab() {
        BViewTab[] bViewTabArray = this.getTabs();
        int n = BViewTabbedPane.indexOf(bViewTabArray, this.tab());
        int n2 = n - 1;
        if (n2 < 0) {
            n2 = bViewTabArray.length - 1;
        }
        this.selectLabelPane(bViewTabArray[n2]);
    }

    public BViewTab addTab() {
        BViewTab bViewTab = new BViewTab(this.shell);
        this.add(null, (BValue)bViewTab);
        this.selectLabelPane(bViewTab);
        return bViewTab;
    }

    public void removeTab(BViewTab bViewTab) {
        if (bViewTab.getParent() != this) {
            throw new IllegalStateException();
        }
        if (bViewTab == this.tab()) {
            this.selectPrevTab();
        }
        this.remove(bViewTab.getPropertyInParent());
    }

    public static String toTabName(BOrd bOrd, OrdTarget ordTarget) {
        String string = null;
        try {
            BObject bObject;
            if (ordTarget != null && ordTarget.get() != null && (bObject = ordTarget.get()) instanceof BINavNode) {
                string = ((BINavNode)bObject).getNavDisplayName(null);
            }
            if (string == null) {
                string = BViewTabbedPane.toTabNameFromOrd(bOrd);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            string = "" + bOrd;
        }
        if (string.length() > 25) {
            string = "..." + string.substring(string.length() - 25, string.length());
        }
        return string;
    }

    private static String toTabNameFromOrd(BOrd bOrd) {
        int n;
        String string;
        if (bOrd.isNull()) {
            return "null";
        }
        OrdQuery[] ordQueryArray = bOrd.parse();
        int n2 = ordQueryArray.length;
        int n3 = n2 - 1;
        OrdQuery ordQuery = ordQueryArray[n3];
        String string2 = null;
        if (ordQuery instanceof ViewQuery && n2 >= 2) {
            string = ((ViewQuery)ordQuery).getViewId();
            if (string != null && (n = string.indexOf(58)) > 0) {
                string2 = string.substring(n + 1);
            }
            ordQuery = ordQueryArray[--n3];
        }
        if ((string = ordQuery.toString()).length() > 25 && (n = string.indexOf(47)) > 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Support
    extends BTabbedPane.TabSupport {
        Support() {
        }

        public void tabPopup(BLabelPane bLabelPane, BMouseEvent bMouseEvent) {
            BViewTab bViewTab = (BViewTab)bLabelPane;
            BMenu bMenu = new BMenu();
            bMenu.add(null, ((BViewTabbedPane)BViewTabbedPane.this).shell.commands.newTab);
            bMenu.add(null, (BValue)new BSeparator());
            bMenu.add(null, (Command)((BViewTabbedPane)BViewTabbedPane.this).shell.commands.makeCloseTab(bViewTab));
            bMenu.add(null, (Command)((BViewTabbedPane)BViewTabbedPane.this).shell.commands.makeCloseOtherTabs(bViewTab));
            bMenu.open((BWidget)BViewTabbedPane.this, bMouseEvent.getX(), bMouseEvent.getY());
        }
    }
}

