/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.shell;

import com.tridium.fox.session.MulticastServer;
import com.tridium.fox.sys.BLearnStation;
import com.tridium.fox.sys.Learn;
import com.tridium.ui.BOptionDialog;
import com.tridium.ui.theme.Theme;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BProgressBar;
import javax.baja.ui.BRadioButtonMenuItem;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;

public class BStationFinder
extends BEdgePane
implements Runnable,
MulticastServer.RollcallCallback {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$shell$BStationFinder == null ? (class$com$tridium$workbench$shell$BStationFinder = BStationFinder.class$("com.tridium.workbench.shell.BStationFinder")) : class$com$tridium$workbench$shell$BStationFinder));
    static BImage findIcon = BImage.make((String)"module://icons/x32/magnifyingGlass.png");
    static BImage foxIcon = BImage.make((String)"module://icons/x16/fox.png");
    static BImage foxsIcon = BImage.make((BIcon)BIcon.make((BIcon)BIcon.std((String)"fox.png"), (BIcon)BIcon.std((String)"badges/lock.png")));
    static boolean lastUseHostName = true;
    Lexicon lex = UiLexicon.bajaui();
    BProgressBar progressBar;
    BTable table;
    Column[] cols;
    Row[] rows = new Row[0];
    BOrd result;
    boolean firstPaint = true;
    BButton ok;
    ToggleCommand useHostName = new ToggleCommand((BWidget)this, "Use Host Name");
    ToggleCommand useHostAddress = new ToggleCommand((BWidget)this, "Use Host Address");
    static /* synthetic */ Class class$com$tridium$workbench$shell$BStationFinder;

    public Type getType() {
        return TYPE;
    }

    public BStationFinder() {
        Property[] propertyArray = new BLearnStation().getPropertiesArray();
        this.cols = new Column[propertyArray.length];
        for (int i = 0; i < this.cols.length; ++i) {
            this.cols[i] = new Column(propertyArray[i]);
        }
        DynamicTableModel dynamicTableModel = new DynamicTableModel((TableModel)new Model());
        this.table = new BTable((TableModel)dynamicTableModel, (TableController)new Controller());
        this.table.setSelection((TableSelection)new Selection());
        this.table.setMultipleSelection(false);
        for (int i = 0; i < this.cols.length; ++i) {
            dynamicTableModel.setShowColumn(i, (this.cols[i].prop.getDefaultFlags() & 8) != 0);
        }
        BLabel bLabel = new BLabel(findIcon, this.lex.getText("findStations.learning"));
        bLabel.setFont(Theme.widget().getBoldText());
        this.progressBar = new BProgressBar();
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.add(null, (BValue)bLabel);
        bGridPane.add(null, (BValue)this.progressBar);
        this.setCenter((BWidget)new BBorderPane((BWidget)bGridPane, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        boolean bl = lastUseHostName;
        HostToggle hostToggle = new HostToggle();
        hostToggle.add(this.useHostName);
        hostToggle.add(this.useHostAddress);
        if (bl) {
            this.useHostName.setSelected(true);
        } else {
            this.useHostAddress.setSelected(true);
        }
    }

    public void paint(Graphics graphics) {
        if (this.firstPaint) {
            BOptionDialog bOptionDialog = (BOptionDialog)this.getShell();
            this.ok = bOptionDialog.getOkButton();
            this.ok.setEnabled(false);
            this.firstPaint = false;
            this.learn();
        }
        super.paint(graphics);
    }

    public void learn() {
        new Thread((Runnable)this, "Ui:FindStations").start();
    }

    public void completed(int n) {
        if (this.progressBar != null) {
            this.progressBar.setValue((double)n);
        }
    }

    public void run() {
        try {
            BLearnStation[] bLearnStationArray = Learn.learn((long)5000L, (MulticastServer.RollcallCallback)this);
            this.rows = new Row[bLearnStationArray.length];
            for (int i = 0; i < this.rows.length; ++i) {
                this.rows[i] = new Row(bLearnStationArray[i]);
            }
            this.updateRows();
            this.setCenter((BWidget)new BBorderPane((BWidget)this.table, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
            this.table.sortByColumn(0, true);
            this.relayout();
        }
        catch (LocalizableRuntimeException localizableRuntimeException) {
            BDialog.error((BWidget)this.getShell(), (String)BDialog.TITLE_ERROR, (Object)BDialog.TITLE_ERROR, (Throwable)localizableRuntimeException);
            BOptionDialog bOptionDialog = (BOptionDialog)this.getShell();
            bOptionDialog.close(2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void hyperlink(Row row) {
        this.result = row.toOrd();
        BDialog bDialog = (BDialog)this.getShell();
        bDialog.close();
    }

    public BOrd result() {
        if (this.result != null) {
            return this.result;
        }
        int n = this.table.getSelection().getRow();
        if (n >= 0) {
            return this.rows[n].toOrd();
        }
        return null;
    }

    public void computePreferredSize() {
        this.setPreferredSize(500.0, 400.0);
    }

    void updateRows() {
        Row[] rowArray = this.rows;
        boolean bl = this.useHostName.isSelected();
        for (int i = 0; i < rowArray.length; ++i) {
            rowArray[i].station.invariant(bl);
        }
        this.table.getModel().updateTable();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Row {
        BLearnStation station;

        Row(BLearnStation bLearnStation) {
            this.station = bLearnStation;
        }

        public Object valueAt(int n) {
            return this.station.get(BStationFinder.this.cols[n].prop);
        }

        public BOrd toOrd() {
            String string = BStationFinder.this.useHostName.isSelected() ? this.station.getHostName() : this.station.getHostAddress();
            return BOrd.make((String)("ip:" + string + "|" + this.station.getScheme() + ":" + this.station.getFoxPort()));
        }

        public BImage getIcon() {
            if (this.station.getScheme().equalsIgnoreCase("foxs")) {
                return foxsIcon;
            }
            return foxIcon;
        }
    }

    class Column {
        public String name;
        public Property prop;

        Column(Property property) {
            this.name = property.getDefaultDisplayName(null);
            this.prop = property;
        }
    }

    class Model
    extends TableModel {
        Model() {
        }

        public int getRowCount() {
            return BStationFinder.this.rows.length;
        }

        public int getColumnCount() {
            return BStationFinder.this.cols.length;
        }

        public String getColumnName(int n) {
            return BStationFinder.this.cols[n].name;
        }

        public Object getValueAt(int n, int n2) {
            return BStationFinder.this.rows[n].valueAt(n2);
        }

        public Object getSubject(int n) {
            return BStationFinder.this.rows[n];
        }

        public BImage getRowIcon(int n) {
            return BStationFinder.this.rows[n].getIcon();
        }

        public boolean isColumnSortable(int n) {
            return true;
        }

        public void sortByColumn(int n, boolean bl) {
            Object[] objectArray = new Object[BStationFinder.this.rows.length];
            for (int i = 0; i < BStationFinder.this.rows.length; ++i) {
                objectArray[i] = BStationFinder.this.rows[i].valueAt(n);
            }
            SortUtil.sort((Object[])objectArray, (Object[])BStationFinder.this.rows, (boolean)bl);
        }
    }

    class HostToggle
    extends ToggleCommandGroup {
        HostToggle() {
        }

        protected void selected(ToggleCommand toggleCommand) {
            lastUseHostName = toggleCommand == BStationFinder.this.useHostName;
            BStationFinder.this.updateRows();
        }
    }

    class Controller
    extends TableController {
        Controller() {
        }

        public void handleEnter(BKeyEvent bKeyEvent) {
            super.handleEnter(bKeyEvent);
            int n = this.getSelection().getRow();
            if (n >= 0) {
                BStationFinder.this.hyperlink(BStationFinder.this.rows[n]);
            }
        }

        public void cellDoubleClicked(BMouseEvent bMouseEvent, int n, int n2) {
            BStationFinder.this.hyperlink(BStationFinder.this.rows[n]);
        }

        public BMenu makeOptionsMenu() {
            BMenu bMenu = super.makeOptionsMenu();
            bMenu.add(null, (BValue)new BSeparator());
            bMenu.add(null, (BValue)new BRadioButtonMenuItem(BStationFinder.this.useHostName));
            bMenu.add(null, (BValue)new BRadioButtonMenuItem(BStationFinder.this.useHostAddress));
            return bMenu;
        }
    }

    class Selection
    extends TableSelection {
        Selection() {
        }

        public void updateTable() {
            BStationFinder.this.ok.setEnabled(this.getRow() >= 0);
            super.updateTable();
        }
    }
}

