/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.shell;

import com.tridium.ui.theme.Theme;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BMouseWheelEvent;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;

public class BScrollingWidgetPane
extends BEdgePane {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$shell$BScrollingWidgetPane == null ? (class$com$tridium$workbench$shell$BScrollingWidgetPane = BScrollingWidgetPane.class$("com.tridium.workbench.shell.BScrollingWidgetPane")) : class$com$tridium$workbench$shell$BScrollingWidgetPane));
    private ScrollThread scrollThread;
    private static final int FRAMES = 7;
    private static final int TICK_INTERVAL = 7;
    private double leftEdge;
    private double rightEdge;
    private double scrollSpeed;
    private BAbstractButton leftButton;
    private BAbstractButton rightButton;
    protected BGridPane gridPane;
    private int scroll;
    static /* synthetic */ Class class$com$tridium$workbench$shell$BScrollingWidgetPane;

    public Type getType() {
        return TYPE;
    }

    public BScrollingWidgetPane() {
        throw new IllegalStateException();
    }

    public BScrollingWidgetPane(BWidget bWidget) {
        this(1, bWidget);
    }

    public BScrollingWidgetPane(BWidget bWidget, double d) {
        this(bWidget);
        this.setScrollSpeed(d);
    }

    protected BScrollingWidgetPane(int n, BWidget bWidget) {
        this.leftButton = BAbstractButton.make((Command)new MoveLeftCommand(), (boolean)false, (boolean)true);
        this.leftButton.setButtonStyle(BButtonStyle.toolBar);
        this.rightButton = BAbstractButton.make((Command)new MoveRightCommand(), (boolean)false, (boolean)true);
        this.rightButton.setButtonStyle(BButtonStyle.toolBar);
        this.gridPane = new BGridPane(n);
        this.gridPane.setHalign(BHalign.center);
        this.gridPane.setColumnGap(0.0);
        this.gridPane.setRowAlign(BValign.fill);
        this.gridPane.add("fixed", (BValue)bWidget);
        this.setCenter((BWidget)this.gridPane);
        this.showHide();
        this.scrollSpeed = Theme.toolBar().getScrollSpeed();
    }

    public void doLayout(BWidget[] bWidgetArray) {
        this.gridPane.doLayout(this.gridPane.getChildWidgets());
        super.doLayout(bWidgetArray);
        this.reset();
        this.showHide();
    }

    private void showHide() {
        boolean bl = false;
        if (this.rightEdge > this.getWidth()) {
            if (this.getLeft().isNull()) {
                this.setLeft((BWidget)this.leftButton);
                bl = true;
            }
            if (this.getRight().isNull()) {
                this.setRight((BWidget)this.rightButton);
                bl = true;
            }
        } else {
            if (!this.getLeft().isNull()) {
                this.setLeft((BWidget)new BNullWidget());
                bl = true;
            }
            if (!this.getRight().isNull()) {
                this.setRight((BWidget)new BNullWidget());
                bl = true;
            }
        }
        if (bl) {
            this.doLayout(this.getChildWidgets());
        }
    }

    private void reset() {
        this.leftEdge = 0.0;
        this.rightEdge = this.getMaxX();
        this.updateButtonStatus();
    }

    public void setScrollSpeed(double d) {
        this.scrollSpeed = d;
    }

    private void startScroll() {
        if (this.scrollThread == null && this.scroll != 0) {
            this.scrollThread = new ScrollThread(this.gridPane.getChildWidgets());
            this.scrollThread.start();
        }
    }

    public void scrollLeft() {
        --this.scroll;
        this.startScroll();
    }

    public void scrollRight() {
        ++this.scroll;
        this.startScroll();
    }

    public void mouseWheel(BMouseWheelEvent bMouseWheelEvent) {
        int n = bMouseWheelEvent.getWheelRotation();
        if (n > 0) {
            this.scrollLeft();
        } else {
            this.scrollRight();
        }
    }

    private boolean canScrollLeft() {
        return this.rightEdge > this.gridPane.getWidth();
    }

    private boolean canScrollRight() {
        return this.leftEdge < 0.0;
    }

    private void updateButtonStatus() {
        this.leftButton.setEnabled(this.canScrollRight());
        this.rightButton.setEnabled(this.canScrollLeft());
    }

    private double getMaxX() {
        double d = 0.0;
        BWidget[] bWidgetArray = this.gridPane.getChildWidgets();
        for (int i = 0; i < bWidgetArray.length; ++i) {
            BWidget bWidget = bWidgetArray[i];
            double d2 = bWidget.getX() + bWidget.getWidth();
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class MoveRightCommand
    extends Command {
        public MoveRightCommand() {
            super((BWidget)BScrollingWidgetPane.this, UiLexicon.bajaui().module, "commands.moveRight");
        }

        public CommandArtifact doInvoke() {
            BScrollingWidgetPane.this.scrollLeft();
            return null;
        }
    }

    private class MoveLeftCommand
    extends Command {
        public MoveLeftCommand() {
            super((BWidget)BScrollingWidgetPane.this, UiLexicon.bajaui().module, "commands.moveLeft");
        }

        public CommandArtifact doInvoke() {
            BScrollingWidgetPane.this.scrollRight();
            return null;
        }
    }

    private class ScrollThread
    extends Thread {
        private BWidget[] widgets;

        public ScrollThread(BWidget[] bWidgetArray) {
            super("Ui:BScrollingToolbarPane.ScrollThread");
            this.widgets = bWidgetArray;
        }

        private double getLeftScroll() {
            double d = BScrollingWidgetPane.this.rightEdge - BScrollingWidgetPane.this.gridPane.getWidth();
            return -Math.min(d, BScrollingWidgetPane.this.scrollSpeed);
        }

        private double getRightScroll() {
            return Math.min(Math.abs(BScrollingWidgetPane.this.leftEdge), BScrollingWidgetPane.this.scrollSpeed);
        }

        private int[][] makeIntervals(double d) {
            int n;
            int[][] nArrayArray = new int[this.widgets.length][];
            double[] dArray = new double[7];
            for (n = 0; n < 7; ++n) {
                dArray[n] = d * (double)(n + 1) / 7.0;
            }
            for (n = 0; n < this.widgets.length; ++n) {
                int[] nArray = new int[7];
                for (int i = 0; i < 7; ++i) {
                    nArray[i] = (int)(this.widgets[n].getX() + dArray[i]);
                }
                nArrayArray[n] = nArray;
            }
            return nArrayArray;
        }

        private void doScroll(int[][] nArray) {
            for (int i = 0; i < 7; ++i) {
                for (int j = 0; j < this.widgets.length; ++j) {
                    BWidget bWidget = this.widgets[j];
                    bWidget.setBounds((double)nArray[j][i], bWidget.getY(), bWidget.getWidth(), bWidget.getHeight());
                }
                BScrollingWidgetPane.this.repaint();
                try {
                    Thread.sleep(7L);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            BScrollingWidgetPane.this.updateButtonStatus();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (BScrollingWidgetPane.this.scroll != 0) {
                    int n;
                    double d;
                    if (BScrollingWidgetPane.this.scroll < 0 && BScrollingWidgetPane.this.canScrollLeft()) {
                        d = this.getLeftScroll();
                        n = 1;
                    } else {
                        if (BScrollingWidgetPane.this.scroll <= 0 || !BScrollingWidgetPane.this.canScrollRight()) {
                            BScrollingWidgetPane.this.scroll = 0;
                            break;
                        }
                        d = this.getRightScroll();
                        n = -1;
                    }
                    BScrollingWidgetPane.this.leftEdge = BScrollingWidgetPane.this.leftEdge + d;
                    BScrollingWidgetPane.this.rightEdge = BScrollingWidgetPane.this.rightEdge + d;
                    BScrollingWidgetPane.this.scroll = BScrollingWidgetPane.this.scroll + n;
                    this.doScroll(this.makeIntervals(d));
                }
            }
            finally {
                BScrollingWidgetPane.this.scroll = 0;
                BScrollingWidgetPane.this.scrollThread = null;
            }
        }
    }
}

