/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.shell;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.shell.WbHistory;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.UiLexicon;

public class BRecentList
extends BEdgePane {
    public static final Action fullOrdChanged = BRecentList.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$shell$BRecentList == null ? (class$com$tridium$workbench$shell$BRecentList = BRecentList.class$("com.tridium.workbench.shell.BRecentList")) : class$com$tridium$workbench$shell$BRecentList));
    static BBrush altRowColor = BColor.make((int)220, (int)220, (int)220).toBrush();
    static boolean lastFullOrd = false;
    BCheckBox fullOrd;
    BTable table;
    Row[] rows;
    HyperlinkInfo result;
    static /* synthetic */ Class class$com$tridium$workbench$shell$BRecentList;

    public void fullOrdChanged() {
        this.invoke(fullOrdChanged, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BRecentList() {
        String string = UiLexicon.bajaui().getText("commands.recentOrds.showFullOrds");
        this.fullOrd = new BCheckBox(string, lastFullOrd);
        this.linkTo((BComponent)this.fullOrd, (Slot)BCheckBox.actionPerformed, (Slot)fullOrdChanged);
        this.table = new BTable((TableModel)new Model(), (TableController)new Controller());
        this.table.setHgridVisible(false);
        this.table.setCellRenderer((TableCellRenderer)new Renderer());
        this.table.setMultipleSelection(false);
        this.table.setHeaderVisible(false);
        this.setCenter((BWidget)new BBorderPane((BWidget)this.table, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        this.setBottom((BWidget)new BBorderPane((BWidget)this.fullOrd, 10.0, 10.0, 0.0, 10.0));
    }

    public void load(WbHistory.Entry[] entryArray) {
        this.rows = new Row[entryArray.length];
        for (int i = 0; i < this.rows.length; ++i) {
            this.rows[i] = new Row(entryArray[i].icon, entryArray[i].name, entryArray[i].ord);
        }
    }

    public void hyperlink(BInputEvent bInputEvent, Row row) {
        this.result = bInputEvent != null ? new HyperlinkInfo(row.ord, bInputEvent) : new HyperlinkInfo(row.ord);
        BDialog bDialog = (BDialog)this.getShell();
        bDialog.close();
    }

    public HyperlinkInfo result() {
        if (this.result != null) {
            return this.result;
        }
        int n = this.table.getSelection().getRow();
        if (n >= 0) {
            return new HyperlinkInfo(this.rows[n].ord);
        }
        return null;
    }

    public void computePreferredSize() {
        super.computePreferredSize();
        double d = this.getPreferredWidth();
        double d2 = this.getPreferredHeight();
        if (d < 300.0) {
            d = 300.0;
        }
        if (d2 < 150.0) {
            d2 = 150.0;
        }
        if (d2 > 260.0) {
            d2 = 260.0;
        }
        this.setPreferredSize(d, d2);
    }

    public void doFullOrdChanged() {
        this.table.sizeColumnsToFit();
        lastFullOrd = this.fullOrd.isSelected();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class Row {
        BImage icon;
        String name;
        BOrd ord;

        Row(BImage bImage, String string, BOrd bOrd) {
            this.icon = bImage;
            this.name = string;
            this.ord = bOrd;
        }
    }

    class Model
    extends TableModel {
        Model() {
        }

        public int getRowCount() {
            return BRecentList.this.rows.length;
        }

        public int getColumnCount() {
            return 1;
        }

        public String getColumnName(int n) {
            return "?";
        }

        public Object getValueAt(int n, int n2) {
            if (BRecentList.this.fullOrd.isSelected()) {
                return BRecentList.this.rows[n].ord;
            }
            return BRecentList.this.rows[n].name;
        }

        public Object getSubject(int n) {
            return BRecentList.this.rows[n];
        }

        public BImage getIcon(int n) {
            return BRecentList.this.rows[n].icon;
        }
    }

    class Renderer
    extends TableCellRenderer {
        Renderer() {
        }

        private BBrush getAltRowColor() {
            return Theme.table().getBandBrush((IStylable)this.getTable());
        }

        public BBrush getBackground(TableCellRenderer.Cell cell) {
            if (cell.row % 2 == 0) {
                return this.getAltRowColor();
            }
            return super.getBackground(cell);
        }

        public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
            return super.getPreferredCellWidth(cell) + 50.0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintCell(Graphics graphics, TableCellRenderer.Cell cell) {
            Row row = BRecentList.this.rows[cell.row];
            this.paintCellBackground(graphics, cell);
            BFont bFont = Theme.table().getCellFont();
            graphics.setFont(bFont);
            BImage bImage = row.icon;
            if (bImage != null) {
                graphics.drawImage(bImage, 4.0, (cell.height - 16.0) / 2.0);
            }
            String string = this.getCellText(cell);
            graphics.push();
            try {
                graphics.clip(0.0, 0.0, cell.width - 30.0, cell.height);
                graphics.drawString(string, 24.0, bFont.getAscent() + 2.0);
            }
            finally {
                graphics.pop();
            }
            if (cell.row < 26) {
                if (!cell.selected) {
                    graphics.setBrush(Theme.menuItem().getAcceleratorBrush());
                }
                graphics.setFont(Theme.menuItem().getAcceleratorFont());
                String string2 = String.valueOf((char)(65 + cell.row));
                graphics.drawString(string2, cell.width - 24.0, bFont.getAscent() + 2.0);
            }
        }
    }

    class Controller
    extends TableController {
        Controller() {
        }

        public void keyPressed(BKeyEvent bKeyEvent) {
            int n = bKeyEvent.getKeyCode();
            if (65 <= n && n < 65 + BRecentList.this.rows.length) {
                bKeyEvent.consume();
                BRecentList.this.hyperlink((BInputEvent)bKeyEvent, BRecentList.this.rows[n - 65]);
            } else if (n == 10) {
                int n2 = this.getSelection().getRow();
                if (n2 >= 0) {
                    bKeyEvent.consume();
                    BRecentList.this.hyperlink((BInputEvent)bKeyEvent, BRecentList.this.rows[n2]);
                }
            } else {
                super.keyPressed(bKeyEvent);
            }
        }

        public void cellDoubleClicked(BMouseEvent bMouseEvent, int n, int n2) {
            BRecentList.this.hyperlink((BInputEvent)bMouseEvent, BRecentList.this.rows[n]);
        }
    }
}

