/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.shell;

import com.tridium.ui.theme.custom.nss.StyleUtils;
import com.tridium.workbench.auth.BCnxConfigPane;
import com.tridium.workbench.shell.BPasswordField;
import javax.baja.gx.BImage;
import javax.baja.security.BPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.user.BPasswordStrength;
import javax.baja.util.Lexicon;

public class BPasswordResetDialog
extends BDialog {
    public static final Action okButtonPressed = BPasswordResetDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Action cancelButtonPressed = BPasswordResetDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Action setModified = BPasswordResetDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$shell$BPasswordResetDialog == null ? (class$com$tridium$workbench$shell$BPasswordResetDialog = BPasswordResetDialog.class$("com.tridium.workbench.shell.BPasswordResetDialog")) : class$com$tridium$workbench$shell$BPasswordResetDialog));
    private static Lexicon lex = Lexicon.make((String)"workbench");
    private static Lexicon bajaLex = Lexicon.make((String)"baja");
    private static final BImage logo = BImage.make((String)lex.get("cert.x32.icon", "module://icons/x32/lock.png"));
    protected BButton okButton;
    protected BButton cancelButton;
    private BPassword password = null;
    private BPasswordField passwordField = null;
    private BPasswordField confirmField = null;
    private BPasswordStrength strength = null;
    private String errMsg = null;
    static /* synthetic */ Class class$com$tridium$workbench$shell$BPasswordResetDialog;

    public void okButtonPressed(BWidgetEvent bWidgetEvent) {
        this.invoke(okButtonPressed, (BValue)bWidgetEvent, null);
    }

    public void cancelButtonPressed(BWidgetEvent bWidgetEvent) {
        this.invoke(cancelButtonPressed, (BValue)bWidgetEvent, null);
    }

    public void setModified(BWidgetEvent bWidgetEvent) {
        this.invoke(setModified, (BValue)bWidgetEvent, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static BPassword open(BWidget bWidget, BPasswordStrength bPasswordStrength, String string) {
        BPasswordResetDialog bPasswordResetDialog = new BPasswordResetDialog(bWidget, bPasswordStrength, string);
        bPasswordResetDialog.setBoundsCenteredOnOwner();
        bPasswordResetDialog.setResizable(false);
        bPasswordResetDialog.open();
        return bPasswordResetDialog.getPassword();
    }

    private BPasswordResetDialog(BWidget bWidget, BPasswordStrength bPasswordStrength, String string) {
        super(bWidget, "Reset Password", true);
        this.errMsg = string;
        this.strength = bPasswordStrength;
        this.setContent(this.buildDialog());
        this.setDefaultButton(this.okButton);
        try {
            bPasswordStrength.isPasswordValid("");
            this.okButton.setEnabled(true);
        }
        catch (Exception exception) {
            this.okButton.setEnabled(false);
        }
    }

    private BWidget buildDialog() {
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setTop(this.buildHeader());
        bEdgePane.setCenter(this.buildContent());
        return bEdgePane;
    }

    private BWidget buildHeader() {
        return new BWizardHeader(BCnxConfigPane.logo, this.getTitle(), "Set new account password");
    }

    private BWidget buildContent() {
        Object object;
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.setHalign(BHalign.fill);
        bGridPane.setColumnAlign(BHalign.fill);
        BGridPane bGridPane2 = new BGridPane(1);
        bGridPane2.setHalign(BHalign.fill);
        bGridPane2.setColumnAlign(BHalign.fill);
        if (this.errMsg != null) {
            object = new BLabel(this.errMsg, BHalign.left);
            StyleUtils.addStyleClass((IStylable)object, (String)"error");
            bGridPane2.add(null, (BValue)object);
        }
        bGridPane2.add(null, (BValue)new BLabel(bajaLex.getText("user.password.change.message"), BHalign.left));
        object = this.getPasswordRulesMessage();
        if (((String)object).length() > 0) {
            bGridPane2.add(null, (BValue)new BLabel(bajaLex.getText("user.password.notStrong"), BHalign.left));
            bGridPane2.add(null, (BValue)new BLabel((String)object, BHalign.left));
        }
        bGridPane.add(null, (BValue)new BBorderPane((BWidget)bGridPane2, 0.0, 0.0, 7.0, 0.0));
        bGridPane.add(null, (BValue)this.buildBody());
        bGridPane.add(null, (BValue)this.buildButtons());
        return new BBorderPane((BWidget)bGridPane, 7.0, 30.0, 7.0, 30.0);
    }

    private BWidget buildBody() {
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.setRowGap(5.0);
        bGridPane.setColumnGap(5.0);
        bGridPane.setColumnAlign(BHalign.left);
        bGridPane.setStretchColumn(1);
        bGridPane.add(null, (BValue)new BLabel(lex.get("password.field.password", "Password")));
        this.passwordField = new BPasswordField();
        bGridPane.add(null, (BValue)this.passwordField);
        bGridPane.add(null, (BValue)new BLabel(lex.get("password.field.confirm", "Confirm")));
        this.confirmField = new BPasswordField();
        bGridPane.add(null, (BValue)this.confirmField);
        this.linkTo(null, (BComponent)this.passwordField, (Slot)BPasswordField.textModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.confirmField, (Slot)BPasswordField.textModified, (Slot)setModified);
        return bGridPane;
    }

    private String getPasswordRulesMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.strength.getMinimumLength() > 0) {
            stringBuffer.append(" - ").append(bajaLex.getText("user.password.notLongEnough", (Object[])new String[]{this.strength.getMinimumLength() + ""})).append("\n");
        }
        if (this.strength.getMinimumDigits() > 0) {
            stringBuffer.append(" - ").append(bajaLex.getText("user.password.notEnoughDigits", (Object[])new String[]{this.strength.getMinimumDigits() + ""})).append("\n");
        }
        if (this.strength.getMinimumLowerCase() > 0) {
            stringBuffer.append(" - ").append(bajaLex.getText("user.password.notEnoughLowerCase", (Object[])new String[]{this.strength.getMinimumLowerCase() + ""})).append("\n");
        }
        if (this.strength.getMinimumUpperCase() > 0) {
            stringBuffer.append(" - ").append(bajaLex.getText("user.password.notEnoughUpperCase", (Object[])new String[]{this.strength.getMinimumUpperCase() + ""})).append("\n");
        }
        if (this.strength.getMinimumSpecial() > 0) {
            stringBuffer.append(" - ").append(bajaLex.getText("user.password.notEnoughSpecial", (Object[])new String[]{this.strength.getMinimumSpecial() + ""})).append("\n");
        }
        return stringBuffer.toString();
    }

    private BWidget buildButtons() {
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.setColumnAlign(BHalign.fill);
        bGridPane.setUniformColumnWidth(true);
        this.okButton = new BButton(UiLexicon.bajaui().getText("dialog.ok"));
        bGridPane.add(null, (BValue)this.okButton);
        this.linkTo("linkA", (BComponent)this.okButton, (Slot)BButton.actionPerformed, (Slot)okButtonPressed);
        this.okButton.setEnabled(false);
        this.cancelButton = new BButton(UiLexicon.bajaui().getText("dialog.cancel"));
        bGridPane.add(null, (BValue)this.cancelButton);
        this.linkTo("linkC", (BComponent)this.cancelButton, (Slot)BButton.actionPerformed, (Slot)cancelButtonPressed);
        return new BBorderPane((BWidget)bGridPane, 7.0, 0.0, 0.0, 0.0);
    }

    public void windowClosing(BWindowEvent bWindowEvent) {
        this.close();
    }

    public BPassword getPassword() {
        return this.password;
    }

    public void doOkButtonPressed(BWidgetEvent bWidgetEvent) throws Exception {
        this.password = BPassword.make((String)this.confirmField.getText());
        this.close();
    }

    public void doCancelButtonPressed(BWidgetEvent bWidgetEvent) {
        this.close();
    }

    public void doSetModified(BWidgetEvent bWidgetEvent) {
        try {
            if (this.passwordField.getText().equals(this.confirmField.getText()) && this.isStrongPassword(this.passwordField.getText())) {
                this.okButton.setEnabled(true);
            } else {
                this.okButton.setEnabled(false);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean isStrongPassword(String string) {
        try {
            this.strength.isPasswordValid(string);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

