/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.shell;

import com.tridium.ui.NiagaraWbShell;
import com.tridium.ui.ShellManager;
import com.tridium.ui.ShellPeer;
import com.tridium.ui.theme.palladium.PalladiumWidgetTheme;
import com.tridium.util.ThrowableUtil;
import com.tridium.workbench.auth.AuthUtil;
import com.tridium.workbench.bql.builder.BBqlQueryBuilder;
import com.tridium.workbench.console.BConsole;
import com.tridium.workbench.file.BTextFileEditor;
import com.tridium.workbench.shell.BErrorPanel;
import com.tridium.workbench.shell.BFontSize;
import com.tridium.workbench.shell.BGeneralOptions;
import com.tridium.workbench.shell.BIRebootable;
import com.tridium.workbench.shell.BNiagaraWbApplet;
import com.tridium.workbench.shell.BNiagaraWbFrame;
import com.tridium.workbench.shell.BNiagaraWbWebStartShell;
import com.tridium.workbench.shell.BSaveAllDialog;
import com.tridium.workbench.shell.BSideBarPane;
import com.tridium.workbench.shell.BViewTab;
import com.tridium.workbench.shell.BViewTabbedPane;
import com.tridium.workbench.shell.BWbApplication;
import com.tridium.workbench.shell.BWbPane;
import com.tridium.workbench.shell.NHyperlinkInfo;
import com.tridium.workbench.shell.WbCommands;
import com.tridium.workbench.shell.WbHistory;
import com.tridium.workbench.shell.WbMain;
import com.tridium.workbench.sidebars.BNavSideBar;
import java.io.File;
import java.net.ConnectException;
import java.net.UnknownHostException;
import javax.baja.file.BFileSystem;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.license.LicenseException;
import javax.baja.log.Log;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavEvent;
import javax.baja.nav.NavListener;
import javax.baja.security.AuthenticationException;
import javax.baja.security.AuthenticationRealm;
import javax.baja.security.BICredentials;
import javax.baja.security.PermissionException;
import javax.baja.sys.BObject;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BHyperlinkMode;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.file.BDirectoryChooser;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.BWbProfile;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.sidebar.BWbSideBar;
import javax.baja.workbench.view.BWbView;

public abstract class BNiagaraWbShell
extends BWbShell
implements NiagaraWbShell,
ShellManager.ShellPeerFactory,
NavListener {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$shell$BNiagaraWbShell == null ? (class$com$tridium$workbench$shell$BNiagaraWbShell = BNiagaraWbShell.class$("com.tridium.workbench.shell.BNiagaraWbShell")) : class$com$tridium$workbench$shell$BNiagaraWbShell));
    static Log log;
    static String statusDefault;
    static BImage errorIcon;
    static WbHistory history;
    public final BWbProfile profile;
    public final WbCommands commands;
    public final BWbPane pane;
    public BFileChooser fileChooser;
    public BDirectoryChooser dirChooser;
    public BBqlQueryBuilder bqlBuilder;
    static /* synthetic */ Class class$com$tridium$workbench$shell$BNiagaraWbShell;

    public Type getType() {
        return TYPE;
    }

    BNiagaraWbShell(Type type) {
        this.profile = BWbProfile.make(this, type);
        this.commands = new WbCommands(this);
        this.pane = new BWbPane(this);
        this.setContent((BWidget)this.pane);
    }

    BNiagaraWbShell(Type type, ShellPeer shellPeer) {
        super(shellPeer);
        this.profile = BWbProfile.make(this, type);
        this.commands = new WbCommands(this);
        this.pane = new BWbPane(this);
        this.setContent((BWidget)this.pane);
    }

    abstract void doShowStatus(String var1);

    BSideBarPane makeSideBar() {
        return new BSideBarPane();
    }

    public Command getRefreshCommand() {
        return this.commands.refresh;
    }

    public Command getSaveCommand() {
        return this.commands.save;
    }

    public Command getExportCommand() {
        return this.commands.export;
    }

    public Command getBackCommand() {
        return this.commands.back;
    }

    public Command getForwardCommand() {
        return this.commands.forward;
    }

    public Command getLogoffCommand() {
        return this.commands.logoff;
    }

    public final BWbProfile getProfile() {
        return this.profile;
    }

    public final void showStatus(String string) {
        if (string == null) {
            string = statusDefault;
        }
        this.doShowStatus(string);
    }

    public final BOrd getActiveOrd() {
        return this.tab().ord;
    }

    public final OrdTarget getActiveOrdTarget() {
        return this.tab().target;
    }

    public final BWbView getActiveView() {
        return this.tab().view;
    }

    public void updateCommandStates(BWbView bWbView) {
        this.commands.updateView(bWbView);
    }

    public void exitBusy() {
        super.exitBusy();
        this.commands.updateSaveBog();
    }

    public void debug() {
    }

    public final boolean isRemoteWebShell() {
        return this.isApplet() || this.isWebStart();
    }

    public final boolean isApplet() {
        return this instanceof BNiagaraWbApplet;
    }

    public final boolean isWebStart() {
        return this instanceof BNiagaraWbWebStartShell;
    }

    public final boolean isFrame() {
        return this instanceof BNiagaraWbFrame;
    }

    public void updateTransferWidgetStates() {
        if (this.tab().view != null) {
            this.tab().view.updateTransferWidgetStates();
        }
    }

    public static BWbApplication app() {
        return (BWbApplication)BNiagaraWbShell.getApplication();
    }

    public String getSelectedText() {
        BTextFileEditor bTextFileEditor;
        String string;
        if (this.tab().view instanceof BTextFileEditor && (string = (bTextFileEditor = (BTextFileEditor)this.tab().view).getSelectedText()) != null && (string = string.trim()).length() > 0) {
            return string;
        }
        return null;
    }

    public void started() throws Exception {
        super.started();
        BNavRoot.INSTANCE.addNavListener((NavListener)this);
    }

    public void stopped() throws Exception {
        super.stopped();
        BNavRoot.INSTANCE.removeNavListener((NavListener)this);
    }

    public void setModified(BWbPlugin bWbPlugin) {
        if (bWbPlugin == this.tab().view) {
            this.commands.save.setEnabled(true);
        }
    }

    public void clearModified(BWbPlugin bWbPlugin) {
        if (bWbPlugin == this.tab().view) {
            this.commands.save.setEnabled(false);
        }
    }

    public void navEvent(NavEvent navEvent) {
        this.commands.updateSaveBog();
        if (navEvent.getId() == 2 || navEvent.getId() == 5) {
            this.checkTabsForRemoveEvent(navEvent);
        }
    }

    private void checkTabsForRemoveEvent(NavEvent navEvent) {
        BViewTab[] bViewTabArray = this.pane.views.getTabs();
        boolean bl = false;
        for (int i = 0; i < bViewTabArray.length; ++i) {
            BISession bISession;
            BViewTab bViewTab = bViewTabArray[i];
            BOrd bOrd = bViewTab.ord;
            if (bOrd == null || bViewTab.getTarget() == null) continue;
            OrdTarget ordTarget = bViewTab.getTarget();
            BObject bObject = ordTarget == null ? null : ordTarget.get();
            BISession bISession2 = bISession = bObject == null ? null : BOrd.toSession((BObject)bObject);
            if (bViewTab.view instanceof BIRebootable && ((BIRebootable)((Object)bViewTab.view)).isRebooting()) continue;
            if (bISession != null && !bISession.isConnected()) {
                bl = true;
                bViewTab.stopView(false);
                this.error(bViewTab, bOrd, (Throwable)new LocalizableException("bajaui", "errorPanel.disconnected"), false);
                continue;
            }
            if (!WbMain.isRemoved(navEvent, bOrd)) continue;
            bl = true;
            bViewTab.stopView(false);
            this.error(bViewTab, bOrd, (Throwable)new LocalizableException("bajaui", "errorPanel.targetRemoved"), false);
        }
        if (bl) {
            this.tab().updateShell();
            this.relayout();
        }
    }

    void autoLogoff() {
    }

    public final boolean confirmClose() {
        String string = UiLexicon.bajaui().getText("saveBeforeClose");
        int n = BSaveAllDialog.saveTabs(this, string);
        return n != 2;
    }

    public void hyperlink(File file, int n, int n2, int n3, int n4) {
        BWbView bWbView;
        BOrd bOrd = BFileSystem.INSTANCE.localFileToOrd(file);
        BViewTab[] bViewTabArray = this.pane.views.getTabs();
        for (int i = 0; i < bViewTabArray.length; ++i) {
            if (bViewTabArray[i].ord == null || !bViewTabArray[i].ord.equals((Object)bOrd) || this.tab() == bViewTabArray[i]) continue;
            this.pane.views.selectLabelPane(bViewTabArray[i]);
        }
        if (!this.tab().ord.equals((Object)bOrd)) {
            this.hyperlink(bOrd);
        }
        if ((bWbView = this.getActiveView()) instanceof BTextFileEditor) {
            ((BTextFileEditor)bWbView).highlight(n, n2, n3, n4);
        }
    }

    public void hyperlink(HyperlinkInfo hyperlinkInfo) {
        this.doHyperlink(hyperlinkInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void doHyperlink(HyperlinkInfo hyperlinkInfo) {
        this.showStatus("");
        NHyperlinkInfo nHyperlinkInfo = NHyperlinkInfo.make(hyperlinkInfo);
        if (nHyperlinkInfo.getMode() == BHyperlinkMode.newShell) {
            WbMain.openFrame((BNiagaraWbFrame)this, nHyperlinkInfo.getOrd(), this.profile.getType());
            return;
        }
        BViewTab bViewTab = this.tab();
        if (nHyperlinkInfo.getMode() == BHyperlinkMode.newTab) {
            bViewTab = this.pane.views.addTab();
        } else if (!this.confirmHyperlink()) {
            return;
        }
        if (!this.profile.canHyperlink(nHyperlinkInfo.getOrd())) {
            this.error(bViewTab, nHyperlinkInfo.getOrd(), (Throwable)new LocalizableException("bajaui", "errorPanel.ordNotAccessible"), true);
            return;
        }
        ShellManager shellManager = (ShellManager)this.widgetSupport(null);
        this.enterBusy();
        try {
            nHyperlinkInfo.hyperlink(bViewTab);
        }
        catch (Throwable throwable) {
            this.error(bViewTab, nHyperlinkInfo.getOrd(), throwable, true);
        }
        finally {
            this.exitBusy();
        }
    }

    public final boolean confirmHyperlink() {
        return this.confirmHyperlink(this.tab());
    }

    public final boolean confirmHyperlink(BViewTab bViewTab) {
        if (bViewTab.view != null && bViewTab.view.isModified()) {
            int n;
            String string = UiLexicon.bajaui().getText("confirmHyperlink.message", new Object[]{bViewTab.getDisplayName()});
            int n2 = BDialog.confirm((BWidget)this, null, (Object)string, (int)(n = 14));
            if (n2 == 2) {
                return false;
            }
            if (n2 == 4) {
                this.save(bViewTab.view);
                if (bViewTab.view.isModified()) {
                    return false;
                }
            }
        }
        return true;
    }

    public void syncTree() {
        this.syncTree(false);
    }

    public void syncTree(boolean bl) {
        if (this.getProfile().hasSideBar()) {
            try {
                BWbSideBar[] bWbSideBarArray = this.pane.sideBar.list();
                for (int i = 0; i < bWbSideBarArray.length; ++i) {
                    if (!(bWbSideBarArray[i] instanceof BNavSideBar)) continue;
                    ((BNavSideBar)bWbSideBarArray[i]).syncTree(bl);
                    return;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void initShell() {
        ((ShellManager)this.widgetSupport(null)).activate();
    }

    public void shutdownShell() {
        BViewTab[] bViewTabArray = this.pane.views.getTabs();
        for (int i = 0; i < bViewTabArray.length; ++i) {
            bViewTabArray[i].stopView(true);
        }
        ((ShellManager)this.widgetSupport(null)).deactivate();
    }

    public OrdTarget resolve(BOrd bOrd, BICredentials bICredentials) throws Exception {
        BICredentials bICredentials2 = bICredentials;
        AuthenticationRealm authenticationRealm = null;
        boolean bl = false;
        int n = 0;
        while (true) {
            try {
                BISession bISession;
                BOrd bOrd2;
                BWbProfile bWbProfile;
                if (authenticationRealm != null) {
                    bICredentials2 = authenticationRealm.getCredentials();
                }
                OrdTarget ordTarget = bOrd.resolve();
                if (bl && (bWbProfile = this.getProfile()) != null && (bOrd2 = bWbProfile.getOpenOrd(bISession = BOrd.toSession((BObject)ordTarget.get()), bOrd)) != null) {
                    bOrd = bOrd2;
                    ordTarget = bOrd2.resolve();
                }
                return ordTarget;
            }
            catch (AuthenticationException authenticationException) {
                bl = true;
                authenticationRealm = authenticationException.getAuthenticationRealm();
                if (bICredentials != null && authenticationException.getAuthenticationRealm() != null) {
                    authenticationRealm.setCredentials(bICredentials);
                    bICredentials = null;
                } else if (n == 0 && WbMain.kioskCredentials != null) {
                    authenticationRealm.setCredentials(WbMain.kioskCredentials);
                } else if (!(n == 0 && AuthUtil.resolveSSO(authenticationException) || AuthUtil.handleAuthResponse(authenticationException, this, bICredentials2) || AuthUtil.challenge((BWidget)this, authenticationException, n > 1))) {
                    throw authenticationException;
                }
                ++n;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(BWbView bWbView) {
        this.enterBusy();
        try {
            bWbView.saveValue();
        }
        catch (Throwable throwable) {
            Object object;
            Throwable throwable2 = throwable;
            String string = UiLexicon.bajaui().getText("plugin.save.error");
            if (throwable instanceof CannotSaveException) {
                object = (CannotSaveException)((Object)throwable);
                if (object.isSilent()) {
                    return;
                }
                string = throwable.getMessage();
                throwable2 = ((CannotSaveException)((Object)throwable)).getCause();
                if (throwable2 == null) {
                    throwable2 = throwable;
                }
            }
            throwable2.printStackTrace();
            object = UiLexicon.bajaui().getText("dialog.error");
            BDialog.error((BWidget)this, (String)object, (Object)string, (Throwable)throwable);
            this.repaint();
            return;
        }
        finally {
            this.exitBusy();
        }
        this.commands.updateSaveBog();
        this.commands.save.setEnabled(false);
        this.repaint();
    }

    void error(BViewTab bViewTab, BOrd bOrd, Throwable throwable, boolean bl) {
        String string = null;
        if (throwable instanceof UnresolvedException) {
            Throwable throwable2 = ThrowableUtil.getCause((Throwable)throwable);
            string = this.exceptionToMessage(throwable2);
            if (string == null) {
                string = this.exceptionToMessage(throwable);
            }
        } else {
            string = this.exceptionToMessage(throwable);
        }
        if (string == null) {
            string = UiLexicon.bajaui().getText("errorPanel.cannotHyperlink");
        }
        this.error(bViewTab, bOrd, string, throwable, bl);
    }

    void error(BViewTab bViewTab, BOrd bOrd, String string, Throwable throwable, boolean bl) {
        if (bl) {
            log.error(string, throwable);
        }
        this.showStatus(string);
        String string2 = BViewTabbedPane.toTabName(bOrd, null);
        BImage bImage = errorIcon;
        bViewTab.fault = null;
        bViewTab.setLabel(new BLabel(bImage, string2));
        Object object = null;
        BWbProfile bWbProfile = this.getProfile();
        if (bWbProfile != null) {
            object = bWbProfile.makeErrorDisplay(this, string, bOrd, throwable);
        }
        if (object == null) {
            object = new BErrorPanel(this, string, bOrd, throwable);
        }
        bViewTab.setContent((BWidget)object);
        bViewTab.relayout();
    }

    private String exceptionToMessage(Throwable throwable) {
        UiLexicon uiLexicon = UiLexicon.bajaui();
        if (throwable instanceof LocalizableException) {
            return throwable.getMessage();
        }
        if (throwable instanceof LocalizableRuntimeException) {
            return throwable.getMessage();
        }
        if (throwable instanceof UnresolvedException) {
            return uiLexicon.getText("errorPanel.targetNotFound");
        }
        if (throwable instanceof AuthenticationException) {
            return uiLexicon.getText("errorPanel.failedToAuthenticate");
        }
        if (throwable instanceof PermissionException) {
            return uiLexicon.getText("errorPanel.noPermission");
        }
        if (throwable instanceof LicenseException) {
            return uiLexicon.getText("errorPanel.license", new Object[]{throwable.getMessage()});
        }
        if (throwable instanceof ConnectException) {
            return uiLexicon.getText("errorPanel.connect");
        }
        if (throwable instanceof UnknownHostException) {
            return uiLexicon.getText("errorPanel.unknownHost", new Object[]{throwable.getMessage()});
        }
        return null;
    }

    public BConsole getConsole() {
        return this.pane.console;
    }

    public BConsole openConsole() {
        this.commands.console.setSelected(true);
        this.pane.console.appendBreak();
        this.relayout();
        return this.pane.console;
    }

    public BViewTab tab() {
        return this.pane.views.tab();
    }

    private static BFont incFontSize(BFont bFont) {
        return BFont.make((String)bFont.getName(), (double)(bFont.getSize() + 4.0), (int)bFont.getStyle());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (BGeneralOptions.make().getFontSize() == BFontSize.large) {
            PalladiumWidgetTheme.plainText = BNiagaraWbShell.incFontSize(PalladiumWidgetTheme.plainText);
            PalladiumWidgetTheme.boldText = BNiagaraWbShell.incFontSize(PalladiumWidgetTheme.boldText);
            PalladiumWidgetTheme.largeFont = BNiagaraWbShell.incFontSize(PalladiumWidgetTheme.largeFont);
            PalladiumWidgetTheme.largeBoldFont = BNiagaraWbShell.incFontSize(PalladiumWidgetTheme.largeBoldFont);
            PalladiumWidgetTheme.fixedWidth = BNiagaraWbShell.incFontSize(PalladiumWidgetTheme.fixedWidth);
            PalladiumWidgetTheme.fixedWidthBold = BNiagaraWbShell.incFontSize(PalladiumWidgetTheme.fixedWidthBold);
        }
        log = Log.getLog((String)"wb.shell");
        statusDefault = "";
        errorIcon = BImage.make((String)"module://icons/x16/error.png");
        history = new WbHistory();
    }

    static class Support {
        BNiagaraWbShell shell;
        BWbProfile profile;

        Support(BNiagaraWbShell bNiagaraWbShell) {
            this.shell = bNiagaraWbShell;
            this.profile = bNiagaraWbShell.profile;
        }
    }
}

