/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.shell;

import com.tridium.sys.Nre;
import com.tridium.sys.NreLib;
import com.tridium.ui.theme.custom.CustomThemeModuleManager;
import com.tridium.ui.theme.custom.nss.NSSUtils;
import com.tridium.util.TimeFormat;
import com.tridium.workbench.shell.BFontSize;
import java.io.File;
import java.io.FileInputStream;
import java.util.Locale;
import java.util.Properties;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.options.BUserOptions;
import javax.baja.units.BUnitConversion;

public class BGeneralOptions
extends BUserOptions {
    public static final Property timeFormat = BGeneralOptions.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldEditor", (String)"workbench:TimeFormatFE"));
    public static final Property unitConversion = BGeneralOptions.newProperty((int)0, (BValue)BUnitConversion.none, null);
    public static final Property autoLogoffEnabled = BGeneralOptions.newProperty((int)0, (boolean)false, null);
    public static final Property autoLogoffPeriod = BGeneralOptions.newProperty((int)0, (BValue)BRelTime.make((long)900000L), null);
    public static final Property promptForNameOnInsert = BGeneralOptions.newProperty((int)0, (boolean)true, null);
    public static final Property useAntiAlias = BGeneralOptions.newProperty((int)4, (boolean)true, null);
    public static final Property fontSize = BGeneralOptions.newProperty((int)0, (BValue)BFontSize.normal, null);
    public static final Property activeTheme = BGeneralOptions.newProperty((int)0, (BValue)BDynamicEnum.DEFAULT, null);
    public static final Property allowUserCredentialCaching = BGeneralOptions.newProperty((int)0, (boolean)true, null);
    public static final Property locale = BGeneralOptions.newProperty((int)2, (String)Locale.getDefault().toString(), (BFacets)BFacets.make((String[])new String[]{"min", "fieldWidth"}, (BIDataValue[])new BInteger[]{BInteger.make((int)2), BInteger.make((int)8)}));
    public static final Property isDefaultConnectionTypeSsl = BGeneralOptions.newProperty((int)4, (boolean)true, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$shell$BGeneralOptions == null ? (class$com$tridium$workbench$shell$BGeneralOptions = BGeneralOptions.class$("com.tridium.workbench.shell.BGeneralOptions")) : class$com$tridium$workbench$shell$BGeneralOptions));
    private static BGeneralOptions options;
    private static String brandThemeDefault;
    private static boolean brandThemeLocked;
    static /* synthetic */ Class class$com$tridium$workbench$shell$BGeneralOptions;

    public String getTimeFormat() {
        return this.getString(timeFormat);
    }

    public void setTimeFormat(String string) {
        this.setString(timeFormat, string, null);
    }

    public BUnitConversion getUnitConversion() {
        return (BUnitConversion)this.get(unitConversion);
    }

    public void setUnitConversion(BUnitConversion bUnitConversion) {
        this.set(unitConversion, (BValue)bUnitConversion, null);
    }

    public boolean getAutoLogoffEnabled() {
        return this.getBoolean(autoLogoffEnabled);
    }

    public void setAutoLogoffEnabled(boolean bl) {
        this.setBoolean(autoLogoffEnabled, bl, null);
    }

    public BRelTime getAutoLogoffPeriod() {
        return (BRelTime)this.get(autoLogoffPeriod);
    }

    public void setAutoLogoffPeriod(BRelTime bRelTime) {
        this.set(autoLogoffPeriod, (BValue)bRelTime, null);
    }

    public boolean getPromptForNameOnInsert() {
        return this.getBoolean(promptForNameOnInsert);
    }

    public void setPromptForNameOnInsert(boolean bl) {
        this.setBoolean(promptForNameOnInsert, bl, null);
    }

    public boolean getUseAntiAlias() {
        return this.getBoolean(useAntiAlias);
    }

    public void setUseAntiAlias(boolean bl) {
        this.setBoolean(useAntiAlias, bl, null);
    }

    public BFontSize getFontSize() {
        return (BFontSize)this.get(fontSize);
    }

    public void setFontSize(BFontSize bFontSize) {
        this.set(fontSize, (BValue)bFontSize, null);
    }

    public BDynamicEnum getActiveTheme() {
        return (BDynamicEnum)this.get(activeTheme);
    }

    public void setActiveTheme(BDynamicEnum bDynamicEnum) {
        this.set(activeTheme, (BValue)bDynamicEnum, null);
    }

    public boolean getAllowUserCredentialCaching() {
        return this.getBoolean(allowUserCredentialCaching);
    }

    public void setAllowUserCredentialCaching(boolean bl) {
        this.setBoolean(allowUserCredentialCaching, bl, null);
    }

    public String getLocale() {
        return this.getString(locale);
    }

    public void setLocale(String string) {
        this.setString(locale, string, null);
    }

    public boolean getIsDefaultConnectionTypeSsl() {
        return this.getBoolean(isDefaultConnectionTypeSsl);
    }

    public void setIsDefaultConnectionTypeSsl(boolean bl) {
        this.setBoolean(isDefaultConnectionTypeSsl, bl, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static BGeneralOptions make() {
        if (options == null) {
            BGeneralOptions.loadBrand();
            options = (BGeneralOptions)BGeneralOptions.load((Type)TYPE);
            NSSUtils.setIncreaseFontSize((options.getFontSize() == BFontSize.large ? 1 : 0) != 0);
            BDynamicEnum bDynamicEnum = options.getActiveTheme();
            String string = bDynamicEnum.getTag();
            Slot slot = options.getSlot("activeTheme");
            int n = options.getFlags(slot);
            if (brandThemeLocked) {
                options.setFlags(slot, n | 4);
                if (brandThemeDefault != null) {
                    string = brandThemeDefault;
                }
            } else {
                boolean bl;
                options.setFlags(slot, n & 0xFFFFFFFB);
                boolean bl2 = bl = string == null || string.equals("0") && bDynamicEnum.getRange().isNull();
                if (brandThemeDefault != null && bl) {
                    string = brandThemeDefault;
                }
            }
            options.setActiveTheme(CustomThemeModuleManager.getModuleEnumForTag((String)string));
        }
        return options;
    }

    private static void loadBrand() {
        File file = new File(Sys.getBajaHome(), "lib" + File.separator + "brand.properties");
        try {
            Properties properties = new Properties();
            FileInputStream fileInputStream = new FileInputStream(file);
            properties.load(fileInputStream);
            fileInputStream.close();
            brandThemeDefault = properties.getProperty("workbench.theme.default", "Lucid");
            brandThemeLocked = "true".equals(properties.getProperty("workbench.theme.locked"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        this.apply();
    }

    public void initFromUserFacets(BFacets bFacets) {
        int n;
        String string = bFacets.gets("timeFormat", null);
        if (string != null) {
            this.setTimeFormat(string);
        }
        if ((n = bFacets.geti("unitConversion", -1)) != -1) {
            this.setUnitConversion(BUnitConversion.make((int)n));
        }
    }

    public void apply() {
        TimeFormat.setDefaultPattern((String)this.getTimeFormat());
        Nre.unitConversion = this.getUnitConversion().getOrdinal();
        if (!this.getLocale().equalsIgnoreCase(Locale.getDefault().toString())) {
            NreLib.setSystemProperty((String)"niagara.lang", (String)this.getLocale());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        brandThemeLocked = false;
    }
}

