/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.service;

import com.tridium.workbench.service.BWbServiceManager;
import javax.baja.gx.BImage;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BIcon;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.workbench.tool.BWbNavNodeTool;
import javax.baja.workbench.tool.BWbService;

public class BWbServiceSpec
extends BStruct {
    public static final Property serviceType = BWbServiceSpec.newProperty((int)0, (BValue)BTypeSpec.NULL, null);
    public static final Property installed = BWbServiceSpec.newProperty((int)2, (boolean)false, null);
    public static final Property autoStart = BWbServiceSpec.newProperty((int)0, (boolean)false, null);
    public static final Property running = BWbServiceSpec.newProperty((int)2, (boolean)false, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$service$BWbServiceSpec == null ? (class$com$tridium$workbench$service$BWbServiceSpec = BWbServiceSpec.class$("com.tridium.workbench.service.BWbServiceSpec")) : class$com$tridium$workbench$service$BWbServiceSpec));
    static final BImage defaultIcon = BImage.make((String)"module://icons/x16/gears.png");
    TypeInfo typeInfo;
    BImage icon;
    static /* synthetic */ Class class$com$tridium$workbench$service$BWbServiceSpec;

    public BTypeSpec getServiceType() {
        return (BTypeSpec)this.get(serviceType);
    }

    public void setServiceType(BTypeSpec bTypeSpec) {
        this.set(serviceType, (BValue)bTypeSpec, null);
    }

    public boolean getInstalled() {
        return this.getBoolean(installed);
    }

    public void setInstalled(boolean bl) {
        this.setBoolean(installed, bl, null);
    }

    public boolean getAutoStart() {
        return this.getBoolean(autoStart);
    }

    public void setAutoStart(boolean bl) {
        this.setBoolean(autoStart, bl, null);
    }

    public boolean getRunning() {
        return this.getBoolean(running);
    }

    public void setRunning(boolean bl) {
        this.setBoolean(running, bl, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BWbService getService() {
        return (BWbService)BWbNavNodeTool.make(this.getServiceType().toString());
    }

    public void start() {
        if (this.getRunning()) {
            return;
        }
        try {
            this.getService().serviceStarted();
            BWbServiceManager.log.message("Started service " + this.getServiceType());
        }
        catch (Exception exception) {
            BWbServiceManager.log.error("Cannot start service " + this.getServiceType(), (Throwable)exception);
        }
        this.setRunning(true);
    }

    public void stop() {
        if (!this.getRunning()) {
            return;
        }
        try {
            this.getService().serviceStopped();
            BWbServiceManager.log.message("Stopped service " + this.getServiceType());
        }
        catch (Exception exception) {
            BWbServiceManager.log.error("Cannot stop service " + this.getServiceType(), (Throwable)exception);
        }
        this.setRunning(false);
    }

    public void updateAutoStart(boolean bl) {
        this.setAutoStart(bl);
        BWbServiceManager.make().save();
        if (bl) {
            this.start();
        }
    }

    public BImage getServiceIcon() {
        if (this.icon == null) {
            BIcon bIcon;
            if (this.typeInfo != null && (bIcon = this.typeInfo.getIcon(null)) != null) {
                this.icon = BImage.make((BIcon)bIcon);
            }
            if (this.icon == null) {
                this.icon = defaultIcon;
            }
        }
        return this.icon;
    }

    public String toString(Context context) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getServiceType()).append("; ").append(this.getInstalled() ? "installed" : "uninstalled").append("; ").append(this.getAutoStart() ? "autoStart" : "manualStart").append("; ").append(this.getRunning() ? "running" : "stopped");
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

