/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.service;

import com.tridium.workbench.service.BWbServiceManager;
import com.tridium.workbench.service.BWbServiceSpec;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.util.BTitlePane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.view.BWbView;

public class BWbServiceManagerView
extends BWbView {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$service$BWbServiceManagerView == null ? (class$com$tridium$workbench$service$BWbServiceManagerView = BWbServiceManagerView.class$("com.tridium.workbench.service.BWbServiceManagerView")) : class$com$tridium$workbench$service$BWbServiceManagerView));
    static final int COL_SERVICE = 0;
    static final int COL_INSTALLED = 1;
    static final int COL_AUTO_START = 2;
    static final int COL_RUNNING = 3;
    final UiLexicon lex = UiLexicon.bajaui();
    final String LEX_SERVICE = this.lex.getText("serviceManager.service");
    final String LEX_INSTALLED = this.lex.getText("serviceManager.installed");
    final String LEX_AUTO_START = this.lex.getText("serviceManager.autoStart");
    final String LEX_RUNNING = this.lex.getText("serviceManager.running");
    final String LEX_TITLE = this.lex.getText("serviceManager.wbServiceManager");
    BTable table;
    Row[] rows = new Row[0];
    Command start;
    Command stop;
    ToggleCommand autoStart;
    boolean inUpdate;
    static /* synthetic */ Class class$com$tridium$workbench$service$BWbServiceManagerView;

    public Type getType() {
        return TYPE;
    }

    public BWbServiceManagerView() {
        this.table = new BTable((TableModel)new Model(), (TableController)new Controller());
        this.table.setSelection((TableSelection)new Selection());
        this.table.setMultipleSelection(false);
        BGridPane bGridPane = new BGridPane(3);
        bGridPane.setValign(BValign.top);
        this.start = new Start(this);
        bGridPane.add(null, (BValue)new BButton(this.start));
        this.stop = new Stop(this);
        bGridPane.add(null, (BValue)new BButton(this.stop));
        this.autoStart = new AutoStart(this);
        bGridPane.add(null, (BValue)new BBorderPane((BWidget)new BCheckBox(this.autoStart), BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)10.0)));
        this.updateRows();
        this.table.sortByColumn(0, true);
        this.updateCommands();
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setCenter((BWidget)BTitlePane.makePane((String)this.LEX_TITLE, (BTable)this.table));
        bEdgePane.setBottom((BWidget)new BBorderPane((BWidget)bGridPane, 10.0, 10.0, 0.0, 10.0));
        this.setContent((BWidget)bEdgePane);
    }

    public BWbServiceSpec getSelectedSpec() {
        int n = this.table.getSelection().getRow();
        if (n < 0) {
            return null;
        }
        return this.rows[n].spec;
    }

    public void updateCommands() {
        this.inUpdate = true;
        BWbServiceSpec bWbServiceSpec = this.getSelectedSpec();
        if (bWbServiceSpec != null && !bWbServiceSpec.getInstalled()) {
            bWbServiceSpec = null;
        }
        this.start.setEnabled(bWbServiceSpec != null && !bWbServiceSpec.getRunning());
        this.stop.setEnabled(bWbServiceSpec != null && bWbServiceSpec.getRunning());
        this.autoStart.setEnabled(bWbServiceSpec != null);
        this.autoStart.setSelected(bWbServiceSpec != null && bWbServiceSpec.getAutoStart());
        this.inUpdate = false;
    }

    public void updateRows() {
        BWbServiceSpec[] bWbServiceSpecArray = BWbServiceManager.make().getSpecs();
        this.rows = new Row[bWbServiceSpecArray.length];
        for (int i = 0; i < bWbServiceSpecArray.length; ++i) {
            this.rows[i] = new Row(bWbServiceSpecArray[i]);
        }
        this.repaint();
    }

    public void open() {
        BWbServiceSpec bWbServiceSpec = this.getSelectedSpec();
        if (bWbServiceSpec != null && bWbServiceSpec.typeInfo != null) {
            this.getWbShell().hyperlink(BOrd.make((String)("workbench:/tools/" + bWbServiceSpec.typeInfo)));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class Row {
        BWbServiceSpec spec;

        Row(BWbServiceSpec bWbServiceSpec) {
            this.spec = bWbServiceSpec;
        }

        public Object valueAt(int n) {
            switch (n) {
                case 0: {
                    return this.spec.getDisplayName(null);
                }
                case 1: {
                    return String.valueOf(this.spec.getInstalled());
                }
                case 2: {
                    return String.valueOf(this.spec.getAutoStart());
                }
                case 3: {
                    return String.valueOf(this.spec.getRunning());
                }
            }
            return "?";
        }
    }

    class Model
    extends TableModel {
        Model() {
        }

        public int getRowCount() {
            return BWbServiceManagerView.this.rows.length;
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return BWbServiceManagerView.this.LEX_SERVICE;
                }
                case 1: {
                    return BWbServiceManagerView.this.LEX_INSTALLED;
                }
                case 2: {
                    return BWbServiceManagerView.this.LEX_AUTO_START;
                }
                case 3: {
                    return BWbServiceManagerView.this.LEX_RUNNING;
                }
            }
            return "?";
        }

        public Object getSubject(int n) {
            return BWbServiceManagerView.this.rows[n].spec;
        }

        public Object getValueAt(int n, int n2) {
            return BWbServiceManagerView.this.rows[n].valueAt(n2);
        }

        public boolean isColumnSortable(int n) {
            return true;
        }

        public void sortByColumn(int n, boolean bl) {
            Object[] objectArray = new Object[BWbServiceManagerView.this.rows.length];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = BWbServiceManagerView.this.rows[i].valueAt(n);
            }
            SortUtil.sort((Object[])objectArray, (Object[])BWbServiceManagerView.this.rows, (boolean)bl);
        }

        public BImage getRowIcon(int n) {
            return BWbServiceManagerView.this.rows[n].spec.getServiceIcon();
        }
    }

    class Controller
    extends TableController {
        Controller() {
        }

        public void keyPressed(BKeyEvent bKeyEvent) {
            if (bKeyEvent.getKeyCode() == 10) {
                bKeyEvent.consume();
                BWbServiceManagerView.this.open();
            }
            super.keyPressed(bKeyEvent);
        }

        public void cellDoubleClicked(BMouseEvent bMouseEvent, int n, int n2) {
            super.cellDoubleClicked(bMouseEvent, n, n2);
            BWbServiceManagerView.this.open();
        }
    }

    class Selection
    extends TableSelection {
        Selection() {
        }

        public void updateTable() {
            super.updateTable();
            BWbServiceManagerView.this.updateCommands();
        }
    }

    class AutoStart
    extends ToggleCommand {
        AutoStart(BWidget bWidget) {
            super(bWidget, BWbServiceManagerView.this.lex.module, "serviceManager.autoStart");
        }

        public void setSelected(boolean bl) {
            super.setSelected(bl);
            if (BWbServiceManagerView.this.inUpdate) {
                return;
            }
            BWbServiceSpec bWbServiceSpec = BWbServiceManagerView.this.getSelectedSpec();
            if (bWbServiceSpec != null) {
                bWbServiceSpec.updateAutoStart(bl);
            }
            BWbServiceManagerView.this.updateRows();
            BWbServiceManagerView.this.updateCommands();
        }
    }

    class Stop
    extends Command {
        Stop(BWidget bWidget) {
            super(bWidget, BWbServiceManagerView.this.lex.module, "serviceManager.stop");
        }

        public CommandArtifact doInvoke() {
            BWbServiceManagerView.this.getSelectedSpec().stop();
            BWbServiceManagerView.this.updateRows();
            BWbServiceManagerView.this.updateCommands();
            return null;
        }
    }

    class Start
    extends Command {
        Start(BWidget bWidget) {
            super(bWidget, BWbServiceManagerView.this.lex.module, "serviceManager.start");
        }

        public CommandArtifact doInvoke() {
            BWbServiceManagerView.this.getSelectedSpec().start();
            BWbServiceManagerView.this.updateRows();
            BWbServiceManagerView.this.updateCommands();
            return null;
        }
    }
}

