/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.propsheet;

import com.tridium.workbench.propsheet.BPropertyEntry;
import com.tridium.workbench.propsheet.BPropertySheet;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.sys.BValue;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbView;

public class PropSheetState {
    static Array history = new Array();
    final String key;
    Array expands = new Array();

    static void save(BPropertySheet bPropertySheet) {
        try {
            String string = PropSheetState.toKey(bPropertySheet);
            PropSheetState propSheetState = new PropSheetState(string);
            propSheetState.save("", bPropertySheet.sheet.root);
            PropSheetState.add(propSheetState);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static void restore(BPropertySheet bPropertySheet) {
        try {
            String string = PropSheetState.toKey(bPropertySheet);
            PropSheetState propSheetState = PropSheetState.get(string);
            if (propSheetState != null) {
                propSheetState.restore(bPropertySheet.sheet.root);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static String toKey(BWbView bWbView) {
        BWbShell bWbShell = bWbView.getWbShell();
        if (bWbShell == null) {
            return null;
        }
        return "" + bWbShell.getActiveOrdTarget().getOrdWithoutViewQuery();
    }

    static PropSheetState get(String string) {
        for (int i = history.size() - 1; i >= 0; --i) {
            PropSheetState propSheetState = (PropSheetState)history.get(i);
            if (!propSheetState.key.equals(string)) continue;
            return propSheetState;
        }
        return (PropSheetState)history.last();
    }

    static void add(PropSheetState propSheetState) {
        if (history.size() > 10) {
            history.remove(0);
        }
        history.add((Object)propSheetState);
    }

    PropSheetState(String string) {
        this.key = string;
    }

    void save(String string, BPropertyEntry bPropertyEntry) {
        this.expands.add((Object)string);
        BPropertyEntry[] bPropertyEntryArray = bPropertyEntry.getChildEntries();
        for (int i = 0; i < bPropertyEntryArray.length; ++i) {
            BPropertyEntry bPropertyEntry2 = bPropertyEntryArray[i];
            if (!bPropertyEntry2.isExpanded) continue;
            this.save(string + "/" + bPropertyEntry2.property.getName(), bPropertyEntry2);
        }
    }

    void restore(BPropertyEntry bPropertyEntry) {
        if (this.expands.size() == 0) {
            return;
        }
        for (int i = 0; i < this.expands.size(); ++i) {
            String string = (String)this.expands.get(i);
            if (string.length() == 0) continue;
            this.tryToExpand(bPropertyEntry, new SlotPath(string));
        }
        bPropertyEntry.relayout();
    }

    void tryToExpand(BPropertyEntry bPropertyEntry, SlotPath slotPath) {
        for (int i = 0; i < slotPath.depth(); ++i) {
            String string = slotPath.nameAt(i);
            BValue bValue = bPropertyEntry.get("e_" + string);
            if (!(bValue instanceof BPropertyEntry)) {
                return;
            }
            bPropertyEntry = (BPropertyEntry)bValue;
            bPropertyEntry.expand();
        }
    }
}

