/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.propsheet;

import com.tridium.ui.theme.PropertySheetTreeTheme;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.propsheet.BComplexEntry;
import com.tridium.workbench.propsheet.BFieldEditorSheet;
import com.tridium.workbench.transfer.TransferUtil;
import com.tridium.workbench.util.ConfigFlagsCommand;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.security.BPermissions;
import javax.baja.space.Mark;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIPropertyContainer;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.UndoManager;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.DragRenderer;
import javax.baja.ui.transfer.SimpleDragRenderer;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.nav.menu.BNavMenuAgent;

public abstract class BPropertyEntry
extends BTransferWidget {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$propsheet$BPropertyEntry == null ? (class$com$tridium$workbench$propsheet$BPropertyEntry = BPropertyEntry.class$("com.tridium.workbench.propsheet.BPropertyEntry")) : class$com$tridium$workbench$propsheet$BPropertyEntry));
    static final BFont font = Theme.label().getTextFont();
    static final double textBaseline = font.getHeight() - font.getDescent();
    static final double EXPANDER_DIM = Theme.propertySheetTree().getExpanderHeight();
    static final double ICON_DIM = 16.0;
    static final double EXPANDER_ICON_GAP = 6.0;
    static final double ICON_NAME_GAP = 4.0;
    static final double INDENT = Math.max(Theme.propertySheetTree().getExpanderWidth() + 4.0, 20.0);
    static final BColor hyperlinkColor = BColor.make((int)0x4444BB);
    static final BColor cutColor = BColor.make((int)0x606060);
    static final double MAX_SUMMARY_WIDTH = 250.0;
    static BImage defaultIcon = BImage.make((String)"module://icons/x16/object.png");
    static final String lexUnsubscribed = UiLexicon.make((String)"bajaui").getText("propsheet.unsubscribed");
    BFieldEditorSheet sheet;
    BComplexEntry parentEntry;
    Property property;
    String displayName;
    BObject target;
    BImage icon;
    BImage dirtyIcon;
    BImage cutIcon;
    boolean isExpanded;
    RectGeom expander = new RectGeom(0.0, 0.0, EXPANDER_DIM, EXPANDER_DIM - 2.0);
    RectGeom label = new RectGeom();
    RectGeom content = new RectGeom();
    boolean hyperlinkActive;
    boolean dropActive;
    BMenu popup;
    boolean dirty = false;
    boolean readonly;
    boolean ignoreRelease = false;
    static /* synthetic */ Class class$com$tridium$workbench$propsheet$BPropertyEntry;

    public Type getType() {
        return TYPE;
    }

    BPropertyEntry() {
    }

    BPropertyEntry(BFieldEditorSheet bFieldEditorSheet, BComplexEntry bComplexEntry, Property property, BObject bObject) {
        this.sheet = bFieldEditorSheet;
        this.property = property;
        this.parentEntry = bComplexEntry;
        this.target = bObject;
        this.readonly = bFieldEditorSheet.isReadonly();
        if (bComplexEntry != null && !(bObject instanceof BComponent)) {
            if (bComplexEntry.target instanceof BIPropertyContainer) {
                this.readonly = bComplexEntry.readonly || (((BIPropertyContainer)bComplexEntry.target).getFlags((Slot)property) & 1) != 0 || bFieldEditorSheet.isReadonly();
            } else {
                boolean bl = this.readonly = bComplexEntry.readonly || Flags.isReadonly((BComplex)((BComplex)bComplexEntry.target), (Slot)property) || bFieldEditorSheet.isReadonly();
            }
        }
        this.displayName = property != null ? (bComplexEntry == null ? property.getDefaultDisplayName(null) : (bComplexEntry.target instanceof BIPropertyContainer ? ((BIPropertyContainer)bComplexEntry.target).getDisplayName((Slot)property, null) : bComplexEntry.target.asComplex().getDisplayName((Slot)property, null))) : (bObject instanceof BIPropertyContainer ? ((BIPropertyContainer)bObject).getDisplayName(null) : bObject.asComplex().getDisplayName(null));
        if (this.displayName == null) {
            this.displayName = "";
        }
        this.reloadIcon();
        this.setCopyEnabled(true);
        this.setCutEnabled(true);
        this.setPasteEnabled(true);
        this.setDuplicateEnabled(true);
        this.setDeleteEnabled(true);
        this.setRenameEnabled(true);
    }

    int computeSizes() {
        this.computeLabelSize();
        this.computeContentSize();
        return (int)this.label.width;
    }

    void computeLabelSize() {
        this.label.width = 20.0 + font.width(this.displayName);
        this.label.height = 16.0;
    }

    void computeContentSize() {
    }

    void positionsComputed() {
    }

    public void paint(Graphics graphics) {
        PropertySheetTreeTheme propertySheetTreeTheme = Theme.propertySheetTree();
        boolean bl = this.isRoot();
        double d = this.getWidth();
        double d2 = this.getHeight();
        graphics.setBrush(propertySheetTreeTheme.getControlBackground((IStylable)this));
        graphics.fillRect(0.0, 0.0, d, d2);
        if (bl) {
            graphics.setBrush(propertySheetTreeTheme.getHeaderBackground((IStylable)this));
            graphics.fillRect(0.0, 0.0, d, this.getDividerY() + 2.0);
        }
        boolean bl2 = false;
        if (this.target.isComponent()) {
            BComponent bComponent = this.target.asComponent();
            bl2 = bComponent.isPendingMove();
        }
        if (this.dropActive) {
            graphics.setBrush(propertySheetTreeTheme.getDropOkBackground((IStylable)this));
            graphics.fillRect(this.label.x, this.label.y, this.label.width, this.label.height);
        }
        if (this.dirty) {
            graphics.drawImage(this.dirtyIcon, this.label.x, this.label.y);
        } else if (bl2) {
            if (this.cutIcon == null) {
                this.cutIcon = this.icon.getDisabledImage();
            }
            graphics.drawImage(this.cutIcon, this.label.x, this.label.y);
        } else {
            graphics.drawImage(this.icon, this.label.x, this.label.y);
        }
        this.paintExpander(graphics);
        graphics.setFont(font);
        double d3 = this.label.x + 16.0 + 4.0;
        double d4 = this.label.y + textBaseline;
        if (this.dropActive) {
            graphics.setBrush(propertySheetTreeTheme.getDropOkForeground((IStylable)this));
        } else if (this.hyperlinkActive) {
            graphics.setBrush(hyperlinkColor);
        } else if (bl2) {
            graphics.setBrush(cutColor);
        } else {
            graphics.setBrush(bl ? propertySheetTreeTheme.getHeaderColor((IStylable)this) : propertySheetTreeTheme.getTextBrush((IStylable)this));
        }
        graphics.drawString(this.displayName, d3, d4);
        this.paintContent(graphics);
        this.paintDivider(graphics);
    }

    void paintExpander(Graphics graphics) {
        Theme.propertySheetTree().paintExpander(graphics, (BWidget)this, this.expander.x, this.expander.y, this.isExpandable(), this.isExpanded);
    }

    void paintContent(Graphics graphics) {
    }

    void paintDivider(Graphics graphics) {
        graphics.setBrush(Theme.propertySheetTree().getDividerColor((IStylable)this));
        double d = this.expander.x;
        double d2 = this.getDividerY();
        graphics.strokeLine(d, d2, this.getWidth(), d2);
    }

    private double getDividerY() {
        return this.content.y + Math.max(this.label.height, this.content.height) + 1.0;
    }

    void reloadIcon() {
        if (this.target != null) {
            this.icon = BImage.make((BIcon)this.target.getIcon());
        }
        if (this.icon == null) {
            this.icon = defaultIcon;
        }
    }

    boolean isRoot() {
        BPropertyEntry bPropertyEntry = this;
        while (bPropertyEntry != null) {
            if (!((bPropertyEntry = bPropertyEntry.getParentWidget()) instanceof BPropertyEntry)) continue;
            return false;
        }
        return true;
    }

    public String getStyleSelector() {
        return "tree property-sheet";
    }

    boolean isHyperlinkSupported() {
        return false;
    }

    void hyperlink(BMouseEvent bMouseEvent) {
    }

    boolean isExpandable() {
        return true;
    }

    void toggleExpansion() {
        if (!this.isExpandable()) {
            return;
        }
        if (this.isExpanded) {
            this.collapse();
        } else {
            this.expand();
        }
    }

    void expand() {
        if (this.isExpanded) {
            return;
        }
        this.isExpanded = true;
        this.doExpand();
        this.relayout();
        this.sheet.relayoutSync();
        RectGeom rectGeom = new RectGeom(0.0, 0.0, this.getWidth(), this.getHeight());
        this.scrollToVisible(rectGeom);
    }

    void collapse() {
        if (!this.isExpanded) {
            return;
        }
        this.isExpanded = false;
        this.doCollapse();
        this.relayout();
    }

    void doExpand() {
    }

    void doCollapse() {
    }

    public abstract void init();

    final void update(BObject bObject) {
        BObject bObject2 = this.target;
        if (bObject2.getType() != bObject.getType() || bObject.isComponent() && bObject2 != bObject) {
            if (this.parentEntry != null) {
                this.parentEntry.rebuildEntry(this, bObject);
            }
            return;
        }
        this.doUpdate(bObject);
    }

    abstract void doUpdate(BObject var1);

    void setDirty() {
        if (this.dirty) {
            return;
        }
        if (this.dirtyIcon == null) {
            try {
                this.dirtyIcon = this.icon.getHighlightedImage();
            }
            catch (Exception exception) {
                this.dirtyIcon = this.icon;
                exception.printStackTrace();
            }
        }
        this.dirty = true;
        BWidget bWidget = this.getParentWidget();
        if (bWidget instanceof BPropertyEntry) {
            ((BPropertyEntry)bWidget).setDirty();
        }
        this.sheet.setModified();
        this.repaint();
    }

    final void save(Context context) throws Exception {
        if (!this.dirty) {
            return;
        }
        try {
            this.doSave(context);
        }
        catch (CannotSaveException cannotSaveException) {
            Object[] objectArray = new Object[]{this.property.getDefaultDisplayName(null)};
            String string = UiLexicon.bajaui().getText("plugin.saveProp.error", objectArray) + "  " + cannotSaveException.getMessage();
            throw new CannotSaveException(string, (Throwable)((Object)cannotSaveException));
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{this.property.getDefaultDisplayName(null)};
            String string = UiLexicon.bajaui().getText("plugin.saveProp.error", objectArray);
            throw new CannotSaveException(string, exception);
        }
        BPropertyEntry[] bPropertyEntryArray = this.getChildEntries();
        for (int i = 0; i < bPropertyEntryArray.length; ++i) {
            bPropertyEntryArray[i].save(context);
        }
    }

    void doSave(Context context) throws Exception {
    }

    void clearDirty() {
        this.dirty = false;
        BPropertyEntry[] bPropertyEntryArray = this.getChildEntries();
        for (int i = 0; i < bPropertyEntryArray.length; ++i) {
            bPropertyEntryArray[i].clearDirty();
        }
    }

    BPropertyEntry[] getChildEntries() {
        return (BPropertyEntry[])this.getChildren(class$com$tridium$workbench$propsheet$BPropertyEntry == null ? (class$com$tridium$workbench$propsheet$BPropertyEntry = BPropertyEntry.class$("com.tridium.workbench.propsheet.BPropertyEntry")) : class$com$tridium$workbench$propsheet$BPropertyEntry);
    }

    public boolean isRegisteredForComponentEvents(BComponent bComponent) {
        if (this.sheet.getParentWbComponentView() != null) {
            return this.sheet.getParentWbComponentView().isRegisteredForComponentEvents(bComponent);
        }
        return false;
    }

    public void mouseEntered(BMouseEvent bMouseEvent) {
        this.checkMouseOver(bMouseEvent);
    }

    public void mouseExited(BMouseEvent bMouseEvent) {
        this.checkMouseOver(null);
    }

    public void mouseMoved(BMouseEvent bMouseEvent) {
        this.checkMouseOver(bMouseEvent);
    }

    public void mousePressed(BMouseEvent bMouseEvent) {
        if (bMouseEvent.isPopupTrigger()) {
            this.checkMouseOver(null);
            this.doPopup(bMouseEvent.getX(), bMouseEvent.getY());
            this.ignoreRelease = true;
        } else if (this.expander.contains(bMouseEvent.getX(), bMouseEvent.getY())) {
            this.toggleExpansion();
        }
    }

    public void mouseReleased(BMouseEvent bMouseEvent) {
        this.setMouseCursor(MouseCursor.normal);
        if (bMouseEvent.isPopupTrigger()) {
            this.checkMouseOver(null);
            this.doPopup(bMouseEvent.getX(), bMouseEvent.getY());
        } else if (!this.ignoreRelease && this.hyperlinkActive) {
            this.hyperlink(bMouseEvent);
        }
        this.ignoreRelease = false;
    }

    void doPopup(double d, double d2) {
        BPermissions bPermissions;
        BComponent bComponent;
        BMenu bMenu = null;
        if (this.target.isComponent() && this.target.asComponent().isMounted()) {
            bComponent = this.target.asComponent();
            bMenu = BNavMenuAgent.makeFor((BObject)bComponent).makeMenu((BWidget)this, (BObject)bComponent);
        }
        if (this.parentEntry != null && this.parentEntry.target.isComponent() && this.parentEntry.target.asComponent().isMounted() && (bPermissions = (bComponent = this.parentEntry.target.asComponent()).getPermissions(null)).has(32)) {
            if (bMenu == null) {
                bMenu = new BMenu();
            } else {
                bMenu.add(null, (BValue)new BSeparator());
            }
            bMenu.add("configFlags", (Command)new ConfigFlagsCommand((BWidget)this, (BIPropertyContainer)bComponent, (Slot)this.property));
        }
        if (bMenu != null) {
            bMenu.open((BWidget)this, d, d2);
        }
    }

    void checkMouseOver(BMouseEvent bMouseEvent) {
        if (this.isHyperlinkSupported()) {
            boolean bl = this.hyperlinkActive;
            if (bMouseEvent != null) {
                double d = bMouseEvent.getX();
                double d2 = bMouseEvent.getY();
                this.hyperlinkActive = this.label.contains(d, d2);
            } else {
                this.hyperlinkActive = false;
            }
            if (this.hyperlinkActive != bl) {
                MouseCursor mouseCursor = this.hyperlinkActive ? MouseCursor.hand : MouseCursor.normal;
                this.setMouseCursor(mouseCursor);
                this.repaint(this.label.x, this.label.y, this.label.width, this.label.height);
            }
        }
    }

    public TransferEnvelope getTransferData() throws Exception {
        if (!this.target.isComponent()) {
            return null;
        }
        return TransferUtil.getTransferData(this.target);
    }

    public CommandArtifact insertTransferData(TransferContext transferContext) throws Exception {
        if (!this.target.isComponent()) {
            return null;
        }
        return TransferUtil.insert((BWidget)this, transferContext, this.target, null);
    }

    public CommandArtifact removeTransferData(TransferContext transferContext) throws Exception {
        return null;
    }

    public CommandArtifact doDuplicate() throws Exception {
        if (!this.target.isComponent()) {
            return null;
        }
        Mark mark = new Mark(this.target);
        BComponent bComponent = (BComponent)this.target.asComponent().getParent();
        if (bComponent == null) {
            return null;
        }
        return TransferUtil.insert((BWidget)this, 16, mark, (BObject)bComponent, null, null);
    }

    public CommandArtifact doDelete() throws Exception {
        if (!this.target.isComponent()) {
            return null;
        }
        Mark mark = new Mark(this.target);
        return TransferUtil.delete((BWidget)this, mark);
    }

    public CommandArtifact doRename() throws Exception {
        if (!this.target.isComponent()) {
            return null;
        }
        Mark mark = new Mark(this.target);
        return TransferUtil.rename((BWidget)this, mark);
    }

    public void mouseDragStarted(BMouseEvent bMouseEvent) {
        double d = bMouseEvent.getX();
        double d2 = bMouseEvent.getY();
        if (!this.target.isComponent()) {
            return;
        }
        if (!this.label.contains(d, d2)) {
            return;
        }
        SimpleDragRenderer simpleDragRenderer = new SimpleDragRenderer(this.icon, this.displayName);
        simpleDragRenderer.font = font;
        simpleDragRenderer.xCursorOffset = this.label.x - d;
        simpleDragRenderer.yCursorOffset = this.label.y - d2;
        this.startDrag(bMouseEvent, TransferEnvelope.make((Mark)new Mark(this.target)), (DragRenderer)simpleDragRenderer);
    }

    public int dragOver(TransferContext transferContext) {
        if (!this.target.isComponent()) {
            return 0;
        }
        boolean bl = this.dropActive;
        double d = transferContext.getX();
        double d2 = transferContext.getY();
        this.dropActive = this.contains(d, d2);
        if (bl != this.dropActive) {
            this.repaint();
        }
        if (!this.dropActive) {
            return 0;
        }
        int n = 48;
        return n;
    }

    public void dragExit(TransferContext transferContext) {
        this.dropActive = false;
        this.repaint();
    }

    public CommandArtifact drop(TransferContext transferContext) throws Exception {
        if (!this.dropActive) {
            return null;
        }
        this.dropActive = false;
        this.repaint();
        return TransferUtil.insert((BWidget)this, transferContext, this.target, null);
    }

    public UndoManager getUndoManager() {
        BWbShell bWbShell = BWbShell.getWbShell(this.sheet);
        UndoManager undoManager = bWbShell.getUndoManager();
        return undoManager;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

