/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.preview;

import com.tridium.ui.theme.LabelTheme;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.preview.BComponentPreviewFactory;
import com.tridium.workbench.transfer.TransferUtil;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BTransform;
import javax.baja.gx.Graphics;
import javax.baja.space.Mark;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.DragRenderer;
import javax.baja.ui.transfer.SimpleDragRenderer;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.util.Lexicon;

public final class BComponentPreviewWidget
extends BTransferWidget {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$preview$BComponentPreviewWidget == null ? (class$com$tridium$workbench$preview$BComponentPreviewWidget = BComponentPreviewWidget.class$("com.tridium.workbench.preview.BComponentPreviewWidget")) : class$com$tridium$workbench$preview$BComponentPreviewWidget));
    private String dragDisplayName = "";
    private BImage dragImage = BImage.DEFAULT;
    private BWidget prevWid;
    private BComponent comp;
    private static Lexicon lex = Lexicon.make((String)"workbench");
    private static final double prevIndent = 5.0;
    static /* synthetic */ Class class$com$tridium$workbench$preview$BComponentPreviewWidget;

    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        double d = this.getWidth();
        double d2 = this.getHeight();
        LabelTheme labelTheme = Theme.label();
        graphics.setBrush(labelTheme.getWindowBackground());
        graphics.fillRect(0.0, 0.0, d, d2);
        boolean bl = false;
        if (this.prevWid != null && this.prevWid.getWidth() > 0.0 && this.prevWid.getHeight() > 0.0) {
            bl = true;
        }
        if (!bl) {
            graphics.setBrush(labelTheme.getTextBrush());
            BFont bFont = labelTheme.getTextFont();
            graphics.setFont(bFont);
            String string = lex.getText("PaletteSideBar.noPrevFound");
            double d3 = bFont.width(string);
            double d4 = bFont.getDescent();
            double d5 = d > d3 + 10.0 ? (d - d3) / 2.0 : 0.0;
            double d6 = d2 > d4 ? d2 / 2.0 + d4 : bFont.getHeight();
            graphics.drawString(string, d5 + 5.0, d6);
        } else {
            double d7;
            double d8;
            double d9 = d - 10.0;
            double d10 = d2 - 10.0;
            BImage bImage = BImage.make((double)this.prevWid.getWidth(), (double)this.prevWid.getHeight());
            Graphics graphics2 = bImage.getGraphics();
            try {
                graphics2.clip(0.0, 0.0, this.prevWid.getWidth(), this.prevWid.getHeight());
                graphics2.setBrush(labelTheme.getWindowBackground());
                graphics2.fillRect(0.0, 0.0, this.prevWid.getWidth(), this.prevWid.getHeight());
                this.prevWid.paint(graphics2);
            }
            finally {
                graphics2.dispose();
            }
            if (this.prevWid.getWidth() > d9 || this.prevWid.getHeight() > d10) {
                d8 = d9 / this.prevWid.getWidth();
                d7 = d10 / this.prevWid.getHeight();
                double d11 = Math.min(d8, d7);
                bImage = bImage.transform(BTransform.makeScale((double)d11, (double)d11));
            }
            d8 = (d - bImage.getWidth()) / 2.0;
            d7 = (d2 - bImage.getHeight()) / 2.0;
            graphics.drawImage(bImage, d8, d7);
        }
    }

    public TransferEnvelope getTransferData() throws Exception {
        if (this.comp == null) {
            return null;
        }
        return TransferEnvelope.make((Mark)new Mark((BObject)this.comp));
    }

    public CommandArtifact insertTransferData(TransferContext transferContext) throws Exception {
        return TransferUtil.insert((BWidget)this, transferContext, (BObject)this.comp, null);
    }

    public CommandArtifact removeTransferData(TransferContext transferContext) throws Exception {
        return null;
    }

    public void mouseDragStarted(BMouseEvent bMouseEvent) {
        if (this.comp == null) {
            return;
        }
        SimpleDragRenderer simpleDragRenderer = new SimpleDragRenderer(this.dragImage, this.dragDisplayName);
        simpleDragRenderer.font = Theme.tree().getFont((BWidget)this);
        simpleDragRenderer.xCursorOffset = Theme.tree().getExpanderWidth() + 4.0;
        simpleDragRenderer.yCursorOffset = Theme.tree().getExpanderWidth() + 4.0;
        TransferEnvelope transferEnvelope = TransferEnvelope.make((Mark)new Mark((BObject)this.comp));
        this.startDrag(bMouseEvent, this.makeTransferContext(transferEnvelope), (DragRenderer)simpleDragRenderer);
    }

    public void setCurrentComponent(BComponent bComponent) {
        this.prevWid = null;
        this.comp = bComponent;
        this.dragDisplayName = bComponent == null ? "" : bComponent.getNavDisplayName(null);
        BImage bImage = this.dragImage = bComponent == null ? BImage.DEFAULT : BImage.make((BIcon)bComponent.getNavIcon());
        if (bComponent != null) {
            this.prevWid = BComponentPreviewFactory.makeFactory(bComponent, null).getPreviewWidget();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

