/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.pathbar;

import com.tridium.ui.UiEnv;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.pathbar.PathBarHyperlinkCommand;
import com.tridium.workbench.shell.BNiagaraWbShell;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.gx.Insets;
import javax.baja.gx.Point;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BHyperlinkMode;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.style.IStylable;

public class BPathBarButton
extends BWidget
implements BMenu.MenuCloseListener {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$pathbar$BPathBarButton == null ? (class$com$tridium$workbench$pathbar$BPathBarButton = BPathBarButton.class$("com.tridium.workbench.pathbar.BPathBarButton")) : class$com$tridium$workbench$pathbar$BPathBarButton));
    private static final BBrush shadow = BColor.make((int)0x333333).toBrush();
    private static final Insets insets = new Insets(3.0, 4.0, 3.0, 4.0);
    private static final int pad = 3;
    private static final int arrow = 10;
    private BNiagaraWbShell shell;
    private BImage icon;
    private String text;
    private String reset;
    private Command command;
    private MenuController menu;
    private BMenu last;
    private boolean pinArrow = false;
    private boolean doCommand = true;
    private Point iconPt = new Point();
    private Point textPt = new Point();
    private boolean over = false;
    private boolean down = false;
    static /* synthetic */ Class class$com$tridium$workbench$pathbar$BPathBarButton;

    public Type getType() {
        return TYPE;
    }

    public BPathBarButton() {
    }

    public BPathBarButton(BNiagaraWbShell bNiagaraWbShell, BImage bImage, String string) {
        this.shell = bNiagaraWbShell;
        this.icon = bImage;
        this.text = string;
        this.reset = string;
    }

    public void setIcon(BImage bImage) {
        this.icon = bImage;
    }

    public void setText(String string) {
        this.text = string;
    }

    public void setCommand(Command command) {
        this.command = command;
    }

    public void setPinArrow(boolean bl) {
        this.pinArrow = bl;
    }

    public void setMenuController(MenuController menuController) {
        this.menu = menuController;
    }

    public void reset() {
        this.text = this.reset;
    }

    public void computePreferredSize() {
        double d = BPathBarButton.insets.left + BPathBarButton.insets.right;
        double d2 = 0.0;
        if (this.icon != null) {
            d += this.icon.getWidth();
            d2 += this.icon.getHeight();
        }
        if (this.text != null) {
            BFont bFont = Theme.pathBar().getTextFont((IStylable)this);
            d += bFont.width(this.text);
            d += 13.0;
            d2 = Math.max(d2, bFont.getHeight());
        }
        if (this.icon != null && this.text != null) {
            d += 3.0;
        }
        this.setPreferredSize(d, d2 += BPathBarButton.insets.top + BPathBarButton.insets.bottom);
    }

    public void doLayout(BWidget[] bWidgetArray) {
        double d = this.getWidth() - (BPathBarButton.insets.left + BPathBarButton.insets.right);
        double d2 = this.getHeight() - (BPathBarButton.insets.top + BPathBarButton.insets.bottom);
        BFont bFont = Theme.widget().getTextFont((IStylable)this);
        double d3 = d;
        if (this.icon != null) {
            d3 -= this.icon.getWidth();
        }
        if (this.text != null) {
            d3 -= bFont.width(this.text);
        }
        if (this.menu != null) {
            d3 -= 13.0;
        }
        if (this.icon != null && this.text != null) {
            d3 -= 3.0;
        }
        if (this.icon != null) {
            this.iconPt.x = d3 / 2.0;
            this.iconPt.y = (d2 - this.icon.getHeight()) / 2.0;
        }
        if (this.text != null) {
            this.textPt.x = this.icon == null ? d3 / 2.0 : this.iconPt.x + this.icon.getWidth() + 3.0;
            this.textPt.y = (d2 - bFont.getHeight()) / 2.0;
            this.textPt.y += bFont.getAscent();
        }
    }

    public void paint(Graphics graphics) {
        BBrush bBrush = Theme.pathBar().getControlBackground((IStylable)this);
        BBrush bBrush2 = Theme.pathBar().getControlForeground((IStylable)this);
        BBrush bBrush3 = Theme.pathBar().getControlHighlight((IStylable)this);
        BBrush bBrush4 = Theme.pathBar().getControlShadow((IStylable)this);
        double d = this.getWidth() - 1.0;
        double d2 = this.getHeight() - 1.0;
        double d3 = BPathBarButton.insets.left;
        double d4 = BPathBarButton.insets.top;
        if (this.over) {
            graphics.setBrush(bBrush);
            graphics.fillRect(0.0, 0.0, d, d2);
            if (this.command != null && this.menu != null) {
                double d5 = 13.0 + BPathBarButton.insets.right - 3.0;
                if (this.down) {
                    d5 -= 1.0;
                }
                graphics.setBrush(bBrush4);
                graphics.strokeLine(d - d5, 0.0, d - d5, d2);
                if (!this.down) {
                    graphics.setBrush(bBrush);
                    graphics.strokeLine(d - d5 + 1.0, 0.0, d - d5 + 1.0, d2);
                }
            }
            graphics.setBrush(this.down ? bBrush4 : bBrush3);
            graphics.strokeLine(0.0, 0.0, d, 0.0);
            graphics.strokeLine(0.0, 0.0, 0.0, d2);
            graphics.setBrush(bBrush4);
            graphics.strokeLine(0.0, d2, d, d2);
            graphics.strokeLine(d, 0.0, d, d2);
            if (this.down) {
                d3 += 1.0;
                d4 += 1.0;
            }
        }
        graphics.translate(d3, d4);
        if (this.icon != null) {
            graphics.drawImage(this.icon, this.iconPt.x, this.iconPt.y);
        }
        if (this.text != null) {
            graphics.setBrush(Theme.pathBar().getTextBrush((IStylable)this));
            graphics.setFont(Theme.pathBar().getTextFont((IStylable)this));
            graphics.drawString(this.text, this.textPt.x, this.textPt.y);
            if (this.menu != null && (this.over || this.pinArrow)) {
                int n = 3;
                int n2 = (int)(d - BPathBarButton.insets.right - (double)n - 4.0);
                int n3 = 0 + n + ((int)d2 - (int)BPathBarButton.insets.bottom - n) / 2 - 1;
                for (int i = 0; i < n; ++i) {
                    graphics.strokeLine((double)(n2 - i), (double)(n3 - i), (double)(n2 + i), (double)(n3 - i));
                }
            }
        }
        graphics.translate(-d3, -d4);
    }

    public String getStyleSelector() {
        return "path-bar";
    }

    public void mousePressed(BMouseEvent bMouseEvent) {
        this.doCommand = true;
        this.down = true;
        this.repaint();
        if (this.menu != null && (this.command == null || bMouseEvent.getX() > this.getWidth() - (13.0 + BPathBarButton.insets.right - 2.0))) {
            this.doCommand = false;
            this.last = this.menu.getMenu();
            if (this.last != null) {
                this.last.open((BWidget)this, 0.0, this.getHeight() + 1.0);
            }
        }
    }

    public void mouseReleased(BMouseEvent bMouseEvent) {
        if (this.last != null && this.last.isOpen()) {
            return;
        }
        this.down = false;
        this.repaint();
        if (this.over && this.command != null && this.doCommand) {
            if (this.command instanceof PathBarHyperlinkCommand) {
                BHyperlinkMode bHyperlinkMode = bMouseEvent.isControlDown() ? BHyperlinkMode.newTab : BHyperlinkMode.replace;
                ((PathBarHyperlinkCommand)this.command).setMode(bHyperlinkMode);
            }
            this.command.invoke();
        }
    }

    public void mouseEntered(BMouseEvent bMouseEvent) {
        this.over = true;
        this.repaint();
    }

    public void mouseExited(BMouseEvent bMouseEvent) {
        UiEnv.get().closeBubbleHelp();
        if (this.last != null && this.last.isOpen()) {
            return;
        }
        this.over = false;
        this.repaint();
    }

    public void mouseHover(BMouseEvent bMouseEvent) {
        Point point = new Point(bMouseEvent.getX(), bMouseEvent.getY());
        point.y = Math.max(this.getHeight() + 1.0, point.y + 16.0);
        UiEnv.get().openBubbleHelp((BWidget)this, point.x, point.y, this.reset);
    }

    public void menuClosed(BMenu bMenu) {
        this.down = false;
        this.over = false;
        this.repaint();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface MenuController {
        public BMenu getMenu();
    }
}

