/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.pathbar;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.auth.BCnxHandler;
import com.tridium.workbench.pathbar.BPathBarAgent;
import com.tridium.workbench.pathbar.BPathBarButton;
import com.tridium.workbench.pathbar.PathBarHyperlinkCommand;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.shell.BViewTab;
import java.util.ArrayList;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.naming.BHost;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavFileNode;
import javax.baja.nav.BNavRoot;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BSubMenuItem;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.style.IStylable;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.nav.menu.NavMenuUtil;

public class BPathBar
extends BEdgePane {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$pathbar$BPathBar == null ? (class$com$tridium$workbench$pathbar$BPathBar = BPathBar.class$("com.tridium.workbench.pathbar.BPathBar")) : class$com$tridium$workbench$pathbar$BPathBar));
    private static final BImage errIcon = BImage.make((String)"module://icons/x16/error.png");
    private static final BImage editIcon = BImage.make((String)"module://icons/x16/edit.png");
    private static final BImage defaultViewIcon = BImage.make((String)"module://icons/x16/views/view.png");
    private static final int menuLimit = 30;
    public final BNiagaraWbShell shell;
    private BINavNode root;
    private BPathBarButton[] buttons;
    private BViewTab tab;
    private BWidget view;
    private boolean restrictToNavFile = false;
    private boolean showViewMenu = true;
    static /* synthetic */ Class class$com$tridium$workbench$pathbar$BPathBar;

    public Type getType() {
        return TYPE;
    }

    public BPathBar() {
        throw new IllegalStateException();
    }

    public BPathBar(BNiagaraWbShell bNiagaraWbShell) {
        this.shell = bNiagaraWbShell;
    }

    public void setRestrictToNavFile(boolean bl) {
        this.restrictToNavFile = bl;
    }

    public void setShowViewMenu(boolean bl) {
        this.showViewMenu = bl;
    }

    public void computePreferredSize() {
        if (this.buttons == null) {
            this.setPreferredSize(200.0, 26.0);
        } else {
            super.computePreferredSize();
        }
    }

    public void doLayout(BWidget[] bWidgetArray) {
        double d;
        if (this.buttons != null) {
            for (int i = 0; i < this.buttons.length; ++i) {
                this.buttons[i].reset();
            }
        }
        super.doLayout(bWidgetArray);
        if (this.buttons == null) {
            return;
        }
        BWidget bWidget = this.getCenter();
        BWidget bWidget2 = this.getRight();
        bWidget.computePreferredSize();
        bWidget2.computePreferredSize();
        double d2 = this.getWidth() - 5.0;
        double d3 = bWidget.getPreferredWidth() + bWidget2.getPreferredWidth();
        for (int i = 0; d3 > d2 && i < this.buttons.length - 1; d3 -= d - this.buttons[i].getPreferredWidth(), ++i) {
            this.buttons[i].computePreferredSize();
            d = this.buttons[i].getPreferredWidth();
            this.buttons[i].setText("");
            this.buttons[i].computePreferredSize();
        }
        bWidget.layout();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        double d = this.getWidth() - 1.0;
        double d2 = this.getHeight() - 1.0;
        BBrush bBrush = Theme.pathBar().getControlBackground((IStylable)this);
        BBrush bBrush2 = Theme.pathBar().getControlHighlight((IStylable)this);
        BBrush bBrush3 = Theme.pathBar().getControlShadow((IStylable)this);
        BBrush bBrush4 = Theme.pathBar().getControlForeground((IStylable)this);
        graphics.setBrush(bBrush2);
        graphics.strokeLine(0.0, d2, d, d2);
        graphics.strokeLine(d, 0.0, d, d2);
        graphics.setBrush(bBrush3);
        graphics.strokeLine(0.0, 0.0, d, 0.0);
        graphics.strokeLine(0.0, 0.0, 0.0, d2);
        graphics.setBrush(bBrush4);
        graphics.strokeRect(1.0, 1.0, d - 2.0, d2 - 2.0);
        if (this.showViewMenu && this.view != null) {
            double d3 = d - this.view.getWidth() - 2.0;
            graphics.setBrush(bBrush4);
            graphics.strokeLine(d3, 1.0, d3, d2 - 1.0);
            graphics.strokeLine(d3 - 4.0, 1.0, d3 - 4.0, d2 - 1.0);
            graphics.setBrush(bBrush2);
            graphics.strokeLine(d3 - 3.0, 1.0, d3 - 3.0, d2);
            graphics.setBrush(bBrush);
            graphics.strokeLine(d3 - 2.0, 0.0, d3 - 2.0, d2);
            graphics.setBrush(bBrush3);
            graphics.strokeLine(d3 - 1.0, 0.0, d3 - 1.0, d2);
        }
    }

    public String getStyleSelector() {
        return "path-bar";
    }

    public void update(BViewTab bViewTab) {
        Object object;
        Object object2;
        BPathBarAgent[] bPathBarAgentArray;
        if (this.root == null) {
            bPathBarAgentArray = this.shell.getProfile().getNavRootOrd();
            this.root = (BINavNode)bPathBarAgentArray.resolve().get();
        }
        this.tab = bViewTab;
        this.buttons = null;
        bPathBarAgentArray = bViewTab.getPathBarAgents();
        BOrd bOrd = bViewTab.getOrd();
        if (bViewTab.getTarget() == null || bPathBarAgentArray == null) {
            this.setToError(bOrd);
            return;
        }
        String string = "";
        BImage bImage = errIcon;
        if (bViewTab.getView() != null) {
            object2 = bViewTab.getViewAgent();
            string = object2.getDisplayName(null);
            bImage = BImage.make((BIcon)object2.getIcon(null));
        }
        object2 = new BPathBarButton(this.shell, bImage, string);
        ((BPathBarButton)((Object)object2)).setMenuController(new ViewController());
        ((BPathBarButton)((Object)object2)).setPinArrow(true);
        this.view = object2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < bPathBarAgentArray.length; ++i) {
            Object object3;
            if (this.root != null && this.root != BNavRoot.INSTANCE) {
                try {
                    for (object3 = bPathBarAgentArray[i].nav(); object3 != null && object3 != this.root; object3 = object3.getNavParent()) {
                    }
                    if (object3 == null) {
                        continue;
                    }
                }
                catch (Exception exception) {
                    break;
                }
            }
            if (this.restrictToNavFile && bPathBarAgentArray[i].nav() instanceof BISession) continue;
            object3 = new BPathBarButton(this.shell, bPathBarAgentArray[i].getAgentIcon(), bPathBarAgentArray[i].getAgentText());
            if (this.root != null && this.root != BNavRoot.INSTANCE && this.root == bPathBarAgentArray[i].nav()) {
                if (!this.restrictToNavFile || this.restrictToNavFile && bPathBarAgentArray[i].nav() instanceof BNavFileNode) {
                    ((BPathBarButton)((Object)object3)).setPinArrow(true);
                    ((BPathBarButton)((Object)object3)).setMenuController(new AgentController(bPathBarAgentArray[i]));
                } else {
                    object3.setEnabled(false);
                }
            } else {
                object = bPathBarAgentArray[i].getAgentOrd();
                if (object != null && !object.isNull()) {
                    ((BPathBarButton)((Object)object3)).setCommand(new PathBarHyperlinkCommand((BWidget)this.shell, null, null, (BOrd)object));
                }
                if (!this.restrictToNavFile || this.restrictToNavFile && bPathBarAgentArray[i].nav() instanceof BNavFileNode) {
                    if (i == 0) {
                        ((BPathBarButton)((Object)object3)).setMenuController(new HostController());
                    } else {
                        ((BPathBarButton)((Object)object3)).setMenuController(new AgentController(bPathBarAgentArray[i]));
                    }
                } else {
                    object3.setEnabled(false);
                }
            }
            arrayList.add(object3);
        }
        if (arrayList.isEmpty()) {
            this.setToError(bOrd);
            return;
        }
        this.buttons = new BPathBarButton[arrayList.size()];
        BGridPane bGridPane = new BGridPane(arrayList.size());
        bGridPane.setColumnGap(0.0);
        bGridPane.setHalign(BHalign.left);
        for (int i = 0; i < arrayList.size(); ++i) {
            object = (BPathBarButton)((Object)arrayList.get(i));
            this.buttons[i] = object;
            bGridPane.add(null, (BValue)object);
        }
        if (this.showViewMenu) {
            this.setContents((BWidget)bGridPane, (BWidget)object2);
        } else {
            this.setContents((BWidget)bGridPane, (BWidget)new BNullWidget());
        }
    }

    private void setToError(BOrd bOrd) {
        this.view = null;
        BLabel bLabel = new BLabel(errIcon, String.valueOf(bOrd));
        bLabel.setForeground(BColor.white.toBrush());
        bLabel.setHalign(BHalign.left);
        this.setContents((BWidget)new BBorderPane((BWidget)bLabel, 0.0, 0.0, 0.0, 5.0), (BWidget)new BNullWidget());
    }

    private void setContents(BWidget bWidget, BWidget bWidget2) {
        this.setCenter((BWidget)new BBorderPane(bWidget, 2.0, 0.0, 2.0, 2.0));
        this.setRight((BWidget)new BBorderPane(bWidget2, 2.0, 2.0, 2.0, 0.0));
    }

    private BMenu makeSubMenu(BWbShell bWbShell, BINavNode[] bINavNodeArray, int n) {
        BMenu bMenu = new BMenu("More");
        for (int i = n; i < n + 30 && i < bINavNodeArray.length; ++i) {
            bMenu.add(null, (Command)new PathBarHyperlinkCommand((BWidget)bWbShell, BImage.make((BIcon)bINavNodeArray[i].getNavIcon()), bINavNodeArray[i].getNavDisplayName(null), bINavNodeArray[i].getNavOrd()));
        }
        return bMenu;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ViewController
    implements BPathBarButton.MenuController {
        ViewController() {
        }

        public BMenu getMenu() {
            return NavMenuUtil.makeViewsMenu((BWidget)BPathBar.this, BPathBar.this.tab.getTarget().get(), BPathBar.this.tab.getOrd());
        }
    }

    class AgentController
    implements BPathBarButton.MenuController {
        private BPathBarAgent agent;

        public AgentController(BPathBarAgent bPathBarAgent) {
            this.agent = bPathBarAgent;
        }

        public BMenu getMenu() {
            int n;
            BINavNode[] bINavNodeArray = this.agent.getChildren();
            Command[] commandArray = this.agent.getCommands(BPathBar.this.shell);
            if (bINavNodeArray == null && commandArray == null) {
                return null;
            }
            BMenu bMenu = new BMenu();
            if (bINavNodeArray != null) {
                for (n = 0; n < 30 && n < bINavNodeArray.length; ++n) {
                    bMenu.add(null, (Command)new PathBarHyperlinkCommand((BWidget)BPathBar.this.shell, BImage.make((BIcon)bINavNodeArray[n].getNavIcon()), bINavNodeArray[n].getNavDisplayName(null), bINavNodeArray[n].getNavOrd()));
                }
                BMenu bMenu2 = bMenu;
                while (n < bINavNodeArray.length - 1) {
                    BMenu bMenu3 = BPathBar.this.makeSubMenu(BPathBar.this.shell, bINavNodeArray, n);
                    bMenu2.add(null, (BValue)new BSubMenuItem(bMenu3));
                    bMenu2 = bMenu3;
                    n += 30;
                }
            }
            if (commandArray != null) {
                for (n = 0; n < commandArray.length; ++n) {
                    if (n == 0 && bINavNodeArray != null) {
                        bMenu.add(null, (BValue)new BSeparator());
                    }
                    bMenu.add(null, commandArray[n]);
                }
            }
            return bMenu;
        }
    }

    class HostController
    implements BPathBarButton.MenuController {
        HostController() {
        }

        public BMenu getMenu() {
            BMenu bMenu = new BMenu();
            BINavNode[] bINavNodeArray = BNavRoot.INSTANCE.getNavChildren();
            for (int i = 0; i < bINavNodeArray.length; ++i) {
                BMenu bMenu2 = new BMenu(bINavNodeArray[i].getNavDisplayName(null));
                BINavNode[] bINavNodeArray2 = bINavNodeArray[i].getNavChildren();
                for (int j = 0; j < bINavNodeArray2.length; ++j) {
                    bMenu2.add(null, (Command)new PathBarHyperlinkCommand((BWidget)BPathBar.this.shell, BImage.make((BIcon)bINavNodeArray2[j].getNavIcon()), bINavNodeArray2[j].getNavDisplayName(null), bINavNodeArray2[j].getNavOrd()));
                }
                Command[] commandArray = BCnxHandler.getCnxCommands((BWidget)BPathBar.this.shell, (BHost)bINavNodeArray[i]);
                for (int j = 0; j < commandArray.length; ++j) {
                    if (j == 0 && bINavNodeArray2.length > 0) {
                        bMenu2.add(null, (BValue)new BSeparator());
                    }
                    bMenu2.add(null, commandArray[j]);
                }
                BSubMenuItem bSubMenuItem = new BSubMenuItem(bMenu2);
                bSubMenuItem.setImage(BImage.make((BIcon)bINavNodeArray[i].getNavIcon()));
                bMenu.add(null, (BValue)bSubMenuItem);
            }
            bMenu.add(null, (BValue)new BSeparator());
            bMenu.add(null, BPathBar.this.shell.commands.findStations);
            return bMenu;
        }
    }
}

