/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.ord;

import com.tridium.workbench.ord.RefFilter;
import java.util.ArrayList;
import javax.baja.gx.BImage;
import javax.baja.sys.BComplex;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.Flags;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.virtual.BVirtualGateway;

public class RefNode {
    public static final BImage propertyIcon = BImage.make((String)"module://icons/x16/object.png");
    public static final BImage actionIcon = BImage.make((String)"module://icons/x16/shapes/circleGreen.png");
    public static final BImage topicIcon = BImage.make((String)"module://icons/x16/shapes/circleGold.png");
    public BObject parent = null;
    public Slot slot = null;
    public BObject object;
    public String name = "";
    public String text = "?";
    public BImage icon = propertyIcon;
    public boolean isLeaf = false;

    public RefNode(BComplex bComplex) {
        this.parent = bComplex.getParent();
        this.slot = bComplex.getPropertyInParent();
        this.object = bComplex;
        this.name = bComplex.getName();
        this.text = bComplex.getDisplayName(null);
        this.icon = BImage.make((BIcon)bComplex.getIcon());
        this.isLeaf = bComplex.isSimple();
        if (this.icon == null) {
            this.icon = propertyIcon;
        }
    }

    public RefNode(BComplex bComplex, Slot slot) {
        this.name = slot.getName();
        this.text = bComplex.getDisplayName(slot, null);
        this.parent = bComplex;
        this.slot = slot;
        if (slot.isProperty()) {
            this.object = bComplex.get(slot.asProperty());
            this.icon = BImage.make((BIcon)this.object.getIcon());
            if (this.icon == null) {
                this.icon = propertyIcon;
            }
            this.isLeaf = this.object.isSimple();
        } else if (slot.isAction()) {
            this.object = null;
            this.icon = actionIcon;
            this.isLeaf = true;
        } else {
            this.object = null;
            this.icon = topicIcon;
            this.isLeaf = true;
        }
    }

    public RefNode[] getChildren(RefFilter refFilter) {
        Slot slot;
        SlotCursor slotCursor;
        RefNode[] refNodeArray;
        ArrayList<RefNode> arrayList = new ArrayList<RefNode>();
        if (this.object instanceof BComplex) {
            refNodeArray = (RefNode[])this.object;
            refNodeArray.loadSlots();
            slotCursor = refNodeArray.getSlots();
            while (slotCursor.next()) {
                slot = slotCursor.slot();
                if (Flags.isHidden((BComplex)refNodeArray, (Slot)slot) || !refFilter.accept(this.object, slot)) continue;
                arrayList.add(new RefNode((BComplex)refNodeArray, slot));
            }
        }
        if (this.object instanceof BVirtualGateway && (slotCursor = (refNodeArray = (BVirtualGateway)this.object).getVirtualSpace()) != null && (slot = slotCursor.getRootComponent()) != null) {
            slot.loadSlots();
            SlotCursor slotCursor2 = slot.getSlots();
            while (slotCursor2.next()) {
                Slot slot2 = slotCursor2.slot();
                if (Flags.isHidden((BComplex)slot, (Slot)slot2) || !refFilter.accept(this.object, slot2)) continue;
                arrayList.add(new RefNode((BComplex)slot, slot2));
            }
        }
        refNodeArray = new RefNode[arrayList.size()];
        return arrayList.toArray(refNodeArray);
    }
}

