/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.ord;

import com.tridium.nre.util.IPAddressUtil;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.fieldeditors.BDialogFE;
import javax.baja.gx.BFont;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BMenu;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.options.BMruButton;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BIValidator;
import javax.baja.util.CannotValidateException;
import javax.baja.util.Lexicon;

public class BHostOrdFE
extends BDialogFE
implements BIValidator {
    public static final Action dropDownModified = BHostOrdFE.newAction((int)0, null);
    public static final Action textModified = BHostOrdFE.newAction((int)0, null);
    public static final Action mruModified = BHostOrdFE.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$ord$BHostOrdFE == null ? (class$com$tridium$workbench$ord$BHostOrdFE = BHostOrdFE.class$("com.tridium.workbench.ord.BHostOrdFE")) : class$com$tridium$workbench$ord$BHostOrdFE));
    private static final Lexicon wbLexicon = Lexicon.make((Class)(class$com$tridium$workbench$ord$BHostOrdFE == null ? (class$com$tridium$workbench$ord$BHostOrdFE = BHostOrdFE.class$("com.tridium.workbench.ord.BHostOrdFE")) : class$com$tridium$workbench$ord$BHostOrdFE));
    protected static UiLexicon bajaUiLex = UiLexicon.bajaui();
    protected static final BFont bold = Theme.widget().getBoldText();
    protected HostScheme[] schemes = new HostScheme[0];
    protected String hostScheme;
    protected String body;
    protected BListDropDown dropDown;
    protected BTextField bodyField;
    protected BTextField port;
    protected BLabel tunnelLabel;
    protected BTextField cnxTunnelPath = null;
    protected int tunnelSchemeIndex = 1;
    protected boolean portEditableOnReadonly = false;
    protected BMruButton history;
    protected boolean autoSaveHistory = true;
    protected boolean local = false;
    protected String localBody = null;
    static /* synthetic */ Class class$com$tridium$workbench$ord$BHostOrdFE;
    static /* synthetic */ Class class$com$tridium$workbench$ord$BHostOrdFE$HostScheme;
    static /* synthetic */ Class class$java$lang$String;

    public void dropDownModified() {
        this.invoke(dropDownModified, null, null);
    }

    public void textModified() {
        this.invoke(textModified, null, null);
    }

    public void mruModified() {
        this.invoke(mruModified, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BHostOrdFE() {
        this.setContent(this.buildContent());
    }

    protected BWidget buildContent() {
        this.schemes = this.buildHostSchemes();
        this.history = new BMruButton("hostOrdFE");
        this.history.setMruController((BMruButton.MruController)new MruController());
        this.history.setButtonStyle(BButtonStyle.toolBar);
        BAbstractButton.MenuController menuController = this.getHistoryMenuController();
        if (menuController != null) {
            this.history.setMenuController(menuController);
        }
        this.dropDown = new BListDropDown();
        for (int i = 0; i < this.schemes.length; ++i) {
            this.dropDown.getList().addItem((Object)this.schemes[i]);
        }
        this.dropDown.setSelectedIndex(0);
        this.bodyField = new BTextField("", 16);
        this.linkTo((BComponent)this.bodyField, (Slot)BTextField.textModified, (Slot)textModified);
        this.linkTo((BComponent)this.bodyField, (Slot)BTextField.actionPerformed, (Slot)actionPerformed);
        this.linkTo((BComponent)this.bodyField, (Slot)BTextField.textModified, (Slot)setModified);
        BGridPane bGridPane = new BGridPane(4);
        bGridPane.setHalign(BHalign.left);
        bGridPane.add(null, (BValue)this.dropDown);
        bGridPane.add(null, (BValue)this.bodyField);
        bGridPane.add(null, (BValue)this.getEditButton());
        bGridPane.add(null, (BValue)this.history);
        this.linkTo(null, (BComponent)this.dropDown, (Slot)BListDropDown.listActionPerformed, (Slot)dropDownModified);
        this.linkTo(null, (BComponent)this.dropDown, (Slot)BListDropDown.listActionPerformed, (Slot)setModified);
        return bGridPane;
    }

    protected HostScheme[] buildHostSchemes() {
        Array array = new Array(class$com$tridium$workbench$ord$BHostOrdFE$HostScheme == null ? (class$com$tridium$workbench$ord$BHostOrdFE$HostScheme = BHostOrdFE.class$("com.tridium.workbench.ord.BHostOrdFE$HostScheme")) : class$com$tridium$workbench$ord$BHostOrdFE$HostScheme);
        try {
            array.add((Object)new IpScheme());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            array.add((Object)new PlatformTunnelScheme());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (HostScheme[])array.trim();
    }

    protected BAbstractButton.MenuController getHistoryMenuController() {
        return new MenuController();
    }

    protected void doSetReadonly(boolean bl) {
        super.doSetReadonly(bl);
        this.bodyField.setEditable(!bl);
        this.history.setEnabled(!bl);
        this.getEditButton().setVisible(!bl);
        if (this.dropDown != null) {
            this.dropDown.setDropDownEnabled(this.portEditableOnReadonly || !bl);
        }
        if (this.port != null) {
            this.port.setEditable(this.portEditableOnReadonly || !bl);
        }
        if (this.tunnelLabel != null) {
            this.tunnelLabel.setEnabled(this.portEditableOnReadonly || !bl);
        }
        if (this.cnxTunnelPath != null) {
            this.cnxTunnelPath.setEditable(this.portEditableOnReadonly || !bl);
        }
    }

    protected void doLoadValue(BObject bObject, Context context) {
        String string;
        BOrd bOrd = (BOrd)bObject;
        if (context != null && (string = (BBoolean)context.getFacet("mruAutoSave")) != null) {
            this.setAutoSaveHistory(string.getBoolean());
        }
        string = "ip";
        String string2 = "";
        if (null != bOrd && !bOrd.isNull()) {
            OrdQuery[] ordQueryArray = bOrd.parse();
            if (ordQueryArray.length > 0) {
                OrdQuery ordQuery = ordQueryArray[0];
                string = ordQuery.getScheme();
                this.local = string.equals("local");
                if (this.local) {
                    try {
                        string2 = Sys.getLocalHost().getHostName();
                    }
                    catch (Exception exception) {
                        string2 = null;
                    }
                    this.localBody = string2;
                }
                if (!this.local || string2 == null) {
                    string2 = ordQuery.getBody();
                }
            }
            if (!this.local) {
                for (int i = 0; i < this.schemes.length; ++i) {
                    if (!string.equals(this.schemes[i].scheme)) continue;
                    this.dropDown.setSelectedIndex(i);
                    break;
                }
            } else {
                this.hostScheme = string;
                for (int i = 0; i < this.schemes.length; ++i) {
                    if (!this.schemes[i].scheme.equals("ip")) continue;
                    this.dropDown.setSelectedIndex(i);
                    break;
                }
            }
        }
        if (!this.local) {
            this.doDropDownModified();
        }
        this.bodyField.setText(string2);
    }

    protected BObject doSaveValue(BObject bObject, Context context) {
        this.body = this.local ? "" : this.bodyField.getText();
        BOrd bOrd = BOrd.make((String)(this.hostScheme + ":" + this.body));
        if (this.autoSaveHistory) {
            this.saveHistory(bOrd);
        }
        return bOrd;
    }

    public final void saveHistory() {
        this.saveHistory((BOrd)this.getCurrentValue());
    }

    protected final void saveHistory(BOrd bOrd) {
        try {
            this.history.getMruOptions().save(bOrd.encodeToString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setAutoSaveHistory(boolean bl) {
        this.autoSaveHistory = bl;
    }

    public boolean getAutoSaveHistory() {
        return this.autoSaveHistory;
    }

    public boolean isTunnelScheme() {
        return this.dropDown.getSelectedItem() instanceof PlatformTunnelScheme;
    }

    public void setTunnelSelected() {
        if (this.isTunnelScheme()) {
            return;
        }
        for (int i = 0; i < this.dropDown.getList().getItemCount(); ++i) {
            if (!((HostScheme)this.dropDown.getList().getItem(i) instanceof PlatformTunnelScheme)) continue;
            this.dropDown.setSelectedIndex(i);
            break;
        }
    }

    public void setTunnelAuthorities(String[] stringArray) {
        if (null == stringArray) {
            return;
        }
        String string = TextUtil.join((String[])stringArray, (char)'/');
        if (this.cnxTunnelPath != null) {
            this.cnxTunnelPath.setText(string);
        }
        this.repaint();
    }

    public void doTextModified() {
        if (this.local && this.localBody != null && !this.bodyField.getText().equals(this.localBody)) {
            HostScheme hostScheme = (HostScheme)this.dropDown.getSelectedItem();
            this.hostScheme = hostScheme.scheme;
            this.local = false;
        }
    }

    public void doDropDownModified() {
        HostScheme hostScheme = (HostScheme)this.dropDown.getSelectedItem();
        this.hostScheme = hostScheme.scheme;
        this.getEditButton().setEnabled(!(hostScheme instanceof IpScheme));
        if (this.cnxTunnelPath != null) {
            this.cnxTunnelPath.setText("");
        }
        this.getEditButton().repaint();
        this.local = false;
    }

    public void doMruModified() {
        this.textModified();
    }

    public void validate(BObject bObject, Context context) throws CannotValidateException {
        BOrd bOrd = (BOrd)bObject;
        OrdQuery[] ordQueryArray = bOrd.parse();
        if (ordQueryArray.length == 0) {
            return;
        }
        for (int i = 0; i < ordQueryArray.length; ++i) {
            if (!ordQueryArray[i].getScheme().equalsIgnoreCase("ip")) continue;
            String string = ordQueryArray[i].getBody();
            if (IPAddressUtil.isNumericAddr((String)string)) {
                return;
            }
            if (IPAddressUtil.isHostname((String)string)) {
                return;
            }
            throw new CannotValidateException("Invalid hostname: " + string);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Entry
    extends Command {
        private String value;
        private BMruButton.MruController controller;

        public Entry(BWidget bWidget, String string, BMruButton.MruController mruController) {
            super(bWidget, mruController.toDisplayString(string));
            this.value = string;
            this.controller = mruController;
        }

        public CommandArtifact doInvoke() {
            this.controller.select(this.value);
            return null;
        }
    }

    class MenuController
    implements BAbstractButton.MenuController {
        MenuController() {
        }

        public boolean isMenuDistinct() {
            return false;
        }

        public BMenu getMenu(BAbstractButton bAbstractButton) {
            BMruButton bMruButton = (BMruButton)bAbstractButton;
            BMruButton.MruController mruController = bMruButton.getMruController();
            BMenu bMenu = new BMenu();
            String[] stringArray = bMruButton.getMruOptions().getHistory(bMruButton.getFilter());
            Array array = new Array(class$java$lang$String == null ? (class$java$lang$String = BHostOrdFE.class$("java.lang.String")) : class$java$lang$String);
            for (int i = 0; i < stringArray.length; ++i) {
                OrdQuery[] ordQueryArray;
                String string = stringArray[i];
                BOrd bOrd = BOrd.make((String)string);
                if (!bOrd.isNull() && (ordQueryArray = bOrd.parse()).length > 0) {
                    string = ordQueryArray[0].toString();
                }
                if (array.contains((Object)string)) continue;
                array.add((Object)string);
                bMenu.add(null, (Command)new Entry((BWidget)bAbstractButton, string, mruController));
            }
            return bMenu;
        }
    }

    class MruController
    extends BMruButton.MruController {
        MruController() {
        }

        public void select(String string) {
            BFacets bFacets = BFacets.make((BFacets)BHostOrdFE.this.getCurrentContext().getFacets(), (BFacets)BFacets.make((String)"MruControllerSelect", (boolean)true));
            BHostOrdFE.this.loadValue((BObject)BOrd.make((String)string), (Context)bFacets);
            BHostOrdFE.this.mruModified();
            BHostOrdFE.this.setModified();
        }
    }

    public static class PlatformTunnelScheme
    extends IpScheme {
        PlatformTunnelScheme() {
            this.scheme = "ip";
            this.displayName = wbLexicon.getText("hostScheme.tunnelplat");
        }
    }

    public static class IpScheme
    extends HostScheme {
        public IpScheme() {
            super("ip");
        }
    }

    public static abstract class HostScheme {
        public String scheme;
        public String displayName;

        public HostScheme(String string) {
            this.scheme = string;
            this.displayName = wbLexicon.getText("hostScheme." + string);
        }

        public String toString() {
            return this.displayName;
        }
    }
}

