/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.nav.editor;

import com.tridium.workbench.nav.editor.BNavFileEditor;
import com.tridium.workbench.nav.editor.Node;
import java.util.ArrayList;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.space.Mark;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferFormat;

public class TransferSupport {
    BNavFileEditor editor;

    public TransferSupport(BNavFileEditor bNavFileEditor) {
        this.editor = bNavFileEditor;
    }

    private Node addNodeCopy(Node node, Node node2) {
        Node node3 = new Node(node, this.editor.getValidName(node, node2.name), node2.ord, node2.icon);
        for (int i = 0; i < node2.getChildCount(); ++i) {
            Node node4 = this.addNodeCopy(node3, (Node)node2.getChild(i));
            node3.kids.add(node4);
        }
        return node3;
    }

    public CommandArtifact insert(Node node, TransferContext transferContext) throws Exception {
        Node[] nodeArray;
        String string = (String)transferContext.getEnvelope().getData(TransferFormat.string);
        if (string.startsWith("navFileEditorNode")) {
            nodeArray = new Node[this.editor.dragNodes.length];
            for (int i = 0; i < this.editor.dragNodes.length; ++i) {
                nodeArray[i] = this.addNodeCopy(node, this.editor.dragNodes[i]);
            }
        } else {
            Mark mark = (Mark)transferContext.getEnvelope().getData(TransferFormat.mark);
            BObject[] bObjectArray = mark.getValues();
            nodeArray = new Node[bObjectArray.length];
            for (int i = 0; i < bObjectArray.length; ++i) {
                BINavNode bINavNode = (BINavNode)bObjectArray[i];
                String string2 = this.editor.toNodeName(bINavNode);
                BOrd bOrd = bINavNode.getNavOrd().relativizeToSession();
                BImage bImage = BImage.make((BIcon)bINavNode.getNavIcon());
                String string3 = string2;
                if (i == 0) {
                    string3 = this.editor.getValidName(node, string3);
                } else {
                    int n = 1;
                    for (int j = 0; j < nodeArray.length && nodeArray[j] != null; ++j) {
                        if (!nodeArray[j].name.equals(string3) && string3.equals(this.editor.getValidName(node, string3))) continue;
                        string3 = string2 + n++;
                        j = -1;
                    }
                }
                nodeArray[i] = new Node(node, string3, bOrd, bImage);
            }
        }
        InsertArtifact insertArtifact = new InsertArtifact(node, nodeArray);
        insertArtifact.redo();
        return insertArtifact;
    }

    public CommandArtifact doDelete(boolean bl) throws Exception {
        Object object;
        Node node;
        Node[] nodeArray;
        if (bl) {
            nodeArray = this.editor.dragNodes;
            node = (Node)nodeArray[0].getParent();
        } else {
            object = new ArrayList();
            int[] nArray = this.editor.model.getSelection().getRows();
            for (int i = nArray.length - 1; i >= 0; --i) {
                ((ArrayList)object).add(this.editor.model.rowToNode(nArray[i]));
            }
            nodeArray = ((ArrayList)object).toArray(new Node[((ArrayList)object).size()]);
            node = (Node)nodeArray[0].getParent();
        }
        object = new DeleteArtifact(node, nodeArray);
        ((DeleteArtifact)object).redo();
        return object;
    }

    private void doInsert(Node node, Node[] nodeArray) throws Exception {
        for (int i = 0; i < nodeArray.length; ++i) {
            Node node2 = new Node(node, nodeArray[i].name, nodeArray[i].ord, nodeArray[i].icon);
            node.kids.add(node2);
            if (nodeArray[i].getChildCount() <= 0) continue;
            Node[] nodeArray2 = nodeArray[i].kids.toArray(new Node[nodeArray[i].getChildCount()]);
            this.doInsert(node2, nodeArray2);
        }
    }

    private void doRemove(Node node, Node[] nodeArray) throws Exception {
        for (int i = 0; i < nodeArray.length; ++i) {
            for (int j = 0; j < node.kids.size(); ++j) {
                Node node2 = (Node)((Object)node.kids.get(j));
                if (!node2.name.equals(nodeArray[i].name)) continue;
                node.kids.remove((Object)node2);
            }
        }
    }

    class DeleteArtifact
    extends InsertArtifact {
        public DeleteArtifact(Node node, Node[] nodeArray) {
            super(node, nodeArray);
        }

        public void undo() throws Exception {
            super.redo();
        }

        public void redo() throws Exception {
            super.undo();
        }
    }

    class InsertArtifact
    implements CommandArtifact {
        String[] path;
        Node[] kids;

        public InsertArtifact(Node node, Node[] nodeArray) {
            this.path = TransferSupport.this.editor.toPath(node);
            this.kids = nodeArray;
        }

        public void undo() throws Exception {
            Node node = TransferSupport.this.editor.findNode(this.path);
            TransferSupport.this.doRemove(node, this.kids);
            node.setExpanded(true);
            TransferSupport.this.editor.model.updateTreeTable(true);
            TransferSupport.this.editor.model.getSelection().deselectAll();
            TransferSupport.this.editor.setModified();
        }

        public void redo() throws Exception {
            Node node = TransferSupport.this.editor.findNode(this.path);
            TransferSupport.this.doInsert(node, this.kids);
            node.setExpanded(true);
            TransferSupport.this.editor.model.updateTreeTable(true);
            TransferSupport.this.editor.model.getSelection().deselectAll();
            TransferSupport.this.editor.setModified();
        }
    }
}

