/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.nav.editor;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.nav.editor.BNavFileEditor;
import com.tridium.workbench.util.WbUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.space.Mark;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.transfer.DragRenderer;
import javax.baja.ui.transfer.SimpleDragRenderer;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.util.Lexicon;

public class BSourceTable
extends BTable {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$nav$editor$BSourceTable == null ? (class$com$tridium$workbench$nav$editor$BSourceTable = BSourceTable.class$("com.tridium.workbench.nav.editor.BSourceTable")) : class$com$tridium$workbench$nav$editor$BSourceTable));
    static Lexicon lex = Lexicon.make((String)"workbench");
    static String lexName = lex.getText("navFileEditor.source.name");
    static String lexType = lex.getText("navFileEditor.source.type");
    static String lexPath = lex.getText("navFileEditor.source.path");
    BNavFileEditor editor;
    Model model;
    static /* synthetic */ Class class$com$tridium$workbench$nav$editor$BSourceTable;

    public Type getType() {
        return TYPE;
    }

    public BSourceTable() {
        throw new IllegalStateException();
    }

    public BSourceTable(BNavFileEditor bNavFileEditor) {
        this.editor = bNavFileEditor;
        this.model = new Model();
        this.setModel(this.model);
    }

    public void showComponents(boolean bl) {
        if (bl) {
            this.discoverComponents("baja:PxView");
            if (WbUtil.isRemoteModuleAvailable("exportTags", this.editor.getCurrentValueSession())) {
                this.discoverComponents("exportTags:SubstitutePxView");
            }
            this.model.updateTable(true);
        } else {
            for (int i = 0; i < this.model.kids.size(); ++i) {
                if (!(this.model.child(i) instanceof BComponent)) continue;
                this.model.kids.remove(this.model.child(i--));
            }
            this.model.updateTable();
        }
    }

    private void discoverComponents(String string) {
        String string2 = "station:|slot:/|bql:select parent.toPathString from " + string;
        BOrd bOrd = BOrd.make((String)string2);
        BITable bITable = (BITable)bOrd.resolve(this.editor.getCurrentValue()).get();
        Column column = bITable.getColumns().get(0);
        BObject bObject = this.editor.getCurrentValue();
        BOrd bOrd2 = ((BINavNode)bObject).getNavOrd();
        for (int i = 0; i < bITable.size(); ++i) {
            BString bString = (BString)bITable.get(i, column);
            String string3 = "station:|slot:" + bString.getString();
            BINavNode bINavNode = (BINavNode)BOrd.make((BOrd)bOrd2, (String)string3).resolve(bObject).get();
            this.model.kids.add(bINavNode);
        }
    }

    public void showFiles(boolean bl) {
        if (bl) {
            BIFile bIFile = (BIFile)BOrd.make((String)"file:^").resolve(this.editor.getCurrentValue()).get();
            this.findFiles(bIFile);
            this.model.updateTable(true);
        } else {
            for (int i = 0; i < this.model.kids.size(); ++i) {
                if (!(this.model.child(i) instanceof BIFile)) continue;
                this.model.kids.remove(this.model.child(i--));
            }
            this.model.updateTable();
        }
    }

    private void findFiles(BIFile bIFile) {
        if (bIFile instanceof BIDirectory) {
            BIFile[] bIFileArray = ((BIDirectory)bIFile).listFiles();
            for (int i = 0; i < bIFileArray.length; ++i) {
                this.findFiles(bIFileArray[i]);
            }
        } else if (bIFile.getExtension().equals("px")) {
            this.model.kids.add(bIFile);
        }
    }

    public void mouseDragStarted(BMouseEvent bMouseEvent) {
        int[] nArray = this.getSelection().getRows();
        if (nArray.length == 0) {
            return;
        }
        BImage[] bImageArray = new BImage[nArray.length];
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            BINavNode bINavNode = this.model.child(nArray[i]);
            bImageArray[i] = BImage.make((BIcon)bINavNode.getNavIcon());
            stringArray[i] = bINavNode.getNavDisplayName(this.editor.getCurrentContext());
        }
        SimpleDragRenderer simpleDragRenderer = new SimpleDragRenderer(bImageArray, stringArray);
        simpleDragRenderer.font = Theme.table().getCellFont();
        simpleDragRenderer.xCursorOffset = 0.0;
        simpleDragRenderer.yCursorOffset = 0.0;
        this.startDrag(bMouseEvent, this.getTransferData(), (DragRenderer)simpleDragRenderer);
    }

    public TransferEnvelope getTransferData() {
        int[] nArray = this.getSelection().getRows();
        if (nArray.length == 0) {
            return null;
        }
        BObject[] bObjectArray = new BObject[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            bObjectArray[i] = (BObject)this.model.child(nArray[i]);
        }
        return TransferEnvelope.make((Mark)new Mark(bObjectArray));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Compare
    implements Comparator {
        int col = 0;
        boolean ascending = true;

        public Compare(int n, boolean bl) {
            this.col = n;
            this.ascending = bl;
        }

        public int compare(Object object, Object object2) {
            BINavNode bINavNode = (BINavNode)object;
            BINavNode bINavNode2 = (BINavNode)object2;
            String string = "";
            String string2 = "";
            switch (this.col) {
                case 0: {
                    string = bINavNode.getNavDisplayName(BSourceTable.this.editor.getCurrentContext());
                    string2 = bINavNode2.getNavDisplayName(BSourceTable.this.editor.getCurrentContext());
                    break;
                }
                case 1: {
                    string = bINavNode.getType().toString();
                    string2 = bINavNode2.getType().toString();
                    break;
                }
                case 2: {
                    string = bINavNode.getNavOrd().relativizeToSession().toString();
                    string2 = bINavNode2.getNavOrd().relativizeToSession().toString();
                }
            }
            int n = string.compareTo(string2);
            return this.ascending ? n : -n;
        }
    }

    class Model
    extends TableModel {
        ArrayList kids = new ArrayList();

        Model() {
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return lexName;
                }
                case 1: {
                    return lexType;
                }
                case 2: {
                    return lexPath;
                }
            }
            return null;
        }

        public int getRowCount() {
            return this.kids.size();
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.child(n).getNavDisplayName(BSourceTable.this.editor.getCurrentContext());
                }
                case 1: {
                    return this.child(n).getType();
                }
                case 2: {
                    return this.child(n).getNavOrd().relativizeToSession();
                }
            }
            return null;
        }

        public Object getSubject(int n) {
            return this.child(n);
        }

        public BImage getRowIcon(int n) {
            return BImage.make((BIcon)this.child(n).getNavIcon());
        }

        public boolean isColumnSortable(int n) {
            return true;
        }

        public void sortByColumn(int n, boolean bl) {
            Collections.sort(this.kids, new Compare(n, bl));
        }

        BINavNode child(int n) {
            return (BINavNode)this.kids.get(n);
        }
    }
}

