/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.nav.editor;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.nav.editor.BNavFileEditor;
import javax.baja.gx.BBrush;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableHeaderRenderer;
import javax.baja.ui.transfer.DragRenderer;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.ui.treetable.BTreeTable;
import javax.baja.ui.treetable.TreeTableCellRenderer;
import javax.baja.ui.treetable.TreeTableHeaderRenderer;

public class BNavTable
extends BTreeTable {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$nav$editor$BNavTable == null ? (class$com$tridium$workbench$nav$editor$BNavTable = BNavTable.class$("com.tridium.workbench.nav.editor.BNavTable")) : class$com$tridium$workbench$nav$editor$BNavTable));
    int targetRow = -1;
    BNavFileEditor editor;
    static /* synthetic */ Class class$com$tridium$workbench$nav$editor$BNavTable;

    public Type getType() {
        return TYPE;
    }

    public BNavTable() {
        throw new IllegalStateException();
    }

    public BNavTable(BNavFileEditor bNavFileEditor) {
        this.editor = bNavFileEditor;
        this.setHeaderRenderer((TableHeaderRenderer)new HeaderRenderer());
        this.setCellRenderer((TableCellRenderer)new CellRenderer());
        this.setCopyEnabled(true);
        this.setCutEnabled(true);
        this.setPasteEnabled(true);
        this.setDuplicateEnabled(true);
    }

    public void mouseDragStarted(BMouseEvent bMouseEvent) {
        DragRenderer dragRenderer = this.editor.makeDragRenderer();
        if (dragRenderer != null) {
            this.startDrag(bMouseEvent, TransferEnvelope.make((String)"navFileEditorNode"), dragRenderer);
        }
    }

    public int dragOver(TransferContext transferContext) {
        this.targetRow = this.getRowAt(transferContext.getY());
        if (this.targetRow == -1 && this.getModel().getRowCount() > 0) {
            this.targetRow = 0;
        }
        this.repaint();
        String string = (String)transferContext.getEnvelope().getData(TransferFormat.string);
        if (string.startsWith("navFileEditorNode")) {
            return 16;
        }
        return 16;
    }

    public void dragExit(TransferContext transferContext) {
        this.targetRow = -1;
        this.repaint();
    }

    public CommandArtifact drop(TransferContext transferContext) throws Exception {
        this.targetRow = -1;
        return this.editor.insertTransferData(transferContext, false);
    }

    public TransferEnvelope getTransferData() throws Exception {
        DragRenderer dragRenderer = this.editor.makeDragRenderer();
        return dragRenderer != null ? TransferEnvelope.make((String)"navFileEditorNode") : null;
    }

    public CommandArtifact insertTransferData(TransferContext transferContext) throws Exception {
        return this.editor.insertTransferData(transferContext, true);
    }

    public CommandArtifact removeTransferData(TransferContext transferContext) throws Exception {
        return this.editor.txSupport.doDelete(true);
    }

    public CommandArtifact doDelete() throws Exception {
        return this.editor.txSupport.doDelete(false);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class CellRenderer
    extends TreeTableCellRenderer {
        CellRenderer() {
        }

        public BBrush getForeground(TableCellRenderer.Cell cell) {
            return cell.row == BNavTable.this.targetRow ? Theme.widget().getDropOkForeground() : super.getForeground(cell);
        }

        public BBrush getBackground(TableCellRenderer.Cell cell) {
            return cell.row == BNavTable.this.targetRow ? Theme.widget().getDropOkBackground() : super.getBackground(cell);
        }
    }

    class HeaderRenderer
    extends TreeTableHeaderRenderer {
        HeaderRenderer() {
        }

        public BBrush getForeground(TableHeaderRenderer.Header header) {
            return BNavTable.this.targetRow > -1 ? Theme.widget().getDropOkForeground() : super.getForeground(header);
        }

        public BBrush getBackground(TableHeaderRenderer.Header header) {
            return BNavTable.this.targetRow > -1 ? Theme.widget().getDropOkBackground() : super.getBackground(header);
        }
    }
}

